# Auth3 Python SDK

The official [Auth3](https://auth3.dev) python SDK library.

## API Documentation

Check-out the API documentation at [https://docs.auth3.dev/apis/identity-platform/administrative](https://docs.auth3.dev/apis/identity-platform/administrative?utm_source=github&utm_medium=sdk&utm_campaign=python) for further help.

## Installation

Add to your requirements.txt: 

```
auth3-sdk>=1.0.0
```

Or run:

```
python3 -m pip install --upgrade auth3-sdk
```

## Build

Run

```bash
python setup.py build # from within the root folder (this)
```

## Install from sources

```bash
$ pip install -rrequirements.txt
$ GRPC_PYTHON_BUILD_WITH_CYTHON=1 python setup.py install # from within the root folder (this)
```

Or, with pip:

```bash
# For the next two commands do `sudo pip install` if you get permission-denied errors
$ pip install -rrequirements.txt
$ GRPC_PYTHON_BUILD_WITH_CYTHON=1 pip install .
```

## Additional help

You can find further help, examples, tools and suggestions [here](https://grpc.io/docs/languages/python/).

## Change Language

Not your target language? Check out our official SDKs for: 

  * [go](https://github.com/auth3-dev/go-sdk)
  * [cpp](https://github.com/auth3-dev/cpp-sdk)
  * [java](https://github.com/auth3-dev/java-sdk)
  * [nodejs](https://github.com/auth3-dev/nodejs-sdk)
  * [dart](https://github.com/auth3-dev/dart-sdk)
  * [python](https://github.com/auth3-dev/python-sdk)
  * [php](https://github.com/auth3-dev/php-sdk)
  * [ruby](https://github.com/auth3-dev/ruby-sdk)
  * [rust](https://github.com/auth3-dev/rust-sdk)
  * [scala](https://github.com/auth3-dev/scala-sdk)
  * [swift](https://github.com/auth3-dev/swift-sdk)
  * [c#](https://github.com/auth3-dev/csharp-sdk)

## Contributing

At this time we don't accept external contributions, but we're open for feedbacks and requests. We're always looking for contributions on our security, refer to [our dedicated page](https://auth3.dev/bounty-program/?utm_source=github&utm_medium=sdk&utm_campaign=swift) for more.

## Support

Customers of the Auth3 Identity Platform can access support through the official channels available on [our website](https://auth3.dev/?utm_source=github&utm_medium=sdk&utm_campaign=python). We won't be able to accomodate Customer requests through the bug tracker for security reasons. 

## License

Read the [LICENSE](https://github.com/auth3-dev/python-sdk/blob/main/LICENSE).