from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '1.0'
DESCRIPTION = 'Data extractor for D2R'
LONG_DESCRIPTION = 'Reads/writes table excel text files from Diablo II Resurrected, and creates json and python files from them.'

# Setting up
setup(
    name="d2r_data",
    version=VERSION,
    author="Aimware0",
    author_email="<mail@neuralnine.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=[],
    keywords=['python', 'D2', 'D2R', 'Diablo II Resurrected', 'Diablo II', 'Diablo 2 Resurrected', 'Diablo 2'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)