"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from weakref import ref
from typing import TYPE_CHECKING, Dict, Optional

from githubkit.typing import Missing
from githubkit.utils import UNSET, exclude_unset

if TYPE_CHECKING:
    from githubkit import GitHubCore
    from githubkit.utils import UNSET
    from githubkit.typing import Missing
    from githubkit.response import Response

    from ..models import (
        ActionsBillingUsage,
        CombinedBillingUsage,
        PackagesBillingUsage,
        AdvancedSecurityActiveCommitters,
    )


class BillingClient:
    _REST_API_VERSION = "2022-11-28"

    def __init__(self, github: GitHubCore):
        self._github_ref = ref(github)

    @property
    def _github(self) -> GitHubCore:
        if g := self._github_ref():
            return g
        raise RuntimeError(
            "GitHub client has already been collected. "
            "Do not use this client after the client has been collected."
        )

    def get_github_actions_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-actions-billing-for-an-enterprise"""

        from ..models import ActionsBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-actions-billing-for-an-enterprise"""

        from ..models import ActionsBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    def get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AdvancedSecurityActiveCommitters]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-advanced-security-active-committers-for-an-enterprise"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_ghe(
        self,
        enterprise: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AdvancedSecurityActiveCommitters]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-advanced-security-active-committers-for-an-enterprise"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/enterprises/{enterprise}/settings/billing/advanced-security"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_github_packages_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackagesBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-packages-billing-for-an-enterprise"""

        from ..models import PackagesBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackagesBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-github-packages-billing-for-an-enterprise"""

        from ..models import PackagesBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-shared-storage-billing-for-an-enterprise"""

        from ..models import CombinedBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_ghe(
        self,
        enterprise: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/enterprise-admin/billing#get-shared-storage-billing-for-an-enterprise"""

        from ..models import CombinedBillingUsage

        url = f"/enterprises/{enterprise}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    def get_github_actions_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-an-organization"""

        from ..models import ActionsBillingUsage

        url = f"/orgs/{org}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-an-organization"""

        from ..models import ActionsBillingUsage

        url = f"/orgs/{org}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    def get_github_advanced_security_billing_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AdvancedSecurityActiveCommitters]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    async def async_get_github_advanced_security_billing_org(
        self,
        org: str,
        per_page: Missing[int] = UNSET,
        page: Missing[int] = UNSET,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[AdvancedSecurityActiveCommitters]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-advanced-security-active-committers-for-an-organization"""

        from ..models import AdvancedSecurityActiveCommitters

        url = f"/orgs/{org}/settings/billing/advanced-security"

        params = {
            "per_page": per_page,
            "page": page,
        }

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            params=exclude_unset(params),
            headers=exclude_unset(headers),
            response_model=AdvancedSecurityActiveCommitters,
        )

    def get_github_packages_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackagesBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-an-organization"""

        from ..models import PackagesBillingUsage

        url = f"/orgs/{org}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackagesBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-an-organization"""

        from ..models import PackagesBillingUsage

        url = f"/orgs/{org}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-an-organization"""

        from ..models import CombinedBillingUsage

        url = f"/orgs/{org}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_org(
        self,
        org: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-an-organization"""

        from ..models import CombinedBillingUsage

        url = f"/orgs/{org}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    def get_github_actions_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-a-user"""

        from ..models import ActionsBillingUsage

        url = f"/users/{username}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    async def async_get_github_actions_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[ActionsBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-actions-billing-for-a-user"""

        from ..models import ActionsBillingUsage

        url = f"/users/{username}/settings/billing/actions"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=ActionsBillingUsage,
        )

    def get_github_packages_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackagesBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-a-user"""

        from ..models import PackagesBillingUsage

        url = f"/users/{username}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    async def async_get_github_packages_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[PackagesBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-github-packages-billing-for-a-user"""

        from ..models import PackagesBillingUsage

        url = f"/users/{username}/settings/billing/packages"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=PackagesBillingUsage,
        )

    def get_shared_storage_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-a-user"""

        from ..models import CombinedBillingUsage

        url = f"/users/{username}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return self._github.request(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )

    async def async_get_shared_storage_billing_user(
        self,
        username: str,
        *,
        headers: Optional[Dict[str, str]] = None,
    ) -> Response[CombinedBillingUsage]:
        """See also: https://docs.github.com/enterprise-cloud@latest//rest/billing/billing#get-shared-storage-billing-for-a-user"""

        from ..models import CombinedBillingUsage

        url = f"/users/{username}/settings/billing/shared-storage"

        headers = {"X-GitHub-Api-Version": self._REST_API_VERSION, **(headers or {})}

        return await self._github.arequest(
            "GET",
            url,
            headers=exclude_unset(headers),
            response_model=CombinedBillingUsage,
        )
