"""DO NOT EDIT THIS FILE!

This file is automatically @generated by githubkit using the follow command:

bash ./scripts/run-codegen.sh

See https://github.com/github/rest-api-description for more information.
"""

from __future__ import annotations

from datetime import datetime
from typing import List, Union, Literal

from pydantic import Field

from githubkit.utils import UNSET
from githubkit.typing import Missing
from githubkit.compat import GitHubModel, model_rebuild


class WebhooksPullRequest5(GitHubModel):
    """Pull Request"""

    links: WebhooksPullRequest5PropLinks = Field(alias="_links")
    active_lock_reason: Union[
        None, Literal["resolved", "off-topic", "too heated", "spam"]
    ] = Field()
    additions: Missing[int] = Field(default=UNSET)
    assignee: Union[WebhooksPullRequest5PropAssignee, None] = Field(title="User")
    assignees: List[Union[WebhooksPullRequest5PropAssigneesItems, None]] = Field()
    author_association: Literal[
        "COLLABORATOR",
        "CONTRIBUTOR",
        "FIRST_TIMER",
        "FIRST_TIME_CONTRIBUTOR",
        "MANNEQUIN",
        "MEMBER",
        "NONE",
        "OWNER",
    ] = Field(
        title="AuthorAssociation",
        description="How the author is associated with the repository.",
    )
    auto_merge: Union[WebhooksPullRequest5PropAutoMerge, None] = Field(
        title="PullRequestAutoMerge",
        description="The status of auto merging a pull request.",
    )
    base: WebhooksPullRequest5PropBase = Field()
    body: Union[str, None] = Field()
    changed_files: Missing[int] = Field(default=UNSET)
    closed_at: Union[datetime, None] = Field()
    comments: Missing[int] = Field(default=UNSET)
    comments_url: str = Field()
    commits: Missing[int] = Field(default=UNSET)
    commits_url: str = Field()
    created_at: datetime = Field()
    deletions: Missing[int] = Field(default=UNSET)
    diff_url: str = Field()
    draft: bool = Field(
        description="Indicates whether or not the pull request is a draft."
    )
    head: WebhooksPullRequest5PropHead = Field()
    html_url: str = Field()
    id: int = Field()
    issue_url: str = Field()
    labels: List[WebhooksPullRequest5PropLabelsItems] = Field()
    locked: bool = Field()
    maintainer_can_modify: Missing[bool] = Field(
        default=UNSET,
        description="Indicates whether maintainers can modify the pull request.",
    )
    merge_commit_sha: Union[str, None] = Field()
    mergeable: Missing[Union[bool, None]] = Field(default=UNSET)
    mergeable_state: Missing[str] = Field(default=UNSET)
    merged: Missing[Union[bool, None]] = Field(default=UNSET)
    merged_at: Union[datetime, None] = Field()
    merged_by: Missing[Union[WebhooksPullRequest5PropMergedBy, None]] = Field(
        default=UNSET, title="User"
    )
    milestone: Union[WebhooksPullRequest5PropMilestone, None] = Field(
        title="Milestone",
        description="A collection of related issues and pull requests.",
    )
    node_id: str = Field()
    number: int = Field(
        description="Number uniquely identifying the pull request within its repository."
    )
    patch_url: str = Field()
    rebaseable: Missing[Union[bool, None]] = Field(default=UNSET)
    requested_reviewers: List[
        Union[
            WebhooksPullRequest5PropRequestedReviewersItemsOneof0,
            None,
            WebhooksPullRequest5PropRequestedReviewersItemsOneof1,
        ]
    ] = Field()
    requested_teams: List[WebhooksPullRequest5PropRequestedTeamsItems] = Field()
    review_comment_url: str = Field()
    review_comments: Missing[int] = Field(default=UNSET)
    review_comments_url: str = Field()
    state: Literal["open", "closed"] = Field(
        description="State of this Pull Request. Either `open` or `closed`."
    )
    statuses_url: str = Field()
    title: str = Field(description="The title of the pull request.")
    updated_at: datetime = Field()
    url: str = Field()
    user: Union[WebhooksPullRequest5PropUser, None] = Field(title="User")


class WebhooksPullRequest5PropAssignee(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropAssigneesItems(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropAutoMerge(GitHubModel):
    """PullRequestAutoMerge

    The status of auto merging a pull request.
    """

    commit_message: Union[str, None] = Field(
        description="Commit message for the merge commit."
    )
    commit_title: Union[str, None] = Field(
        description="Title for the merge commit message."
    )
    enabled_by: Union[WebhooksPullRequest5PropAutoMergePropEnabledBy, None] = Field(
        title="User"
    )
    merge_method: Literal["merge", "squash", "rebase"] = Field(
        description="The merge method to use."
    )


class WebhooksPullRequest5PropAutoMergePropEnabledBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropLabelsItems(GitHubModel):
    """Label"""

    color: str = Field(
        description="6-character hex code, without the leading #, identifying the color"
    )
    default: bool = Field()
    description: Union[str, None] = Field()
    id: int = Field()
    name: str = Field(description="The name of the label.")
    node_id: str = Field()
    url: str = Field(description="URL for the label")


class WebhooksPullRequest5PropMergedBy(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropMilestone(GitHubModel):
    """Milestone

    A collection of related issues and pull requests.
    """

    closed_at: Union[datetime, None] = Field()
    closed_issues: int = Field()
    created_at: datetime = Field()
    creator: Union[WebhooksPullRequest5PropMilestonePropCreator, None] = Field(
        title="User"
    )
    description: Union[str, None] = Field()
    due_on: Union[datetime, None] = Field()
    html_url: str = Field()
    id: int = Field()
    labels_url: str = Field()
    node_id: str = Field()
    number: int = Field(description="The number of the milestone.")
    open_issues: int = Field()
    state: Literal["open", "closed"] = Field(description="The state of the milestone.")
    title: str = Field(description="The title of the milestone.")
    updated_at: datetime = Field()
    url: str = Field()


class WebhooksPullRequest5PropMilestonePropCreator(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropRequestedReviewersItemsOneof0(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization", "Mannequin"]] = Field(
        default=UNSET
    )
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropLinks(GitHubModel):
    """WebhooksPullRequest5PropLinks"""

    comments: WebhooksPullRequest5PropLinksPropComments = Field(title="Link")
    commits: WebhooksPullRequest5PropLinksPropCommits = Field(title="Link")
    html: WebhooksPullRequest5PropLinksPropHtml = Field(title="Link")
    issue: WebhooksPullRequest5PropLinksPropIssue = Field(title="Link")
    review_comment: WebhooksPullRequest5PropLinksPropReviewComment = Field(title="Link")
    review_comments: WebhooksPullRequest5PropLinksPropReviewComments = Field(
        title="Link"
    )
    self_: WebhooksPullRequest5PropLinksPropSelf = Field(alias="self", title="Link")
    statuses: WebhooksPullRequest5PropLinksPropStatuses = Field(title="Link")


class WebhooksPullRequest5PropLinksPropComments(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropCommits(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropHtml(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropIssue(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropReviewComment(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropReviewComments(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropSelf(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropLinksPropStatuses(GitHubModel):
    """Link"""

    href: str = Field()


class WebhooksPullRequest5PropBase(GitHubModel):
    """WebhooksPullRequest5PropBase"""

    label: str = Field()
    ref: str = Field()
    repo: WebhooksPullRequest5PropBasePropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[WebhooksPullRequest5PropBasePropUser, None] = Field(title="User")


class WebhooksPullRequest5PropBasePropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropBasePropRepo(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[WebhooksPullRequest5PropBasePropRepoPropLicense, None] = Field(
        alias="license", title="License"
    )
    master_branch: Missing[str] = Field(default=UNSET)
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[WebhooksPullRequest5PropBasePropRepoPropOwner, None] = Field(
        title="User"
    )
    permissions: Missing[WebhooksPullRequest5PropBasePropRepoPropPermissions] = Field(
        default=UNSET
    )
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    squash_merge_commit_title: Missing[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]] = (
        Field(
            default=UNSET,
            description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        )
    )
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default.",
    )
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhooksPullRequest5PropBasePropRepoPropLicense(GitHubModel):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhooksPullRequest5PropBasePropRepoPropOwner(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropBasePropRepoPropPermissions(GitHubModel):
    """WebhooksPullRequest5PropBasePropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhooksPullRequest5PropHead(GitHubModel):
    """WebhooksPullRequest5PropHead"""

    label: str = Field()
    ref: str = Field()
    repo: WebhooksPullRequest5PropHeadPropRepo = Field(
        title="Repository", description="A git repository"
    )
    sha: str = Field()
    user: Union[WebhooksPullRequest5PropHeadPropUser, None] = Field(title="User")


class WebhooksPullRequest5PropHeadPropUser(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropHeadPropRepo(GitHubModel):
    """Repository

    A git repository
    """

    allow_auto_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow auto-merge for pull requests."
    )
    allow_forking: Missing[bool] = Field(
        default=UNSET, description="Whether to allow private forks"
    )
    allow_merge_commit: Missing[bool] = Field(
        default=UNSET, description="Whether to allow merge commits for pull requests."
    )
    allow_rebase_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow rebase merges for pull requests."
    )
    allow_squash_merge: Missing[bool] = Field(
        default=UNSET, description="Whether to allow squash merges for pull requests."
    )
    allow_update_branch: Missing[bool] = Field(default=UNSET)
    archive_url: str = Field()
    archived: bool = Field(
        default=False, description="Whether the repository is archived."
    )
    assignees_url: str = Field()
    blobs_url: str = Field()
    branches_url: str = Field()
    clone_url: str = Field()
    collaborators_url: str = Field()
    comments_url: str = Field()
    commits_url: str = Field()
    compare_url: str = Field()
    contents_url: str = Field()
    contributors_url: str = Field()
    created_at: Union[int, datetime] = Field()
    default_branch: str = Field(description="The default branch of the repository.")
    delete_branch_on_merge: Missing[bool] = Field(
        default=UNSET,
        description="Whether to delete head branches when pull requests are merged",
    )
    deployments_url: str = Field()
    description: Union[str, None] = Field()
    disabled: Missing[bool] = Field(
        default=UNSET, description="Returns whether or not this repository is disabled."
    )
    downloads_url: str = Field()
    events_url: str = Field()
    fork: bool = Field()
    forks: int = Field()
    forks_count: int = Field()
    forks_url: str = Field()
    full_name: str = Field()
    git_commits_url: str = Field()
    git_refs_url: str = Field()
    git_tags_url: str = Field()
    git_url: str = Field()
    has_downloads: bool = Field(
        default=True, description="Whether downloads are enabled."
    )
    has_issues: bool = Field(default=True, description="Whether issues are enabled.")
    has_pages: bool = Field()
    has_projects: bool = Field(
        default=True, description="Whether projects are enabled."
    )
    has_wiki: bool = Field(default=True, description="Whether the wiki is enabled.")
    has_discussions: bool = Field(
        default=False, description="Whether discussions are enabled."
    )
    homepage: Union[str, None] = Field()
    hooks_url: str = Field()
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the repository")
    is_template: Missing[bool] = Field(default=UNSET)
    issue_comment_url: str = Field()
    issue_events_url: str = Field()
    issues_url: str = Field()
    keys_url: str = Field()
    labels_url: str = Field()
    language: Union[str, None] = Field()
    languages_url: str = Field()
    license_: Union[WebhooksPullRequest5PropHeadPropRepoPropLicense, None] = Field(
        alias="license", title="License"
    )
    master_branch: Missing[str] = Field(default=UNSET)
    merge_commit_message: Missing[Literal["PR_BODY", "PR_TITLE", "BLANK"]] = Field(
        default=UNSET,
        description="The default value for a merge commit message.\n\n- `PR_TITLE` - default to the pull request's title.\n- `PR_BODY` - default to the pull request's body.\n- `BLANK` - default to a blank commit message.",
    )
    merge_commit_title: Missing[Literal["PR_TITLE", "MERGE_MESSAGE"]] = Field(
        default=UNSET,
        description="The default value for a merge commit title.\n\n- `PR_TITLE` - default to the pull request's title.\n- `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).",
    )
    merges_url: str = Field()
    milestones_url: str = Field()
    mirror_url: Union[str, None] = Field()
    name: str = Field(description="The name of the repository.")
    node_id: str = Field()
    notifications_url: str = Field()
    open_issues: int = Field()
    open_issues_count: int = Field()
    organization: Missing[str] = Field(default=UNSET)
    owner: Union[WebhooksPullRequest5PropHeadPropRepoPropOwner, None] = Field(
        title="User"
    )
    permissions: Missing[WebhooksPullRequest5PropHeadPropRepoPropPermissions] = Field(
        default=UNSET
    )
    private: bool = Field(description="Whether the repository is private or public.")
    public: Missing[bool] = Field(default=UNSET)
    pulls_url: str = Field()
    pushed_at: Union[int, datetime, None] = Field()
    releases_url: str = Field()
    role_name: Missing[Union[str, None]] = Field(default=UNSET)
    size: int = Field()
    squash_merge_commit_message: Missing[
        Literal["PR_BODY", "COMMIT_MESSAGES", "BLANK"]
    ] = Field(
        default=UNSET,
        description="The default value for a squash merge commit message:\n\n- `PR_BODY` - default to the pull request's body.\n- `COMMIT_MESSAGES` - default to the branch's commit messages.\n- `BLANK` - default to a blank commit message.",
    )
    squash_merge_commit_title: Missing[Literal["PR_TITLE", "COMMIT_OR_PR_TITLE"]] = (
        Field(
            default=UNSET,
            description="The default value for a squash merge commit title:\n\n- `PR_TITLE` - default to the pull request's title.\n- `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).",
        )
    )
    ssh_url: str = Field()
    stargazers: Missing[int] = Field(default=UNSET)
    stargazers_count: int = Field()
    stargazers_url: str = Field()
    statuses_url: str = Field()
    subscribers_url: str = Field()
    subscription_url: str = Field()
    svn_url: str = Field()
    tags_url: str = Field()
    teams_url: str = Field()
    topics: List[str] = Field()
    trees_url: str = Field()
    updated_at: datetime = Field()
    url: str = Field()
    use_squash_pr_title_as_default: Missing[bool] = Field(
        default=UNSET,
        description="Whether a squash merge commit can use the pull request title as default.",
    )
    visibility: Literal["public", "private", "internal"] = Field()
    watchers: int = Field()
    watchers_count: int = Field()
    web_commit_signoff_required: Missing[bool] = Field(
        default=UNSET,
        description="Whether to require contributors to sign off on web-based commits",
    )


class WebhooksPullRequest5PropHeadPropRepoPropLicense(GitHubModel):
    """License"""

    key: str = Field()
    name: str = Field()
    node_id: str = Field()
    spdx_id: str = Field()
    url: Union[str, None] = Field()


class WebhooksPullRequest5PropHeadPropRepoPropOwner(GitHubModel):
    """User"""

    avatar_url: Missing[str] = Field(default=UNSET)
    deleted: Missing[bool] = Field(default=UNSET)
    email: Missing[Union[str, None]] = Field(default=UNSET)
    events_url: Missing[str] = Field(default=UNSET)
    followers_url: Missing[str] = Field(default=UNSET)
    following_url: Missing[str] = Field(default=UNSET)
    gists_url: Missing[str] = Field(default=UNSET)
    gravatar_id: Missing[str] = Field(default=UNSET)
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field()
    login: str = Field()
    name: Missing[str] = Field(default=UNSET)
    node_id: Missing[str] = Field(default=UNSET)
    organizations_url: Missing[str] = Field(default=UNSET)
    received_events_url: Missing[str] = Field(default=UNSET)
    repos_url: Missing[str] = Field(default=UNSET)
    site_admin: Missing[bool] = Field(default=UNSET)
    starred_url: Missing[str] = Field(default=UNSET)
    subscriptions_url: Missing[str] = Field(default=UNSET)
    type: Missing[Literal["Bot", "User", "Organization"]] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET)


class WebhooksPullRequest5PropHeadPropRepoPropPermissions(GitHubModel):
    """WebhooksPullRequest5PropHeadPropRepoPropPermissions"""

    admin: bool = Field()
    maintain: Missing[bool] = Field(default=UNSET)
    pull: bool = Field()
    push: bool = Field()
    triage: Missing[bool] = Field(default=UNSET)


class WebhooksPullRequest5PropRequestedReviewersItemsOneof1(GitHubModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[WebhooksPullRequest5PropRequestedReviewersItemsOneof1PropParent, None]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhooksPullRequest5PropRequestedReviewersItemsOneof1PropParent(GitHubModel):
    """WebhooksPullRequest5PropRequestedReviewersItemsOneof1PropParent"""

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


class WebhooksPullRequest5PropRequestedTeamsItems(GitHubModel):
    """Team

    Groups of organization members that gives permissions on specified repositories.
    """

    deleted: Missing[bool] = Field(default=UNSET)
    description: Missing[Union[str, None]] = Field(
        default=UNSET, description="Description of the team"
    )
    html_url: Missing[str] = Field(default=UNSET)
    id: int = Field(description="Unique identifier of the team")
    members_url: Missing[str] = Field(default=UNSET)
    name: str = Field(description="Name of the team")
    node_id: Missing[str] = Field(default=UNSET)
    parent: Missing[
        Union[WebhooksPullRequest5PropRequestedTeamsItemsPropParent, None]
    ] = Field(default=UNSET)
    permission: Missing[str] = Field(
        default=UNSET,
        description="Permission that the team will have for its repositories",
    )
    privacy: Missing[Literal["open", "closed", "secret"]] = Field(default=UNSET)
    repositories_url: Missing[str] = Field(default=UNSET)
    slug: Missing[str] = Field(default=UNSET)
    url: Missing[str] = Field(default=UNSET, description="URL for the team")


class WebhooksPullRequest5PropRequestedTeamsItemsPropParent(GitHubModel):
    """WebhooksPullRequest5PropRequestedTeamsItemsPropParent"""

    description: Union[str, None] = Field(description="Description of the team")
    html_url: str = Field()
    id: int = Field(description="Unique identifier of the team")
    members_url: str = Field()
    name: str = Field(description="Name of the team")
    node_id: str = Field()
    permission: str = Field(
        description="Permission that the team will have for its repositories"
    )
    privacy: Literal["open", "closed", "secret"] = Field()
    repositories_url: str = Field()
    slug: str = Field()
    url: str = Field(description="URL for the team")


model_rebuild(WebhooksPullRequest5)
model_rebuild(WebhooksPullRequest5PropAssignee)
model_rebuild(WebhooksPullRequest5PropAssigneesItems)
model_rebuild(WebhooksPullRequest5PropAutoMerge)
model_rebuild(WebhooksPullRequest5PropAutoMergePropEnabledBy)
model_rebuild(WebhooksPullRequest5PropLabelsItems)
model_rebuild(WebhooksPullRequest5PropMergedBy)
model_rebuild(WebhooksPullRequest5PropMilestone)
model_rebuild(WebhooksPullRequest5PropMilestonePropCreator)
model_rebuild(WebhooksPullRequest5PropRequestedReviewersItemsOneof0)
model_rebuild(WebhooksPullRequest5PropUser)
model_rebuild(WebhooksPullRequest5PropLinks)
model_rebuild(WebhooksPullRequest5PropLinksPropComments)
model_rebuild(WebhooksPullRequest5PropLinksPropCommits)
model_rebuild(WebhooksPullRequest5PropLinksPropHtml)
model_rebuild(WebhooksPullRequest5PropLinksPropIssue)
model_rebuild(WebhooksPullRequest5PropLinksPropReviewComment)
model_rebuild(WebhooksPullRequest5PropLinksPropReviewComments)
model_rebuild(WebhooksPullRequest5PropLinksPropSelf)
model_rebuild(WebhooksPullRequest5PropLinksPropStatuses)
model_rebuild(WebhooksPullRequest5PropBase)
model_rebuild(WebhooksPullRequest5PropBasePropUser)
model_rebuild(WebhooksPullRequest5PropBasePropRepo)
model_rebuild(WebhooksPullRequest5PropBasePropRepoPropLicense)
model_rebuild(WebhooksPullRequest5PropBasePropRepoPropOwner)
model_rebuild(WebhooksPullRequest5PropBasePropRepoPropPermissions)
model_rebuild(WebhooksPullRequest5PropHead)
model_rebuild(WebhooksPullRequest5PropHeadPropUser)
model_rebuild(WebhooksPullRequest5PropHeadPropRepo)
model_rebuild(WebhooksPullRequest5PropHeadPropRepoPropLicense)
model_rebuild(WebhooksPullRequest5PropHeadPropRepoPropOwner)
model_rebuild(WebhooksPullRequest5PropHeadPropRepoPropPermissions)
model_rebuild(WebhooksPullRequest5PropRequestedReviewersItemsOneof1)
model_rebuild(WebhooksPullRequest5PropRequestedReviewersItemsOneof1PropParent)
model_rebuild(WebhooksPullRequest5PropRequestedTeamsItems)
model_rebuild(WebhooksPullRequest5PropRequestedTeamsItemsPropParent)

__all__ = (
    "WebhooksPullRequest5",
    "WebhooksPullRequest5PropAssignee",
    "WebhooksPullRequest5PropAssigneesItems",
    "WebhooksPullRequest5PropAutoMerge",
    "WebhooksPullRequest5PropAutoMergePropEnabledBy",
    "WebhooksPullRequest5PropLabelsItems",
    "WebhooksPullRequest5PropMergedBy",
    "WebhooksPullRequest5PropMilestone",
    "WebhooksPullRequest5PropMilestonePropCreator",
    "WebhooksPullRequest5PropRequestedReviewersItemsOneof0",
    "WebhooksPullRequest5PropUser",
    "WebhooksPullRequest5PropLinks",
    "WebhooksPullRequest5PropLinksPropComments",
    "WebhooksPullRequest5PropLinksPropCommits",
    "WebhooksPullRequest5PropLinksPropHtml",
    "WebhooksPullRequest5PropLinksPropIssue",
    "WebhooksPullRequest5PropLinksPropReviewComment",
    "WebhooksPullRequest5PropLinksPropReviewComments",
    "WebhooksPullRequest5PropLinksPropSelf",
    "WebhooksPullRequest5PropLinksPropStatuses",
    "WebhooksPullRequest5PropBase",
    "WebhooksPullRequest5PropBasePropUser",
    "WebhooksPullRequest5PropBasePropRepo",
    "WebhooksPullRequest5PropBasePropRepoPropLicense",
    "WebhooksPullRequest5PropBasePropRepoPropOwner",
    "WebhooksPullRequest5PropBasePropRepoPropPermissions",
    "WebhooksPullRequest5PropHead",
    "WebhooksPullRequest5PropHeadPropUser",
    "WebhooksPullRequest5PropHeadPropRepo",
    "WebhooksPullRequest5PropHeadPropRepoPropLicense",
    "WebhooksPullRequest5PropHeadPropRepoPropOwner",
    "WebhooksPullRequest5PropHeadPropRepoPropPermissions",
    "WebhooksPullRequest5PropRequestedReviewersItemsOneof1",
    "WebhooksPullRequest5PropRequestedReviewersItemsOneof1PropParent",
    "WebhooksPullRequest5PropRequestedTeamsItems",
    "WebhooksPullRequest5PropRequestedTeamsItemsPropParent",
)
