// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "opencv_converters.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "ml_wrapper.hpp"
#include "arrayobject.h"
#include "ndarray.hpp"
#include "ml_ext_classes_5.pypp.hpp"

namespace bp = boost::python;

struct CvERTreeTrainData_wrapper : CvERTreeTrainData, bp::wrapper< CvERTreeTrainData > {

    CvERTreeTrainData_wrapper(CvERTreeTrainData const & arg )
    : CvERTreeTrainData( arg )
      , bp::wrapper< CvERTreeTrainData >(){
        // copy constructor
        
    }

    CvERTreeTrainData_wrapper()
    : CvERTreeTrainData()
      , bp::wrapper< CvERTreeTrainData >(){
        // null constructor
        
    }

    virtual void get_vectors( ::CvMat const * _subsample_idx, float * values, ::uchar * missing, float * responses, bool get_class_idx=false ) {
        namespace bpl = boost::python;
        if( bpl::override func_get_vectors = this->get_override( "get_vectors" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_get_vectors.ptr(), _subsample_idx, values, missing, responses, get_class_idx );
        }
        else{
            CvERTreeTrainData::get_vectors( boost::python::ptr(_subsample_idx), values, missing, responses, get_class_idx );
        }
    }
    
    static void default_get_vectors( ::CvERTreeTrainData & inst, ::cv::Mat & _subsample_idx, std::vector<float> const & values, std::vector<unsigned char> const & missing, std::vector<float> const & responses, bool get_class_idx=false ){
        if( dynamic_cast< CvERTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvERTreeTrainData::get_vectors(get_CvMat_ptr(_subsample_idx), (float *)(&values[0]), (::uchar *)(&missing[0]), (float *)(&responses[0]), get_class_idx);
        }
        else{
            inst.get_vectors(get_CvMat_ptr(_subsample_idx), (float *)(&values[0]), (::uchar *)(&missing[0]), (float *)(&responses[0]), get_class_idx);
        }
    }

    virtual void set_data( ::CvMat const * _train_data, int _tflag, ::CvMat const * _responses, ::CvMat const * _var_idx=0, ::CvMat const * _sample_idx=0, ::CvMat const * _var_type=0, ::CvMat const * _missing_mask=0, ::CvDTreeParams const & _params=::CvDTreeParams( ), bool _shared=false, bool _add_labels=false, bool _update_data=false ) {
        namespace bpl = boost::python;
        if( bpl::override func_set_data = this->get_override( "set_data" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_set_data.ptr(), _train_data, _tflag, _responses, _var_idx, _sample_idx, _var_type, _missing_mask, _params, _shared, _add_labels, _update_data );
        }
        else{
            CvERTreeTrainData::set_data( boost::python::ptr(_train_data), _tflag, boost::python::ptr(_responses), boost::python::ptr(_var_idx), boost::python::ptr(_sample_idx), boost::python::ptr(_var_type), boost::python::ptr(_missing_mask), boost::ref(_params), _shared, _add_labels, _update_data );
        }
    }
    
    static void default_set_data( ::CvERTreeTrainData & inst, ::cv::Mat & _train_data, int _tflag, ::cv::Mat & _responses, ::cv::Mat _var_idx=cv::Mat(), ::cv::Mat _sample_idx=cv::Mat(), ::cv::Mat _var_type=cv::Mat(), ::cv::Mat _missing_mask=cv::Mat(), ::CvDTreeParams const & _params=::CvDTreeParams( ), bool _shared=false, bool _add_labels=false, bool _update_data=false ){
        if( dynamic_cast< CvERTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvERTreeTrainData::set_data(get_CvMat_ptr(_train_data), _tflag, get_CvMat_ptr(_responses), get_CvMat_ptr(_var_idx), get_CvMat_ptr(_sample_idx), get_CvMat_ptr(_var_type), get_CvMat_ptr(_missing_mask), _params, _shared, _add_labels, _update_data);
        }
        else{
            inst.set_data(get_CvMat_ptr(_train_data), _tflag, get_CvMat_ptr(_responses), get_CvMat_ptr(_var_idx), get_CvMat_ptr(_sample_idx), get_CvMat_ptr(_var_type), get_CvMat_ptr(_missing_mask), _params, _shared, _add_labels, _update_data);
        }
    }

    virtual CvDTreeNode * subsample_data( ::CvMat const * _subsample_idx ) {
        namespace bpl = boost::python;
        if( bpl::override func_subsample_data = this->get_override( "subsample_data" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_subsample_data.ptr(), _subsample_idx );
            return bpl::extract< CvDTreeNode * >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvERTreeTrainData::subsample_data( boost::python::ptr(_subsample_idx) );
        }
    }
    
    static boost::python::object default_subsample_data( ::CvERTreeTrainData & inst, ::cv::Mat & _subsample_idx ){
        CvDTreeNode * result;
        if( dynamic_cast< CvERTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            result = inst.::CvERTreeTrainData::subsample_data(get_CvMat_ptr(_subsample_idx));
        }
        else{
            result = inst.subsample_data(get_CvMat_ptr(_subsample_idx));
        }
        typedef bp::return_internal_reference< > call_policies_t;
        return bp::object( pyplusplus::call_policies::make_object< call_policies_t, CvDTreeNode * >( result ) );
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->CvDTreeTrainData::clear(  );
        }
    }
    
    void default_clear(  ) {
        CvDTreeTrainData::clear( );
    }

    virtual void do_responses_copy(  ) {
        if( bp::override func_do_responses_copy = this->get_override( "do_responses_copy" ) )
            func_do_responses_copy(  );
        else{
            this->CvDTreeTrainData::do_responses_copy(  );
        }
    }
    
    void default_do_responses_copy(  ) {
        CvDTreeTrainData::do_responses_copy( );
    }

    virtual void free_node( ::CvDTreeNode * node ) {
        if( bp::override func_free_node = this->get_override( "free_node" ) )
            func_free_node( boost::python::ptr(node) );
        else{
            this->CvDTreeTrainData::free_node( boost::python::ptr(node) );
        }
    }
    
    void default_free_node( ::CvDTreeNode * node ) {
        CvDTreeTrainData::free_node( boost::python::ptr(node) );
    }

    virtual void free_node_data( ::CvDTreeNode * node ) {
        if( bp::override func_free_node_data = this->get_override( "free_node_data" ) )
            func_free_node_data( boost::python::ptr(node) );
        else{
            this->CvDTreeTrainData::free_node_data( boost::python::ptr(node) );
        }
    }
    
    void default_free_node_data( ::CvDTreeNode * node ) {
        CvDTreeTrainData::free_node_data( boost::python::ptr(node) );
    }

    virtual void free_train_data(  ) {
        if( bp::override func_free_train_data = this->get_override( "free_train_data" ) )
            func_free_train_data(  );
        else{
            this->CvDTreeTrainData::free_train_data(  );
        }
    }
    
    void default_free_train_data(  ) {
        CvDTreeTrainData::free_train_data( );
    }

    virtual int get_child_buf_idx( ::CvDTreeNode * n ) {
        if( bp::override func_get_child_buf_idx = this->get_override( "get_child_buf_idx" ) )
            return func_get_child_buf_idx( boost::python::ptr(n) );
        else{
            return this->CvDTreeTrainData::get_child_buf_idx( boost::python::ptr(n) );
        }
    }
    
    int default_get_child_buf_idx( ::CvDTreeNode * n ) {
        return CvDTreeTrainData::get_child_buf_idx( boost::python::ptr(n) );
    }

    virtual ::CvDTreeNode * new_node( ::CvDTreeNode * parent, int count, int storage_idx, int offset ) {
        if( bp::override func_new_node = this->get_override( "new_node" ) )
            return func_new_node( boost::python::ptr(parent), count, storage_idx, offset );
        else{
            return this->CvDTreeTrainData::new_node( boost::python::ptr(parent), count, storage_idx, offset );
        }
    }
    
    ::CvDTreeNode * default_new_node( ::CvDTreeNode * parent, int count, int storage_idx, int offset ) {
        return CvDTreeTrainData::new_node( boost::python::ptr(parent), count, storage_idx, offset );
    }

    virtual ::CvDTreeSplit * new_split_cat( int vi, float quality ) {
        if( bp::override func_new_split_cat = this->get_override( "new_split_cat" ) )
            return func_new_split_cat( vi, quality );
        else{
            return this->CvDTreeTrainData::new_split_cat( vi, quality );
        }
    }
    
    ::CvDTreeSplit * default_new_split_cat( int vi, float quality ) {
        return CvDTreeTrainData::new_split_cat( vi, quality );
    }

    virtual ::CvDTreeSplit * new_split_ord( int vi, float cmp_val, int split_point, int inversed, float quality ) {
        if( bp::override func_new_split_ord = this->get_override( "new_split_ord" ) )
            return func_new_split_ord( vi, cmp_val, split_point, inversed, quality );
        else{
            return this->CvDTreeTrainData::new_split_ord( vi, cmp_val, split_point, inversed, quality );
        }
    }
    
    ::CvDTreeSplit * default_new_split_ord( int vi, float cmp_val, int split_point, int inversed, float quality ) {
        return CvDTreeTrainData::new_split_ord( vi, cmp_val, split_point, inversed, quality );
    }

    virtual void read_params( ::CvFileStorage * fs, ::CvFileNode * node ) {
        namespace bpl = boost::python;
        if( bpl::override func_read_params = this->get_override( "read_params" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_read_params.ptr(), fs, node );
        }
        else{
            CvDTreeTrainData::read_params( boost::python::ptr(fs), boost::python::ptr(node) );
        }
    }
    
    static void default_read_params( ::CvDTreeTrainData & inst, ::cv::FileStorage & fs, ::cv::FileNode & node ){
        if( dynamic_cast< CvERTreeTrainData_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvDTreeTrainData::read_params(fs.fs, *(node));
        }
        else{
            inst.read_params(fs.fs, *(node));
        }
    }

    virtual bool set_params( ::CvDTreeParams const & params ) {
        if( bp::override func_set_params = this->get_override( "set_params" ) )
            return func_set_params( boost::ref(params) );
        else{
            return this->CvDTreeTrainData::set_params( boost::ref(params) );
        }
    }
    
    bool default_set_params( ::CvDTreeParams const & params ) {
        return CvDTreeTrainData::set_params( boost::ref(params) );
    }

    virtual void write_params( ::CvFileStorage * fs ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_write_params = this->get_override( "write_params" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_write_params.ptr(), fs );
        }
        else{
            CvDTreeTrainData::write_params( boost::python::ptr(fs) );
        }
    }
    
    static void default_write_params( ::CvDTreeTrainData const & inst, ::cv::FileStorage & fs ){
        if( dynamic_cast< CvERTreeTrainData_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::CvDTreeTrainData::write_params(fs.fs);
        }
        else{
            inst.write_params(fs.fs);
        }
    }

};

static bp::object CvERTreeTrainData_get_cat_var_data(bp::object const &bpinst, CvDTreeNode* n, int vi)
{
    CvERTreeTrainData &inst = bp::extract<CvERTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_cat_var_data(n, vi, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::object CvERTreeTrainData_get_cv_labels(bp::object const &bpinst, CvDTreeNode* n)
{
    CvERTreeTrainData &inst = bp::extract<CvERTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_cv_labels(n, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::object CvERTreeTrainData_get_sample_indices(bp::object const &bpinst, CvDTreeNode* n)
{
    CvERTreeTrainData &inst = bp::extract<CvERTreeTrainData &>(bpinst);
    int size = n->sample_count;
    sdcpp::ndarray result = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    int *in_arr = (int*)result.data();
    const int *out_arr = inst.get_sample_indices(n, in_arr);
    
    if(!out_arr) return bp::object();
    if(out_arr == in_arr) return result.get_obj();
    
    result = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr);
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result.get_obj();
}

static bp::tuple CvERTreeTrainData_get_ord_var_data(bp::object const &bpinst, CvDTreeNode* n, int vi)
{
    CvERTreeTrainData &inst = bp::extract<CvERTreeTrainData &>(bpinst);
    int size = n->sample_count;
    std::vector<int> sample_indices(size);
    sdcpp::ndarray result1 = sdcpp::simplenew_ndarray(1, &size, NPY_FLOAT);
    sdcpp::ndarray result2 = sdcpp::simplenew_ndarray(1, &size, NPY_INT);
    float *in_arr1 = (float*)result1.data();
    int *in_arr2 = (int*)result2.data();
    const float *out_arr1;
    const int *out_arr2;
    inst.get_ord_var_data(n, vi, in_arr1, in_arr2, &out_arr1, &out_arr2, &sample_indices[0]);
    
    bp::object obj1, obj2;
    
    if(out_arr1 && out_arr1 != in_arr1)
    {
        result1 = sdcpp::new_ndarray1d(size, NPY_FLOAT, (void *)out_arr1);
        bp::objects::make_nurse_and_patient(result1.get_obj().ptr(), bpinst.ptr());
    }
    if(out_arr1) obj1 = result1.get_obj();
    
    if(out_arr2 && out_arr2 != in_arr2)
    {
        result2 = sdcpp::new_ndarray1d(size, NPY_INT, (void *)out_arr2);
        bp::objects::make_nurse_and_patient(result2.get_obj().ptr(), bpinst.ptr());
    }
    if(out_arr2) obj2 = result2.get_obj();
    
    return bp::make_tuple(obj1, obj2);
}

static cv::Mat get_CvERTreeTrainData_missing_mask(CvERTreeTrainData const &inst) { return inst.missing_mask? cv::Mat(inst.missing_mask): cv::Mat(); }

static cv::TermCriteria *get_CvRTParams_term_crit(CvRTParams const &inst) { return (cv::TermCriteria *)(&inst.term_crit); }

struct CvRTrees_wrapper : CvRTrees, bp::wrapper< CvRTrees > {

    CvRTrees_wrapper(CvRTrees const & arg )
    : CvRTrees( arg )
      , bp::wrapper< CvRTrees >(){
        // copy constructor
        
    }

    CvRTrees_wrapper( )
    : CvRTrees( )
      , bp::wrapper< CvRTrees >(){
        // null constructor
    
    }

    virtual float calc_error( ::CvMLData * _data, int type, ::std::vector< float > * resp=0 ) {
        if( bp::override func_calc_error = this->get_override( "calc_error" ) )
            return func_calc_error( boost::python::ptr(_data), type, boost::python::ptr(resp) );
        else{
            return this->CvRTrees::calc_error( boost::python::ptr(_data), type, boost::python::ptr(resp) );
        }
    }
    
    float default_calc_error( ::CvMLData * _data, int type, ::std::vector< float > * resp=0 ) {
        return CvRTrees::calc_error( boost::python::ptr(_data), type, boost::python::ptr(resp) );
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->CvRTrees::clear(  );
        }
    }
    
    void default_clear(  ) {
        CvRTrees::clear( );
    }

    virtual float get_proximity( ::CvMat const * sample1, ::CvMat const * sample2, ::CvMat const * missing1=0, ::CvMat const * missing2=0 ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_get_proximity = this->get_override( "get_proximity" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_get_proximity.ptr(), sample1, sample2, missing1, missing2 );
            return bpl::extract< float >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvRTrees::get_proximity( boost::python::ptr(sample1), boost::python::ptr(sample2), boost::python::ptr(missing1), boost::python::ptr(missing2) );
        }
    }
    
    static boost::python::object default_get_proximity( ::CvRTrees const & inst, ::cv::Mat & sample1, ::cv::Mat & sample2, ::cv::Mat missing1=cv::Mat(), ::cv::Mat missing2=cv::Mat() ){
        float result;
        if( dynamic_cast< CvRTrees_wrapper const* >( boost::addressof( inst ) ) ){
            result = inst.::CvRTrees::get_proximity(get_CvMat_ptr(sample1), get_CvMat_ptr(sample2), get_CvMat_ptr(missing1), get_CvMat_ptr(missing2));
        }
        else{
            result = inst.get_proximity(get_CvMat_ptr(sample1), get_CvMat_ptr(sample2), get_CvMat_ptr(missing1), get_CvMat_ptr(missing2));
        }
        return bp::object( result );
    }

    virtual float get_train_error(  ) {
        if( bp::override func_get_train_error = this->get_override( "get_train_error" ) )
            return func_get_train_error(  );
        else{
            return this->CvRTrees::get_train_error(  );
        }
    }
    
    float default_get_train_error(  ) {
        return CvRTrees::get_train_error( );
    }

    virtual ::CvMat const * get_var_importance(  ) {
        if( bp::override func_get_var_importance = this->get_override( "get_var_importance" ) )
            return func_get_var_importance(  );
        else{
            return this->CvRTrees::get_var_importance(  );
        }
    }
    
    ::CvMat const * default_get_var_importance(  ) {
        return CvRTrees::get_var_importance( );
    }

    virtual float predict( ::CvMat const * sample, ::CvMat const * missing=0 ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_predict = this->get_override( "predict" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_predict.ptr(), sample, missing );
            return bpl::extract< float >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvRTrees::predict( boost::python::ptr(sample), boost::python::ptr(missing) );
        }
    }
    
    static boost::python::object default_predict_8f760c2403d8e76b3c8cb03f101d0997( ::CvRTrees const & inst, ::cv::Mat & sample, ::cv::Mat missing=cv::Mat() ){
        float result;
        if( dynamic_cast< CvRTrees_wrapper const* >( boost::addressof( inst ) ) ){
            result = inst.::CvRTrees::predict(get_CvMat_ptr(sample), get_CvMat_ptr(missing));
        }
        else{
            result = inst.predict(get_CvMat_ptr(sample), get_CvMat_ptr(missing));
        }
        return bp::object( result );
    }

    virtual float predict( ::cv::Mat const & sample, ::cv::Mat const & missing=cv::Mat() ) const  {
        if( bp::override func_predict = this->get_override( "predict" ) )
            return func_predict( boost::ref(sample), boost::ref(missing) );
        else{
            return this->CvRTrees::predict( boost::ref(sample), boost::ref(missing) );
        }
    }
    
    float default_predict( ::cv::Mat const & sample, ::cv::Mat const & missing=cv::Mat() ) const  {
        return CvRTrees::predict( boost::ref(sample), boost::ref(missing) );
    }

    virtual float predict_prob( ::CvMat const * sample, ::CvMat const * missing=0 ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_predict_prob = this->get_override( "predict_prob" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_predict_prob.ptr(), sample, missing );
            return bpl::extract< float >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvRTrees::predict_prob( boost::python::ptr(sample), boost::python::ptr(missing) );
        }
    }
    
    static boost::python::object default_predict_prob_4a1ffb549242708ef963dcd84a06f27d( ::CvRTrees const & inst, ::cv::Mat & sample, ::cv::Mat missing=cv::Mat() ){
        float result;
        if( dynamic_cast< CvRTrees_wrapper const* >( boost::addressof( inst ) ) ){
            result = inst.::CvRTrees::predict_prob(get_CvMat_ptr(sample), get_CvMat_ptr(missing));
        }
        else{
            result = inst.predict_prob(get_CvMat_ptr(sample), get_CvMat_ptr(missing));
        }
        return bp::object( result );
    }

    virtual float predict_prob( ::cv::Mat const & sample, ::cv::Mat const & missing=cv::Mat() ) const  {
        if( bp::override func_predict_prob = this->get_override( "predict_prob" ) )
            return func_predict_prob( boost::ref(sample), boost::ref(missing) );
        else{
            return this->CvRTrees::predict_prob( boost::ref(sample), boost::ref(missing) );
        }
    }
    
    float default_predict_prob( ::cv::Mat const & sample, ::cv::Mat const & missing=cv::Mat() ) const  {
        return CvRTrees::predict_prob( boost::ref(sample), boost::ref(missing) );
    }

    virtual void read( ::CvFileStorage * fs, ::CvFileNode * node ) {
        namespace bpl = boost::python;
        if( bpl::override func_read = this->get_override( "read" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_read.ptr(), fs, node );
        }
        else{
            CvRTrees::read( boost::python::ptr(fs), boost::python::ptr(node) );
        }
    }
    
    static void default_read( ::CvRTrees & inst, ::cv::FileStorage & fs, ::cv::FileNode & node ){
        if( dynamic_cast< CvRTrees_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvRTrees::read(fs.fs, *(node));
        }
        else{
            inst.read(fs.fs, *(node));
        }
    }

    virtual bool train( ::CvMat const * _train_data, int _tflag, ::CvMat const * _responses, ::CvMat const * _var_idx=0, ::CvMat const * _sample_idx=0, ::CvMat const * _var_type=0, ::CvMat const * _missing_mask=0, ::CvRTParams params=::CvRTParams( ) ) {
        namespace bpl = boost::python;
        if( bpl::override func_train = this->get_override( "train" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_train.ptr(), _train_data, _tflag, _responses, _var_idx, _sample_idx, _var_type, _missing_mask, params );
            return bpl::extract< bool >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return CvRTrees::train( boost::python::ptr(_train_data), _tflag, boost::python::ptr(_responses), boost::python::ptr(_var_idx), boost::python::ptr(_sample_idx), boost::python::ptr(_var_type), boost::python::ptr(_missing_mask), params );
        }
    }
    
    static boost::python::object default_train_cfc4310d5a1b0f02573fba5d58a97880( ::CvRTrees & inst, ::cv::Mat & _train_data, int _tflag, ::cv::Mat & _responses, ::cv::Mat _var_idx=cv::Mat(), ::cv::Mat _sample_idx=cv::Mat(), ::cv::Mat _var_type=cv::Mat(), ::cv::Mat _missing_mask=cv::Mat(), ::CvRTParams params=::CvRTParams( ) ){
        bool result;
        if( dynamic_cast< CvRTrees_wrapper * >( boost::addressof( inst ) ) ){
            result = inst.::CvRTrees::train(get_CvMat_ptr(_train_data), _tflag, get_CvMat_ptr(_responses), get_CvMat_ptr(_var_idx), get_CvMat_ptr(_sample_idx), get_CvMat_ptr(_var_type), get_CvMat_ptr(_missing_mask), params);
        }
        else{
            result = inst.train(get_CvMat_ptr(_train_data), _tflag, get_CvMat_ptr(_responses), get_CvMat_ptr(_var_idx), get_CvMat_ptr(_sample_idx), get_CvMat_ptr(_var_type), get_CvMat_ptr(_missing_mask), params);
        }
        return bp::object( result );
    }

    virtual bool train( ::CvMLData * data, ::CvRTParams params=::CvRTParams( ) ) {
        if( bp::override func_train = this->get_override( "train" ) )
            return func_train( boost::python::ptr(data), params );
        else{
            return this->CvRTrees::train( boost::python::ptr(data), params );
        }
    }
    
    bool default_train( ::CvMLData * data, ::CvRTParams params=::CvRTParams( ) ) {
        return CvRTrees::train( boost::python::ptr(data), params );
    }

    virtual bool train( ::cv::Mat const & _train_data, int _tflag, ::cv::Mat const & _responses, ::cv::Mat const & _var_idx=cv::Mat(), ::cv::Mat const & _sample_idx=cv::Mat(), ::cv::Mat const & _var_type=cv::Mat(), ::cv::Mat const & _missing_mask=cv::Mat(), ::CvRTParams params=::CvRTParams( ) ) {
        if( bp::override func_train = this->get_override( "train" ) )
            return func_train( boost::ref(_train_data), _tflag, boost::ref(_responses), boost::ref(_var_idx), boost::ref(_sample_idx), boost::ref(_var_type), boost::ref(_missing_mask), params );
        else{
            return this->CvRTrees::train( boost::ref(_train_data), _tflag, boost::ref(_responses), boost::ref(_var_idx), boost::ref(_sample_idx), boost::ref(_var_type), boost::ref(_missing_mask), params );
        }
    }
    
    bool default_train( ::cv::Mat const & _train_data, int _tflag, ::cv::Mat const & _responses, ::cv::Mat const & _var_idx=cv::Mat(), ::cv::Mat const & _sample_idx=cv::Mat(), ::cv::Mat const & _var_type=cv::Mat(), ::cv::Mat const & _missing_mask=cv::Mat(), ::CvRTParams params=::CvRTParams( ) ) {
        return CvRTrees::train( boost::ref(_train_data), _tflag, boost::ref(_responses), boost::ref(_var_idx), boost::ref(_sample_idx), boost::ref(_var_type), boost::ref(_missing_mask), params );
    }

    virtual void write( ::CvFileStorage * fs, char const * name ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_write = this->get_override( "write" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_write.ptr(), fs, name );
        }
        else{
            CvRTrees::write( boost::python::ptr(fs), name );
        }
    }
    
    static void default_write( ::CvRTrees const & inst, ::cv::FileStorage & fs, char const * name ){
        if( dynamic_cast< CvRTrees_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::CvRTrees::write(fs.fs, name);
        }
        else{
            inst.write(fs.fs, name);
        }
    }

    virtual void load( char const * filename, char const * name=0 ) {
        if( bp::override func_load = this->get_override( "load" ) )
            func_load( filename, name );
        else{
            this->CvStatModel::load( filename, name );
        }
    }
    
    void default_load( char const * filename, char const * name=0 ) {
        CvStatModel::load( filename, name );
    }

    virtual void save( char const * filename, char const * name=0 ) const  {
        if( bp::override func_save = this->get_override( "save" ) )
            func_save( filename, name );
        else{
            this->CvStatModel::save( filename, name );
        }
    }
    
    void default_save( char const * filename, char const * name=0 ) const  {
        CvStatModel::save( filename, name );
    }

};

void register_classes_5(){

    bp::class_< CvERTreeTrainData_wrapper, bp::bases< CvDTreeTrainData > >( "CvERTreeTrainData" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvERTreeTrainData >() )    
        .def( 
            "get_vectors"
            , (void (*)( CvERTreeTrainData &,::cv::Mat &,std::vector<float> const &,std::vector<unsigned char> const &,std::vector<float> const &,bool ))( &CvERTreeTrainData_wrapper::default_get_vectors )
            , ( bp::arg("inst"), bp::arg("_subsample_idx"), bp::arg("values"), bp::arg("missing"), bp::arg("responses"), bp::arg("get_class_idx")=(bool)(false) )
            , "\nArgument '_subsample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'values':"\
    "\n    C++ type: float *"\
    "\n    Python type: vector_float32"\
    "\nArgument 'missing':"\
    "\n    C++ type: ::uchar *"\
    "\n    Python type: vector_uint8"\
    "\nArgument 'responses':"\
    "\n    C++ type: float *"\
    "\n    Python type: vector_float32" )    
        .def( 
            "set_data"
            , (void (*)( CvERTreeTrainData &,::cv::Mat &,int,::cv::Mat &,::cv::Mat,::cv::Mat,::cv::Mat,::cv::Mat,CvDTreeParams const &,bool,bool,bool ))( &CvERTreeTrainData_wrapper::default_set_data )
            , ( bp::arg("inst"), bp::arg("_train_data"), bp::arg("_tflag"), bp::arg("_responses"), bp::arg("_var_idx")=cv::Mat(), bp::arg("_sample_idx")=cv::Mat(), bp::arg("_var_type")=cv::Mat(), bp::arg("_missing_mask")=cv::Mat(), bp::arg("_params")=::CvDTreeParams( ), bp::arg("_shared")=(bool)(false), bp::arg("_add_labels")=(bool)(false), bp::arg("_update_data")=(bool)(false) )
            , "\nArgument '_train_data':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_responses':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_sample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_type':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_missing_mask':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "subsample_data"
            , (boost::python::object (*)( CvERTreeTrainData &,::cv::Mat & ))( &CvERTreeTrainData_wrapper::default_subsample_data )
            , ( bp::arg("inst"), bp::arg("_subsample_idx") )
            , "\nArgument '_subsample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "clear"
            , (void ( CvDTreeTrainData::* )(  ) )(&::CvDTreeTrainData::clear)
            , (void ( CvERTreeTrainData_wrapper::* )(  ) )(&CvERTreeTrainData_wrapper::default_clear) )    
        .def( 
            "do_responses_copy"
            , (void ( CvDTreeTrainData::* )(  ) )(&::CvDTreeTrainData::do_responses_copy)
            , (void ( CvERTreeTrainData_wrapper::* )(  ) )(&CvERTreeTrainData_wrapper::default_do_responses_copy) )    
        .def( 
            "free_node"
            , (void ( CvDTreeTrainData::* )( ::CvDTreeNode * ) )(&::CvDTreeTrainData::free_node)
            , (void ( CvERTreeTrainData_wrapper::* )( ::CvDTreeNode * ) )(&CvERTreeTrainData_wrapper::default_free_node)
            , ( bp::arg("node") ) )    
        .def( 
            "free_node_data"
            , (void ( CvDTreeTrainData::* )( ::CvDTreeNode * ) )(&::CvDTreeTrainData::free_node_data)
            , (void ( CvERTreeTrainData_wrapper::* )( ::CvDTreeNode * ) )(&CvERTreeTrainData_wrapper::default_free_node_data)
            , ( bp::arg("node") ) )    
        .def( 
            "free_train_data"
            , (void ( CvDTreeTrainData::* )(  ) )(&::CvDTreeTrainData::free_train_data)
            , (void ( CvERTreeTrainData_wrapper::* )(  ) )(&CvERTreeTrainData_wrapper::default_free_train_data) )    
        .def( 
            "get_child_buf_idx"
            , (int ( CvDTreeTrainData::* )( ::CvDTreeNode * ) )(&::CvDTreeTrainData::get_child_buf_idx)
            , (int ( CvERTreeTrainData_wrapper::* )( ::CvDTreeNode * ) )(&CvERTreeTrainData_wrapper::default_get_child_buf_idx)
            , ( bp::arg("n") ) )    
        .def( 
            "new_node"
            , (::CvDTreeNode * ( CvDTreeTrainData::* )( ::CvDTreeNode *,int,int,int ) )(&::CvDTreeTrainData::new_node)
            , (::CvDTreeNode * ( CvERTreeTrainData_wrapper::* )( ::CvDTreeNode *,int,int,int ) )(&CvERTreeTrainData_wrapper::default_new_node)
            , ( bp::arg("parent"), bp::arg("count"), bp::arg("storage_idx"), bp::arg("offset") )
            , bp::return_internal_reference< >() )    
        .def( 
            "new_split_cat"
            , (::CvDTreeSplit * ( CvDTreeTrainData::* )( int,float ) )(&::CvDTreeTrainData::new_split_cat)
            , (::CvDTreeSplit * ( CvERTreeTrainData_wrapper::* )( int,float ) )(&CvERTreeTrainData_wrapper::default_new_split_cat)
            , ( bp::arg("vi"), bp::arg("quality") )
            , bp::return_internal_reference< >() )    
        .def( 
            "new_split_ord"
            , (::CvDTreeSplit * ( CvDTreeTrainData::* )( int,float,int,int,float ) )(&::CvDTreeTrainData::new_split_ord)
            , (::CvDTreeSplit * ( CvERTreeTrainData_wrapper::* )( int,float,int,int,float ) )(&CvERTreeTrainData_wrapper::default_new_split_ord)
            , ( bp::arg("vi"), bp::arg("cmp_val"), bp::arg("split_point"), bp::arg("inversed"), bp::arg("quality") )
            , bp::return_internal_reference< >() )    
        .def( 
            "read_params"
            , (void (*)( CvDTreeTrainData &,::cv::FileStorage &,::cv::FileNode & ))( &CvERTreeTrainData_wrapper::default_read_params )
            , ( bp::arg("inst"), bp::arg("fs"), bp::arg("node") )
            , "\nArgument 'fs':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'node':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "set_params"
            , (bool ( CvDTreeTrainData::* )( ::CvDTreeParams const & ) )(&::CvDTreeTrainData::set_params)
            , (bool ( CvERTreeTrainData_wrapper::* )( ::CvDTreeParams const & ) )(&CvERTreeTrainData_wrapper::default_set_params)
            , ( bp::arg("params") ) )    
        .def( 
            "write_params"
            , (void (*)( CvDTreeTrainData const &,::cv::FileStorage & ))( &CvERTreeTrainData_wrapper::default_write_params )
            , ( bp::arg("inst"), bp::arg("fs") )
            , "\nArgument 'fs':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" )    
        .def("get_cat_var_data", &::CvERTreeTrainData_get_cat_var_data, (bp::arg("self"), bp::arg("n"), bp::arg("vi")))    
        .def("get_cv_labels", &::CvERTreeTrainData_get_cv_labels, (bp::arg("self"), bp::arg("n")))    
        .def("get_sample_indices", &::CvERTreeTrainData_get_sample_indices, (bp::arg("self"), bp::arg("n")))    
        .def("get_ord_var_data", &::CvERTreeTrainData_get_ord_var_data, (bp::arg("self"), bp::arg("n"), bp::arg("vi")))    
        .add_property( "missing_mask", &::get_CvERTreeTrainData_missing_mask );

    bp::class_< CvRTParams, bp::bases< CvDTreeParams > >( "CvRTParams", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvRTParams >() )    
        .def( bp::init< int, int, float, bool, int, float const *, bool, int, int, float, int >(( bp::arg("_max_depth"), bp::arg("_min_sample_count"), bp::arg("_regression_accuracy"), bp::arg("_use_surrogates"), bp::arg("_max_categories"), bp::arg("_priors"), bp::arg("_calc_var_importance"), bp::arg("_nactive_vars"), bp::arg("max_num_of_trees_in_the_forest"), bp::arg("forest_accuracy"), bp::arg("termcrit_type") ), "\nWrapped function:"
    "\n    CvRTParams"
    "\nArgument '_priors':"\
    "\n    C++ type: float const *"\
    "\n    Python type: vector_float32") )    
        .def_readwrite( "calc_var_importance", &CvRTParams::calc_var_importance )    
        .def_readwrite( "nactive_vars", &CvRTParams::nactive_vars )    
        .add_property( "term_crit", bp::make_function(&::get_CvRTParams_term_crit, bp::return_internal_reference<>()) );

    bp::class_< CvRTrees_wrapper, bp::bases< CvStatModel > >( "CvRTrees", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvRTrees >() )    
        .def( 
            "calc_error"
            , (float ( CvRTrees::* )( ::CvMLData *,int,::std::vector< float > * ) )(&::CvRTrees::calc_error)
            , (float ( CvRTrees_wrapper::* )( ::CvMLData *,int,::std::vector< float > * ) )(&CvRTrees_wrapper::default_calc_error)
            , ( bp::arg("_data"), bp::arg("type"), bp::arg("resp")=bp::object() ) )    
        .def( 
            "clear"
            , (void ( CvRTrees::* )(  ) )(&::CvRTrees::clear)
            , (void ( CvRTrees_wrapper::* )(  ) )(&CvRTrees_wrapper::default_clear) )    
        .def( 
            "get_active_var_mask"
            , (::CvMat * ( CvRTrees::* )(  ) )( &::CvRTrees::get_active_var_mask )
            , bp::return_internal_reference< >() )    
        .def( 
            "get_proximity"
            , (boost::python::object (*)( CvRTrees const &,::cv::Mat &,::cv::Mat &,::cv::Mat,::cv::Mat ))( &CvRTrees_wrapper::default_get_proximity )
            , ( bp::arg("inst"), bp::arg("sample1"), bp::arg("sample2"), bp::arg("missing1")=cv::Mat(), bp::arg("missing2")=cv::Mat() )
            , "\nArgument 'sample1':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'sample2':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'missing1':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'missing2':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "get_train_error"
            , (float ( CvRTrees::* )(  ) )(&::CvRTrees::get_train_error)
            , (float ( CvRTrees_wrapper::* )(  ) )(&CvRTrees_wrapper::default_get_train_error) )    
        .def( 
            "get_tree"
            , (::CvForestTree * ( CvRTrees::* )( int ) const)( &::CvRTrees::get_tree )
            , ( bp::arg("i") )
            , bp::return_internal_reference< >() )    
        .def( 
            "get_tree_count"
            , (int ( CvRTrees::* )(  ) const)( &::CvRTrees::get_tree_count ) )    
        .def( 
            "get_var_importance"
            , (::CvMat const * ( CvRTrees::* )(  ) )(&::CvRTrees::get_var_importance)
            , (::CvMat const * ( CvRTrees_wrapper::* )(  ) )(&CvRTrees_wrapper::default_get_var_importance)
            , bp::return_internal_reference< >() )    
        .def( 
            "predict"
            , (boost::python::object (*)( CvRTrees const &,::cv::Mat &,::cv::Mat ))( &CvRTrees_wrapper::default_predict_8f760c2403d8e76b3c8cb03f101d0997 )
            , ( bp::arg("inst"), bp::arg("sample"), bp::arg("missing")=cv::Mat() )
            , "\nArgument 'sample':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'missing':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "predict"
            , (float ( CvRTrees::* )( ::cv::Mat const &,::cv::Mat const & ) const)(&::CvRTrees::predict)
            , (float ( CvRTrees_wrapper::* )( ::cv::Mat const &,::cv::Mat const & ) const)(&CvRTrees_wrapper::default_predict)
            , ( bp::arg("sample"), bp::arg("missing")=cv::Mat() ) )    
        .def( 
            "predict_prob"
            , (boost::python::object (*)( CvRTrees const &,::cv::Mat &,::cv::Mat ))( &CvRTrees_wrapper::default_predict_prob_4a1ffb549242708ef963dcd84a06f27d )
            , ( bp::arg("inst"), bp::arg("sample"), bp::arg("missing")=cv::Mat() )
            , "\nArgument 'sample':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument 'missing':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "predict_prob"
            , (float ( CvRTrees::* )( ::cv::Mat const &,::cv::Mat const & ) const)(&::CvRTrees::predict_prob)
            , (float ( CvRTrees_wrapper::* )( ::cv::Mat const &,::cv::Mat const & ) const)(&CvRTrees_wrapper::default_predict_prob)
            , ( bp::arg("sample"), bp::arg("missing")=cv::Mat() ) )    
        .def( 
            "read"
            , (void (*)( CvRTrees &,::cv::FileStorage &,::cv::FileNode & ))( &CvRTrees_wrapper::default_read )
            , ( bp::arg("inst"), bp::arg("fs"), bp::arg("node") )
            , "\nArgument 'fs':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'node':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "train"
            , (boost::python::object (*)( CvRTrees &,::cv::Mat &,int,::cv::Mat &,::cv::Mat,::cv::Mat,::cv::Mat,::cv::Mat,CvRTParams ))( &CvRTrees_wrapper::default_train_cfc4310d5a1b0f02573fba5d58a97880 )
            , ( bp::arg("inst"), bp::arg("_train_data"), bp::arg("_tflag"), bp::arg("_responses"), bp::arg("_var_idx")=cv::Mat(), bp::arg("_sample_idx")=cv::Mat(), bp::arg("_var_type")=cv::Mat(), bp::arg("_missing_mask")=cv::Mat(), bp::arg("params")=::CvRTParams( ) )
            , "\nArgument '_train_data':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_responses':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_sample_idx':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_var_type':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat"\
    "\nArgument '_missing_mask':"\
    "\n    C++ type: ::CvMat const *"\
    "\n    Python type: Mat" )    
        .def( 
            "train"
            , (bool ( CvRTrees::* )( ::CvMLData *,::CvRTParams ) )(&::CvRTrees::train)
            , (bool ( CvRTrees_wrapper::* )( ::CvMLData *,::CvRTParams ) )(&CvRTrees_wrapper::default_train)
            , ( bp::arg("data"), bp::arg("params")=::CvRTParams( ) ) )    
        .def( 
            "train"
            , (bool ( CvRTrees::* )( ::cv::Mat const &,int,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::CvRTParams ) )(&::CvRTrees::train)
            , (bool ( CvRTrees_wrapper::* )( ::cv::Mat const &,int,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::CvRTParams ) )(&CvRTrees_wrapper::default_train)
            , ( bp::arg("_train_data"), bp::arg("_tflag"), bp::arg("_responses"), bp::arg("_var_idx")=cv::Mat(), bp::arg("_sample_idx")=cv::Mat(), bp::arg("_var_type")=cv::Mat(), bp::arg("_missing_mask")=cv::Mat(), bp::arg("params")=::CvRTParams( ) ) )    
        .def( 
            "write"
            , (void (*)( CvRTrees const &,::cv::FileStorage &,char const * ))( &CvRTrees_wrapper::default_write )
            , ( bp::arg("inst"), bp::arg("fs"), bp::arg("name") )
            , "\nArgument 'fs':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" )    
        .def( 
            "load"
            , (void ( CvStatModel::* )( char const *,char const * ) )(&::CvStatModel::load)
            , (void ( CvRTrees_wrapper::* )( char const *,char const * ) )(&CvRTrees_wrapper::default_load)
            , ( bp::arg("filename"), bp::arg("name")=bp::object() ) )    
        .def( 
            "save"
            , (void ( CvStatModel::* )( char const *,char const * ) const)(&::CvStatModel::save)
            , (void ( CvRTrees_wrapper::* )( char const *,char const * ) const)(&CvRTrees_wrapper::default_save)
            , ( bp::arg("filename"), bp::arg("name")=bp::object() ) );

}
