// This file has been generated by Py++.

#include "boost/python.hpp"
#include "opencv_converters.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "ndarray.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cxcore_hpp_wrapper.hpp"
#include "opencv_converters.hpp"
#include "boost/python/object/life_support.hpp"
#include "arrayobject.h"
#include "ndarray.hpp"
#include "cxcore_hpp_ext_classes_2.pypp.hpp"

namespace bp = boost::python;

static bp::tuple children(cv::FileNode const &inst)
{
    bp::list l;
    for(cv::FileNodeIterator i = inst.begin(); i != inst.end(); ++i)
        l.append(bp::object(*i));
    return bp::tuple(l);
}

static cv::Mat readRaw(cv::FileNode const &inst, std::string const &fmt, int len)
{
    std::vector<uchar> data;
    data.resize(len);
    inst.readRaw(fmt, &data[0], len);
    return convert_from_vector_of_T_to_Mat<uchar>(data);
}

struct FileStorage_wrapper : cv::FileStorage, bp::wrapper< cv::FileStorage > {

    FileStorage_wrapper(cv::FileStorage const & arg )
    : cv::FileStorage( arg )
      , bp::wrapper< cv::FileStorage >(){
        // copy constructor
        
    }

    FileStorage_wrapper( )
    : cv::FileStorage( )
      , bp::wrapper< cv::FileStorage >(){
        // null constructor
    
    }

    FileStorage_wrapper(::std::string const & filename, int flags )
    : cv::FileStorage( boost::ref(filename), flags )
      , bp::wrapper< cv::FileStorage >(){
        // constructor
    
    }

    virtual bool isOpened(  ) const  {
        if( bp::override func_isOpened = this->get_override( "isOpened" ) )
            return func_isOpened(  );
        else{
            return this->cv::FileStorage::isOpened(  );
        }
    }
    
    bool default_isOpened(  ) const  {
        return cv::FileStorage::isOpened( );
    }

    virtual bool open( ::std::string const & filename, int flags ) {
        if( bp::override func_open = this->get_override( "open" ) )
            return func_open( boost::ref(filename), flags );
        else{
            return this->cv::FileStorage::open( boost::ref(filename), flags );
        }
    }
    
    bool default_open( ::std::string const & filename, int flags ) {
        return cv::FileStorage::open( boost::ref(filename), flags );
    }

    virtual void release(  ) {
        if( bp::override func_release = this->get_override( "release" ) )
            func_release(  );
        else{
            this->cv::FileStorage::release(  );
        }
    }
    
    void default_release(  ) {
        cv::FileStorage::release( );
    }

    static void writeRaw( ::cv::FileStorage & inst, ::std::string const & fmt, std::vector<unsigned char> const & vec ){
        inst.writeRaw(fmt, (::uchar const *)(&vec[0]), (int)(vec.size()));
    }

};

static boost::python::tuple findNearest_ea97c6aa84c5363d34b3e91951773ead( ::cv::KDTree const & inst, std::vector<float> const & vec, int K, int Emax ){
    std::vector<int> neighborsIdx2;
    cv::Mat neighbors2;
    std::vector<float> dist2;
    int result = inst.findNearest((float const *)(&vec[0]), K, Emax, &neighborsIdx2, &neighbors2, &dist2);
    return bp::make_tuple( result, neighborsIdx2, neighbors2, dist2 );
}

static boost::python::tuple findOrthoRange_8f5141c7ea87ab587a033ff4e81c09d9( ::cv::KDTree const & inst, std::vector<float> const & minBounds, std::vector<float> const & maxBounds ){
    std::vector<int> neighborsIdx2;
    cv::Mat neighbors2;
    inst.findOrthoRange((float const *)(&minBounds[0]), (float const *)(&maxBounds[0]), &neighborsIdx2, &neighbors2);
    return bp::make_tuple( neighborsIdx2, neighbors2 );
}

static boost::python::object getPoints_cb19ade779f56a2e3d487759ce0fd7ea( ::cv::KDTree const & inst, std::vector<int> const & idx ){
    cv::Mat pts2;
    inst.getPoints((int const *)(&idx[0]), (int)(idx.size()), pts2);
    return bp::object( pts2 );
}

static boost::python::object getPoints_dfa4c20a74f0aaa501985d64a11da238( ::cv::KDTree const & inst, ::cv::Mat const & idxs ){
    cv::Mat pts2;
    inst.getPoints(idxs, pts2);
    return bp::object( pts2 );
}

inline int cv::KDTree::dims() const { return points.cols; }

sdcpp::ndarray KDTree_getPoint(bp::object const &bpinst, int i) {
    cv::KDTree const &inst = bp::extract<cv::KDTree const &>(bpinst);
    sdcpp::ndarray result = sdcpp::new_ndarray1d(inst.points.cols, NPY_FLOAT, 
        (void *)inst.getPoint(i));
    bp::objects::make_nurse_and_patient(result.get_obj().ptr(), bpinst.ptr());
    return result;
}

struct LineIterator_wrapper : cv::LineIterator, bp::wrapper< cv::LineIterator > {

    LineIterator_wrapper(cv::LineIterator const & arg )
    : cv::LineIterator( arg )
      , bp::wrapper< cv::LineIterator >(){
        // copy constructor
        
    }

    private:
    int iteration;
    int ws, es;
    uchar *ptr0;

public:
    LineIterator_wrapper(const cv::Mat& img, cv::Point const &pt1, cv::Point const &pt2,
        int connectivity=8, bool leftToRight=false)
        : cv::LineIterator(img, pt1, pt2, connectivity, leftToRight),
        iteration(0), ptr0(img.data), ws(img.step), es(img.elemSize()) {}
        
    LineIterator_wrapper const &iter() { return *this; }
    
    cv::Point next()
    {
        int ofs = (int)(ptr-ptr0);
        
        if(iteration < count)
        {
            ++(*this);
            ++iteration;
        }
        else
        {
            PyErr_SetString(PyExc_StopIteration, "No more pixel.");
            throw bp::error_already_set(); 
        }
        
        return cv::Point((ofs%ws)/es, ofs/ws);
    }

};

struct NAryMatNDIterator_wrapper : cv::NAryMatNDIterator, bp::wrapper< cv::NAryMatNDIterator > {

    NAryMatNDIterator_wrapper(cv::NAryMatNDIterator const & arg )
    : cv::NAryMatNDIterator( arg )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // copy constructor
        
    }

    NAryMatNDIterator_wrapper(::cv::MatND const & m1 )
    : cv::NAryMatNDIterator( boost::ref(m1) )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // constructor
    
    }

    NAryMatNDIterator_wrapper(::cv::MatND const & m1, ::cv::MatND const & m2 )
    : cv::NAryMatNDIterator( boost::ref(m1), boost::ref(m2) )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // constructor
    
    }

    NAryMatNDIterator_wrapper(::cv::MatND const & m1, ::cv::MatND const & m2, ::cv::MatND const & m3 )
    : cv::NAryMatNDIterator( boost::ref(m1), boost::ref(m2), boost::ref(m3) )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // constructor
    
    }

    NAryMatNDIterator_wrapper(::cv::MatND const & m1, ::cv::MatND const & m2, ::cv::MatND const & m3, ::cv::MatND const & m4 )
    : cv::NAryMatNDIterator( boost::ref(m1), boost::ref(m2), boost::ref(m3), boost::ref(m4) )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // constructor
    
    }

    NAryMatNDIterator_wrapper(::cv::MatND const & m1, ::cv::MatND const & m2, ::cv::MatND const & m3, ::cv::MatND const & m4, ::cv::MatND const & m5 )
    : cv::NAryMatNDIterator( boost::ref(m1), boost::ref(m2), boost::ref(m3), boost::ref(m4), boost::ref(m5) )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // constructor
    
    }

    NAryMatNDIterator_wrapper(::cv::MatND const & m1, ::cv::MatND const & m2, ::cv::MatND const & m3, ::cv::MatND const & m4, ::cv::MatND const & m5, ::cv::MatND const & m6 )
    : cv::NAryMatNDIterator( boost::ref(m1), boost::ref(m2), boost::ref(m3), boost::ref(m4), boost::ref(m5), boost::ref(m6) )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // constructor
    
    }

    NAryMatNDIterator_wrapper( )
    : cv::NAryMatNDIterator( )
      , bp::wrapper< cv::NAryMatNDIterator >(){
        // null constructor
    
    }

    static void init( ::cv::NAryMatNDIterator & inst, std::vector<cv::MatND> const & arrays ){
        
    std::vector<cv::MatND const *> buf_arrays(arrays.size());
    for(size_t i_arrays = 0; i_arrays<arrays.size(); ++i_arrays)
        buf_arrays[i_arrays] = (cv::MatND const *)&(arrays[i_arrays]);
        
        inst.init((cv::MatND const * *)(&buf_arrays[0]), arrays.size());
    }

    NAryMatNDIterator_wrapper const &iter() { return *this; }
    
    bp::object next()
    {
        if(idx >= nplanes)
        {
            PyErr_SetString(PyExc_StopIteration, "No more plane.");
            throw bp::error_already_set(); 
        }
        bp::object result(planes);
        if(idx >= nplanes-1) ++idx;
        else ++(*this);
        return result;
    }

};

static boost::shared_ptr<cv::NAryMatNDIterator> NAryMatNDIterator__init1__(std::vector<cv::MatND> const &arrays)
{
    std::vector<cv::MatND const *> buf_arrays(arrays.size());
    for(size_t i_arrays = 0; i_arrays<arrays.size(); ++i_arrays)
        buf_arrays[i_arrays] = (cv::MatND const *)&(arrays[i_arrays]);
        
    return boost::shared_ptr<cv::NAryMatNDIterator>(new cv::NAryMatNDIterator((cv::MatND const * *)(&buf_arrays[0]), arrays.size()));
}

void register_classes_2(){

    { //::cv::FileNode
        typedef bp::class_< cv::FileNode > FileNode_exposer_t;
        FileNode_exposer_t FileNode_exposer = FileNode_exposer_t( "FileNode", "\nThe XML/YAML file node class."
    "\n"
    "\nIn PyOpenCV, FileNode is a Python iterator which iterates over the "
    "\nchild nodes of type FileNode. You can use the read-only attribute "
    "\n'children' to get the list of child nodes, too."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filenode", bp::init< >() );
        bp::scope FileNode_scope( FileNode_exposer );
        FileNode_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::FileNode >(), "\nThe XML/YAML file node class."
    "\n"
    "\nIn PyOpenCV, FileNode is a Python iterator which iterates over the "
    "\nchild nodes of type FileNode. You can use the read-only attribute "
    "\n'children' to get the list of child nodes, too."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filenode" );
        bp::scope().attr("NONE") = (int)cv::FileNode::NONE;
        bp::scope().attr("INT") = (int)cv::FileNode::INT;
        bp::scope().attr("REAL") = (int)cv::FileNode::REAL;
        bp::scope().attr("FLOAT") = (int)cv::FileNode::FLOAT;
        bp::scope().attr("STR") = (int)cv::FileNode::STR;
        bp::scope().attr("STRING") = (int)cv::FileNode::STRING;
        bp::scope().attr("REF") = (int)cv::FileNode::REF;
        bp::scope().attr("SEQ") = (int)cv::FileNode::SEQ;
        bp::scope().attr("MAP") = (int)cv::FileNode::MAP;
        bp::scope().attr("TYPE_MASK") = (int)cv::FileNode::TYPE_MASK;
        bp::scope().attr("FLOW") = (int)cv::FileNode::FLOW;
        bp::scope().attr("USER") = (int)cv::FileNode::USER;
        bp::scope().attr("EMPTY") = (int)cv::FileNode::EMPTY;
        bp::scope().attr("NAMED") = (int)cv::FileNode::NAMED;
        FileNode_exposer.def( bp::init< cv::FileNode const & >(( bp::arg("_node") )) );
        { //::cv::FileNode::empty
        
            typedef bool ( ::cv::FileNode::*empty_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "empty"
                , empty_function_type( &::cv::FileNode::empty ) );
        
        }
        { //::cv::FileNode::isInt
        
            typedef bool ( ::cv::FileNode::*isInt_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isInt"
                , isInt_function_type( &::cv::FileNode::isInt ) );
        
        }
        { //::cv::FileNode::isMap
        
            typedef bool ( ::cv::FileNode::*isMap_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isMap"
                , isMap_function_type( &::cv::FileNode::isMap ) );
        
        }
        { //::cv::FileNode::isNamed
        
            typedef bool ( ::cv::FileNode::*isNamed_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isNamed"
                , isNamed_function_type( &::cv::FileNode::isNamed ) );
        
        }
        { //::cv::FileNode::isNone
        
            typedef bool ( ::cv::FileNode::*isNone_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isNone"
                , isNone_function_type( &::cv::FileNode::isNone ) );
        
        }
        { //::cv::FileNode::isReal
        
            typedef bool ( ::cv::FileNode::*isReal_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isReal"
                , isReal_function_type( &::cv::FileNode::isReal ) );
        
        }
        { //::cv::FileNode::isSeq
        
            typedef bool ( ::cv::FileNode::*isSeq_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isSeq"
                , isSeq_function_type( &::cv::FileNode::isSeq ) );
        
        }
        { //::cv::FileNode::isString
        
            typedef bool ( ::cv::FileNode::*isString_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "isString"
                , isString_function_type( &::cv::FileNode::isString ) );
        
        }
        { //::cv::FileNode::name
        
            typedef ::std::string ( ::cv::FileNode::*name_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "name"
                , name_function_type( &::cv::FileNode::name ) );
        
        }
        FileNode_exposer.def( "as_str", &cv::FileNode::operator ::std::string , "\nWrapped function:"
    "\n    operator ::std::string" );
        FileNode_exposer.def( "as_float64", &cv::FileNode::operator double , "\nWrapped function:"
    "\n    operator double" );
        FileNode_exposer.def( "as_float32", &cv::FileNode::operator float , "\nWrapped function:"
    "\n    operator float" );
        FileNode_exposer.def( "as_int", &cv::FileNode::operator int , "\nWrapped function:"
    "\n    operator int" );
        { //::cv::FileNode::operator[]
        
            typedef ::cv::FileNode ( ::cv::FileNode::*__getitem___function_type )( ::std::string const & ) const;
            
            FileNode_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::FileNode::operator[] )
                , ( bp::arg("nodename") )
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::FileNode::operator[]
        
            typedef ::cv::FileNode ( ::cv::FileNode::*__getitem___function_type )( int ) const;
            
            FileNode_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::FileNode::operator[] )
                , ( bp::arg("i") )
                , "\nWrapped function:"
    "\n    operator[]" );
        
        }
        { //::cv::FileNode::size
        
            typedef ::size_t ( ::cv::FileNode::*size_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "size"
                , size_function_type( &::cv::FileNode::size ) );
        
        }
        { //::cv::FileNode::type
        
            typedef int ( ::cv::FileNode::*type_function_type )(  ) const;
            
            FileNode_exposer.def( 
                "type"
                , type_function_type( &::cv::FileNode::type ) );
        
        }
        FileNode_exposer.add_property("children", &::children);
        FileNode_exposer.def("__iter__", &::children);
        FileNode_exposer.def("readRaw", &::readRaw, ( bp::arg("inst"), bp::arg("fmt"), bp::arg("len") ), "Reads raw data. Argument 'vec' is returned as a Mat.");
    }

    { //::cv::FileStorage
        typedef bp::class_< FileStorage_wrapper > FileStorage_exposer_t;
        FileStorage_exposer_t FileStorage_exposer = FileStorage_exposer_t( "FileStorage", "\nThe XML/YAML file storage class."
    "\n"
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage", bp::init< >("\nConstructor."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage") );
        bp::scope FileStorage_scope( FileStorage_exposer );
        FileStorage_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::FileStorage >(), "\nThe XML/YAML file storage class."
    "\n"
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage" );
        bp::scope().attr("READ") = (int)cv::FileStorage::READ;
        bp::scope().attr("WRITE") = (int)cv::FileStorage::WRITE;
        bp::scope().attr("APPEND") = (int)cv::FileStorage::APPEND;
        bp::scope().attr("UNDEFINED") = (int)cv::FileStorage::UNDEFINED;
        bp::scope().attr("VALUE_EXPECTED") = (int)cv::FileStorage::VALUE_EXPECTED;
        bp::scope().attr("NAME_EXPECTED") = (int)cv::FileStorage::NAME_EXPECTED;
        bp::scope().attr("INSIDE_MAP") = (int)cv::FileStorage::INSIDE_MAP;
        FileStorage_exposer.def( bp::init< std::string const &, int >(( bp::arg("filename"), bp::arg("flags") ), "\nConstructor."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage") );
        { //::cv::FileStorage::getDefaultObjectName
        
            typedef ::std::string ( *getDefaultObjectName_function_type )( ::std::string const & );
            
            FileStorage_exposer.def( 
                "getDefaultObjectName"
                , getDefaultObjectName_function_type( &::cv::FileStorage::getDefaultObjectName )
                , ( bp::arg("filename") )
                , "\nReturns the default object name from the filename (used by cvSave() "
    "\nwith the default object name etc.)."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage" );
        
        }
        { //::cv::FileStorage::getFirstTopLevelNode
        
            typedef ::cv::FileNode ( ::cv::FileStorage::*getFirstTopLevelNode_function_type )(  ) const;
            
            FileStorage_exposer.def( 
                "getFirstTopLevelNode"
                , getFirstTopLevelNode_function_type( &::cv::FileStorage::getFirstTopLevelNode )
                , "\nReturns the first top-level node."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage" );
        
        }
        { //::cv::FileStorage::isOpened
        
            typedef bool ( ::cv::FileStorage::*isOpened_function_type )(  ) const;
            typedef bool ( FileStorage_wrapper::*default_isOpened_function_type )(  ) const;
            
            FileStorage_exposer.def( 
                "isOpened"
                , isOpened_function_type(&::cv::FileStorage::isOpened)
                , default_isOpened_function_type(&FileStorage_wrapper::default_isOpened) );
        
        }
        { //::cv::FileStorage::open
        
            typedef bool ( ::cv::FileStorage::*open_function_type )( ::std::string const &,int ) ;
            typedef bool ( FileStorage_wrapper::*default_open_function_type )( ::std::string const &,int ) ;
            
            FileStorage_exposer.def( 
                "open"
                , open_function_type(&::cv::FileStorage::open)
                , default_open_function_type(&FileStorage_wrapper::default_open)
                , ( bp::arg("filename"), bp::arg("flags") ) );
        
        }
        { //::cv::FileStorage::operator[]
        
            typedef ::cv::FileNode ( ::cv::FileStorage::*__getitem___function_type )( ::std::string const & ) const;
            
            FileStorage_exposer.def( 
                "__getitem__"
                , __getitem___function_type( &::cv::FileStorage::operator[] )
                , ( bp::arg("nodename") )
                , "\nReturns the top-level node by name."
    "\nWrapped function:"
    "\n    operator[]"
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage" );
        
        }
        { //::cv::FileStorage::release
        
            typedef void ( ::cv::FileStorage::*release_function_type )(  ) ;
            typedef void ( FileStorage_wrapper::*default_release_function_type )(  ) ;
            
            FileStorage_exposer.def( 
                "release"
                , release_function_type(&::cv::FileStorage::release)
                , default_release_function_type(&FileStorage_wrapper::default_release) );
        
        }
        { //::cv::FileStorage::root
        
            typedef ::cv::FileNode ( ::cv::FileStorage::*root_function_type )( int ) const;
            
            FileStorage_exposer.def( 
                "root"
                , root_function_type( &::cv::FileStorage::root )
                , ( bp::arg("streamidx")=(int)(0) )
                , "\nReturns the root file node (it's the parent of the first top-level "
    "\nnode)."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage" );
        
        }
        { //::cv::FileStorage::writeRaw
        
            typedef void ( *writeRaw_function_type )( cv::FileStorage &,::std::string const &,std::vector<unsigned char> const & );
            
            FileStorage_exposer.def( 
                "writeRaw"
                , writeRaw_function_type( &FileStorage_wrapper::writeRaw )
                , ( bp::arg("inst"), bp::arg("fmt"), bp::arg("vec") )
                , "\nWrites the certain number of elements of the specified format."
    "\nReference:"
    "\n    http://opencv.willowgarage.com/documentation/cpp/xml_yaml_persistence.html#filestorage"
    "\nArgument 'vec':"\
    "\n    C++ type: ::uchar const *"\
    "\n    Python type: vector_uint8"\
    "\nArgument 'len':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'vec'." );
        
        }
        FileStorage_exposer.def_readwrite( "elname", &cv::FileStorage::elname );
        FileStorage_exposer.def_readwrite( "state", &cv::FileStorage::state );
        FileStorage_exposer.staticmethod( "getDefaultObjectName" );
    }

    { //::cv::KDTree
        typedef bp::class_< cv::KDTree > KDTree_exposer_t;
        KDTree_exposer_t KDTree_exposer = KDTree_exposer_t( "KDTree", bp::init< >() );
        bp::scope KDTree_scope( KDTree_exposer );
        KDTree_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::KDTree >() );
        bp::class_< cv::KDTree::Node >( "KDTree_Node", bp::init< >() )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::KDTree::Node >() )    
            .def( bp::init< int, int, int, float >(( bp::arg("_idx"), bp::arg("_left"), bp::arg("_right"), bp::arg("_boundary") )) )    
            .def_readwrite( "boundary", &cv::KDTree::Node::boundary )    
            .def_readwrite( "idx", &cv::KDTree::Node::idx )    
            .def_readwrite( "left", &cv::KDTree::Node::left )    
            .def_readwrite( "right", &cv::KDTree::Node::right );
        KDTree_exposer.def( bp::init< cv::Mat const &, bp::optional< bool > >(( bp::arg("_points"), bp::arg("copyAndReorderPoints")=(bool)(false) )) );
        bp::implicitly_convertible< cv::Mat const &, cv::KDTree >();
        { //::cv::KDTree::build
        
            typedef void ( ::cv::KDTree::*build_function_type )( ::cv::Mat const &,bool ) ;
            
            KDTree_exposer.def( 
                "build"
                , build_function_type( &::cv::KDTree::build )
                , ( bp::arg("_points"), bp::arg("copyAndReorderPoints")=(bool)(false) ) );
        
        }
        { //::cv::KDTree::dims
        
            typedef int ( ::cv::KDTree::*dims_function_type )(  ) const;
            
            KDTree_exposer.def( 
                "dims"
                , dims_function_type( &::cv::KDTree::dims ) );
        
        }
        { //::cv::KDTree::findNearest
        
            typedef boost::python::tuple ( *findNearest_function_type )( cv::KDTree const &,std::vector<float> const &,int,int );
            
            KDTree_exposer.def( 
                "findNearest"
                , findNearest_function_type( &findNearest_ea97c6aa84c5363d34b3e91951773ead )
                , ( bp::arg("inst"), bp::arg("vec"), bp::arg("K"), bp::arg("Emax") )
                , "\nArgument 'vec':"\
    "\n    C++ type: float const *"\
    "\n    Python type: vector_float32"\
    "\nArgument 'neighborsIdx':"\
    "\n    C++ type: ::std::vector< int > *"\
    "\n    Python type: vector_int"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'neighbors':"\
    "\n    C++ type: ::cv::Mat *"\
    "\n    Python type: Mat"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'dist':"\
    "\n    C++ type: ::std::vector< float > *"\
    "\n    Python type: vector_float32"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((int), neighborsIdx, neighbors, dist)" );
        
        }
        { //::cv::KDTree::findOrthoRange
        
            typedef boost::python::tuple ( *findOrthoRange_function_type )( cv::KDTree const &,std::vector<float> const &,std::vector<float> const & );
            
            KDTree_exposer.def( 
                "findOrthoRange"
                , findOrthoRange_function_type( &findOrthoRange_8f5141c7ea87ab587a033ff4e81c09d9 )
                , ( bp::arg("inst"), bp::arg("minBounds"), bp::arg("maxBounds") )
                , "\nArgument 'minBounds':"\
    "\n    C++ type: float const *"\
    "\n    Python type: vector_float32"\
    "\nArgument 'maxBounds':"\
    "\n    C++ type: float const *"\
    "\n    Python type: vector_float32"\
    "\nArgument 'neighborsIdx':"\
    "\n    C++ type: ::std::vector< int > *"\
    "\n    Python type: vector_int"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'neighbors':"\
    "\n    C++ type: ::cv::Mat *"\
    "\n    Python type: Mat"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    (neighborsIdx, neighbors)" );
        
        }
        { //::cv::KDTree::getPoints
        
            typedef boost::python::object ( *getPoints_function_type )( cv::KDTree const &,std::vector<int> const & );
            
            KDTree_exposer.def( 
                "getPoints"
                , getPoints_function_type( &getPoints_cb19ade779f56a2e3d487759ce0fd7ea )
                , ( bp::arg("inst"), bp::arg("idx") )
                , "\nArgument 'idx':"\
    "\n    C++ type: int const *"\
    "\n    Python type: vector_int"\
    "\nArgument 'nidx':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'idx'."\
    "\nArgument 'pts':"\
    "\n    C++ type: ::cv::Mat &"\
    "\n    Python type: Mat"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    pts" );
        
        }
        { //::cv::KDTree::getPoints
        
            typedef boost::python::object ( *getPoints_function_type )( cv::KDTree const &,cv::Mat const & );
            
            KDTree_exposer.def( 
                "getPoints"
                , getPoints_function_type( &getPoints_dfa4c20a74f0aaa501985d64a11da238 )
                , ( bp::arg("inst"), bp::arg("idxs") )
                , "\nArgument 'pts':"\
    "\n    C++ type: ::cv::Mat &"\
    "\n    Python type: Mat"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    pts" );
        
        }
        KDTree_exposer.def_readwrite( "maxDepth", &cv::KDTree::maxDepth );
        KDTree_exposer.def_readwrite( "nodes", &cv::KDTree::nodes );
        KDTree_exposer.def_readwrite( "normType", &cv::KDTree::normType );
        KDTree_exposer.def_readwrite( "points", &cv::KDTree::points );
        KDTree_exposer.def( "getPoint", &KDTree_getPoint, (bp::arg("ptidx")) );
    }

    bp::class_< LineIterator_wrapper >( "LineIterator", bp::no_init )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::LineIterator >() )    
        .def_readwrite( "count", &cv::LineIterator::count )    
        .def_readwrite( "err", &cv::LineIterator::err )    
        .def_readwrite( "minusDelta", &cv::LineIterator::minusDelta )    
        .def_readwrite( "minusStep", &cv::LineIterator::minusStep )    
        .def_readwrite( "plusDelta", &cv::LineIterator::plusDelta )    
        .def_readwrite( "plusStep", &cv::LineIterator::plusStep )    
        .def(bp::init<cv::Mat const &, cv::Point const &, cv::Point const &, int, bool>(( bp::arg("img"), bp::arg("pt1"), bp::arg("pt2"), bp::arg("connectivity")=8, bp::arg("leftToRight")=false)))    
        .def("__iter__", &::LineIterator_wrapper::iter, bp::return_self<>())    
        .def("next", &::LineIterator_wrapper::next);

    { //::cv::NAryMatNDIterator
        typedef bp::class_< NAryMatNDIterator_wrapper > NAryMatNDIterator_exposer_t;
        NAryMatNDIterator_exposer_t NAryMatNDIterator_exposer = NAryMatNDIterator_exposer_t( "NAryMatNDIterator", bp::init< cv::MatND const & >(( bp::arg("m1") )) );
        bp::scope NAryMatNDIterator_scope( NAryMatNDIterator_exposer );
        NAryMatNDIterator_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::NAryMatNDIterator >() );
        bp::implicitly_convertible< cv::MatND const &, cv::NAryMatNDIterator >();
        NAryMatNDIterator_exposer.def( bp::init< cv::MatND const &, cv::MatND const & >(( bp::arg("m1"), bp::arg("m2") )) );
        NAryMatNDIterator_exposer.def( bp::init< cv::MatND const &, cv::MatND const &, cv::MatND const & >(( bp::arg("m1"), bp::arg("m2"), bp::arg("m3") )) );
        NAryMatNDIterator_exposer.def( bp::init< cv::MatND const &, cv::MatND const &, cv::MatND const &, cv::MatND const & >(( bp::arg("m1"), bp::arg("m2"), bp::arg("m3"), bp::arg("m4") )) );
        NAryMatNDIterator_exposer.def( bp::init< cv::MatND const &, cv::MatND const &, cv::MatND const &, cv::MatND const &, cv::MatND const & >(( bp::arg("m1"), bp::arg("m2"), bp::arg("m3"), bp::arg("m4"), bp::arg("m5") )) );
        NAryMatNDIterator_exposer.def( bp::init< cv::MatND const &, cv::MatND const &, cv::MatND const &, cv::MatND const &, cv::MatND const &, cv::MatND const & >(( bp::arg("m1"), bp::arg("m2"), bp::arg("m3"), bp::arg("m4"), bp::arg("m5"), bp::arg("m6") )) );
        NAryMatNDIterator_exposer.def( bp::init< >() );
        { //::cv::NAryMatNDIterator::init
        
            typedef void ( *init_function_type )( cv::NAryMatNDIterator &,std::vector<cv::MatND> const & );
            
            NAryMatNDIterator_exposer.def( 
                "init"
                , init_function_type( &NAryMatNDIterator_wrapper::init )
                , ( bp::arg("inst"), bp::arg("arrays") )
                , "\nArgument 'arrays':"\
    "\n    C++ type: ::cv::MatND const * *"\
    "\n    Python type: vector_MatND"\
    "\nArgument 'count':"\
    "\n    Dependent argument: omitted from input. Its value is derived from "\
    "\n    argument 'arrays'." );
        
        }
        NAryMatNDIterator_exposer.def_readwrite( "arrays", &cv::NAryMatNDIterator::arrays );
        NAryMatNDIterator_exposer.def_readwrite( "nplanes", &cv::NAryMatNDIterator::nplanes );
        NAryMatNDIterator_exposer.def_readwrite( "planes", &cv::NAryMatNDIterator::planes );
        NAryMatNDIterator_exposer.def("__init__", bp::make_constructor(&NAryMatNDIterator__init1__, bp::default_call_policies(), (bp::arg("arrays"))));
        NAryMatNDIterator_exposer.def("__iter__", &NAryMatNDIterator_wrapper::iter, bp::return_self<>());
        NAryMatNDIterator_exposer.def("next", &NAryMatNDIterator_wrapper::next);
    }

}
