// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "__array_1.pypp.hpp"
#include "ndarray.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cvaux_wrapper.hpp"
#include "sstream"
#include "cvaux_ext_classes_6.pypp.hpp"

namespace bp = boost::python;

struct Octree_wrapper : cv::Octree, bp::wrapper< cv::Octree > {

    Octree_wrapper(cv::Octree const & arg )
    : cv::Octree( arg )
      , bp::wrapper< cv::Octree >(){
        // copy constructor
        
    }

    struct Node_wrapper : cv::Octree::Node, bp::wrapper< cv::Octree::Node > {
    
        Node_wrapper(cv::Octree::Node const & arg )
        : cv::Octree::Node( arg )
          , bp::wrapper< cv::Octree::Node >(){
            // copy constructor
            
        }
    
        Node_wrapper( )
        : cv::Octree::Node( )
          , bp::wrapper< cv::Octree::Node >(){
            // null constructor
        
        }
    
        static pyplusplus::containers::static_sized::array_1_t< int, 8>
        pyplusplus_children_wrapper( cv::Octree::Node & inst ){
            return pyplusplus::containers::static_sized::array_1_t< int, 8>( inst.children );
        }
    
    };

    Octree_wrapper( )
    : cv::Octree( )
      , bp::wrapper< cv::Octree >(){
        // null constructor
    
    }

    Octree_wrapper(::std::vector< cv::Point3_<float> > const & points, int maxLevels=10, int minPoints=20 )
    : cv::Octree( boost::ref(points), maxLevels, minPoints )
      , bp::wrapper< cv::Octree >(){
        // constructor
    
    }

    virtual void buildTree( ::std::vector< cv::Point3_<float> > const & points, int maxLevels=10, int minPoints=20 ) {
        if( bp::override func_buildTree = this->get_override( "buildTree" ) )
            func_buildTree( boost::ref(points), maxLevels, minPoints );
        else{
            this->cv::Octree::buildTree( boost::ref(points), maxLevels, minPoints );
        }
    }
    
    void default_buildTree( ::std::vector< cv::Point3_<float> > const & points, int maxLevels=10, int minPoints=20 ) {
        cv::Octree::buildTree( boost::ref(points), maxLevels, minPoints );
    }

    virtual void getPointsWithinSphere( ::cv::Point3f const & center, float radius, ::std::vector< cv::Point3_<float> > & points ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_getPointsWithinSphere = this->get_override( "getPointsWithinSphere" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_getPointsWithinSphere.ptr(), center, radius, points );
        }
        else{
            cv::Octree::getPointsWithinSphere( boost::ref(center), radius, boost::ref(points) );
        }
    }
    
    static boost::python::object default_getPointsWithinSphere( ::cv::Octree const & inst, ::cv::Point3f const & center, float radius ){
        std::vector<cv::Point3_<float> > points2;
        if( dynamic_cast< Octree_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::cv::Octree::getPointsWithinSphere(center, radius, points2);
        }
        else{
            inst.getPointsWithinSphere(center, radius, points2);
        }
        return bp::object( points2 );
    }

};

struct PlanarObjectDetector_wrapper : cv::PlanarObjectDetector, bp::wrapper< cv::PlanarObjectDetector > {

    PlanarObjectDetector_wrapper(cv::PlanarObjectDetector const & arg )
    : cv::PlanarObjectDetector( arg )
      , bp::wrapper< cv::PlanarObjectDetector >(){
        // copy constructor
        
    }

    PlanarObjectDetector_wrapper( )
    : cv::PlanarObjectDetector( )
      , bp::wrapper< cv::PlanarObjectDetector >(){
        // null constructor
    
    }

    PlanarObjectDetector_wrapper(::cv::FileNode const & node )
    : cv::PlanarObjectDetector( boost::ref(node) )
      , bp::wrapper< cv::PlanarObjectDetector >(){
        // constructor
    
    }

    PlanarObjectDetector_wrapper(::std::vector< cv::Mat > const & pyr, int _npoints=300, int _patchSize=cv::FernClassifier::PATCH_SIZE, int _nstructs=cv::FernClassifier::DEFAULT_STRUCTS, int _structSize=cv::FernClassifier::DEFAULT_STRUCT_SIZE, int _nviews=cv::FernClassifier::DEFAULT_VIEWS, ::cv::LDetector const & detector=cv::LDetector(), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() )
    : cv::PlanarObjectDetector( boost::ref(pyr), _npoints, _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) )
      , bp::wrapper< cv::PlanarObjectDetector >(){
        // constructor
    
    }

    static boost::python::tuple __call___4ace94e257458a02821c3e23f229be80( ::cv::PlanarObjectDetector const & inst, ::cv::Mat const & image, ::cv::Mat & H ){
        std::vector<cv::Point_<float> > corners2;
        bool result = inst.operator()(image, H, corners2);
        return bp::make_tuple( result, corners2 );
    }

    static boost::python::tuple __call___353477db407d578b28250d295a56ae36( ::cv::PlanarObjectDetector const & inst, ::std::vector< cv::Mat > const & pyr, ::std::vector< cv::KeyPoint > const & keypoints, ::cv::Mat & H ){
        std::vector<cv::Point_<float> > corners2;
        std::vector<int> pairs2;
        bool result = inst.operator()(pyr, keypoints, H, corners2, &pairs2);
        return bp::make_tuple( result, corners2, pairs2 );
    }

    virtual void train( ::std::vector< cv::Mat > const & pyr, int _npoints=300, int _patchSize=cv::FernClassifier::PATCH_SIZE, int _nstructs=cv::FernClassifier::DEFAULT_STRUCTS, int _structSize=cv::FernClassifier::DEFAULT_STRUCT_SIZE, int _nviews=cv::FernClassifier::DEFAULT_VIEWS, ::cv::LDetector const & detector=cv::LDetector(), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        if( bp::override func_train = this->get_override( "train" ) )
            func_train( boost::ref(pyr), _npoints, _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) );
        else{
            this->cv::PlanarObjectDetector::train( boost::ref(pyr), _npoints, _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) );
        }
    }
    
    void default_train( ::std::vector< cv::Mat > const & pyr, int _npoints=300, int _patchSize=cv::FernClassifier::PATCH_SIZE, int _nstructs=cv::FernClassifier::DEFAULT_STRUCTS, int _structSize=cv::FernClassifier::DEFAULT_STRUCT_SIZE, int _nviews=cv::FernClassifier::DEFAULT_VIEWS, ::cv::LDetector const & detector=cv::LDetector(), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        cv::PlanarObjectDetector::train( boost::ref(pyr), _npoints, _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) );
    }

    virtual void train( ::std::vector< cv::Mat > const & pyr, ::std::vector< cv::KeyPoint > const & keypoints, int _patchSize=cv::FernClassifier::PATCH_SIZE, int _nstructs=cv::FernClassifier::DEFAULT_STRUCTS, int _structSize=cv::FernClassifier::DEFAULT_STRUCT_SIZE, int _nviews=cv::FernClassifier::DEFAULT_VIEWS, ::cv::LDetector const & detector=cv::LDetector(), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        if( bp::override func_train = this->get_override( "train" ) )
            func_train( boost::ref(pyr), boost::ref(keypoints), _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) );
        else{
            this->cv::PlanarObjectDetector::train( boost::ref(pyr), boost::ref(keypoints), _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) );
        }
    }
    
    void default_train( ::std::vector< cv::Mat > const & pyr, ::std::vector< cv::KeyPoint > const & keypoints, int _patchSize=cv::FernClassifier::PATCH_SIZE, int _nstructs=cv::FernClassifier::DEFAULT_STRUCTS, int _structSize=cv::FernClassifier::DEFAULT_STRUCT_SIZE, int _nviews=cv::FernClassifier::DEFAULT_VIEWS, ::cv::LDetector const & detector=cv::LDetector(), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        cv::PlanarObjectDetector::train( boost::ref(pyr), boost::ref(keypoints), _patchSize, _nstructs, _structSize, _nviews, boost::ref(detector), boost::ref(patchGenerator) );
    }

};

struct SelfSimDescriptor_wrapper : cv::SelfSimDescriptor, bp::wrapper< cv::SelfSimDescriptor > {

    SelfSimDescriptor_wrapper( )
    : cv::SelfSimDescriptor( )
      , bp::wrapper< cv::SelfSimDescriptor >(){
        // null constructor
    
    }

    SelfSimDescriptor_wrapper(int _ssize, int _lsize, int _startDistanceBucket=int(::cv::SelfSimDescriptor::DEFAULT_START_DISTANCE_BUCKET), int _numberOfDistanceBuckets=int(::cv::SelfSimDescriptor::DEFAULT_NUM_DISTANCE_BUCKETS), int _nangles=int(::cv::SelfSimDescriptor::DEFAULT_NUM_ANGLES) )
    : cv::SelfSimDescriptor( _ssize, _lsize, _startDistanceBucket, _numberOfDistanceBuckets, _nangles )
      , bp::wrapper< cv::SelfSimDescriptor >(){
        // constructor
    
    }

    SelfSimDescriptor_wrapper(::cv::SelfSimDescriptor const & ss )
    : cv::SelfSimDescriptor( boost::ref(ss) )
      , bp::wrapper< cv::SelfSimDescriptor >(){
        // copy constructor
    
    }

    virtual void SSD( ::cv::Mat const & img, ::cv::Point pt, ::cv::Mat & ssd ) const  {
        if( bp::override func_SSD = this->get_override( "SSD" ) )
            func_SSD( boost::ref(img), pt, boost::ref(ssd) );
        else{
            this->cv::SelfSimDescriptor::SSD( boost::ref(img), pt, boost::ref(ssd) );
        }
    }
    
    void default_SSD( ::cv::Mat const & img, ::cv::Point pt, ::cv::Mat & ssd ) const  {
        cv::SelfSimDescriptor::SSD( boost::ref(img), pt, boost::ref(ssd) );
    }

    virtual void compute( ::cv::Mat const & img, ::std::vector< float > & descriptors, ::cv::Size winStride=cv::Size_<int>(), ::std::vector< cv::Point_<int> > const & locations=std::vector<cv::Point>() ) const  {
        if( bp::override func_compute = this->get_override( "compute" ) )
            func_compute( boost::ref(img), boost::ref(descriptors), winStride, boost::ref(locations) );
        else{
            this->cv::SelfSimDescriptor::compute( boost::ref(img), boost::ref(descriptors), winStride, boost::ref(locations) );
        }
    }
    
    void default_compute( ::cv::Mat const & img, ::std::vector< float > & descriptors, ::cv::Size winStride=cv::Size_<int>(), ::std::vector< cv::Point_<int> > const & locations=std::vector<cv::Point>() ) const  {
        cv::SelfSimDescriptor::compute( boost::ref(img), boost::ref(descriptors), winStride, boost::ref(locations) );
    }

    virtual void computeLogPolarMapping( ::cv::Mat & mappingMask ) const  {
        if( bp::override func_computeLogPolarMapping = this->get_override( "computeLogPolarMapping" ) )
            func_computeLogPolarMapping( boost::ref(mappingMask) );
        else{
            this->cv::SelfSimDescriptor::computeLogPolarMapping( boost::ref(mappingMask) );
        }
    }
    
    void default_computeLogPolarMapping( ::cv::Mat & mappingMask ) const  {
        cv::SelfSimDescriptor::computeLogPolarMapping( boost::ref(mappingMask) );
    }

};

static boost::python::object match_86773a6b4d89ae97806d1109a2438811( ::cv::SpinImageModel & inst, ::cv::SpinImageModel const & scene ){
    std::vector<std::vector<cv::Vec<int,2> > > result3;
    inst.match(scene, result3);
    return bp::object( result3 );
}

static bp::str TickMeter__str__(cv::TickMeter const &inst)
{
    std::ostringstream oss;
    oss << inst;
    return bp::str(oss.str());
}

static bp::str TickMeter__repr__(cv::TickMeter const &inst)
{
    std::ostringstream oss;
    oss << "TickMeter(" << inst << ")";
    return bp::str(oss.str());
}

void register_classes_6(){

    { //::cv::Mesh3D
        typedef bp::class_< cv::Mesh3D > Mesh3D_exposer_t;
        Mesh3D_exposer_t Mesh3D_exposer = Mesh3D_exposer_t( "Mesh3D", bp::init< >() );
        bp::scope Mesh3D_scope( Mesh3D_exposer );
        Mesh3D_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Mesh3D >() );
        bp::class_< cv::Mesh3D::EmptyMeshException >( "EmptyMeshException" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Mesh3D::EmptyMeshException >() );
        Mesh3D_exposer.def( bp::init< std::vector< cv::Point3_<float> > const & >(( bp::arg("vtx") )) );
        bp::implicitly_convertible< std::vector< cv::Point3_<float> > const &, cv::Mesh3D >();
        { //::cv::Mesh3D::buildOctree
        
            typedef void ( ::cv::Mesh3D::*buildOctree_function_type )(  ) ;
            
            Mesh3D_exposer.def( 
                "buildOctree"
                , buildOctree_function_type( &::cv::Mesh3D::buildOctree ) );
        
        }
        { //::cv::Mesh3D::clearOctree
        
            typedef void ( ::cv::Mesh3D::*clearOctree_function_type )(  ) ;
            
            Mesh3D_exposer.def( 
                "clearOctree"
                , clearOctree_function_type( &::cv::Mesh3D::clearOctree ) );
        
        }
        { //::cv::Mesh3D::computeNormals
        
            typedef void ( ::cv::Mesh3D::*computeNormals_function_type )( float,int ) ;
            
            Mesh3D_exposer.def( 
                "computeNormals"
                , computeNormals_function_type( &::cv::Mesh3D::computeNormals )
                , ( bp::arg("normalRadius"), bp::arg("minNeighbors")=(int)(20) ) );
        
        }
        { //::cv::Mesh3D::computeNormals
        
            typedef void ( ::cv::Mesh3D::*computeNormals_function_type )( ::std::vector< int > const &,float,int ) ;
            
            Mesh3D_exposer.def( 
                "computeNormals"
                , computeNormals_function_type( &::cv::Mesh3D::computeNormals )
                , ( bp::arg("subset"), bp::arg("normalRadius"), bp::arg("minNeighbors")=(int)(20) ) );
        
        }
        { //::cv::Mesh3D::estimateResolution
        
            typedef float ( ::cv::Mesh3D::*estimateResolution_function_type )( float ) ;
            
            Mesh3D_exposer.def( 
                "estimateResolution"
                , estimateResolution_function_type( &::cv::Mesh3D::estimateResolution )
                , ( bp::arg("tryRatio")=1.00000001490116119384765625e-1f ) );
        
        }
        { //::cv::Mesh3D::writeAsVrml
        
            typedef void ( ::cv::Mesh3D::*writeAsVrml_function_type )( ::cv::String const &,::std::vector< cv::Scalar_<double> > const & ) const;
            
            Mesh3D_exposer.def( 
                "writeAsVrml"
                , writeAsVrml_function_type( &::cv::Mesh3D::writeAsVrml )
                , ( bp::arg("file"), bp::arg("colors")=std::vector<cv::Scalar>() ) );
        
        }
        Mesh3D_exposer.def_readonly( "allzero", cv::Mesh3D::allzero );
        Mesh3D_exposer.def_readwrite( "normals", &cv::Mesh3D::normals );
        Mesh3D_exposer.def_readwrite( "octree", &cv::Mesh3D::octree );
        Mesh3D_exposer.def_readwrite( "resolution", &cv::Mesh3D::resolution );
        Mesh3D_exposer.def_readwrite( "vtx", &cv::Mesh3D::vtx );
    }

    { //::cv::Octree
        typedef bp::class_< Octree_wrapper > Octree_exposer_t;
        Octree_exposer_t Octree_exposer = Octree_exposer_t( "Octree", bp::init< >() );
        bp::scope Octree_scope( Octree_exposer );
        Octree_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Octree >() );
        { //::cv::Octree::Node
            typedef bp::class_< Octree_wrapper::Node_wrapper > Node_exposer_t;
            Node_exposer_t Node_exposer = Node_exposer_t( "Node", bp::init< >() );
            bp::scope Node_scope( Node_exposer );
            Node_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::Octree::Node >() );
            Node_exposer.def_readwrite( "begin", &cv::Octree::Node::begin );
            pyplusplus::containers::static_sized::register_array_1< int, 8 >( "__array_1_int_8" );
            { //cv::Octree::Node::children [variable], type=int[8]
            
                typedef pyplusplus::containers::static_sized::array_1_t< int, 8> ( *array_wrapper_creator )( cv::Octree::Node & );
                
                Node_exposer.add_property( "children"
                    , bp::make_function( array_wrapper_creator(&Octree_wrapper::Node_wrapper::pyplusplus_children_wrapper)
                                        , bp::with_custodian_and_ward_postcall< 0, 1 >() ) );
            }
            Node_exposer.def_readwrite( "end", &cv::Octree::Node::end );
            Node_exposer.def_readwrite( "isLeaf", &cv::Octree::Node::isLeaf );
            Node_exposer.def_readwrite( "maxLevels", &cv::Octree::Node::maxLevels );
            Node_exposer.def_readwrite( "x_max", &cv::Octree::Node::x_max );
            Node_exposer.def_readwrite( "x_min", &cv::Octree::Node::x_min );
            Node_exposer.def_readwrite( "y_max", &cv::Octree::Node::y_max );
            Node_exposer.def_readwrite( "y_min", &cv::Octree::Node::y_min );
            Node_exposer.def_readwrite( "z_max", &cv::Octree::Node::z_max );
            Node_exposer.def_readwrite( "z_min", &cv::Octree::Node::z_min );
        }
        Octree_exposer.def( bp::init< std::vector< cv::Point3_<float> > const &, bp::optional< int, int > >(( bp::arg("points"), bp::arg("maxLevels")=(int)(10), bp::arg("minPoints")=(int)(20) )) );
        bp::implicitly_convertible< std::vector< cv::Point3_<float> > const &, cv::Octree >();
        { //::cv::Octree::buildTree
        
            typedef void ( ::cv::Octree::*buildTree_function_type )( ::std::vector< cv::Point3_<float> > const &,int,int ) ;
            typedef void ( Octree_wrapper::*default_buildTree_function_type )( ::std::vector< cv::Point3_<float> > const &,int,int ) ;
            
            Octree_exposer.def( 
                "buildTree"
                , buildTree_function_type(&::cv::Octree::buildTree)
                , default_buildTree_function_type(&Octree_wrapper::default_buildTree)
                , ( bp::arg("points"), bp::arg("maxLevels")=(int)(10), bp::arg("minPoints")=(int)(20) ) );
        
        }
        { //::cv::Octree::getNodes
        
            typedef ::std::vector< cv::Octree::Node > const & ( ::cv::Octree::*getNodes_function_type )(  ) const;
            
            Octree_exposer.def( 
                "getNodes"
                , getNodes_function_type( &::cv::Octree::getNodes )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::cv::Octree::getPointsWithinSphere
        
            typedef boost::python::object ( *default_getPointsWithinSphere_function_type )( cv::Octree const &,::cv::Point3f const &,float );
            
            Octree_exposer.def( 
                "getPointsWithinSphere"
                , default_getPointsWithinSphere_function_type( &Octree_wrapper::default_getPointsWithinSphere )
                , ( bp::arg("inst"), bp::arg("center"), bp::arg("radius") )
                , "\nArgument 'points':"\
    "\n    C++ type: ::std::vector< cv::Point3_<float> > &"\
    "\n    Python type: vector_Point3f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    points" );
        
        }
    }

    bp::class_< cv::OneWayDescriptor >( "OneWayDescriptor" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::OneWayDescriptor >() );

    bp::class_< cv::OneWayDescriptorBase >( "OneWayDescriptorBase", bp::no_init )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::OneWayDescriptorBase >() );

    { //::cv::PlanarObjectDetector
        typedef bp::class_< PlanarObjectDetector_wrapper > PlanarObjectDetector_exposer_t;
        PlanarObjectDetector_exposer_t PlanarObjectDetector_exposer = PlanarObjectDetector_exposer_t( "PlanarObjectDetector", bp::init< >() );
        bp::scope PlanarObjectDetector_scope( PlanarObjectDetector_exposer );
        PlanarObjectDetector_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::PlanarObjectDetector >() );
        PlanarObjectDetector_exposer.def( bp::init< cv::FileNode const & >(( bp::arg("node") )) );
        bp::implicitly_convertible< cv::FileNode const &, cv::PlanarObjectDetector >();
        PlanarObjectDetector_exposer.def( bp::init< std::vector< cv::Mat > const &, bp::optional< int, int, int, int, int, cv::LDetector const &, cv::PatchGenerator const & > >(( bp::arg("pyr"), bp::arg("_npoints")=(int)(300), bp::arg("_patchSize")=(int)(cv::FernClassifier::PATCH_SIZE), bp::arg("_nstructs")=(int)(cv::FernClassifier::DEFAULT_STRUCTS), bp::arg("_structSize")=(int)(cv::FernClassifier::DEFAULT_STRUCT_SIZE), bp::arg("_nviews")=(int)(cv::FernClassifier::DEFAULT_VIEWS), bp::arg("detector")=cv::LDetector(), bp::arg("patchGenerator")=cv::PatchGenerator() )) );
        bp::implicitly_convertible< std::vector< cv::Mat > const &, cv::PlanarObjectDetector >();
        { //::cv::PlanarObjectDetector::getModelPoints
        
            typedef ::std::vector< cv::KeyPoint > ( ::cv::PlanarObjectDetector::*getModelPoints_function_type )(  ) const;
            
            PlanarObjectDetector_exposer.def( 
                "getModelPoints"
                , getModelPoints_function_type( &::cv::PlanarObjectDetector::getModelPoints ) );
        
        }
        { //::cv::PlanarObjectDetector::operator()
        
            typedef boost::python::tuple ( *__call___function_type )( cv::PlanarObjectDetector const &,cv::Mat const &,cv::Mat & );
            
            PlanarObjectDetector_exposer.def( 
                "__call__"
                , __call___function_type( &PlanarObjectDetector_wrapper::__call___4ace94e257458a02821c3e23f229be80 )
                , ( bp::arg("inst"), bp::arg("image"), bp::arg("H") )
                , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'corners':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((bool), corners)" );
        
        }
        { //::cv::PlanarObjectDetector::operator()
        
            typedef boost::python::tuple ( *__call___function_type )( cv::PlanarObjectDetector const &,std::vector<cv::Mat> const &,std::vector<cv::KeyPoint> const &,cv::Mat & );
            
            PlanarObjectDetector_exposer.def( 
                "__call__"
                , __call___function_type( &PlanarObjectDetector_wrapper::__call___353477db407d578b28250d295a56ae36 )
                , ( bp::arg("inst"), bp::arg("pyr"), bp::arg("keypoints"), bp::arg("H") )
                , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'corners':"\
    "\n    C++ type: ::std::vector< cv::Point_<float> > &"\
    "\n    Python type: vector_Point2f"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nArgument 'pairs':"\
    "\n    C++ type: ::std::vector< int > *"\
    "\n    Python type: vector_int"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((bool), corners, pairs)" );
        
        }
        { //::cv::PlanarObjectDetector::read
        
            typedef void ( ::cv::PlanarObjectDetector::*read_function_type )( ::cv::FileNode const & ) ;
            
            PlanarObjectDetector_exposer.def( 
                "read"
                , read_function_type( &::cv::PlanarObjectDetector::read )
                , ( bp::arg("node") ) );
        
        }
        { //::cv::PlanarObjectDetector::setVerbose
        
            typedef void ( ::cv::PlanarObjectDetector::*setVerbose_function_type )( bool ) ;
            
            PlanarObjectDetector_exposer.def( 
                "setVerbose"
                , setVerbose_function_type( &::cv::PlanarObjectDetector::setVerbose )
                , ( bp::arg("verbose") ) );
        
        }
        { //::cv::PlanarObjectDetector::train
        
            typedef void ( ::cv::PlanarObjectDetector::*train_function_type )( ::std::vector< cv::Mat > const &,int,int,int,int,int,::cv::LDetector const &,::cv::PatchGenerator const & ) ;
            typedef void ( PlanarObjectDetector_wrapper::*default_train_function_type )( ::std::vector< cv::Mat > const &,int,int,int,int,int,::cv::LDetector const &,::cv::PatchGenerator const & ) ;
            
            PlanarObjectDetector_exposer.def( 
                "train"
                , train_function_type(&::cv::PlanarObjectDetector::train)
                , default_train_function_type(&PlanarObjectDetector_wrapper::default_train)
                , ( bp::arg("pyr"), bp::arg("_npoints")=(int)(300), bp::arg("_patchSize")=(int)(cv::FernClassifier::PATCH_SIZE), bp::arg("_nstructs")=(int)(cv::FernClassifier::DEFAULT_STRUCTS), bp::arg("_structSize")=(int)(cv::FernClassifier::DEFAULT_STRUCT_SIZE), bp::arg("_nviews")=(int)(cv::FernClassifier::DEFAULT_VIEWS), bp::arg("detector")=cv::LDetector(), bp::arg("patchGenerator")=cv::PatchGenerator() ) );
        
        }
        { //::cv::PlanarObjectDetector::train
        
            typedef void ( ::cv::PlanarObjectDetector::*train_function_type )( ::std::vector< cv::Mat > const &,::std::vector< cv::KeyPoint > const &,int,int,int,int,::cv::LDetector const &,::cv::PatchGenerator const & ) ;
            typedef void ( PlanarObjectDetector_wrapper::*default_train_function_type )( ::std::vector< cv::Mat > const &,::std::vector< cv::KeyPoint > const &,int,int,int,int,::cv::LDetector const &,::cv::PatchGenerator const & ) ;
            
            PlanarObjectDetector_exposer.def( 
                "train"
                , train_function_type(&::cv::PlanarObjectDetector::train)
                , default_train_function_type(&PlanarObjectDetector_wrapper::default_train)
                , ( bp::arg("pyr"), bp::arg("keypoints"), bp::arg("_patchSize")=(int)(cv::FernClassifier::PATCH_SIZE), bp::arg("_nstructs")=(int)(cv::FernClassifier::DEFAULT_STRUCTS), bp::arg("_structSize")=(int)(cv::FernClassifier::DEFAULT_STRUCT_SIZE), bp::arg("_nviews")=(int)(cv::FernClassifier::DEFAULT_VIEWS), bp::arg("detector")=cv::LDetector(), bp::arg("patchGenerator")=cv::PatchGenerator() ) );
        
        }
        { //::cv::PlanarObjectDetector::write
        
            typedef void ( ::cv::PlanarObjectDetector::*write_function_type )( ::cv::FileStorage &,::cv::String const & ) const;
            
            PlanarObjectDetector_exposer.def( 
                "write"
                , write_function_type( &::cv::PlanarObjectDetector::write )
                , ( bp::arg("fs"), bp::arg("name")=std::string() ) );
        
        }
    }

    { //::cv::SelfSimDescriptor
        typedef bp::class_< SelfSimDescriptor_wrapper > SelfSimDescriptor_exposer_t;
        SelfSimDescriptor_exposer_t SelfSimDescriptor_exposer = SelfSimDescriptor_exposer_t( "SelfSimDescriptor", bp::init< >() );
        bp::scope SelfSimDescriptor_scope( SelfSimDescriptor_exposer );
        SelfSimDescriptor_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::SelfSimDescriptor >() );
        bp::scope().attr("DEFAULT_SMALL_SIZE") = (int)cv::SelfSimDescriptor::DEFAULT_SMALL_SIZE;
        bp::scope().attr("DEFAULT_LARGE_SIZE") = (int)cv::SelfSimDescriptor::DEFAULT_LARGE_SIZE;
        bp::scope().attr("DEFAULT_NUM_ANGLES") = (int)cv::SelfSimDescriptor::DEFAULT_NUM_ANGLES;
        bp::scope().attr("DEFAULT_START_DISTANCE_BUCKET") = (int)cv::SelfSimDescriptor::DEFAULT_START_DISTANCE_BUCKET;
        bp::scope().attr("DEFAULT_NUM_DISTANCE_BUCKETS") = (int)cv::SelfSimDescriptor::DEFAULT_NUM_DISTANCE_BUCKETS;
        SelfSimDescriptor_exposer.def( bp::init< int, int, bp::optional< int, int, int > >(( bp::arg("_ssize"), bp::arg("_lsize"), bp::arg("_startDistanceBucket")=int(::cv::SelfSimDescriptor::DEFAULT_START_DISTANCE_BUCKET), bp::arg("_numberOfDistanceBuckets")=int(::cv::SelfSimDescriptor::DEFAULT_NUM_DISTANCE_BUCKETS), bp::arg("_nangles")=int(::cv::SelfSimDescriptor::DEFAULT_NUM_ANGLES) )) );
        SelfSimDescriptor_exposer.def( bp::init< cv::SelfSimDescriptor const & >(( bp::arg("ss") )) );
        { //::cv::SelfSimDescriptor::SSD
        
            typedef void ( ::cv::SelfSimDescriptor::*SSD_function_type )( ::cv::Mat const &,::cv::Point,::cv::Mat & ) const;
            typedef void ( SelfSimDescriptor_wrapper::*default_SSD_function_type )( ::cv::Mat const &,::cv::Point,::cv::Mat & ) const;
            
            SelfSimDescriptor_exposer.def( 
                "SSD"
                , SSD_function_type(&::cv::SelfSimDescriptor::SSD)
                , default_SSD_function_type(&SelfSimDescriptor_wrapper::default_SSD)
                , ( bp::arg("img"), bp::arg("pt"), bp::arg("ssd") ) );
        
        }
        { //::cv::SelfSimDescriptor::compute
        
            typedef void ( ::cv::SelfSimDescriptor::*compute_function_type )( ::cv::Mat const &,::std::vector< float > &,::cv::Size,::std::vector< cv::Point_<int> > const & ) const;
            typedef void ( SelfSimDescriptor_wrapper::*default_compute_function_type )( ::cv::Mat const &,::std::vector< float > &,::cv::Size,::std::vector< cv::Point_<int> > const & ) const;
            
            SelfSimDescriptor_exposer.def( 
                "compute"
                , compute_function_type(&::cv::SelfSimDescriptor::compute)
                , default_compute_function_type(&SelfSimDescriptor_wrapper::default_compute)
                , ( bp::arg("img"), bp::arg("descriptors"), bp::arg("winStride")=cv::Size_<int>(), bp::arg("locations")=std::vector<cv::Point>() ) );
        
        }
        { //::cv::SelfSimDescriptor::computeLogPolarMapping
        
            typedef void ( ::cv::SelfSimDescriptor::*computeLogPolarMapping_function_type )( ::cv::Mat & ) const;
            typedef void ( SelfSimDescriptor_wrapper::*default_computeLogPolarMapping_function_type )( ::cv::Mat & ) const;
            
            SelfSimDescriptor_exposer.def( 
                "computeLogPolarMapping"
                , computeLogPolarMapping_function_type(&::cv::SelfSimDescriptor::computeLogPolarMapping)
                , default_computeLogPolarMapping_function_type(&SelfSimDescriptor_wrapper::default_computeLogPolarMapping)
                , ( bp::arg("mappingMask") ) );
        
        }
        { //::cv::SelfSimDescriptor::getDescriptorSize
        
            typedef ::size_t ( ::cv::SelfSimDescriptor::*getDescriptorSize_function_type )(  ) const;
            
            SelfSimDescriptor_exposer.def( 
                "getDescriptorSize"
                , getDescriptorSize_function_type( &::cv::SelfSimDescriptor::getDescriptorSize ) );
        
        }
        { //::cv::SelfSimDescriptor::getGridSize
        
            typedef ::cv::Size ( ::cv::SelfSimDescriptor::*getGridSize_function_type )( ::cv::Size,::cv::Size ) const;
            
            SelfSimDescriptor_exposer.def( 
                "getGridSize"
                , getGridSize_function_type( &::cv::SelfSimDescriptor::getGridSize )
                , ( bp::arg("imgsize"), bp::arg("winStride") ) );
        
        }
        { //::cv::SelfSimDescriptor::operator=
        
            typedef ::cv::SelfSimDescriptor & ( ::cv::SelfSimDescriptor::*assign_function_type )( ::cv::SelfSimDescriptor const & ) ;
            
            SelfSimDescriptor_exposer.def( 
                "assign"
                , assign_function_type( &::cv::SelfSimDescriptor::operator= )
                , ( bp::arg("ss") )
                , bp::return_self< >()
                , "\nWrapped function:"
    "\n    operator=" );
        
        }
        SelfSimDescriptor_exposer.def_readwrite( "largeSize", &cv::SelfSimDescriptor::largeSize );
        SelfSimDescriptor_exposer.def_readwrite( "numberOfAngles", &cv::SelfSimDescriptor::numberOfAngles );
        SelfSimDescriptor_exposer.def_readwrite( "numberOfDistanceBuckets", &cv::SelfSimDescriptor::numberOfDistanceBuckets );
        SelfSimDescriptor_exposer.def_readwrite( "smallSize", &cv::SelfSimDescriptor::smallSize );
        SelfSimDescriptor_exposer.def_readwrite( "startDistanceBucket", &cv::SelfSimDescriptor::startDistanceBucket );
    }

    { //::cv::SpinImageModel
        typedef bp::class_< cv::SpinImageModel > SpinImageModel_exposer_t;
        SpinImageModel_exposer_t SpinImageModel_exposer = SpinImageModel_exposer_t( "SpinImageModel", bp::init< >() );
        bp::scope SpinImageModel_scope( SpinImageModel_exposer );
        SpinImageModel_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::SpinImageModel >() );
        SpinImageModel_exposer.def( bp::init< cv::Mesh3D const & >(( bp::arg("mesh") )) );
        bp::implicitly_convertible< cv::Mesh3D const &, cv::SpinImageModel >();
        { //::cv::SpinImageModel::compute
        
            typedef void ( ::cv::SpinImageModel::*compute_function_type )(  ) ;
            
            SpinImageModel_exposer.def( 
                "compute"
                , compute_function_type( &::cv::SpinImageModel::compute ) );
        
        }
        { //::cv::SpinImageModel::getMesh
        
            typedef ::cv::Mesh3D const & ( ::cv::SpinImageModel::*getMesh_function_type )(  ) const;
            
            SpinImageModel_exposer.def( 
                "getMesh"
                , getMesh_function_type( &::cv::SpinImageModel::getMesh )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::cv::SpinImageModel::getMesh
        
            typedef ::cv::Mesh3D & ( ::cv::SpinImageModel::*getMesh_function_type )(  ) ;
            
            SpinImageModel_exposer.def( 
                "getMesh"
                , getMesh_function_type( &::cv::SpinImageModel::getMesh )
                , bp::return_internal_reference< >() );
        
        }
        { //::cv::SpinImageModel::getSpinCount
        
            typedef ::size_t ( ::cv::SpinImageModel::*getSpinCount_function_type )(  ) const;
            
            SpinImageModel_exposer.def( 
                "getSpinCount"
                , getSpinCount_function_type( &::cv::SpinImageModel::getSpinCount ) );
        
        }
        { //::cv::SpinImageModel::getSpinImage
        
            typedef ::cv::Mat ( ::cv::SpinImageModel::*getSpinImage_function_type )( ::size_t ) const;
            
            SpinImageModel_exposer.def( 
                "getSpinImage"
                , getSpinImage_function_type( &::cv::SpinImageModel::getSpinImage )
                , ( bp::arg("index") ) );
        
        }
        { //::cv::SpinImageModel::getSpinNormal
        
            typedef ::cv::Point3f const & ( ::cv::SpinImageModel::*getSpinNormal_function_type )( ::size_t ) const;
            
            SpinImageModel_exposer.def( 
                "getSpinNormal"
                , getSpinNormal_function_type( &::cv::SpinImageModel::getSpinNormal )
                , ( bp::arg("index") )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::cv::SpinImageModel::getSpinVertex
        
            typedef ::cv::Point3f const & ( ::cv::SpinImageModel::*getSpinVertex_function_type )( ::size_t ) const;
            
            SpinImageModel_exposer.def( 
                "getSpinVertex"
                , getSpinVertex_function_type( &::cv::SpinImageModel::getSpinVertex )
                , ( bp::arg("index") )
                , bp::return_value_policy< bp::copy_const_reference >() );
        
        }
        { //::cv::SpinImageModel::match
        
            typedef boost::python::object ( *match_function_type )( cv::SpinImageModel &,cv::SpinImageModel const & );
            
            SpinImageModel_exposer.def( 
                "match"
                , match_function_type( &match_86773a6b4d89ae97806d1109a2438811 )
                , ( bp::arg("inst"), bp::arg("scene") )
                , "\nArgument 'result':"\
    "\n    C++ type: ::std::vector< std::vector< cv::Vec<int, 2> > > &"\
    "\n    Python type: vector_vector_Vec2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    result" );
        
        }
        { //::cv::SpinImageModel::packRandomScaledSpins
        
            typedef ::cv::Mat ( ::cv::SpinImageModel::*packRandomScaledSpins_function_type )( bool,::size_t,::size_t ) const;
            
            SpinImageModel_exposer.def( 
                "packRandomScaledSpins"
                , packRandomScaledSpins_function_type( &::cv::SpinImageModel::packRandomScaledSpins )
                , ( bp::arg("separateScale")=(bool)(false), bp::arg("xCount")=(::size_t)(10), bp::arg("yCount")=(::size_t)(10) ) );
        
        }
        { //::cv::SpinImageModel::selectRandomSubset
        
            typedef void ( ::cv::SpinImageModel::*selectRandomSubset_function_type )( float ) ;
            
            SpinImageModel_exposer.def( 
                "selectRandomSubset"
                , selectRandomSubset_function_type( &::cv::SpinImageModel::selectRandomSubset )
                , ( bp::arg("ratio") ) );
        
        }
        { //::cv::SpinImageModel::setSubset
        
            typedef void ( ::cv::SpinImageModel::*setSubset_function_type )( ::std::vector< int > const & ) ;
            
            SpinImageModel_exposer.def( 
                "setSubset"
                , setSubset_function_type( &::cv::SpinImageModel::setSubset )
                , ( bp::arg("subset") ) );
        
        }
        { //::cv::SpinImageModel::spinCorrelation
        
            typedef bool ( *spinCorrelation_function_type )( ::cv::Mat const &,::cv::Mat const &,float,float & );
            
            SpinImageModel_exposer.def( 
                "spinCorrelation"
                , spinCorrelation_function_type( &::cv::SpinImageModel::spinCorrelation )
                , ( bp::arg("spin1"), bp::arg("spin2"), bp::arg("lambda"), bp::arg("result") ) );
        
        }
        SpinImageModel_exposer.def_readwrite( "T_GeometriccConsistency", &cv::SpinImageModel::T_GeometriccConsistency );
        SpinImageModel_exposer.def_readwrite( "T_GroupingCorespondances", &cv::SpinImageModel::T_GroupingCorespondances );
        SpinImageModel_exposer.def_readwrite( "binSize", &cv::SpinImageModel::binSize );
        SpinImageModel_exposer.def_readwrite( "gamma", &cv::SpinImageModel::gamma );
        SpinImageModel_exposer.def_readwrite( "imageWidth", &cv::SpinImageModel::imageWidth );
        SpinImageModel_exposer.def_readwrite( "lambda_", &cv::SpinImageModel::lambda );
        SpinImageModel_exposer.def_readwrite( "minNeighbors", &cv::SpinImageModel::minNeighbors );
        SpinImageModel_exposer.def_readwrite( "normalRadius", &cv::SpinImageModel::normalRadius );
        SpinImageModel_exposer.staticmethod( "spinCorrelation" );
    }

    bp::class_< cv::TickMeter >( "TickMeter", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::TickMeter >() )    
        .def( 
            "getCounter"
            , (::int64 ( cv::TickMeter::* )(  ) const)( &::cv::TickMeter::getCounter ) )    
        .def( 
            "getTimeMicro"
            , (double ( cv::TickMeter::* )(  ) const)( &::cv::TickMeter::getTimeMicro ) )    
        .def( 
            "getTimeMilli"
            , (double ( cv::TickMeter::* )(  ) const)( &::cv::TickMeter::getTimeMilli ) )    
        .def( 
            "getTimeSec"
            , (double ( cv::TickMeter::* )(  ) const)( &::cv::TickMeter::getTimeSec ) )    
        .def( 
            "getTimeTicks"
            , (::int64 ( cv::TickMeter::* )(  ) const)( &::cv::TickMeter::getTimeTicks ) )    
        .def( 
            "reset"
            , (void ( cv::TickMeter::* )(  ) )( &::cv::TickMeter::reset ) )    
        .def( 
            "start"
            , (void ( cv::TickMeter::* )(  ) )( &::cv::TickMeter::start ) )    
        .def( 
            "stop"
            , (void ( cv::TickMeter::* )(  ) )( &::cv::TickMeter::stop ) )    
        .def("__str__", &::TickMeter__str__)    
        .def("__repr__", &::TickMeter__repr__);

    { //::cvaux_dummy_struct
        typedef bp::class_< cvaux_dummy_struct > __cvaux_dummy_struct_exposer_t;
        __cvaux_dummy_struct_exposer_t __cvaux_dummy_struct_exposer = __cvaux_dummy_struct_exposer_t( "__cvaux_dummy_struct" );
        bp::scope __cvaux_dummy_struct_scope( __cvaux_dummy_struct_exposer );
        __cvaux_dummy_struct_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cvaux_dummy_struct >() );
        bp::class_< cvaux_dummy_struct::dummy_struct2 >( "dummy_struct2" )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cvaux_dummy_struct::dummy_struct2 >() );
        __cvaux_dummy_struct_exposer.setattr("v0", 0);
    }
    {;
    }

}
