// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cvaux_wrapper.hpp"
#include "opencv_converters.hpp"
#include "cvaux_ext_classes_5.pypp.hpp"

namespace bp = boost::python;

struct BackgroundSubtractor_wrapper : cv::BackgroundSubtractor, bp::wrapper< cv::BackgroundSubtractor > {

    BackgroundSubtractor_wrapper(cv::BackgroundSubtractor const & arg )
    : cv::BackgroundSubtractor( arg )
      , bp::wrapper< cv::BackgroundSubtractor >(){
        // copy constructor
        
    }

    BackgroundSubtractor_wrapper()
    : cv::BackgroundSubtractor()
      , bp::wrapper< cv::BackgroundSubtractor >(){
        // null constructor
        
    }

    virtual void operator()( ::cv::Mat const & image, ::cv::Mat & fgmask, double learningRate=0 ) {
        if( bp::override func___call__ = this->get_override( "__call__" ) )
            func___call__( boost::ref(image), boost::ref(fgmask), learningRate );
        else{
            this->cv::BackgroundSubtractor::operator()( boost::ref(image), boost::ref(fgmask), learningRate );
        }
    }
    
    void default___call__( ::cv::Mat const & image, ::cv::Mat & fgmask, double learningRate=0 ) {
        cv::BackgroundSubtractor::operator()( boost::ref(image), boost::ref(fgmask), learningRate );
    }

};

struct BackgroundSubtractorMOG_wrapper : cv::BackgroundSubtractorMOG, bp::wrapper< cv::BackgroundSubtractorMOG > {

    BackgroundSubtractorMOG_wrapper(cv::BackgroundSubtractorMOG const & arg )
    : cv::BackgroundSubtractorMOG( arg )
      , bp::wrapper< cv::BackgroundSubtractorMOG >(){
        // copy constructor
        
    }

    BackgroundSubtractorMOG_wrapper( )
    : cv::BackgroundSubtractorMOG( )
      , bp::wrapper< cv::BackgroundSubtractorMOG >(){
        // null constructor
    
    }

    BackgroundSubtractorMOG_wrapper(int history, int nmixtures, double backgroundRatio, double noiseSigma=0 )
    : cv::BackgroundSubtractorMOG( history, nmixtures, backgroundRatio, noiseSigma )
      , bp::wrapper< cv::BackgroundSubtractorMOG >(){
        // constructor
    
    }

    virtual void initialize( ::cv::Size frameSize, int frameType ) {
        if( bp::override func_initialize = this->get_override( "initialize" ) )
            func_initialize( frameSize, frameType );
        else{
            this->cv::BackgroundSubtractorMOG::initialize( frameSize, frameType );
        }
    }
    
    void default_initialize( ::cv::Size frameSize, int frameType ) {
        cv::BackgroundSubtractorMOG::initialize( frameSize, frameType );
    }

    virtual void operator()( ::cv::Mat const & image, ::cv::Mat & fgmask, double learningRate=0 ) {
        if( bp::override func___call__ = this->get_override( "__call__" ) )
            func___call__( boost::ref(image), boost::ref(fgmask), learningRate );
        else{
            this->cv::BackgroundSubtractorMOG::operator()( boost::ref(image), boost::ref(fgmask), learningRate );
        }
    }
    
    void default___call__( ::cv::Mat const & image, ::cv::Mat & fgmask, double learningRate=0 ) {
        cv::BackgroundSubtractorMOG::operator()( boost::ref(image), boost::ref(fgmask), learningRate );
    }

};

struct FernClassifier_wrapper : cv::FernClassifier, bp::wrapper< cv::FernClassifier > {

    FernClassifier_wrapper(cv::FernClassifier const & arg )
    : cv::FernClassifier( arg )
      , bp::wrapper< cv::FernClassifier >(){
        // copy constructor
        
    }

    FernClassifier_wrapper( )
    : cv::FernClassifier( )
      , bp::wrapper< cv::FernClassifier >(){
        // null constructor
    
    }

    FernClassifier_wrapper(::cv::FileNode const & node )
    : cv::FernClassifier( boost::ref(node) )
      , bp::wrapper< cv::FernClassifier >(){
        // constructor
    
    }

    FernClassifier_wrapper(::std::vector< cv::Point_<float> > const & points, ::std::vector< cv::Ptr<cv::Mat> > const & refimgs, ::std::vector< int > const & labels=std::vector<int>(), int _nclasses=0, int _patchSize=int(::cv::FernClassifier::PATCH_SIZE), int _signatureSize=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), int _nstructs=int(::cv::FernClassifier::DEFAULT_STRUCTS), int _structSize=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), int _nviews=int(::cv::FernClassifier::DEFAULT_VIEWS), int _compressionMethod=int(::cv::FernClassifier::COMPRESSION_NONE), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() )
    : cv::FernClassifier( boost::ref(points), boost::ref(refimgs), boost::ref(labels), _nclasses, _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) )
      , bp::wrapper< cv::FernClassifier >(){
        // constructor
    
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->cv::FernClassifier::clear(  );
        }
    }
    
    void default_clear(  ) {
        cv::FernClassifier::clear( );
    }

    virtual int operator()( ::cv::Mat const & img, ::cv::Point2f kpt, ::std::vector< float > & signature ) const  {
        namespace bpl = boost::python;
        if( bpl::override func___call__ = this->get_override( "__call__" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func___call__.ptr(), img, kpt, signature );
            return bpl::extract< int >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return cv::FernClassifier::operator()( boost::ref(img), kpt, boost::ref(signature) );
        }
    }
    
    static boost::python::tuple default___call___c4d2198033cf380377bb6f32571c2657( ::cv::FernClassifier const & inst, ::cv::Mat const & img, ::cv::Point2f kpt ){
        std::vector<float> signature2;
        int result;
        if( dynamic_cast< FernClassifier_wrapper const* >( boost::addressof( inst ) ) ){
            result = inst.::cv::FernClassifier::operator()(img, kpt, signature2);
        }
        else{
            result = inst.operator()(img, kpt, signature2);
        }
        return bp::make_tuple( result, signature2 );
    }

    virtual int operator()( ::cv::Mat const & patch, ::std::vector< float > & signature ) const  {
        namespace bpl = boost::python;
        if( bpl::override func___call__ = this->get_override( "__call__" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func___call__.ptr(), patch, signature );
            return bpl::extract< int >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
            return cv::FernClassifier::operator()( boost::ref(patch), boost::ref(signature) );
        }
    }
    
    static boost::python::tuple default___call___ddcd7402f4cc50fa35ce4888642630c7( ::cv::FernClassifier const & inst, ::cv::Mat const & patch ){
        std::vector<float> signature2;
        int result;
        if( dynamic_cast< FernClassifier_wrapper const* >( boost::addressof( inst ) ) ){
            result = inst.::cv::FernClassifier::operator()(patch, signature2);
        }
        else{
            result = inst.operator()(patch, signature2);
        }
        return bp::make_tuple( result, signature2 );
    }

    virtual void read( ::cv::FileNode const & n ) {
        if( bp::override func_read = this->get_override( "read" ) )
            func_read( boost::ref(n) );
        else{
            this->cv::FernClassifier::read( boost::ref(n) );
        }
    }
    
    void default_read( ::cv::FileNode const & n ) {
        cv::FernClassifier::read( boost::ref(n) );
    }

    virtual void train( ::std::vector< cv::Point_<float> > const & points, ::std::vector< cv::Ptr<cv::Mat> > const & refimgs, ::std::vector< int > const & labels=std::vector<int>(), int _nclasses=0, int _patchSize=int(::cv::FernClassifier::PATCH_SIZE), int _signatureSize=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), int _nstructs=int(::cv::FernClassifier::DEFAULT_STRUCTS), int _structSize=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), int _nviews=int(::cv::FernClassifier::DEFAULT_VIEWS), int _compressionMethod=int(::cv::FernClassifier::COMPRESSION_NONE), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        if( bp::override func_train = this->get_override( "train" ) )
            func_train( boost::ref(points), boost::ref(refimgs), boost::ref(labels), _nclasses, _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) );
        else{
            this->cv::FernClassifier::train( boost::ref(points), boost::ref(refimgs), boost::ref(labels), _nclasses, _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) );
        }
    }
    
    void default_train( ::std::vector< cv::Point_<float> > const & points, ::std::vector< cv::Ptr<cv::Mat> > const & refimgs, ::std::vector< int > const & labels=std::vector<int>(), int _nclasses=0, int _patchSize=int(::cv::FernClassifier::PATCH_SIZE), int _signatureSize=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), int _nstructs=int(::cv::FernClassifier::DEFAULT_STRUCTS), int _structSize=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), int _nviews=int(::cv::FernClassifier::DEFAULT_VIEWS), int _compressionMethod=int(::cv::FernClassifier::COMPRESSION_NONE), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        cv::FernClassifier::train( boost::ref(points), boost::ref(refimgs), boost::ref(labels), _nclasses, _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) );
    }

    virtual void trainFromSingleView( ::cv::Mat const & image, ::std::vector< cv::KeyPoint > const & keypoints, int _patchSize=int(::cv::FernClassifier::PATCH_SIZE), int _signatureSize=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), int _nstructs=int(::cv::FernClassifier::DEFAULT_STRUCTS), int _structSize=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), int _nviews=int(::cv::FernClassifier::DEFAULT_VIEWS), int _compressionMethod=int(::cv::FernClassifier::COMPRESSION_NONE), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        if( bp::override func_trainFromSingleView = this->get_override( "trainFromSingleView" ) )
            func_trainFromSingleView( boost::ref(image), boost::ref(keypoints), _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) );
        else{
            this->cv::FernClassifier::trainFromSingleView( boost::ref(image), boost::ref(keypoints), _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) );
        }
    }
    
    void default_trainFromSingleView( ::cv::Mat const & image, ::std::vector< cv::KeyPoint > const & keypoints, int _patchSize=int(::cv::FernClassifier::PATCH_SIZE), int _signatureSize=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), int _nstructs=int(::cv::FernClassifier::DEFAULT_STRUCTS), int _structSize=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), int _nviews=int(::cv::FernClassifier::DEFAULT_VIEWS), int _compressionMethod=int(::cv::FernClassifier::COMPRESSION_NONE), ::cv::PatchGenerator const & patchGenerator=cv::PatchGenerator() ) {
        cv::FernClassifier::trainFromSingleView( boost::ref(image), boost::ref(keypoints), _patchSize, _signatureSize, _nstructs, _structSize, _nviews, _compressionMethod, boost::ref(patchGenerator) );
    }

    virtual void write( ::cv::FileStorage & fs, ::cv::String const & name=std::string() ) const  {
        if( bp::override func_write = this->get_override( "write" ) )
            func_write( boost::ref(fs), boost::ref(name) );
        else{
            this->cv::FernClassifier::write( boost::ref(fs), boost::ref(name) );
        }
    }
    
    void default_write( ::cv::FileStorage & fs, ::cv::String const & name=std::string() ) const  {
        cv::FernClassifier::write( boost::ref(fs), boost::ref(name) );
    }

};

struct HOGDescriptor_wrapper : cv::HOGDescriptor, bp::wrapper< cv::HOGDescriptor > {

    HOGDescriptor_wrapper(cv::HOGDescriptor const & arg )
    : cv::HOGDescriptor( arg )
      , bp::wrapper< cv::HOGDescriptor >(){
        // copy constructor
        
    }

    HOGDescriptor_wrapper( )
    : cv::HOGDescriptor( )
      , bp::wrapper< cv::HOGDescriptor >(){
        // null constructor
    
    }

    HOGDescriptor_wrapper(::cv::Size _winSize, ::cv::Size _blockSize, ::cv::Size _blockStride, ::cv::Size _cellSize, int _nbins, int _derivAperture=1, double _winSigma=-0x000000001, int _histogramNormType=int(::cv::HOGDescriptor::L2Hys), double _L2HysThreshold=2.00000000000000011102230246251565404236316680908e-1, bool _gammaCorrection=false )
    : cv::HOGDescriptor( _winSize, _blockSize, _blockStride, _cellSize, _nbins, _derivAperture, _winSigma, _histogramNormType, _L2HysThreshold, _gammaCorrection )
      , bp::wrapper< cv::HOGDescriptor >(){
        // constructor
    
    }

    HOGDescriptor_wrapper(::cv::String const & filename )
    : cv::HOGDescriptor( boost::ref(filename) )
      , bp::wrapper< cv::HOGDescriptor >(){
        // constructor
    
    }

    virtual void compute( ::cv::Mat const & img, ::std::vector< float > & descriptors, ::cv::Size winStride=cv::Size_<int>(), ::cv::Size padding=cv::Size_<int>(), ::std::vector< cv::Point_<int> > const & locations=std::vector<cv::Point>() ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_compute = this->get_override( "compute" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_compute.ptr(), img, descriptors, winStride, padding, locations );
        }
        else{
            cv::HOGDescriptor::compute( boost::ref(img), boost::ref(descriptors), winStride, padding, boost::ref(locations) );
        }
    }
    
    static boost::python::object default_compute( ::cv::HOGDescriptor const & inst, ::cv::Mat const & img, ::cv::Size winStride=cv::Size_<int>(), ::cv::Size padding=cv::Size_<int>(), ::std::vector< cv::Point_<int> > const & locations=std::vector<cv::Point>() ){
        std::vector<float> descriptors2;
        if( dynamic_cast< HOGDescriptor_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::cv::HOGDescriptor::compute(img, descriptors2, winStride, padding, locations);
        }
        else{
            inst.compute(img, descriptors2, winStride, padding, locations);
        }
        return bp::object( descriptors2 );
    }

    virtual void computeGradient( ::cv::Mat const & img, ::cv::Mat & grad, ::cv::Mat & angleOfs, ::cv::Size paddingTL=cv::Size_<int>(), ::cv::Size paddingBR=cv::Size_<int>() ) const  {
        if( bp::override func_computeGradient = this->get_override( "computeGradient" ) )
            func_computeGradient( boost::ref(img), boost::ref(grad), boost::ref(angleOfs), paddingTL, paddingBR );
        else{
            this->cv::HOGDescriptor::computeGradient( boost::ref(img), boost::ref(grad), boost::ref(angleOfs), paddingTL, paddingBR );
        }
    }
    
    void default_computeGradient( ::cv::Mat const & img, ::cv::Mat & grad, ::cv::Mat & angleOfs, ::cv::Size paddingTL=cv::Size_<int>(), ::cv::Size paddingBR=cv::Size_<int>() ) const  {
        cv::HOGDescriptor::computeGradient( boost::ref(img), boost::ref(grad), boost::ref(angleOfs), paddingTL, paddingBR );
    }

    virtual void detect( ::cv::Mat const & img, ::std::vector< cv::Point_<int> > & foundLocations, double hitThreshold=0, ::cv::Size winStride=cv::Size_<int>(), ::cv::Size padding=cv::Size_<int>(), ::std::vector< cv::Point_<int> > const & searchLocations=std::vector<cv::Point>() ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_detect = this->get_override( "detect" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_detect.ptr(), img, foundLocations, hitThreshold, winStride, padding, searchLocations );
        }
        else{
            cv::HOGDescriptor::detect( boost::ref(img), boost::ref(foundLocations), hitThreshold, winStride, padding, boost::ref(searchLocations) );
        }
    }
    
    static boost::python::object default_detect( ::cv::HOGDescriptor const & inst, ::cv::Mat const & img, double hitThreshold=0, ::cv::Size winStride=cv::Size_<int>(), ::cv::Size padding=cv::Size_<int>(), ::std::vector< cv::Point_<int> > const & searchLocations=std::vector<cv::Point>() ){
        std::vector<cv::Point_<int> > foundLocations2;
        if( dynamic_cast< HOGDescriptor_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::cv::HOGDescriptor::detect(img, foundLocations2, hitThreshold, winStride, padding, searchLocations);
        }
        else{
            inst.detect(img, foundLocations2, hitThreshold, winStride, padding, searchLocations);
        }
        return bp::object( foundLocations2 );
    }

    virtual void detectMultiScale( ::cv::Mat const & img, ::std::vector< cv::Rect_<int> > & foundLocations, double hitThreshold=0, ::cv::Size winStride=cv::Size_<int>(), ::cv::Size padding=cv::Size_<int>(), double scale=1.05000000000000004440892098500626161694526672363e+0, int groupThreshold=2 ) const  {
        namespace bpl = boost::python;
        if( bpl::override func_detectMultiScale = this->get_override( "detectMultiScale" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_detectMultiScale.ptr(), img, foundLocations, hitThreshold, winStride, padding, scale, groupThreshold );
        }
        else{
            cv::HOGDescriptor::detectMultiScale( boost::ref(img), boost::ref(foundLocations), hitThreshold, winStride, padding, scale, groupThreshold );
        }
    }
    
    static boost::python::object default_detectMultiScale( ::cv::HOGDescriptor const & inst, ::cv::Mat const & img, double hitThreshold=0, ::cv::Size winStride=cv::Size_<int>(), ::cv::Size padding=cv::Size_<int>(), double scale=1.05000000000000004440892098500626161694526672363e+0, int groupThreshold=2 ){
        std::vector<cv::Rect_<int> > foundLocations2;
        if( dynamic_cast< HOGDescriptor_wrapper const* >( boost::addressof( inst ) ) ){
            inst.::cv::HOGDescriptor::detectMultiScale(img, foundLocations2, hitThreshold, winStride, padding, scale, groupThreshold);
        }
        else{
            inst.detectMultiScale(img, foundLocations2, hitThreshold, winStride, padding, scale, groupThreshold);
        }
        return bp::object( foundLocations2 );
    }

    virtual bool load( ::cv::String const & filename, ::cv::String const & objname=std::string() ) {
        if( bp::override func_load = this->get_override( "load" ) )
            return func_load( boost::ref(filename), boost::ref(objname) );
        else{
            return this->cv::HOGDescriptor::load( boost::ref(filename), boost::ref(objname) );
        }
    }
    
    bool default_load( ::cv::String const & filename, ::cv::String const & objname=std::string() ) {
        return cv::HOGDescriptor::load( boost::ref(filename), boost::ref(objname) );
    }

    virtual void save( ::cv::String const & filename, ::cv::String const & objname=std::string() ) const  {
        if( bp::override func_save = this->get_override( "save" ) )
            func_save( boost::ref(filename), boost::ref(objname) );
        else{
            this->cv::HOGDescriptor::save( boost::ref(filename), boost::ref(objname) );
        }
    }
    
    void default_save( ::cv::String const & filename, ::cv::String const & objname=std::string() ) const  {
        cv::HOGDescriptor::save( boost::ref(filename), boost::ref(objname) );
    }

    virtual void setSVMDetector( ::std::vector< float > const & _svmdetector ) {
        if( bp::override func_setSVMDetector = this->get_override( "setSVMDetector" ) )
            func_setSVMDetector( boost::ref(_svmdetector) );
        else{
            this->cv::HOGDescriptor::setSVMDetector( boost::ref(_svmdetector) );
        }
    }
    
    void default_setSVMDetector( ::std::vector< float > const & _svmdetector ) {
        cv::HOGDescriptor::setSVMDetector( boost::ref(_svmdetector) );
    }

};

static boost::python::object __call___14ec982e59fdc13237968e34b82d6fe2( ::cv::LDetector const & inst, ::cv::Mat const & image, int maxCount=0, bool scaleCoords=true ){
    std::vector<cv::KeyPoint> keypoints2;
    inst.operator()(image, keypoints2, maxCount, scaleCoords);
    return bp::object( keypoints2 );
}

static boost::python::object __call___015c5cd98f14b41d0eaab62238a1a6fe( ::cv::LDetector const & inst, ::std::vector< cv::Mat > const & pyr, int maxCount=0, bool scaleCoords=true ){
    std::vector<cv::KeyPoint> keypoints2;
    inst.operator()(pyr, keypoints2, maxCount, scaleCoords);
    return bp::object( keypoints2 );
}

struct LevMarqSparse_wrapper : cv::LevMarqSparse, bp::wrapper< cv::LevMarqSparse > {

    LevMarqSparse_wrapper(cv::LevMarqSparse const & arg )
    : cv::LevMarqSparse( arg )
      , bp::wrapper< cv::LevMarqSparse >(){
        // copy constructor
        
    }

    LevMarqSparse_wrapper( )
    : cv::LevMarqSparse( )
      , bp::wrapper< cv::LevMarqSparse >(){
        // null constructor
    
    }

    virtual void clear(  ) {
        if( bp::override func_clear = this->get_override( "clear" ) )
            func_clear(  );
        else{
            this->cv::LevMarqSparse::clear(  );
        }
    }
    
    void default_clear(  ) {
        cv::LevMarqSparse::clear( );
    }

    bp::object fjac, func, data;
    
    // real callback for estimation of Jacobian matrices
    static void real_fjac(int i, int j, cv::Mat& point_params,
                           cv::Mat& cam_params, cv::Mat& A, cv::Mat& B, void* data)
    {
        LevMarqSparse_wrapper *self = (LevMarqSparse_wrapper *)data;
        if(self->fjac.ptr() != Py_None) // if not None
            self->fjac(i, j, point_params, cam_params, A, B, data);
    }
    
    // real callback for estimation of backprojection errors
    static void real_func(int i, int j, cv::Mat& point_params,
                           cv::Mat& cam_params, cv::Mat& estim, void* data)
    {
        LevMarqSparse_wrapper *self = (LevMarqSparse_wrapper *)data;
        if(self->func.ptr() != Py_None) // if not None
            self->func(i, j, point_params, cam_params, estim, data);
    }
    

    void sdrun( int npoints, // number of points
        int ncameras, // number of cameras
        int nPointParams, // number of params per one point  (3 in case of 3D points)
        int nCameraParams, // number of parameters per one camera
        int nErrParams, // number of parameters in measurement vector
                        // for 1 point at one camera (2 in case of 2D projections)
        cv::Mat& visibility, // visibility matrix. rows correspond to points, columns correspond to cameras
                         // 1 - point is visible for the camera, 0 - invisible
        cv::Mat& P0, // starting vector of parameters, first cameras then points
        cv::Mat& X, // measurements, in order of visibility. non visible cases are skipped 
        cv::TermCriteria criteria, // termination criteria
        
        // callback for estimation of Jacobian matrices
        bp::object const &fjac,
        // callback for estimation of backprojection errors
        bp::object const &func,
        bp::object const &data // user-specific data passed to the callbacks
        )
    {
        this->fjac = fjac;
        this->func = func;
        this->data = data;
        run(npoints, ncameras, nPointParams, nCameraParams, nErrParams, 
            visibility, P0, X, criteria, real_fjac, real_func, (void *)this);
    }
    
    LevMarqSparse_wrapper(int npoints, // number of points
        int ncameras, // number of cameras
        int nPointParams, // number of params per one point  (3 in case of 3D points)
        int nCameraParams, // number of parameters per one camera
        int nErrParams, // number of parameters in measurement vector
                        // for 1 point at one camera (2 in case of 2D projections)
        cv::Mat& visibility, // visibility matrix. rows correspond to points, columns correspond to cameras
                         // 1 - point is visible for the camera, 0 - invisible
        cv::Mat& P0, // starting vector of parameters, first cameras then points
        cv::Mat& X, // measurements, in order of visibility. non visible cases are skipped 
        cv::TermCriteria criteria, // termination criteria
        
        // callback for estimation of Jacobian matrices
        bp::object const &fjac,
        // callback for estimation of backprojection errors
        bp::object const &func,
        bp::object const &data // user-specific data passed to the callbacks
        )
        : cv::LevMarqSparse(), bp::wrapper< cv::LevMarqSparse >()
    {
        sdrun(npoints, ncameras, nPointParams, nCameraParams, nErrParams,
            visibility, P0, X, criteria, fjac, func, data);
    }

};

void register_classes_5(){

    bp::class_< CvTracksTimePos >( "CvTracksTimePos" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvTracksTimePos >() )    
        .def_readwrite( "beg1", &CvTracksTimePos::beg1 )    
        .def_readwrite( "beg2", &CvTracksTimePos::beg2 )    
        .def_readwrite( "comLen", &CvTracksTimePos::comLen )    
        .def_readwrite( "end1", &CvTracksTimePos::end1 )    
        .def_readwrite( "end2", &CvTracksTimePos::end2 )    
        .def_readwrite( "len1", &CvTracksTimePos::len1 )    
        .def_readwrite( "len2", &CvTracksTimePos::len2 )    
        .def_readwrite( "shift1", &CvTracksTimePos::shift1 )    
        .def_readwrite( "shift2", &CvTracksTimePos::shift2 );

    bp::class_< BackgroundSubtractor_wrapper >( "BackgroundSubtractor" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::BackgroundSubtractor >() )    
        .def( 
            "__call__"
            , (void ( cv::BackgroundSubtractor::* )( ::cv::Mat const &,::cv::Mat &,double ) )(&::cv::BackgroundSubtractor::operator())
            , (void ( BackgroundSubtractor_wrapper::* )( ::cv::Mat const &,::cv::Mat &,double ) )(&BackgroundSubtractor_wrapper::default___call__)
            , ( bp::arg("image"), bp::arg("fgmask"), bp::arg("learningRate")=0 ) );

    bp::class_< BackgroundSubtractorMOG_wrapper, bp::bases< cv::BackgroundSubtractor > >( "BackgroundSubtractorMOG", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::BackgroundSubtractorMOG >() )    
        .def( bp::init< int, int, double, bp::optional< double > >(( bp::arg("history"), bp::arg("nmixtures"), bp::arg("backgroundRatio"), bp::arg("noiseSigma")=0 )) )    
        .def( 
            "initialize"
            , (void ( cv::BackgroundSubtractorMOG::* )( ::cv::Size,int ) )(&::cv::BackgroundSubtractorMOG::initialize)
            , (void ( BackgroundSubtractorMOG_wrapper::* )( ::cv::Size,int ) )(&BackgroundSubtractorMOG_wrapper::default_initialize)
            , ( bp::arg("frameSize"), bp::arg("frameType") ) )    
        .def( 
            "__call__"
            , (void ( cv::BackgroundSubtractorMOG::* )( ::cv::Mat const &,::cv::Mat &,double ) )(&::cv::BackgroundSubtractorMOG::operator())
            , (void ( BackgroundSubtractorMOG_wrapper::* )( ::cv::Mat const &,::cv::Mat &,double ) )(&BackgroundSubtractorMOG_wrapper::default___call__)
            , ( bp::arg("image"), bp::arg("fgmask"), bp::arg("learningRate")=0 ) )    
        .def_readwrite( "backgroundRatio", &cv::BackgroundSubtractorMOG::backgroundRatio )    
        .def_readwrite( "bgmodel", &cv::BackgroundSubtractorMOG::bgmodel )    
        .def_readwrite( "frameSize", &cv::BackgroundSubtractorMOG::frameSize )    
        .def_readwrite( "frameType", &cv::BackgroundSubtractorMOG::frameType )    
        .def_readwrite( "history", &cv::BackgroundSubtractorMOG::history )    
        .def_readwrite( "nframes", &cv::BackgroundSubtractorMOG::nframes )    
        .def_readwrite( "nmixtures", &cv::BackgroundSubtractorMOG::nmixtures )    
        .def_readwrite( "noiseSigma", &cv::BackgroundSubtractorMOG::noiseSigma )    
        .def_readwrite( "varThreshold", &cv::BackgroundSubtractorMOG::varThreshold );

    bp::class_< cv::CvAffinePose >( "CvAffinePose" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::CvAffinePose >() )    
        .def_readwrite( "lambda1", &cv::CvAffinePose::lambda1 )    
        .def_readwrite( "lambda2", &cv::CvAffinePose::lambda2 )    
        .def_readwrite( "phi", &cv::CvAffinePose::phi )    
        .def_readwrite( "theta", &cv::CvAffinePose::theta );

    bp::class_< cv::PatchGenerator >( "PatchGenerator", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::PatchGenerator >() )    
        .def( bp::init< double, double, double, bp::optional< bool, double, double, double, double, double, double > >(( bp::arg("_backgroundMin"), bp::arg("_backgroundMax"), bp::arg("_noiseRange"), bp::arg("_randomBlur")=(bool)(true), bp::arg("_lambdaMin")=5.99999999999999977795539507496869191527366638184e-1, bp::arg("_lambdaMax")=1.5e+0, bp::arg("_thetaMin")=-3.14159265358979311599796346854418516159057617188e+0, bp::arg("_thetaMax")=3.14159265358979311599796346854418516159057617188e+0, bp::arg("_phiMin")=-3.14159265358979311599796346854418516159057617188e+0, bp::arg("_phiMax")=3.14159265358979311599796346854418516159057617188e+0 )) )    
        .def( 
            "generateRandomTransform"
            , (void ( cv::PatchGenerator::* )( ::cv::Point2f,::cv::Point2f,::cv::Mat &,::cv::RNG &,bool ) const)( &::cv::PatchGenerator::generateRandomTransform )
            , ( bp::arg("srcCenter"), bp::arg("dstCenter"), bp::arg("transform"), bp::arg("rng"), bp::arg("inverse")=(bool)(false) ) )    
        .def( 
            "__call__"
            , (void ( cv::PatchGenerator::* )( ::cv::Mat const &,::cv::Point2f,::cv::Mat &,::cv::Size,::cv::RNG & ) const)( &::cv::PatchGenerator::operator() )
            , ( bp::arg("image"), bp::arg("pt"), bp::arg("patch"), bp::arg("patchSize"), bp::arg("rng") ) )    
        .def( 
            "__call__"
            , (void ( cv::PatchGenerator::* )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Size,::cv::RNG & ) const)( &::cv::PatchGenerator::operator() )
            , ( bp::arg("image"), bp::arg("transform"), bp::arg("patch"), bp::arg("patchSize"), bp::arg("rng") ) )    
        .def( 
            "warpWholeImage"
            , (void ( cv::PatchGenerator::* )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,int,::cv::RNG & ) const)( &::cv::PatchGenerator::warpWholeImage )
            , ( bp::arg("image"), bp::arg("matT"), bp::arg("buf"), bp::arg("warped"), bp::arg("border"), bp::arg("rng") ) )    
        .def_readwrite( "backgroundMax", &cv::PatchGenerator::backgroundMax )    
        .def_readwrite( "backgroundMin", &cv::PatchGenerator::backgroundMin )    
        .def_readwrite( "lambdaMax", &cv::PatchGenerator::lambdaMax )    
        .def_readwrite( "lambdaMin", &cv::PatchGenerator::lambdaMin )    
        .def_readwrite( "noiseRange", &cv::PatchGenerator::noiseRange )    
        .def_readwrite( "phiMax", &cv::PatchGenerator::phiMax )    
        .def_readwrite( "phiMin", &cv::PatchGenerator::phiMin )    
        .def_readwrite( "randomBlur", &cv::PatchGenerator::randomBlur )    
        .def_readwrite( "thetaMax", &cv::PatchGenerator::thetaMax )    
        .def_readwrite( "thetaMin", &cv::PatchGenerator::thetaMin );

    { //::cv::FernClassifier
        typedef bp::class_< FernClassifier_wrapper > FernClassifier_exposer_t;
        FernClassifier_exposer_t FernClassifier_exposer = FernClassifier_exposer_t( "FernClassifier", bp::init< >() );
        bp::scope FernClassifier_scope( FernClassifier_exposer );
        FernClassifier_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::FernClassifier >() );
        bp::scope().attr("PATCH_SIZE") = (int)cv::FernClassifier::PATCH_SIZE;
        bp::scope().attr("DEFAULT_STRUCTS") = (int)cv::FernClassifier::DEFAULT_STRUCTS;
        bp::scope().attr("DEFAULT_STRUCT_SIZE") = (int)cv::FernClassifier::DEFAULT_STRUCT_SIZE;
        bp::scope().attr("DEFAULT_VIEWS") = (int)cv::FernClassifier::DEFAULT_VIEWS;
        bp::scope().attr("DEFAULT_SIGNATURE_SIZE") = (int)cv::FernClassifier::DEFAULT_SIGNATURE_SIZE;
        bp::scope().attr("COMPRESSION_NONE") = (int)cv::FernClassifier::COMPRESSION_NONE;
        bp::scope().attr("COMPRESSION_RANDOM_PROJ") = (int)cv::FernClassifier::COMPRESSION_RANDOM_PROJ;
        bp::scope().attr("COMPRESSION_PCA") = (int)cv::FernClassifier::COMPRESSION_PCA;
        bp::scope().attr("DEFAULT_COMPRESSION_METHOD") = (int)cv::FernClassifier::DEFAULT_COMPRESSION_METHOD;
        bp::class_< cv::FernClassifier::Feature >( "Feature", bp::init< >() )    
            .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::FernClassifier::Feature >() )    
            .def( bp::init< int, int, int, int >(( bp::arg("_x1"), bp::arg("_y1"), bp::arg("_x2"), bp::arg("_y2") )) )    
            .def_readwrite( "x1", &cv::FernClassifier::Feature::x1 )    
            .def_readwrite( "x2", &cv::FernClassifier::Feature::x2 )    
            .def_readwrite( "y1", &cv::FernClassifier::Feature::y1 )    
            .def_readwrite( "y2", &cv::FernClassifier::Feature::y2 );
        FernClassifier_exposer.def( bp::init< cv::FileNode const & >(( bp::arg("node") )) );
        bp::implicitly_convertible< cv::FileNode const &, cv::FernClassifier >();
        FernClassifier_exposer.def( bp::init< std::vector< cv::Point_<float> > const &, std::vector< cv::Ptr<cv::Mat> > const &, bp::optional< std::vector< int > const &, int, int, int, int, int, int, int, cv::PatchGenerator const & > >(( bp::arg("points"), bp::arg("refimgs"), bp::arg("labels")=std::vector<int>(), bp::arg("_nclasses")=(int)(0), bp::arg("_patchSize")=int(::cv::FernClassifier::PATCH_SIZE), bp::arg("_signatureSize")=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), bp::arg("_nstructs")=int(::cv::FernClassifier::DEFAULT_STRUCTS), bp::arg("_structSize")=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), bp::arg("_nviews")=int(::cv::FernClassifier::DEFAULT_VIEWS), bp::arg("_compressionMethod")=int(::cv::FernClassifier::COMPRESSION_NONE), bp::arg("patchGenerator")=cv::PatchGenerator() )) );
        { //::cv::FernClassifier::clear
        
            typedef void ( ::cv::FernClassifier::*clear_function_type )(  ) ;
            typedef void ( FernClassifier_wrapper::*default_clear_function_type )(  ) ;
            
            FernClassifier_exposer.def( 
                "clear"
                , clear_function_type(&::cv::FernClassifier::clear)
                , default_clear_function_type(&FernClassifier_wrapper::default_clear) );
        
        }
        { //::cv::FernClassifier::getClassCount
        
            typedef int ( ::cv::FernClassifier::*getClassCount_function_type )(  ) const;
            
            FernClassifier_exposer.def( 
                "getClassCount"
                , getClassCount_function_type( &::cv::FernClassifier::getClassCount ) );
        
        }
        { //::cv::FernClassifier::getCompressionMethod
        
            typedef int ( ::cv::FernClassifier::*getCompressionMethod_function_type )(  ) const;
            
            FernClassifier_exposer.def( 
                "getCompressionMethod"
                , getCompressionMethod_function_type( &::cv::FernClassifier::getCompressionMethod ) );
        
        }
        { //::cv::FernClassifier::getPatchSize
        
            typedef ::cv::Size ( ::cv::FernClassifier::*getPatchSize_function_type )(  ) const;
            
            FernClassifier_exposer.def( 
                "getPatchSize"
                , getPatchSize_function_type( &::cv::FernClassifier::getPatchSize ) );
        
        }
        { //::cv::FernClassifier::getSignatureSize
        
            typedef int ( ::cv::FernClassifier::*getSignatureSize_function_type )(  ) const;
            
            FernClassifier_exposer.def( 
                "getSignatureSize"
                , getSignatureSize_function_type( &::cv::FernClassifier::getSignatureSize ) );
        
        }
        { //::cv::FernClassifier::getStructCount
        
            typedef int ( ::cv::FernClassifier::*getStructCount_function_type )(  ) const;
            
            FernClassifier_exposer.def( 
                "getStructCount"
                , getStructCount_function_type( &::cv::FernClassifier::getStructCount ) );
        
        }
        { //::cv::FernClassifier::getStructSize
        
            typedef int ( ::cv::FernClassifier::*getStructSize_function_type )(  ) const;
            
            FernClassifier_exposer.def( 
                "getStructSize"
                , getStructSize_function_type( &::cv::FernClassifier::getStructSize ) );
        
        }
        { //::cv::FernClassifier::operator()
        
            typedef boost::python::tuple ( *default___call___function_type )( cv::FernClassifier const &,cv::Mat const &,::cv::Point2f );
            
            FernClassifier_exposer.def( 
                "__call__"
                , default___call___function_type( &FernClassifier_wrapper::default___call___c4d2198033cf380377bb6f32571c2657 )
                , ( bp::arg("inst"), bp::arg("img"), bp::arg("kpt") )
                , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'signature':"\
    "\n    C++ type: ::std::vector< float > &"\
    "\n    Python type: vector_float32"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((int), signature)" );
        
        }
        { //::cv::FernClassifier::operator()
        
            typedef boost::python::tuple ( *default___call___function_type )( cv::FernClassifier const &,cv::Mat const & );
            
            FernClassifier_exposer.def( 
                "__call__"
                , default___call___function_type( &FernClassifier_wrapper::default___call___ddcd7402f4cc50fa35ce4888642630c7 )
                , ( bp::arg("inst"), bp::arg("patch") )
                , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'signature':"\
    "\n    C++ type: ::std::vector< float > &"\
    "\n    Python type: vector_float32"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    ((int), signature)" );
        
        }
        { //::cv::FernClassifier::read
        
            typedef void ( ::cv::FernClassifier::*read_function_type )( ::cv::FileNode const & ) ;
            typedef void ( FernClassifier_wrapper::*default_read_function_type )( ::cv::FileNode const & ) ;
            
            FernClassifier_exposer.def( 
                "read"
                , read_function_type(&::cv::FernClassifier::read)
                , default_read_function_type(&FernClassifier_wrapper::default_read)
                , ( bp::arg("n") ) );
        
        }
        { //::cv::FernClassifier::setVerbose
        
            typedef void ( ::cv::FernClassifier::*setVerbose_function_type )( bool ) ;
            
            FernClassifier_exposer.def( 
                "setVerbose"
                , setVerbose_function_type( &::cv::FernClassifier::setVerbose )
                , ( bp::arg("verbose") ) );
        
        }
        { //::cv::FernClassifier::train
        
            typedef void ( ::cv::FernClassifier::*train_function_type )( ::std::vector< cv::Point_<float> > const &,::std::vector< cv::Ptr<cv::Mat> > const &,::std::vector< int > const &,int,int,int,int,int,int,int,::cv::PatchGenerator const & ) ;
            typedef void ( FernClassifier_wrapper::*default_train_function_type )( ::std::vector< cv::Point_<float> > const &,::std::vector< cv::Ptr<cv::Mat> > const &,::std::vector< int > const &,int,int,int,int,int,int,int,::cv::PatchGenerator const & ) ;
            
            FernClassifier_exposer.def( 
                "train"
                , train_function_type(&::cv::FernClassifier::train)
                , default_train_function_type(&FernClassifier_wrapper::default_train)
                , ( bp::arg("points"), bp::arg("refimgs"), bp::arg("labels")=std::vector<int>(), bp::arg("_nclasses")=(int)(0), bp::arg("_patchSize")=int(::cv::FernClassifier::PATCH_SIZE), bp::arg("_signatureSize")=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), bp::arg("_nstructs")=int(::cv::FernClassifier::DEFAULT_STRUCTS), bp::arg("_structSize")=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), bp::arg("_nviews")=int(::cv::FernClassifier::DEFAULT_VIEWS), bp::arg("_compressionMethod")=int(::cv::FernClassifier::COMPRESSION_NONE), bp::arg("patchGenerator")=cv::PatchGenerator() ) );
        
        }
        { //::cv::FernClassifier::trainFromSingleView
        
            typedef void ( ::cv::FernClassifier::*trainFromSingleView_function_type )( ::cv::Mat const &,::std::vector< cv::KeyPoint > const &,int,int,int,int,int,int,::cv::PatchGenerator const & ) ;
            typedef void ( FernClassifier_wrapper::*default_trainFromSingleView_function_type )( ::cv::Mat const &,::std::vector< cv::KeyPoint > const &,int,int,int,int,int,int,::cv::PatchGenerator const & ) ;
            
            FernClassifier_exposer.def( 
                "trainFromSingleView"
                , trainFromSingleView_function_type(&::cv::FernClassifier::trainFromSingleView)
                , default_trainFromSingleView_function_type(&FernClassifier_wrapper::default_trainFromSingleView)
                , ( bp::arg("image"), bp::arg("keypoints"), bp::arg("_patchSize")=int(::cv::FernClassifier::PATCH_SIZE), bp::arg("_signatureSize")=int(::cv::FernClassifier::DEFAULT_SIGNATURE_SIZE), bp::arg("_nstructs")=int(::cv::FernClassifier::DEFAULT_STRUCTS), bp::arg("_structSize")=int(::cv::FernClassifier::DEFAULT_STRUCT_SIZE), bp::arg("_nviews")=int(::cv::FernClassifier::DEFAULT_VIEWS), bp::arg("_compressionMethod")=int(::cv::FernClassifier::COMPRESSION_NONE), bp::arg("patchGenerator")=cv::PatchGenerator() ) );
        
        }
        { //::cv::FernClassifier::write
        
            typedef void ( ::cv::FernClassifier::*write_function_type )( ::cv::FileStorage &,::cv::String const & ) const;
            typedef void ( FernClassifier_wrapper::*default_write_function_type )( ::cv::FileStorage &,::cv::String const & ) const;
            
            FernClassifier_exposer.def( 
                "write"
                , write_function_type(&::cv::FernClassifier::write)
                , default_write_function_type(&FernClassifier_wrapper::default_write)
                , ( bp::arg("fs"), bp::arg("name")=std::string() ) );
        
        }
    }

    { //::cv::HOGDescriptor
        typedef bp::class_< HOGDescriptor_wrapper > HOGDescriptor_exposer_t;
        HOGDescriptor_exposer_t HOGDescriptor_exposer = HOGDescriptor_exposer_t( "HOGDescriptor", bp::init< >() );
        bp::scope HOGDescriptor_scope( HOGDescriptor_exposer );
        HOGDescriptor_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::HOGDescriptor >() );
        bp::scope().attr("L2Hys") = (int)cv::HOGDescriptor::L2Hys;
        HOGDescriptor_exposer.def( bp::init< cv::Size, cv::Size, cv::Size, cv::Size, int, bp::optional< int, double, int, double, bool > >(( bp::arg("_winSize"), bp::arg("_blockSize"), bp::arg("_blockStride"), bp::arg("_cellSize"), bp::arg("_nbins"), bp::arg("_derivAperture")=(int)(1), bp::arg("_winSigma")=-0x000000001, bp::arg("_histogramNormType")=int(::cv::HOGDescriptor::L2Hys), bp::arg("_L2HysThreshold")=2.00000000000000011102230246251565404236316680908e-1, bp::arg("_gammaCorrection")=(bool)(false) )) );
        HOGDescriptor_exposer.def( bp::init< cv::String const & >(( bp::arg("filename") )) );
        bp::implicitly_convertible< cv::String const &, cv::HOGDescriptor >();
        { //::cv::HOGDescriptor::checkDetectorSize
        
            typedef bool ( ::cv::HOGDescriptor::*checkDetectorSize_function_type )(  ) const;
            
            HOGDescriptor_exposer.def( 
                "checkDetectorSize"
                , checkDetectorSize_function_type( &::cv::HOGDescriptor::checkDetectorSize ) );
        
        }
        { //::cv::HOGDescriptor::compute
        
            typedef boost::python::object ( *default_compute_function_type )( cv::HOGDescriptor const &,cv::Mat const &,::cv::Size,::cv::Size,std::vector<cv::Point_<int> > const & );
            
            HOGDescriptor_exposer.def( 
                "compute"
                , default_compute_function_type( &HOGDescriptor_wrapper::default_compute )
                , ( bp::arg("inst"), bp::arg("img"), bp::arg("winStride")=cv::Size_<int>(), bp::arg("padding")=cv::Size_<int>(), bp::arg("locations")=std::vector<cv::Point>() )
                , "\nArgument 'descriptors':"\
    "\n    C++ type: ::std::vector< float > &"\
    "\n    Python type: vector_float32"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    descriptors" );
        
        }
        { //::cv::HOGDescriptor::computeGradient
        
            typedef void ( ::cv::HOGDescriptor::*computeGradient_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Size,::cv::Size ) const;
            typedef void ( HOGDescriptor_wrapper::*default_computeGradient_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Size,::cv::Size ) const;
            
            HOGDescriptor_exposer.def( 
                "computeGradient"
                , computeGradient_function_type(&::cv::HOGDescriptor::computeGradient)
                , default_computeGradient_function_type(&HOGDescriptor_wrapper::default_computeGradient)
                , ( bp::arg("img"), bp::arg("grad"), bp::arg("angleOfs"), bp::arg("paddingTL")=cv::Size_<int>(), bp::arg("paddingBR")=cv::Size_<int>() ) );
        
        }
        { //::cv::HOGDescriptor::detect
        
            typedef boost::python::object ( *default_detect_function_type )( cv::HOGDescriptor const &,cv::Mat const &,double,::cv::Size,::cv::Size,std::vector<cv::Point_<int> > const & );
            
            HOGDescriptor_exposer.def( 
                "detect"
                , default_detect_function_type( &HOGDescriptor_wrapper::default_detect )
                , ( bp::arg("inst"), bp::arg("img"), bp::arg("hitThreshold")=0, bp::arg("winStride")=cv::Size_<int>(), bp::arg("padding")=cv::Size_<int>(), bp::arg("searchLocations")=std::vector<cv::Point>() )
                , "\nArgument 'foundLocations':"\
    "\n    C++ type: ::std::vector< cv::Point_<int> > &"\
    "\n    Python type: vector_Point2i"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    foundLocations" );
        
        }
        { //::cv::HOGDescriptor::detectMultiScale
        
            typedef boost::python::object ( *default_detectMultiScale_function_type )( cv::HOGDescriptor const &,cv::Mat const &,double,::cv::Size,::cv::Size,double,int );
            
            HOGDescriptor_exposer.def( 
                "detectMultiScale"
                , default_detectMultiScale_function_type( &HOGDescriptor_wrapper::default_detectMultiScale )
                , ( bp::arg("inst"), bp::arg("img"), bp::arg("hitThreshold")=0, bp::arg("winStride")=cv::Size_<int>(), bp::arg("padding")=cv::Size_<int>(), bp::arg("scale")=1.05000000000000004440892098500626161694526672363e+0, bp::arg("groupThreshold")=(int)(2) )
                , "\nArgument 'foundLocations':"\
    "\n    C++ type: ::std::vector< cv::Rect_<int> > &"\
    "\n    Python type: vector_Rect"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    foundLocations" );
        
        }
        { //::cv::HOGDescriptor::getDefaultPeopleDetector
        
            typedef ::std::vector< float > ( *getDefaultPeopleDetector_function_type )(  );
            
            HOGDescriptor_exposer.def( 
                "getDefaultPeopleDetector"
                , getDefaultPeopleDetector_function_type( &::cv::HOGDescriptor::getDefaultPeopleDetector ) );
        
        }
        { //::cv::HOGDescriptor::getDescriptorSize
        
            typedef ::size_t ( ::cv::HOGDescriptor::*getDescriptorSize_function_type )(  ) const;
            
            HOGDescriptor_exposer.def( 
                "getDescriptorSize"
                , getDescriptorSize_function_type( &::cv::HOGDescriptor::getDescriptorSize ) );
        
        }
        { //::cv::HOGDescriptor::getWinSigma
        
            typedef double ( ::cv::HOGDescriptor::*getWinSigma_function_type )(  ) const;
            
            HOGDescriptor_exposer.def( 
                "getWinSigma"
                , getWinSigma_function_type( &::cv::HOGDescriptor::getWinSigma ) );
        
        }
        { //::cv::HOGDescriptor::load
        
            typedef bool ( ::cv::HOGDescriptor::*load_function_type )( ::cv::String const &,::cv::String const & ) ;
            typedef bool ( HOGDescriptor_wrapper::*default_load_function_type )( ::cv::String const &,::cv::String const & ) ;
            
            HOGDescriptor_exposer.def( 
                "load"
                , load_function_type(&::cv::HOGDescriptor::load)
                , default_load_function_type(&HOGDescriptor_wrapper::default_load)
                , ( bp::arg("filename"), bp::arg("objname")=std::string() ) );
        
        }
        { //::cv::HOGDescriptor::save
        
            typedef void ( ::cv::HOGDescriptor::*save_function_type )( ::cv::String const &,::cv::String const & ) const;
            typedef void ( HOGDescriptor_wrapper::*default_save_function_type )( ::cv::String const &,::cv::String const & ) const;
            
            HOGDescriptor_exposer.def( 
                "save"
                , save_function_type(&::cv::HOGDescriptor::save)
                , default_save_function_type(&HOGDescriptor_wrapper::default_save)
                , ( bp::arg("filename"), bp::arg("objname")=std::string() ) );
        
        }
        { //::cv::HOGDescriptor::setSVMDetector
        
            typedef void ( ::cv::HOGDescriptor::*setSVMDetector_function_type )( ::std::vector< float > const & ) ;
            typedef void ( HOGDescriptor_wrapper::*default_setSVMDetector_function_type )( ::std::vector< float > const & ) ;
            
            HOGDescriptor_exposer.def( 
                "setSVMDetector"
                , setSVMDetector_function_type(&::cv::HOGDescriptor::setSVMDetector)
                , default_setSVMDetector_function_type(&HOGDescriptor_wrapper::default_setSVMDetector)
                , ( bp::arg("_svmdetector") ) );
        
        }
        HOGDescriptor_exposer.def_readwrite( "L2HysThreshold", &cv::HOGDescriptor::L2HysThreshold );
        HOGDescriptor_exposer.def_readwrite( "blockSize", &cv::HOGDescriptor::blockSize );
        HOGDescriptor_exposer.def_readwrite( "blockStride", &cv::HOGDescriptor::blockStride );
        HOGDescriptor_exposer.def_readwrite( "cellSize", &cv::HOGDescriptor::cellSize );
        HOGDescriptor_exposer.def_readwrite( "derivAperture", &cv::HOGDescriptor::derivAperture );
        HOGDescriptor_exposer.def_readwrite( "gammaCorrection", &cv::HOGDescriptor::gammaCorrection );
        HOGDescriptor_exposer.def_readwrite( "histogramNormType", &cv::HOGDescriptor::histogramNormType );
        HOGDescriptor_exposer.def_readwrite( "nbins", &cv::HOGDescriptor::nbins );
        HOGDescriptor_exposer.def_readwrite( "svmDetector", &cv::HOGDescriptor::svmDetector );
        HOGDescriptor_exposer.def_readwrite( "winSigma", &cv::HOGDescriptor::winSigma );
        HOGDescriptor_exposer.def_readwrite( "winSize", &cv::HOGDescriptor::winSize );
        HOGDescriptor_exposer.staticmethod( "getDefaultPeopleDetector" );
    }

    bp::class_< cv::LDetector >( "LDetector", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::LDetector >() )    
        .def( bp::init< int, int, int, int, double, double >(( bp::arg("_radius"), bp::arg("_threshold"), bp::arg("_nOctaves"), bp::arg("_nViews"), bp::arg("_baseFeatureSize"), bp::arg("_clusteringDistance") )) )    
        .def( 
            "getMostStable2D"
            , (void ( cv::LDetector::* )( ::cv::Mat const &,::std::vector< cv::KeyPoint > &,int,::cv::PatchGenerator const & ) const)( &::cv::LDetector::getMostStable2D )
            , ( bp::arg("image"), bp::arg("keypoints"), bp::arg("maxCount"), bp::arg("patchGenerator") ) )    
        .def( 
            "__call__"
            , (boost::python::object (*)( cv::LDetector const &,cv::Mat const &,int,bool ))( &__call___14ec982e59fdc13237968e34b82d6fe2 )
            , ( bp::arg("inst"), bp::arg("image"), bp::arg("maxCount")=(int)(0), bp::arg("scaleCoords")=(bool)(true) )
            , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'keypoints':"\
    "\n    C++ type: ::std::vector< cv::KeyPoint > &"\
    "\n    Python type: vector_KeyPoint"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    keypoints" )    
        .def( 
            "__call__"
            , (boost::python::object (*)( cv::LDetector const &,std::vector<cv::Mat> const &,int,bool ))( &__call___015c5cd98f14b41d0eaab62238a1a6fe )
            , ( bp::arg("inst"), bp::arg("pyr"), bp::arg("maxCount")=(int)(0), bp::arg("scaleCoords")=(bool)(true) )
            , "\nWrapped function:"
    "\n    operator()"
    "\nArgument 'keypoints':"\
    "\n    C++ type: ::std::vector< cv::KeyPoint > &"\
    "\n    Python type: vector_KeyPoint"\
    "\n    Output argument: omitted from input and returned as output."\
    "\nReturns:"\
    "\n    keypoints" )    
        .def( 
            "read"
            , (void ( cv::LDetector::* )( ::cv::FileNode const & ) )( &::cv::LDetector::read )
            , ( bp::arg("node") ) )    
        .def( 
            "setVerbose"
            , (void ( cv::LDetector::* )( bool ) )( &::cv::LDetector::setVerbose )
            , ( bp::arg("verbose") ) )    
        .def( 
            "write"
            , (void ( cv::LDetector::* )( ::cv::FileStorage &,::cv::String const & ) const)( &::cv::LDetector::write )
            , ( bp::arg("fs"), bp::arg("name")=std::string() ) )    
        .def_readwrite( "baseFeatureSize", &cv::LDetector::baseFeatureSize )    
        .def_readwrite( "clusteringDistance", &cv::LDetector::clusteringDistance )    
        .def_readwrite( "nOctaves", &cv::LDetector::nOctaves )    
        .def_readwrite( "nViews", &cv::LDetector::nViews )    
        .def_readwrite( "radius", &cv::LDetector::radius )    
        .def_readwrite( "threshold", &cv::LDetector::threshold )    
        .def_readwrite( "verbose", &cv::LDetector::verbose );

    bp::class_< LevMarqSparse_wrapper >( "LevMarqSparse", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< cv::LevMarqSparse >() )    
        .def( 
            "bundleAdjust"
            , (void (*)( ::std::vector< cv::Point3_<double> > &,::std::vector< std::vector< cv::Point_<double> > > const &,::std::vector< std::vector< int > > const &,::std::vector< cv::Mat > &,::std::vector< cv::Mat > &,::std::vector< cv::Mat > &,::std::vector< cv::Mat > &,::cv::TermCriteria const & ))( &::cv::LevMarqSparse::bundleAdjust )
            , ( bp::arg("points"), bp::arg("imagePoints"), bp::arg("visibility"), bp::arg("cameraMatrix"), bp::arg("R"), bp::arg("T"), bp::arg("distCoeffs"), bp::arg("criteria")=cv::TermCriteria(3, 30, 2.220446049250313080847263336181640625e-16) ) )    
        .def( 
            "clear"
            , (void ( cv::LevMarqSparse::* )(  ) )(&::cv::LevMarqSparse::clear)
            , (void ( LevMarqSparse_wrapper::* )(  ) )(&LevMarqSparse_wrapper::default_clear) )    
        .staticmethod( "bundleAdjust" )    
        .def( bp::init< int, int, int, int, int, cv::Mat&, cv::Mat&, cv::Mat&, cv::TermCriteria, bp::object const &, bp::object const &, bp::object const & >(( bp::arg("npoints"), bp::arg("ncameras"), bp::arg("nPointParams"), bp::arg("nCameraParams"), bp::arg("nErrParams"), bp::arg("visibility"), bp::arg("P0"), bp::arg("X"), bp::arg("criteria"), bp::arg("fjac"), bp::arg("func"), bp::arg("data"))) )    
        .def("run", &LevMarqSparse_wrapper::sdrun, ( bp::arg("npoints"), bp::arg("ncameras"), bp::arg("nPointParams"), bp::arg("nCameraParams"), bp::arg("nErrParams"), bp::arg("visibility"), bp::arg("P0"), bp::arg("X"), bp::arg("criteria"), bp::arg("fjac"), bp::arg("func"), bp::arg("data")) );

}
