// This file has been generated by Py++.

#include "boost/python.hpp"
#include "__call_policies.pypp.hpp"
#include "__convenience.pypp.hpp"
#include "opencv_converters.hpp"
#include "__ctypes_integration.pypp.hpp"
#include "cvaux_wrapper.hpp"
#include "boost/python/object.hpp"
#include "cvaux_ext_classes_2.pypp.hpp"

namespace bp = boost::python;

static CvBlobSeq * get_CvBlobTrack_pBlobSeq( CvBlobTrack const & inst ) { return inst.pBlobSeq; }

struct CvBlobTrackAnalysis_wrapper : CvBlobTrackAnalysis, bp::wrapper< CvBlobTrackAnalysis > {

    CvBlobTrackAnalysis_wrapper( )
    : CvBlobTrackAnalysis( )
      , bp::wrapper< CvBlobTrackAnalysis >(){
        // null constructor
    
    }

    virtual void AddBlob( ::CvBlob * pBlob ){
        bp::override func_AddBlob = this->get_override( "AddBlob" );
        func_AddBlob( boost::python::ptr(pBlob) );
    }

    virtual float GetState( int BlobID ){
        bp::override func_GetState = this->get_override( "GetState" );
        return func_GetState( BlobID );
    }

    virtual char const * GetStateDesc( int arg0 ) {
        if( bp::override func_GetStateDesc = this->get_override( "GetStateDesc" ) )
            return func_GetStateDesc( arg0 );
        else{
            return this->CvBlobTrackAnalysis::GetStateDesc( arg0 );
        }
    }
    
    char const * default_GetStateDesc( int arg0 ) {
        return CvBlobTrackAnalysis::GetStateDesc( arg0 );
    }

    virtual void Process( ::IplImage * pImg, ::IplImage * pFG ) {
        namespace bpl = boost::python;
        if( bpl::override func_Process = this->get_override( "Process" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_Process.ptr(), pImg, pFG );
        }
        else{
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
    }
    
    static void default_Process( ::CvBlobTrackAnalysis & inst, ::cv::Mat & pImg, ::cv::Mat & pFG ){
        if( dynamic_cast< CvBlobTrackAnalysis_wrapper * >( boost::addressof( inst ) ) ){
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
        else{
            inst.Process(get_IplImage_ptr(pImg), get_IplImage_ptr(pFG));
        }
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

    virtual void SetFileName( char * arg0 ) {
        if( bp::override func_SetFileName = this->get_override( "SetFileName" ) )
            func_SetFileName( arg0 );
        else{
            this->CvBlobTrackAnalysis::SetFileName( arg0 );
        }
    }
    
    void default_SetFileName( char * arg0 ) {
        CvBlobTrackAnalysis::SetFileName( arg0 );
    }

    virtual void LoadState( ::CvFileStorage * arg0, ::CvFileNode * arg1 ) {
        namespace bpl = boost::python;
        if( bpl::override func_LoadState = this->get_override( "LoadState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_LoadState.ptr(), arg0, arg1 );
        }
        else{
            CvVSModule::LoadState( boost::python::ptr(arg0), boost::python::ptr(arg1) );
        }
    }
    
    static void default_LoadState( ::CvVSModule & inst, ::cv::FileStorage & arg0, ::cv::FileNode & arg1 ){
        if( dynamic_cast< CvBlobTrackAnalysis_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::LoadState(arg0.fs, *(arg1));
        }
        else{
            inst.LoadState(arg0.fs, *(arg1));
        }
    }

    virtual void ParamUpdate(  ) {
        if( bp::override func_ParamUpdate = this->get_override( "ParamUpdate" ) )
            func_ParamUpdate(  );
        else{
            this->CvVSModule::ParamUpdate(  );
        }
    }
    
    void default_ParamUpdate(  ) {
        CvVSModule::ParamUpdate( );
    }

    virtual void SaveState( ::CvFileStorage * arg0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_SaveState = this->get_override( "SaveState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_SaveState.ptr(), arg0 );
        }
        else{
            CvVSModule::SaveState( boost::python::ptr(arg0) );
        }
    }
    
    static void default_SaveState( ::CvVSModule & inst, ::cv::FileStorage & arg0 ){
        if( dynamic_cast< CvBlobTrackAnalysis_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::SaveState(arg0.fs);
        }
        else{
            inst.SaveState(arg0.fs);
        }
    }

};

struct CvBlobTrackAnalysisHeight_wrapper : CvBlobTrackAnalysisHeight, bp::wrapper< CvBlobTrackAnalysisHeight > {

    CvBlobTrackAnalysisHeight_wrapper()
    : CvBlobTrackAnalysisHeight()
      , bp::wrapper< CvBlobTrackAnalysisHeight >(){
        // null constructor
        
    }

    virtual double GetHeight( ::CvBlob * pB ){
        bp::override func_GetHeight = this->get_override( "GetHeight" );
        return func_GetHeight( boost::python::ptr(pB) );
    }

    virtual void AddBlob( ::CvBlob * pBlob ){
        bp::override func_AddBlob = this->get_override( "AddBlob" );
        func_AddBlob( boost::python::ptr(pBlob) );
    }

    virtual float GetState( int BlobID ){
        bp::override func_GetState = this->get_override( "GetState" );
        return func_GetState( BlobID );
    }

    virtual char const * GetStateDesc( int arg0 ) {
        if( bp::override func_GetStateDesc = this->get_override( "GetStateDesc" ) )
            return func_GetStateDesc( arg0 );
        else{
            return this->CvBlobTrackAnalysis::GetStateDesc( arg0 );
        }
    }
    
    char const * default_GetStateDesc( int arg0 ) {
        return CvBlobTrackAnalysis::GetStateDesc( arg0 );
    }

    virtual void LoadState( ::CvFileStorage * arg0, ::CvFileNode * arg1 ) {
        namespace bpl = boost::python;
        if( bpl::override func_LoadState = this->get_override( "LoadState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_LoadState.ptr(), arg0, arg1 );
        }
        else{
            CvVSModule::LoadState( boost::python::ptr(arg0), boost::python::ptr(arg1) );
        }
    }
    
    static void default_LoadState( ::CvVSModule & inst, ::cv::FileStorage & arg0, ::cv::FileNode & arg1 ){
        if( dynamic_cast< CvBlobTrackAnalysisHeight_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::LoadState(arg0.fs, *(arg1));
        }
        else{
            inst.LoadState(arg0.fs, *(arg1));
        }
    }

    virtual void ParamUpdate(  ) {
        if( bp::override func_ParamUpdate = this->get_override( "ParamUpdate" ) )
            func_ParamUpdate(  );
        else{
            this->CvVSModule::ParamUpdate(  );
        }
    }
    
    void default_ParamUpdate(  ) {
        CvVSModule::ParamUpdate( );
    }

    virtual void Process( ::IplImage * pImg, ::IplImage * pFG ) {
        namespace bpl = boost::python;
        if( bpl::override func_Process = this->get_override( "Process" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_Process.ptr(), pImg, pFG );
        }
        else{
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
    }
    
    static void default_Process( ::CvBlobTrackAnalysis & inst, ::cv::Mat & pImg, ::cv::Mat & pFG ){
        if( dynamic_cast< CvBlobTrackAnalysisHeight_wrapper * >( boost::addressof( inst ) ) ){
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
        else{
            inst.Process(get_IplImage_ptr(pImg), get_IplImage_ptr(pFG));
        }
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

    virtual void SaveState( ::CvFileStorage * arg0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_SaveState = this->get_override( "SaveState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_SaveState.ptr(), arg0 );
        }
        else{
            CvVSModule::SaveState( boost::python::ptr(arg0) );
        }
    }
    
    static void default_SaveState( ::CvVSModule & inst, ::cv::FileStorage & arg0 ){
        if( dynamic_cast< CvBlobTrackAnalysisHeight_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::SaveState(arg0.fs);
        }
        else{
            inst.SaveState(arg0.fs);
        }
    }

    virtual void SetFileName( char * arg0 ) {
        if( bp::override func_SetFileName = this->get_override( "SetFileName" ) )
            func_SetFileName( arg0 );
        else{
            this->CvBlobTrackAnalysis::SetFileName( arg0 );
        }
    }
    
    void default_SetFileName( char * arg0 ) {
        CvBlobTrackAnalysis::SetFileName( arg0 );
    }

};

struct CvBlobTrackAnalysisOne_wrapper : CvBlobTrackAnalysisOne, bp::wrapper< CvBlobTrackAnalysisOne > {

    CvBlobTrackAnalysisOne_wrapper()
    : CvBlobTrackAnalysisOne()
      , bp::wrapper< CvBlobTrackAnalysisOne >(){
        // null constructor
        
    }

    virtual int Process( ::CvBlob * pBlob, ::IplImage * pImg, ::IplImage * pFG ) {
        namespace bpl = boost::python;
        if( bpl::override func_Process = this->get_override( "Process" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_Process.ptr(), pBlob, pImg, pFG );
            return bpl::extract< int >( pyplus_conv::get_out_argument( py_result, 0 ) );
        }
        else{
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
    }
    
    static boost::python::object default_Process( ::CvBlobTrackAnalysisOne & inst, ::CvBlob * pBlob, ::cv::Mat & pImg, ::cv::Mat & pFG ){
        int result;
        if( dynamic_cast< CvBlobTrackAnalysisOne_wrapper * >( boost::addressof( inst ) ) ){
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
        else{
            result = inst.Process(pBlob, get_IplImage_ptr(pImg), get_IplImage_ptr(pFG));
        }
        return bp::object( result );
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

};

struct CvBlobTrackGen_wrapper : CvBlobTrackGen, bp::wrapper< CvBlobTrackGen > {

    CvBlobTrackGen_wrapper( )
    : CvBlobTrackGen( )
      , bp::wrapper< CvBlobTrackGen >(){
        // null constructor
    
    }

    virtual void AddBlob( ::CvBlob * pBlob ){
        bp::override func_AddBlob = this->get_override( "AddBlob" );
        func_AddBlob( boost::python::ptr(pBlob) );
    }

    virtual void Process( ::IplImage * pImg=0, ::IplImage * pFG=0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_Process = this->get_override( "Process" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_Process.ptr(), pImg, pFG );
        }
        else{
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
    }
    
    static void default_Process( ::CvBlobTrackGen & inst, ::cv::Mat pImg=cv::Mat(), ::cv::Mat pFG=cv::Mat() ){
        if( dynamic_cast< CvBlobTrackGen_wrapper * >( boost::addressof( inst ) ) ){
              PyErr_SetString(PyExc_NotImplementedError, "Attempted calling Pure Virtual function that is not implemented :Process");
              boost::python::throw_error_already_set();
        }
        else{
            inst.Process(get_IplImage_ptr(pImg), get_IplImage_ptr(pFG));
        }
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

    virtual void SetFileName( char * pFileName ){
        bp::override func_SetFileName = this->get_override( "SetFileName" );
        func_SetFileName( pFileName );
    }

    virtual void LoadState( ::CvFileStorage * arg0, ::CvFileNode * arg1 ) {
        namespace bpl = boost::python;
        if( bpl::override func_LoadState = this->get_override( "LoadState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_LoadState.ptr(), arg0, arg1 );
        }
        else{
            CvVSModule::LoadState( boost::python::ptr(arg0), boost::python::ptr(arg1) );
        }
    }
    
    static void default_LoadState( ::CvVSModule & inst, ::cv::FileStorage & arg0, ::cv::FileNode & arg1 ){
        if( dynamic_cast< CvBlobTrackGen_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::LoadState(arg0.fs, *(arg1));
        }
        else{
            inst.LoadState(arg0.fs, *(arg1));
        }
    }

    virtual void ParamUpdate(  ) {
        if( bp::override func_ParamUpdate = this->get_override( "ParamUpdate" ) )
            func_ParamUpdate(  );
        else{
            this->CvVSModule::ParamUpdate(  );
        }
    }
    
    void default_ParamUpdate(  ) {
        CvVSModule::ParamUpdate( );
    }

    virtual void SaveState( ::CvFileStorage * arg0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_SaveState = this->get_override( "SaveState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_SaveState.ptr(), arg0 );
        }
        else{
            CvVSModule::SaveState( boost::python::ptr(arg0) );
        }
    }
    
    static void default_SaveState( ::CvVSModule & inst, ::cv::FileStorage & arg0 ){
        if( dynamic_cast< CvBlobTrackGen_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::SaveState(arg0.fs);
        }
        else{
            inst.SaveState(arg0.fs);
        }
    }

};

struct CvBlobTrackPostProc_wrapper : CvBlobTrackPostProc, bp::wrapper< CvBlobTrackPostProc > {

    CvBlobTrackPostProc_wrapper( )
    : CvBlobTrackPostProc( )
      , bp::wrapper< CvBlobTrackPostProc >(){
        // null constructor
    
    }

    virtual void AddBlob( ::CvBlob * pBlob ){
        bp::override func_AddBlob = this->get_override( "AddBlob" );
        func_AddBlob( boost::python::ptr(pBlob) );
    }

    virtual ::CvBlob * GetBlob( int index ){
        bp::override func_GetBlob = this->get_override( "GetBlob" );
        return func_GetBlob( index );
    }

    virtual ::CvBlob * GetBlobByID( int BlobID ) {
        if( bp::override func_GetBlobByID = this->get_override( "GetBlobByID" ) )
            return func_GetBlobByID( BlobID );
        else{
            return this->CvBlobTrackPostProc::GetBlobByID( BlobID );
        }
    }
    
    ::CvBlob * default_GetBlobByID( int BlobID ) {
        return CvBlobTrackPostProc::GetBlobByID( BlobID );
    }

    virtual int GetBlobNum(  ){
        bp::override func_GetBlobNum = this->get_override( "GetBlobNum" );
        return func_GetBlobNum(  );
    }

    virtual void Process(  ){
        bp::override func_Process = this->get_override( "Process" );
        func_Process(  );
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

    virtual void LoadState( ::CvFileStorage * arg0, ::CvFileNode * arg1 ) {
        namespace bpl = boost::python;
        if( bpl::override func_LoadState = this->get_override( "LoadState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_LoadState.ptr(), arg0, arg1 );
        }
        else{
            CvVSModule::LoadState( boost::python::ptr(arg0), boost::python::ptr(arg1) );
        }
    }
    
    static void default_LoadState( ::CvVSModule & inst, ::cv::FileStorage & arg0, ::cv::FileNode & arg1 ){
        if( dynamic_cast< CvBlobTrackPostProc_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::LoadState(arg0.fs, *(arg1));
        }
        else{
            inst.LoadState(arg0.fs, *(arg1));
        }
    }

    virtual void ParamUpdate(  ) {
        if( bp::override func_ParamUpdate = this->get_override( "ParamUpdate" ) )
            func_ParamUpdate(  );
        else{
            this->CvVSModule::ParamUpdate(  );
        }
    }
    
    void default_ParamUpdate(  ) {
        CvVSModule::ParamUpdate( );
    }

    virtual void SaveState( ::CvFileStorage * arg0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_SaveState = this->get_override( "SaveState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_SaveState.ptr(), arg0 );
        }
        else{
            CvVSModule::SaveState( boost::python::ptr(arg0) );
        }
    }
    
    static void default_SaveState( ::CvVSModule & inst, ::cv::FileStorage & arg0 ){
        if( dynamic_cast< CvBlobTrackPostProc_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::SaveState(arg0.fs);
        }
        else{
            inst.SaveState(arg0.fs);
        }
    }

};

struct CvBlobTrackPostProcOne_wrapper : CvBlobTrackPostProcOne, bp::wrapper< CvBlobTrackPostProcOne > {

    CvBlobTrackPostProcOne_wrapper( )
    : CvBlobTrackPostProcOne( )
      , bp::wrapper< CvBlobTrackPostProcOne >(){
        // null constructor
    
    }

    virtual ::CvBlob * Process( ::CvBlob * pBlob ){
        bp::override func_Process = this->get_override( "Process" );
        return func_Process( boost::python::ptr(pBlob) );
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

    virtual void LoadState( ::CvFileStorage * arg0, ::CvFileNode * arg1 ) {
        namespace bpl = boost::python;
        if( bpl::override func_LoadState = this->get_override( "LoadState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_LoadState.ptr(), arg0, arg1 );
        }
        else{
            CvVSModule::LoadState( boost::python::ptr(arg0), boost::python::ptr(arg1) );
        }
    }
    
    static void default_LoadState( ::CvVSModule & inst, ::cv::FileStorage & arg0, ::cv::FileNode & arg1 ){
        if( dynamic_cast< CvBlobTrackPostProcOne_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::LoadState(arg0.fs, *(arg1));
        }
        else{
            inst.LoadState(arg0.fs, *(arg1));
        }
    }

    virtual void ParamUpdate(  ) {
        if( bp::override func_ParamUpdate = this->get_override( "ParamUpdate" ) )
            func_ParamUpdate(  );
        else{
            this->CvVSModule::ParamUpdate(  );
        }
    }
    
    void default_ParamUpdate(  ) {
        CvVSModule::ParamUpdate( );
    }

    virtual void SaveState( ::CvFileStorage * arg0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_SaveState = this->get_override( "SaveState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_SaveState.ptr(), arg0 );
        }
        else{
            CvVSModule::SaveState( boost::python::ptr(arg0) );
        }
    }
    
    static void default_SaveState( ::CvVSModule & inst, ::cv::FileStorage & arg0 ){
        if( dynamic_cast< CvBlobTrackPostProcOne_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::SaveState(arg0.fs);
        }
        else{
            inst.SaveState(arg0.fs);
        }
    }

};

struct CvBlobTrackPredictor_wrapper : CvBlobTrackPredictor, bp::wrapper< CvBlobTrackPredictor > {

    CvBlobTrackPredictor_wrapper( )
    : CvBlobTrackPredictor( )
      , bp::wrapper< CvBlobTrackPredictor >(){
        // null constructor
    
    }

    virtual ::CvBlob * Predict(  ){
        bp::override func_Predict = this->get_override( "Predict" );
        return func_Predict(  );
    }

    virtual void Release(  ){
        bp::override func_Release = this->get_override( "Release" );
        func_Release(  );
    }

    virtual void Update( ::CvBlob * pBlob ){
        bp::override func_Update = this->get_override( "Update" );
        func_Update( boost::python::ptr(pBlob) );
    }

    virtual void LoadState( ::CvFileStorage * arg0, ::CvFileNode * arg1 ) {
        namespace bpl = boost::python;
        if( bpl::override func_LoadState = this->get_override( "LoadState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_LoadState.ptr(), arg0, arg1 );
        }
        else{
            CvVSModule::LoadState( boost::python::ptr(arg0), boost::python::ptr(arg1) );
        }
    }
    
    static void default_LoadState( ::CvVSModule & inst, ::cv::FileStorage & arg0, ::cv::FileNode & arg1 ){
        if( dynamic_cast< CvBlobTrackPredictor_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::LoadState(arg0.fs, *(arg1));
        }
        else{
            inst.LoadState(arg0.fs, *(arg1));
        }
    }

    virtual void ParamUpdate(  ) {
        if( bp::override func_ParamUpdate = this->get_override( "ParamUpdate" ) )
            func_ParamUpdate(  );
        else{
            this->CvVSModule::ParamUpdate(  );
        }
    }
    
    void default_ParamUpdate(  ) {
        CvVSModule::ParamUpdate( );
    }

    virtual void SaveState( ::CvFileStorage * arg0 ) {
        namespace bpl = boost::python;
        if( bpl::override func_SaveState = this->get_override( "SaveState" ) ){
            bpl::object py_result = bpl::call<bpl::object>( func_SaveState.ptr(), arg0 );
        }
        else{
            CvVSModule::SaveState( boost::python::ptr(arg0) );
        }
    }
    
    static void default_SaveState( ::CvVSModule & inst, ::cv::FileStorage & arg0 ){
        if( dynamic_cast< CvBlobTrackPredictor_wrapper * >( boost::addressof( inst ) ) ){
            inst.::CvVSModule::SaveState(arg0.fs);
        }
        else{
            inst.SaveState(arg0.fs);
        }
    }

};

struct CvBlobTrackSeq_wrapper : CvBlobTrackSeq, bp::wrapper< CvBlobTrackSeq > {

    CvBlobTrackSeq_wrapper(CvBlobTrackSeq const & arg )
    : CvBlobTrackSeq( arg )
      , bp::wrapper< CvBlobTrackSeq >(){
        // copy constructor
        
    }

    CvBlobTrackSeq_wrapper(int TrackSize=12u )
    : CvBlobTrackSeq( TrackSize )
      , bp::wrapper< CvBlobTrackSeq >(){
        // constructor
    
    }

    virtual void AddBlobTrack( int TrackID, int StartFrame=0 ) {
        if( bp::override func_AddBlobTrack = this->get_override( "AddBlobTrack" ) )
            func_AddBlobTrack( TrackID, StartFrame );
        else{
            this->CvBlobTrackSeq::AddBlobTrack( TrackID, StartFrame );
        }
    }
    
    void default_AddBlobTrack( int TrackID, int StartFrame=0 ) {
        CvBlobTrackSeq::AddBlobTrack( TrackID, StartFrame );
    }

    virtual void Clear(  ) {
        if( bp::override func_Clear = this->get_override( "Clear" ) )
            func_Clear(  );
        else{
            this->CvBlobTrackSeq::Clear(  );
        }
    }
    
    void default_Clear(  ) {
        CvBlobTrackSeq::Clear( );
    }

    virtual void DelBlobTrack( int TrackIndex ) {
        if( bp::override func_DelBlobTrack = this->get_override( "DelBlobTrack" ) )
            func_DelBlobTrack( TrackIndex );
        else{
            this->CvBlobTrackSeq::DelBlobTrack( TrackIndex );
        }
    }
    
    void default_DelBlobTrack( int TrackIndex ) {
        CvBlobTrackSeq::DelBlobTrack( TrackIndex );
    }

    virtual void DelBlobTrackByID( int TrackID ) {
        if( bp::override func_DelBlobTrackByID = this->get_override( "DelBlobTrackByID" ) )
            func_DelBlobTrackByID( TrackID );
        else{
            this->CvBlobTrackSeq::DelBlobTrackByID( TrackID );
        }
    }
    
    void default_DelBlobTrackByID( int TrackID ) {
        CvBlobTrackSeq::DelBlobTrackByID( TrackID );
    }

    virtual ::CvBlobTrack * GetBlobTrack( int TrackIndex ) {
        if( bp::override func_GetBlobTrack = this->get_override( "GetBlobTrack" ) )
            return func_GetBlobTrack( TrackIndex );
        else{
            return this->CvBlobTrackSeq::GetBlobTrack( TrackIndex );
        }
    }
    
    ::CvBlobTrack * default_GetBlobTrack( int TrackIndex ) {
        return CvBlobTrackSeq::GetBlobTrack( TrackIndex );
    }

    virtual ::CvBlobTrack * GetBlobTrackByID( int TrackID ) {
        if( bp::override func_GetBlobTrackByID = this->get_override( "GetBlobTrackByID" ) )
            return func_GetBlobTrackByID( TrackID );
        else{
            return this->CvBlobTrackSeq::GetBlobTrackByID( TrackID );
        }
    }
    
    ::CvBlobTrack * default_GetBlobTrackByID( int TrackID ) {
        return CvBlobTrackSeq::GetBlobTrackByID( TrackID );
    }

    virtual int GetBlobTrackNum(  ) {
        if( bp::override func_GetBlobTrackNum = this->get_override( "GetBlobTrackNum" ) )
            return func_GetBlobTrackNum(  );
        else{
            return this->CvBlobTrackSeq::GetBlobTrackNum(  );
        }
    }
    
    int default_GetBlobTrackNum(  ) {
        return CvBlobTrackSeq::GetBlobTrackNum( );
    }

};

void register_classes_2(){

    bp::class_< CvBlobTrack >( "CvBlobTrack" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrack >() )    
        .def_readwrite( "StartFrame", &CvBlobTrack::StartFrame )    
        .def_readwrite( "TrackID", &CvBlobTrack::TrackID )    
        .add_property( "pBlobSeq", bp::make_function(&::get_CvBlobTrack_pBlobSeq, bp::return_internal_reference<>()) );

    bp::class_< CvBlobTrackAnalysis_wrapper, bp::bases< CvVSModule >, boost::noncopyable >( "CvBlobTrackAnalysis", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackAnalysis >() )    
        .def( 
            "AddBlob"
            , bp::pure_virtual( (void ( CvBlobTrackAnalysis::* )( ::CvBlob * ) )(&::CvBlobTrackAnalysis::AddBlob) )
            , ( bp::arg("pBlob") ) )    
        .def( 
            "GetState"
            , bp::pure_virtual( (float ( CvBlobTrackAnalysis::* )( int ) )(&::CvBlobTrackAnalysis::GetState) )
            , ( bp::arg("BlobID") ) )    
        .def( 
            "GetStateDesc"
            , (char const * ( CvBlobTrackAnalysis::* )( int ) )(&::CvBlobTrackAnalysis::GetStateDesc)
            , (char const * ( CvBlobTrackAnalysis_wrapper::* )( int ) )(&CvBlobTrackAnalysis_wrapper::default_GetStateDesc)
            , ( bp::arg("arg0") ) )    
        .def( 
            "Process"
            , (void (*)( CvBlobTrackAnalysis &,::cv::Mat &,::cv::Mat & ))( &CvBlobTrackAnalysis_wrapper::default_Process )
            , ( bp::arg("inst"), bp::arg("pImg"), bp::arg("pFG") )
            , "\nArgument 'pImg':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat"\
    "\nArgument 'pFG':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat" )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackAnalysis::* )(  ) )(&::CvBlobTrackAnalysis::Release) ) )    
        .def( 
            "SetFileName"
            , (void ( CvBlobTrackAnalysis::* )( char * ) )(&::CvBlobTrackAnalysis::SetFileName)
            , (void ( CvBlobTrackAnalysis_wrapper::* )( char * ) )(&CvBlobTrackAnalysis_wrapper::default_SetFileName)
            , ( bp::arg("arg0") ) )    
        .def( 
            "LoadState"
            , (void (*)( CvVSModule &,::cv::FileStorage &,::cv::FileNode & ))( &CvBlobTrackAnalysis_wrapper::default_LoadState )
            , ( bp::arg("inst"), bp::arg("arg0"), bp::arg("arg1") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'arg1':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "ParamUpdate"
            , (void ( CvVSModule::* )(  ) )(&::CvVSModule::ParamUpdate)
            , (void ( CvBlobTrackAnalysis_wrapper::* )(  ) )(&CvBlobTrackAnalysis_wrapper::default_ParamUpdate) )    
        .def( 
            "SaveState"
            , (void (*)( CvVSModule &,::cv::FileStorage & ))( &CvBlobTrackAnalysis_wrapper::default_SaveState )
            , ( bp::arg("inst"), bp::arg("arg0") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" );

    bp::class_< CvBlobTrackAnalysisHeight_wrapper, bp::bases< CvBlobTrackAnalysis >, boost::noncopyable >( "CvBlobTrackAnalysisHeight" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackAnalysisHeight >() )    
        .def( 
            "GetHeight"
            , bp::pure_virtual( (double ( CvBlobTrackAnalysisHeight::* )( ::CvBlob * ) )(&::CvBlobTrackAnalysisHeight::GetHeight) )
            , ( bp::arg("pB") ) )    
        .def( 
            "AddBlob"
            , bp::pure_virtual( (void ( CvBlobTrackAnalysis::* )( ::CvBlob * ) )(&::CvBlobTrackAnalysis::AddBlob) )
            , ( bp::arg("pBlob") ) )    
        .def( 
            "GetState"
            , bp::pure_virtual( (float ( CvBlobTrackAnalysis::* )( int ) )(&::CvBlobTrackAnalysis::GetState) )
            , ( bp::arg("BlobID") ) )    
        .def( 
            "GetStateDesc"
            , (char const * ( CvBlobTrackAnalysis::* )( int ) )(&::CvBlobTrackAnalysis::GetStateDesc)
            , (char const * ( CvBlobTrackAnalysisHeight_wrapper::* )( int ) )(&CvBlobTrackAnalysisHeight_wrapper::default_GetStateDesc)
            , ( bp::arg("arg0") ) )    
        .def( 
            "LoadState"
            , (void (*)( CvVSModule &,::cv::FileStorage &,::cv::FileNode & ))( &CvBlobTrackAnalysisHeight_wrapper::default_LoadState )
            , ( bp::arg("inst"), bp::arg("arg0"), bp::arg("arg1") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'arg1':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "ParamUpdate"
            , (void ( CvVSModule::* )(  ) )(&::CvVSModule::ParamUpdate)
            , (void ( CvBlobTrackAnalysisHeight_wrapper::* )(  ) )(&CvBlobTrackAnalysisHeight_wrapper::default_ParamUpdate) )    
        .def( 
            "Process"
            , (void (*)( CvBlobTrackAnalysis &,::cv::Mat &,::cv::Mat & ))( &CvBlobTrackAnalysisHeight_wrapper::default_Process )
            , ( bp::arg("inst"), bp::arg("pImg"), bp::arg("pFG") )
            , "\nArgument 'pImg':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat"\
    "\nArgument 'pFG':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat" )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackAnalysis::* )(  ) )(&::CvBlobTrackAnalysis::Release) ) )    
        .def( 
            "SaveState"
            , (void (*)( CvVSModule &,::cv::FileStorage & ))( &CvBlobTrackAnalysisHeight_wrapper::default_SaveState )
            , ( bp::arg("inst"), bp::arg("arg0") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" )    
        .def( 
            "SetFileName"
            , (void ( CvBlobTrackAnalysis::* )( char * ) )(&::CvBlobTrackAnalysis::SetFileName)
            , (void ( CvBlobTrackAnalysisHeight_wrapper::* )( char * ) )(&CvBlobTrackAnalysisHeight_wrapper::default_SetFileName)
            , ( bp::arg("arg0") ) );

    bp::class_< CvBlobTrackAnalysisOne_wrapper, boost::noncopyable >( "CvBlobTrackAnalysisOne" )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackAnalysisOne >() )    
        .def( 
            "Process"
            , (boost::python::object (*)( CvBlobTrackAnalysisOne &,CvBlob *,::cv::Mat &,::cv::Mat & ))( &CvBlobTrackAnalysisOne_wrapper::default_Process )
            , ( bp::arg("inst"), bp::arg("pBlob"), bp::arg("pImg"), bp::arg("pFG") )
            , "\nArgument 'pImg':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat"\
    "\nArgument 'pFG':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat" )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackAnalysisOne::* )(  ) )(&::CvBlobTrackAnalysisOne::Release) ) );

    bp::class_< CvBlobTrackGen_wrapper, bp::bases< CvVSModule >, boost::noncopyable >( "CvBlobTrackGen", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackGen >() )    
        .def( 
            "AddBlob"
            , bp::pure_virtual( (void ( CvBlobTrackGen::* )( ::CvBlob * ) )(&::CvBlobTrackGen::AddBlob) )
            , ( bp::arg("pBlob") ) )    
        .def( 
            "Process"
            , (void (*)( CvBlobTrackGen &,::cv::Mat,::cv::Mat ))( &CvBlobTrackGen_wrapper::default_Process )
            , ( bp::arg("inst"), bp::arg("pImg")=cv::Mat(), bp::arg("pFG")=cv::Mat() )
            , "\nArgument 'pImg':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat"\
    "\nArgument 'pFG':"\
    "\n    C++ type: ::IplImage *"\
    "\n    Python type: Mat" )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackGen::* )(  ) )(&::CvBlobTrackGen::Release) ) )    
        .def( 
            "SetFileName"
            , bp::pure_virtual( (void ( CvBlobTrackGen::* )( char * ) )(&::CvBlobTrackGen::SetFileName) )
            , ( bp::arg("pFileName") ) )    
        .def( 
            "LoadState"
            , (void (*)( CvVSModule &,::cv::FileStorage &,::cv::FileNode & ))( &CvBlobTrackGen_wrapper::default_LoadState )
            , ( bp::arg("inst"), bp::arg("arg0"), bp::arg("arg1") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'arg1':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "ParamUpdate"
            , (void ( CvVSModule::* )(  ) )(&::CvVSModule::ParamUpdate)
            , (void ( CvBlobTrackGen_wrapper::* )(  ) )(&CvBlobTrackGen_wrapper::default_ParamUpdate) )    
        .def( 
            "SaveState"
            , (void (*)( CvVSModule &,::cv::FileStorage & ))( &CvBlobTrackGen_wrapper::default_SaveState )
            , ( bp::arg("inst"), bp::arg("arg0") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" );

    bp::class_< CvBlobTrackPostProc_wrapper, bp::bases< CvVSModule >, boost::noncopyable >( "CvBlobTrackPostProc", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackPostProc >() )    
        .def( 
            "AddBlob"
            , bp::pure_virtual( (void ( CvBlobTrackPostProc::* )( ::CvBlob * ) )(&::CvBlobTrackPostProc::AddBlob) )
            , ( bp::arg("pBlob") ) )    
        .def( 
            "GetBlob"
            , bp::pure_virtual( (::CvBlob * ( CvBlobTrackPostProc::* )( int ) )(&::CvBlobTrackPostProc::GetBlob) )
            , ( bp::arg("index") )
            , bp::return_internal_reference< >() )    
        .def( 
            "GetBlobByID"
            , (::CvBlob * ( CvBlobTrackPostProc::* )( int ) )(&::CvBlobTrackPostProc::GetBlobByID)
            , (::CvBlob * ( CvBlobTrackPostProc_wrapper::* )( int ) )(&CvBlobTrackPostProc_wrapper::default_GetBlobByID)
            , ( bp::arg("BlobID") )
            , bp::return_internal_reference< >() )    
        .def( 
            "GetBlobNum"
            , bp::pure_virtual( (int ( CvBlobTrackPostProc::* )(  ) )(&::CvBlobTrackPostProc::GetBlobNum) ) )    
        .def( 
            "Process"
            , bp::pure_virtual( (void ( CvBlobTrackPostProc::* )(  ) )(&::CvBlobTrackPostProc::Process) ) )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackPostProc::* )(  ) )(&::CvBlobTrackPostProc::Release) ) )    
        .def( 
            "LoadState"
            , (void (*)( CvVSModule &,::cv::FileStorage &,::cv::FileNode & ))( &CvBlobTrackPostProc_wrapper::default_LoadState )
            , ( bp::arg("inst"), bp::arg("arg0"), bp::arg("arg1") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'arg1':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "ParamUpdate"
            , (void ( CvVSModule::* )(  ) )(&::CvVSModule::ParamUpdate)
            , (void ( CvBlobTrackPostProc_wrapper::* )(  ) )(&CvBlobTrackPostProc_wrapper::default_ParamUpdate) )    
        .def( 
            "SaveState"
            , (void (*)( CvVSModule &,::cv::FileStorage & ))( &CvBlobTrackPostProc_wrapper::default_SaveState )
            , ( bp::arg("inst"), bp::arg("arg0") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" );

    bp::class_< CvBlobTrackPostProcOne_wrapper, bp::bases< CvVSModule >, boost::noncopyable >( "CvBlobTrackPostProcOne", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackPostProcOne >() )    
        .def( 
            "Process"
            , bp::pure_virtual( (::CvBlob * ( CvBlobTrackPostProcOne::* )( ::CvBlob * ) )(&::CvBlobTrackPostProcOne::Process) )
            , ( bp::arg("pBlob") )
            , bp::return_internal_reference< >() )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackPostProcOne::* )(  ) )(&::CvBlobTrackPostProcOne::Release) ) )    
        .def( 
            "LoadState"
            , (void (*)( CvVSModule &,::cv::FileStorage &,::cv::FileNode & ))( &CvBlobTrackPostProcOne_wrapper::default_LoadState )
            , ( bp::arg("inst"), bp::arg("arg0"), bp::arg("arg1") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'arg1':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "ParamUpdate"
            , (void ( CvVSModule::* )(  ) )(&::CvVSModule::ParamUpdate)
            , (void ( CvBlobTrackPostProcOne_wrapper::* )(  ) )(&CvBlobTrackPostProcOne_wrapper::default_ParamUpdate) )    
        .def( 
            "SaveState"
            , (void (*)( CvVSModule &,::cv::FileStorage & ))( &CvBlobTrackPostProcOne_wrapper::default_SaveState )
            , ( bp::arg("inst"), bp::arg("arg0") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" );

    bp::class_< CvBlobTrackPredictor_wrapper, bp::bases< CvVSModule >, boost::noncopyable >( "CvBlobTrackPredictor", bp::init< >() )    
        .add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackPredictor >() )    
        .def( 
            "Predict"
            , bp::pure_virtual( (::CvBlob * ( CvBlobTrackPredictor::* )(  ) )(&::CvBlobTrackPredictor::Predict) )
            , bp::return_internal_reference< >() )    
        .def( 
            "Release"
            , bp::pure_virtual( (void ( CvBlobTrackPredictor::* )(  ) )(&::CvBlobTrackPredictor::Release) ) )    
        .def( 
            "Update"
            , bp::pure_virtual( (void ( CvBlobTrackPredictor::* )( ::CvBlob * ) )(&::CvBlobTrackPredictor::Update) )
            , ( bp::arg("pBlob") ) )    
        .def( 
            "LoadState"
            , (void (*)( CvVSModule &,::cv::FileStorage &,::cv::FileNode & ))( &CvBlobTrackPredictor_wrapper::default_LoadState )
            , ( bp::arg("inst"), bp::arg("arg0"), bp::arg("arg1") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage"\
    "\nArgument 'arg1':"\
    "\n    C++ type: ::CvFileNode *"\
    "\n    Python type: FileNode" )    
        .def( 
            "ParamUpdate"
            , (void ( CvVSModule::* )(  ) )(&::CvVSModule::ParamUpdate)
            , (void ( CvBlobTrackPredictor_wrapper::* )(  ) )(&CvBlobTrackPredictor_wrapper::default_ParamUpdate) )    
        .def( 
            "SaveState"
            , (void (*)( CvVSModule &,::cv::FileStorage & ))( &CvBlobTrackPredictor_wrapper::default_SaveState )
            , ( bp::arg("inst"), bp::arg("arg0") )
            , "\nArgument 'arg0':"\
    "\n    C++ type: ::CvFileStorage *"\
    "\n    Python type: FileStorage" );

    { //::CvBlobTrackSeq
        typedef bp::class_< CvBlobTrackSeq_wrapper > CvBlobTrackSeq_exposer_t;
        CvBlobTrackSeq_exposer_t CvBlobTrackSeq_exposer = CvBlobTrackSeq_exposer_t( "CvBlobTrackSeq", bp::init< bp::optional< int > >(( bp::arg("TrackSize")=(int)(12u) )) );
        bp::scope CvBlobTrackSeq_scope( CvBlobTrackSeq_exposer );
        CvBlobTrackSeq_exposer.add_property( "this", pyplus_conv::make_addressof_inst_getter< CvBlobTrackSeq >() );
        bp::implicitly_convertible< int, CvBlobTrackSeq >();
        { //::CvBlobTrackSeq::AddBlobTrack
        
            typedef void ( ::CvBlobTrackSeq::*AddBlobTrack_function_type )( int,int ) ;
            typedef void ( CvBlobTrackSeq_wrapper::*default_AddBlobTrack_function_type )( int,int ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "AddBlobTrack"
                , AddBlobTrack_function_type(&::CvBlobTrackSeq::AddBlobTrack)
                , default_AddBlobTrack_function_type(&CvBlobTrackSeq_wrapper::default_AddBlobTrack)
                , ( bp::arg("TrackID"), bp::arg("StartFrame")=(int)(0) ) );
        
        }
        { //::CvBlobTrackSeq::Clear
        
            typedef void ( ::CvBlobTrackSeq::*Clear_function_type )(  ) ;
            typedef void ( CvBlobTrackSeq_wrapper::*default_Clear_function_type )(  ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "Clear"
                , Clear_function_type(&::CvBlobTrackSeq::Clear)
                , default_Clear_function_type(&CvBlobTrackSeq_wrapper::default_Clear) );
        
        }
        { //::CvBlobTrackSeq::DelBlobTrack
        
            typedef void ( ::CvBlobTrackSeq::*DelBlobTrack_function_type )( int ) ;
            typedef void ( CvBlobTrackSeq_wrapper::*default_DelBlobTrack_function_type )( int ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "DelBlobTrack"
                , DelBlobTrack_function_type(&::CvBlobTrackSeq::DelBlobTrack)
                , default_DelBlobTrack_function_type(&CvBlobTrackSeq_wrapper::default_DelBlobTrack)
                , ( bp::arg("TrackIndex") ) );
        
        }
        { //::CvBlobTrackSeq::DelBlobTrackByID
        
            typedef void ( ::CvBlobTrackSeq::*DelBlobTrackByID_function_type )( int ) ;
            typedef void ( CvBlobTrackSeq_wrapper::*default_DelBlobTrackByID_function_type )( int ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "DelBlobTrackByID"
                , DelBlobTrackByID_function_type(&::CvBlobTrackSeq::DelBlobTrackByID)
                , default_DelBlobTrackByID_function_type(&CvBlobTrackSeq_wrapper::default_DelBlobTrackByID)
                , ( bp::arg("TrackID") ) );
        
        }
        { //::CvBlobTrackSeq::GetBlobTrack
        
            typedef ::CvBlobTrack * ( ::CvBlobTrackSeq::*GetBlobTrack_function_type )( int ) ;
            typedef ::CvBlobTrack * ( CvBlobTrackSeq_wrapper::*default_GetBlobTrack_function_type )( int ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "GetBlobTrack"
                , GetBlobTrack_function_type(&::CvBlobTrackSeq::GetBlobTrack)
                , default_GetBlobTrack_function_type(&CvBlobTrackSeq_wrapper::default_GetBlobTrack)
                , ( bp::arg("TrackIndex") )
                , bp::return_internal_reference< >() );
        
        }
        { //::CvBlobTrackSeq::GetBlobTrackByID
        
            typedef ::CvBlobTrack * ( ::CvBlobTrackSeq::*GetBlobTrackByID_function_type )( int ) ;
            typedef ::CvBlobTrack * ( CvBlobTrackSeq_wrapper::*default_GetBlobTrackByID_function_type )( int ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "GetBlobTrackByID"
                , GetBlobTrackByID_function_type(&::CvBlobTrackSeq::GetBlobTrackByID)
                , default_GetBlobTrackByID_function_type(&CvBlobTrackSeq_wrapper::default_GetBlobTrackByID)
                , ( bp::arg("TrackID") )
                , bp::return_internal_reference< >() );
        
        }
        { //::CvBlobTrackSeq::GetBlobTrackNum
        
            typedef int ( ::CvBlobTrackSeq::*GetBlobTrackNum_function_type )(  ) ;
            typedef int ( CvBlobTrackSeq_wrapper::*default_GetBlobTrackNum_function_type )(  ) ;
            
            CvBlobTrackSeq_exposer.def( 
                "GetBlobTrackNum"
                , GetBlobTrackNum_function_type(&::CvBlobTrackSeq::GetBlobTrackNum)
                , default_GetBlobTrackNum_function_type(&CvBlobTrackSeq_wrapper::default_GetBlobTrackNum) );
        
        }
    }

}
