// This file has been generated by Py++.

#include "boost/python.hpp"
#include "cv_hpp_wrapper.hpp"
#include "cv_hpp_ext_free_functions.pypp.hpp"

namespace bp = boost::python;

void register_free_functions(){

    { //::cv::CamShift
    
        typedef ::cv::RotatedRect ( *CamShift_function_type )( ::cv::Mat const &,::cv::Rect &,::cv::TermCriteria );
        
        bp::def( 
            "CamShift"
            , CamShift_function_type( &::cv::CamShift )
            , ( bp::arg("probImage"), bp::arg("window"), bp::arg("criteria") ) );
    
    }

    { //::cv::Canny
    
        typedef void ( *Canny_function_type )( ::cv::Mat const &,::cv::Mat &,double,double,int,bool );
        
        bp::def( 
            "Canny"
            , Canny_function_type( &::cv::Canny )
            , ( bp::arg("image"), bp::arg("edges"), bp::arg("threshold1"), bp::arg("threshold2"), bp::arg("apertureSize")=(int)(3), bp::arg("L2gradient")=(bool)(false) ) );
    
    }

    { //::cv::GaussianBlur
    
        typedef void ( *GaussianBlur_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size,double,double,int );
        
        bp::def( 
            "GaussianBlur"
            , GaussianBlur_function_type( &::cv::GaussianBlur )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize"), bp::arg("sigma1"), bp::arg("sigma2")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::Laplacian
    
        typedef void ( *Laplacian_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,double,double,int );
        
        bp::def( 
            "Laplacian"
            , Laplacian_function_type( &::cv::Laplacian )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("ksize")=(int)(1), bp::arg("scale")=1, bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::RQDecomp3x3
    
        typedef ::cv::Vec3d ( *RQDecomp3x3_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "RQDecomp3x3"
            , RQDecomp3x3_function_type( &::cv::RQDecomp3x3 )
            , ( bp::arg("M"), bp::arg("R"), bp::arg("Q"), bp::arg("Qx"), bp::arg("Qy"), bp::arg("Qz") ) );
    
    }

    { //::cv::RQDecomp3x3
    
        typedef void ( *RQDecomp3x3_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "RQDecomp3x3"
            , RQDecomp3x3_function_type( &::cv::RQDecomp3x3 )
            , ( bp::arg("M"), bp::arg("R"), bp::arg("Q") ) );
    
    }

    { //::cv::Rodrigues
    
        typedef void ( *Rodrigues_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "Rodrigues"
            , Rodrigues_function_type( &::cv::Rodrigues )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("jacobian") ) );
    
    }

    { //::cv::Rodrigues
    
        typedef void ( *Rodrigues_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "Rodrigues"
            , Rodrigues_function_type( &::cv::Rodrigues )
            , ( bp::arg("src"), bp::arg("dst") ) );
    
    }

    { //::cv::Scharr
    
        typedef void ( *Scharr_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int,double,double,int );
        
        bp::def( 
            "Scharr"
            , Scharr_function_type( &::cv::Scharr )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("dx"), bp::arg("dy"), bp::arg("scale")=1, bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::Sobel
    
        typedef void ( *Sobel_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int,int,double,double,int );
        
        bp::def( 
            "Sobel"
            , Sobel_function_type( &::cv::Sobel )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("dx"), bp::arg("dy"), bp::arg("ksize")=(int)(3), bp::arg("scale")=1, bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::accumulate
    
        typedef void ( *accumulate_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "accumulate"
            , accumulate_function_type( &::cv::accumulate )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::accumulateProduct
    
        typedef void ( *accumulateProduct_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "accumulateProduct"
            , accumulateProduct_function_type( &::cv::accumulateProduct )
            , ( bp::arg("src1"), bp::arg("src2"), bp::arg("dst"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::accumulateSquare
    
        typedef void ( *accumulateSquare_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const & );
        
        bp::def( 
            "accumulateSquare"
            , accumulateSquare_function_type( &::cv::accumulateSquare )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::accumulateWeighted
    
        typedef void ( *accumulateWeighted_function_type )( ::cv::Mat const &,::cv::Mat &,double,::cv::Mat const & );
        
        bp::def( 
            "accumulateWeighted"
            , accumulateWeighted_function_type( &::cv::accumulateWeighted )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("alpha"), bp::arg("mask")=cv::Mat() ) );
    
    }

    { //::cv::adaptiveThreshold
    
        typedef void ( *adaptiveThreshold_function_type )( ::cv::Mat const &,::cv::Mat &,double,int,int,int,double );
        
        bp::def( 
            "adaptiveThreshold"
            , adaptiveThreshold_function_type( &::cv::adaptiveThreshold )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("maxValue"), bp::arg("adaptiveMethod"), bp::arg("thresholdType"), bp::arg("blockSize"), bp::arg("C") ) );
    
    }

    { //::cv::arcLength
    
        typedef double ( *arcLength_function_type )( ::cv::Mat const &,bool );
        
        bp::def( 
            "arcLength"
            , arcLength_function_type( &::cv::arcLength )
            , ( bp::arg("curve"), bp::arg("closed") ) );
    
    }

    { //::cv::bilateralFilter
    
        typedef void ( *bilateralFilter_function_type )( ::cv::Mat const &,::cv::Mat &,int,double,double,int );
        
        bp::def( 
            "bilateralFilter"
            , bilateralFilter_function_type( &::cv::bilateralFilter )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("d"), bp::arg("sigmaColor"), bp::arg("sigmaSpace"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::blur
    
        typedef void ( *blur_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size,::cv::Point,int );
        
        bp::def( 
            "blur"
            , blur_function_type( &::cv::blur )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::borderInterpolate
    
        typedef int ( *borderInterpolate_function_type )( int,int,int );
        
        bp::def( 
            "borderInterpolate"
            , borderInterpolate_function_type( &::cv::borderInterpolate )
            , ( bp::arg("p"), bp::arg("len"), bp::arg("borderType") ) );
    
    }

    { //::cv::boundingRect
    
        typedef ::cv::Rect ( *boundingRect_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "boundingRect"
            , boundingRect_function_type( &::cv::boundingRect )
            , ( bp::arg("points") ) );
    
    }

    { //::cv::boxFilter
    
        typedef void ( *boxFilter_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Size,::cv::Point,bool,int );
        
        bp::def( 
            "boxFilter"
            , boxFilter_function_type( &::cv::boxFilter )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("normalize")=(bool)(true), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::buildPyramid
    
        typedef void ( *buildPyramid_function_type )( ::cv::Mat const &,::std::vector< cv::Mat > &,int );
        
        bp::def( 
            "buildPyramid"
            , buildPyramid_function_type( &::cv::buildPyramid )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("maxlevel") ) );
    
    }

    { //::cv::calcGlobalOrientation
    
        typedef double ( *calcGlobalOrientation_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,double,double );
        
        bp::def( 
            "calcGlobalOrientation"
            , calcGlobalOrientation_function_type( &::cv::calcGlobalOrientation )
            , ( bp::arg("orientation"), bp::arg("mask"), bp::arg("mhi"), bp::arg("timestamp"), bp::arg("duration") ) );
    
    }

    { //::cv::calcMotionGradient
    
        typedef void ( *calcMotionGradient_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,double,double,int );
        
        bp::def( 
            "calcMotionGradient"
            , calcMotionGradient_function_type( &::cv::calcMotionGradient )
            , ( bp::arg("mhi"), bp::arg("mask"), bp::arg("orientation"), bp::arg("delta1"), bp::arg("delta2"), bp::arg("apertureSize")=(int)(3) ) );
    
    }

    { //::cv::calcOpticalFlowFarneback
    
        typedef void ( *calcOpticalFlowFarneback_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double,int,int,int,int,double,int );
        
        bp::def( 
            "calcOpticalFlowFarneback"
            , calcOpticalFlowFarneback_function_type( &::cv::calcOpticalFlowFarneback )
            , ( bp::arg("prev0"), bp::arg("next0"), bp::arg("flow0"), bp::arg("pyr_scale"), bp::arg("levels"), bp::arg("winsize"), bp::arg("iterations"), bp::arg("poly_n"), bp::arg("poly_sigma"), bp::arg("flags") ) );
    
    }

    { //::cv::calcOpticalFlowPyrLK
    
        typedef void ( *calcOpticalFlowPyrLK_function_type )( ::cv::Mat const &,::cv::Mat const &,::std::vector< cv::Point_<float> > const &,::std::vector< cv::Point_<float> > &,::std::vector< unsigned char > &,::std::vector< float > &,::cv::Size,int,::cv::TermCriteria,double,int );
        
        bp::def( 
            "calcOpticalFlowPyrLK"
            , calcOpticalFlowPyrLK_function_type( &::cv::calcOpticalFlowPyrLK )
            , ( bp::arg("prevImg"), bp::arg("nextImg"), bp::arg("prevPts"), bp::arg("nextPts"), bp::arg("status"), bp::arg("err"), bp::arg("winSize")=cv::Size_<int>(15, 15), bp::arg("maxLevel")=(int)(3), bp::arg("criteria")=cv::TermCriteria(3, 30, 1.0000000000000000208166817117216851329430937767e-2), bp::arg("derivLambda")=5.0e-1, bp::arg("flags")=(int)(0) ) );
    
    }

    { //::cv::calibrationMatrixValues
    
        typedef void ( *calibrationMatrixValues_function_type )( ::cv::Mat const &,::cv::Size,double,double,double &,double &,double &,::cv::Point2d &,double & );
        
        bp::def( 
            "calibrationMatrixValues"
            , calibrationMatrixValues_function_type( &::cv::calibrationMatrixValues )
            , ( bp::arg("cameraMatrix"), bp::arg("imageSize"), bp::arg("apertureWidth"), bp::arg("apertureHeight"), bp::arg("fovx"), bp::arg("fovy"), bp::arg("focalLength"), bp::arg("principalPoint"), bp::arg("aspectRatio") ) );
    
    }

    { //::cv::compareHist
    
        typedef double ( *compareHist_function_type )( ::cv::SparseMat const &,::cv::SparseMat const &,int );
        
        bp::def( 
            "compareHist"
            , compareHist_function_type( &::cv::compareHist )
            , ( bp::arg("H1"), bp::arg("H2"), bp::arg("method") ) );
    
    }

    { //::cv::compareHist
    
        typedef double ( *compareHist_function_type )( ::cv::MatND const &,::cv::MatND const &,int );
        
        bp::def( 
            "compareHist"
            , compareHist_function_type( &::cv::compareHist )
            , ( bp::arg("H1"), bp::arg("H2"), bp::arg("method") ) );
    
    }

    { //::cv::composeRT
    
        typedef void ( *composeRT_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "composeRT"
            , composeRT_function_type( &::cv::composeRT )
            , ( bp::arg("rvec1"), bp::arg("tvec1"), bp::arg("rvec2"), bp::arg("tvec2"), bp::arg("rvec3"), bp::arg("tvec3"), bp::arg("dr3dr1"), bp::arg("dr3dt1"), bp::arg("dr3dr2"), bp::arg("dr3dt2"), bp::arg("dt3dr1"), bp::arg("dt3dt1"), bp::arg("dt3dr2"), bp::arg("dt3dt2") ) );
    
    }

    { //::cv::composeRT
    
        typedef void ( *composeRT_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "composeRT"
            , composeRT_function_type( &::cv::composeRT )
            , ( bp::arg("rvec1"), bp::arg("tvec1"), bp::arg("rvec2"), bp::arg("tvec2"), bp::arg("rvec3"), bp::arg("tvec3") ) );
    
    }

    { //::cv::contourArea
    
        typedef double ( *contourArea_function_type )( ::cv::Mat const &,bool );
        
        bp::def( 
            "contourArea"
            , contourArea_function_type( &::cv::contourArea )
            , ( bp::arg("contour"), bp::arg("oriented")=(bool)(false) ) );
    
    }

    { //::cv::convertMaps
    
        typedef void ( *convertMaps_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,bool );
        
        bp::def( 
            "convertMaps"
            , convertMaps_function_type( &::cv::convertMaps )
            , ( bp::arg("map1"), bp::arg("map2"), bp::arg("dstmap1"), bp::arg("dstmap2"), bp::arg("dstmap1type"), bp::arg("nninterpolation")=(bool)(false) ) );
    
    }

    { //::cv::copyMakeBorder
    
        typedef void ( *copyMakeBorder_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int,int,int,::cv::Scalar const & );
        
        bp::def( 
            "copyMakeBorder"
            , copyMakeBorder_function_type( &::cv::copyMakeBorder )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("top"), bp::arg("bottom"), bp::arg("left"), bp::arg("right"), bp::arg("borderType"), bp::arg("value")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::cornerEigenValsAndVecs
    
        typedef void ( *cornerEigenValsAndVecs_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int );
        
        bp::def( 
            "cornerEigenValsAndVecs"
            , cornerEigenValsAndVecs_function_type( &::cv::cornerEigenValsAndVecs )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("blockSize"), bp::arg("ksize"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::cornerHarris
    
        typedef void ( *cornerHarris_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,double,int );
        
        bp::def( 
            "cornerHarris"
            , cornerHarris_function_type( &::cv::cornerHarris )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("blockSize"), bp::arg("ksize"), bp::arg("k"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::cornerMinEigenVal
    
        typedef void ( *cornerMinEigenVal_function_type )( ::cv::Mat const &,::cv::Mat &,int,int,int );
        
        bp::def( 
            "cornerMinEigenVal"
            , cornerMinEigenVal_function_type( &::cv::cornerMinEigenVal )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("blockSize"), bp::arg("ksize")=(int)(3), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::cornerSubPix
    
        typedef void ( *cornerSubPix_function_type )( ::cv::Mat const &,::std::vector< cv::Point_<float> > &,::cv::Size,::cv::Size,::cv::TermCriteria );
        
        bp::def( 
            "cornerSubPix"
            , cornerSubPix_function_type( &::cv::cornerSubPix )
            , ( bp::arg("image"), bp::arg("corners"), bp::arg("winSize"), bp::arg("zeroZone"), bp::arg("criteria") ) );
    
    }

    { //::cv::createBoxFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createBoxFilter_function_type )( int,int,::cv::Size,::cv::Point,bool,int );
        
        bp::def( 
            "createBoxFilter"
            , createBoxFilter_function_type( &::cv::createBoxFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("normalize")=(bool)(true), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::createDerivFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createDerivFilter_function_type )( int,int,int,int,int,int );
        
        bp::def( 
            "createDerivFilter"
            , createDerivFilter_function_type( &::cv::createDerivFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("dx"), bp::arg("dy"), bp::arg("ksize"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::createGaussianFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createGaussianFilter_function_type )( int,::cv::Size,double,double,int );
        
        bp::def( 
            "createGaussianFilter"
            , createGaussianFilter_function_type( &::cv::createGaussianFilter )
            , ( bp::arg("type"), bp::arg("ksize"), bp::arg("sigma1"), bp::arg("sigma2")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::createLinearFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createLinearFilter_function_type )( int,int,::cv::Mat const &,::cv::Point,double,int,int,::cv::Scalar const & );
        
        bp::def( 
            "createLinearFilter"
            , createLinearFilter_function_type( &::cv::createLinearFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("kernel"), bp::arg("_anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("_rowBorderType")=int(::cv::BORDER_REFLECT_101), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::createMorphologyFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createMorphologyFilter_function_type )( int,int,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "createMorphologyFilter"
            , createMorphologyFilter_function_type( &::cv::createMorphologyFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("_rowBorderType")=int(::cv::BORDER_CONSTANT), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::createSeparableLinearFilter
    
        typedef ::cv::Ptr< cv::FilterEngine > ( *createSeparableLinearFilter_function_type )( int,int,::cv::Mat const &,::cv::Mat const &,::cv::Point,double,int,int,::cv::Scalar const & );
        
        bp::def( 
            "createSeparableLinearFilter"
            , createSeparableLinearFilter_function_type( &::cv::createSeparableLinearFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("rowKernel"), bp::arg("columnKernel"), bp::arg("_anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("_rowBorderType")=int(::cv::BORDER_REFLECT_101), bp::arg("_columnBorderType")=(int)(-0x000000001), bp::arg("_borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::cvtColor
    
        typedef void ( *cvtColor_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "cvtColor"
            , cvtColor_function_type( &::cv::cvtColor )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("code"), bp::arg("dstCn")=(int)(0) ) );
    
    }

    { //::cv::decomposeProjectionMatrix
    
        typedef void ( *decomposeProjectionMatrix_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Vec3d & );
        
        bp::def( 
            "decomposeProjectionMatrix"
            , decomposeProjectionMatrix_function_type( &::cv::decomposeProjectionMatrix )
            , ( bp::arg("projMatrix"), bp::arg("cameraMatrix"), bp::arg("rotMatrix"), bp::arg("transVect"), bp::arg("rotMatrixX"), bp::arg("rotMatrixY"), bp::arg("rotMatrixZ"), bp::arg("eulerAngles") ) );
    
    }

    { //::cv::decomposeProjectionMatrix
    
        typedef void ( *decomposeProjectionMatrix_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "decomposeProjectionMatrix"
            , decomposeProjectionMatrix_function_type( &::cv::decomposeProjectionMatrix )
            , ( bp::arg("projMatrix"), bp::arg("cameraMatrix"), bp::arg("rotMatrix"), bp::arg("transVect") ) );
    
    }

    { //::cv::dilate
    
        typedef void ( *dilate_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "dilate"
            , dilate_function_type( &::cv::dilate )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("iterations")=(int)(1), bp::arg("borderType")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::distanceTransform
    
        typedef void ( *distanceTransform_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "distanceTransform"
            , distanceTransform_function_type( &::cv::distanceTransform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("distanceType"), bp::arg("maskSize") ) );
    
    }

    { //::cv::distanceTransform
    
        typedef void ( *distanceTransform_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "distanceTransform"
            , distanceTransform_function_type( &::cv::distanceTransform )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("labels"), bp::arg("distanceType"), bp::arg("maskSize") ) );
    
    }

    { //::cv::drawChessboardCorners
    
        typedef void ( *drawChessboardCorners_function_type )( ::cv::Mat &,::cv::Size,::cv::Mat const &,bool );
        
        bp::def( 
            "drawChessboardCorners"
            , drawChessboardCorners_function_type( &::cv::drawChessboardCorners )
            , ( bp::arg("image"), bp::arg("patternSize"), bp::arg("corners"), bp::arg("patternWasFound") ) );
    
    }

    { //::cv::drawContours
    
        typedef void ( *drawContours_function_type )( ::cv::Mat &,::std::vector< std::vector< cv::Point_<int> > > const &,int,::cv::Scalar const &,int,int,::std::vector< cv::Vec<int, 4> > const &,int,::cv::Point );
        
        bp::def( 
            "drawContours"
            , drawContours_function_type( &::cv::drawContours )
            , ( bp::arg("image"), bp::arg("contours"), bp::arg("contourIdx"), bp::arg("color"), bp::arg("thickness")=(int)(1), bp::arg("lineType")=(int)(8), bp::arg("hierarchy")=std::vector<cv::Vec4i>(), bp::arg("maxLevel")=(int)(2147483647), bp::arg("offset")=cv::Point_<int>() ) );
    
    }

    { //::cv::equalizeHist
    
        typedef void ( *equalizeHist_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "equalizeHist"
            , equalizeHist_function_type( &::cv::equalizeHist )
            , ( bp::arg("src"), bp::arg("dst") ) );
    
    }

    { //::cv::erode
    
        typedef void ( *erode_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "erode"
            , erode_function_type( &::cv::erode )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("iterations")=(int)(1), bp::arg("borderType")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::estimateAffine3D
    
        typedef int ( *estimateAffine3D_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::std::vector< unsigned char > &,double,double );
        
        bp::def( 
            "estimateAffine3D"
            , estimateAffine3D_function_type( &::cv::estimateAffine3D )
            , ( bp::arg("from"), bp::arg("to"), bp::arg("out"), bp::arg("outliers"), bp::arg("param1")=3.0e+0, bp::arg("param2")=9.89999999999999991118215802998747676610946655273e-1 ) );
    
    }

    { //::cv::filter2D
    
        typedef void ( *filter2D_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Mat const &,::cv::Point,double,int );
        
        bp::def( 
            "filter2D"
            , filter2D_function_type( &::cv::filter2D )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::filterSpeckles
    
        typedef void ( *filterSpeckles_function_type )( ::cv::Mat &,double,int,double,::cv::Mat & );
        
        bp::def( 
            "filterSpeckles"
            , filterSpeckles_function_type( &::cv::filterSpeckles )
            , ( bp::arg("img"), bp::arg("newVal"), bp::arg("maxSpeckleSize"), bp::arg("maxDiff"), bp::arg("buf") ) );
    
    }

    { //::cv::findFundamentalMat
    
        typedef ::cv::Mat ( *findFundamentalMat_function_type )( ::cv::Mat const &,::cv::Mat const &,int,double,double );
        
        bp::def( 
            "findFundamentalMat"
            , findFundamentalMat_function_type( &::cv::findFundamentalMat )
            , ( bp::arg("points1"), bp::arg("points2"), bp::arg("method")=int(::cv::FM_RANSAC), bp::arg("param1")=3.0e+0, bp::arg("param2")=9.89999999999999991118215802998747676610946655273e-1 ) );
    
    }

    { //::cv::findHomography
    
        typedef ::cv::Mat ( *findHomography_function_type )( ::cv::Mat const &,::cv::Mat const &,int,double );
        
        bp::def( 
            "findHomography"
            , findHomography_function_type( &::cv::findHomography )
            , ( bp::arg("srcPoints"), bp::arg("dstPoints"), bp::arg("method")=(int)(0), bp::arg("ransacReprojThreshold")=0 ) );
    
    }

    { //::cv::fitEllipse
    
        typedef ::cv::RotatedRect ( *fitEllipse_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "fitEllipse"
            , fitEllipse_function_type( &::cv::fitEllipse )
            , ( bp::arg("points") ) );
    
    }

    { //::cv::fitLine
    
        typedef void ( *fitLine_function_type )( ::cv::Mat const &,::cv::Vec6f &,int,double,double,double );
        
        bp::def( 
            "fitLine"
            , fitLine_function_type( &::cv::fitLine )
            , ( bp::arg("points"), bp::arg("line"), bp::arg("distType"), bp::arg("param"), bp::arg("reps"), bp::arg("aeps") ) );
    
    }

    { //::cv::fitLine
    
        typedef void ( *fitLine_function_type )( ::cv::Mat const &,::cv::Vec4f &,int,double,double,double );
        
        bp::def( 
            "fitLine"
            , fitLine_function_type( &::cv::fitLine )
            , ( bp::arg("points"), bp::arg("line"), bp::arg("distType"), bp::arg("param"), bp::arg("reps"), bp::arg("aeps") ) );
    
    }

    { //::cv::getColumnSumFilter
    
        typedef ::cv::Ptr< cv::BaseColumnFilter > ( *getColumnSumFilter_function_type )( int,int,int,int,double );
        
        bp::def( 
            "getColumnSumFilter"
            , getColumnSumFilter_function_type( &::cv::getColumnSumFilter )
            , ( bp::arg("sumType"), bp::arg("dstType"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001), bp::arg("scale")=1 ) );
    
    }

    { //::cv::getDefaultNewCameraMatrix
    
        typedef ::cv::Mat ( *getDefaultNewCameraMatrix_function_type )( ::cv::Mat const &,::cv::Size,bool );
        
        bp::def( 
            "getDefaultNewCameraMatrix"
            , getDefaultNewCameraMatrix_function_type( &::cv::getDefaultNewCameraMatrix )
            , ( bp::arg("cameraMatrix"), bp::arg("imgsize")=cv::Size_<int>(), bp::arg("centerPrincipalPoint")=(bool)(false) ) );
    
    }

    { //::cv::getDerivKernels
    
        typedef void ( *getDerivKernels_function_type )( ::cv::Mat &,::cv::Mat &,int,int,int,bool,int );
        
        bp::def( 
            "getDerivKernels"
            , getDerivKernels_function_type( &::cv::getDerivKernels )
            , ( bp::arg("kx"), bp::arg("ky"), bp::arg("dx"), bp::arg("dy"), bp::arg("ksize"), bp::arg("normalize")=(bool)(false), bp::arg("ktype")=(int)(5) ) );
    
    }

    { //::cv::getGaussianKernel
    
        typedef ::cv::Mat ( *getGaussianKernel_function_type )( int,double,int );
        
        bp::def( 
            "getGaussianKernel"
            , getGaussianKernel_function_type( &::cv::getGaussianKernel )
            , ( bp::arg("ksize"), bp::arg("sigma"), bp::arg("ktype")=(int)(6) ) );
    
    }

    { //::cv::getKernelType
    
        typedef int ( *getKernelType_function_type )( ::cv::Mat const &,::cv::Point );
        
        bp::def( 
            "getKernelType"
            , getKernelType_function_type( &::cv::getKernelType )
            , ( bp::arg("kernel"), bp::arg("anchor") ) );
    
    }

    { //::cv::getLinearColumnFilter
    
        typedef ::cv::Ptr< cv::BaseColumnFilter > ( *getLinearColumnFilter_function_type )( int,int,::cv::Mat const &,int,int,double,int );
        
        bp::def( 
            "getLinearColumnFilter"
            , getLinearColumnFilter_function_type( &::cv::getLinearColumnFilter )
            , ( bp::arg("bufType"), bp::arg("dstType"), bp::arg("kernel"), bp::arg("anchor"), bp::arg("symmetryType"), bp::arg("delta")=0, bp::arg("bits")=(int)(0) ) );
    
    }

    { //::cv::getLinearFilter
    
        typedef ::cv::Ptr< cv::BaseFilter > ( *getLinearFilter_function_type )( int,int,::cv::Mat const &,::cv::Point,double,int );
        
        bp::def( 
            "getLinearFilter"
            , getLinearFilter_function_type( &::cv::getLinearFilter )
            , ( bp::arg("srcType"), bp::arg("dstType"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("bits")=(int)(0) ) );
    
    }

    { //::cv::getLinearRowFilter
    
        typedef ::cv::Ptr< cv::BaseRowFilter > ( *getLinearRowFilter_function_type )( int,int,::cv::Mat const &,int,int );
        
        bp::def( 
            "getLinearRowFilter"
            , getLinearRowFilter_function_type( &::cv::getLinearRowFilter )
            , ( bp::arg("srcType"), bp::arg("bufType"), bp::arg("kernel"), bp::arg("anchor"), bp::arg("symmetryType") ) );
    
    }

    { //::cv::getMorphologyColumnFilter
    
        typedef ::cv::Ptr< cv::BaseColumnFilter > ( *getMorphologyColumnFilter_function_type )( int,int,int,int );
        
        bp::def( 
            "getMorphologyColumnFilter"
            , getMorphologyColumnFilter_function_type( &::cv::getMorphologyColumnFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getMorphologyFilter
    
        typedef ::cv::Ptr< cv::BaseFilter > ( *getMorphologyFilter_function_type )( int,int,::cv::Mat const &,::cv::Point );
        
        bp::def( 
            "getMorphologyFilter"
            , getMorphologyFilter_function_type( &::cv::getMorphologyFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001) ) );
    
    }

    { //::cv::getMorphologyRowFilter
    
        typedef ::cv::Ptr< cv::BaseRowFilter > ( *getMorphologyRowFilter_function_type )( int,int,int,int );
        
        bp::def( 
            "getMorphologyRowFilter"
            , getMorphologyRowFilter_function_type( &::cv::getMorphologyRowFilter )
            , ( bp::arg("op"), bp::arg("type"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getRectSubPix
    
        typedef void ( *getRectSubPix_function_type )( ::cv::Mat const &,::cv::Size,::cv::Point2f,::cv::Mat &,int );
        
        bp::def( 
            "getRectSubPix"
            , getRectSubPix_function_type( &::cv::getRectSubPix )
            , ( bp::arg("image"), bp::arg("patchSize"), bp::arg("center"), bp::arg("patch"), bp::arg("patchType")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getRotationMatrix2D
    
        typedef ::cv::Mat ( *getRotationMatrix2D_function_type )( ::cv::Point2f,double,double );
        
        bp::def( 
            "getRotationMatrix2D"
            , getRotationMatrix2D_function_type( &::cv::getRotationMatrix2D )
            , ( bp::arg("center"), bp::arg("angle"), bp::arg("scale") ) );
    
    }

    { //::cv::getRowSumFilter
    
        typedef ::cv::Ptr< cv::BaseRowFilter > ( *getRowSumFilter_function_type )( int,int,int,int );
        
        bp::def( 
            "getRowSumFilter"
            , getRowSumFilter_function_type( &::cv::getRowSumFilter )
            , ( bp::arg("srcType"), bp::arg("sumType"), bp::arg("ksize"), bp::arg("anchor")=(int)(-0x000000001) ) );
    
    }

    { //::cv::getStructuringElement
    
        typedef ::cv::Mat ( *getStructuringElement_function_type )( int,::cv::Size,::cv::Point );
        
        bp::def( 
            "getStructuringElement"
            , getStructuringElement_function_type( &::cv::getStructuringElement )
            , ( bp::arg("shape"), bp::arg("ksize"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001) ) );
    
    }

    { //::cv::getValidDisparityROI
    
        typedef ::cv::Rect ( *getValidDisparityROI_function_type )( ::cv::Rect,::cv::Rect,int,int,int );
        
        bp::def( 
            "getValidDisparityROI"
            , getValidDisparityROI_function_type( &::cv::getValidDisparityROI )
            , ( bp::arg("roi1"), bp::arg("roi2"), bp::arg("minDisparity"), bp::arg("numberOfDisparities"), bp::arg("SADWindowSize") ) );
    
    }

    { //::cv::grabCut
    
        typedef void ( *grabCut_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Rect,::cv::Mat &,::cv::Mat &,int,int );
        
        bp::def( 
            "grabCut"
            , grabCut_function_type( &::cv::grabCut )
            , ( bp::arg("img"), bp::arg("mask"), bp::arg("rect"), bp::arg("bgdModel"), bp::arg("fgdModel"), bp::arg("iterCount"), bp::arg("mode")=int(::cv::GC_EVAL) ) );
    
    }

    { //::cv::groupRectangles
    
        typedef void ( *groupRectangles_function_type )( ::std::vector< cv::Rect_<int> > &,::std::vector< int > &,int,double );
        
        bp::def( 
            "groupRectangles"
            , groupRectangles_function_type( &::cv::groupRectangles )
            , ( bp::arg("rectList"), bp::arg("weights"), bp::arg("groupThreshold"), bp::arg("eps")=2.00000000000000011102230246251565404236316680908e-1 ) );
    
    }

    { //::cv::groupRectangles
    
        typedef void ( *groupRectangles_function_type )( ::std::vector< cv::Rect_<int> > &,int,double );
        
        bp::def( 
            "groupRectangles"
            , groupRectangles_function_type( &::cv::groupRectangles )
            , ( bp::arg("rectList"), bp::arg("groupThreshold"), bp::arg("eps")=2.00000000000000011102230246251565404236316680908e-1 ) );
    
    }

    { //::cv::initCameraMatrix2D
    
        typedef ::cv::Mat ( *initCameraMatrix2D_function_type )( ::std::vector< std::vector< cv::Point3_<float> > > const &,::std::vector< std::vector< cv::Point_<float> > > const &,::cv::Size,double );
        
        bp::def( 
            "initCameraMatrix2D"
            , initCameraMatrix2D_function_type( &::cv::initCameraMatrix2D )
            , ( bp::arg("objectPoints"), bp::arg("imagePoints"), bp::arg("imageSize"), bp::arg("aspectRatio")=1.0e+0 ) );
    
    }

    { //::cv::initUndistortRectifyMap
    
        typedef void ( *initUndistortRectifyMap_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Size,int,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "initUndistortRectifyMap"
            , initUndistortRectifyMap_function_type( &::cv::initUndistortRectifyMap )
            , ( bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("R"), bp::arg("newCameraMatrix"), bp::arg("size"), bp::arg("m1type"), bp::arg("map1"), bp::arg("map2") ) );
    
    }

    { //::cv::inpaint
    
        typedef void ( *inpaint_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,double,int );
        
        bp::def( 
            "inpaint"
            , inpaint_function_type( &::cv::inpaint )
            , ( bp::arg("src"), bp::arg("inpaintMask"), bp::arg("dst"), bp::arg("inpaintRange"), bp::arg("flags") ) );
    
    }

    { //::cv::integral
    
        typedef void ( *integral_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,int );
        
        bp::def( 
            "integral"
            , integral_function_type( &::cv::integral )
            , ( bp::arg("src"), bp::arg("sum"), bp::arg("sqsum"), bp::arg("tilted"), bp::arg("sdepth")=(int)(-0x000000001) ) );
    
    }

    { //::cv::integral
    
        typedef void ( *integral_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat &,int );
        
        bp::def( 
            "integral"
            , integral_function_type( &::cv::integral )
            , ( bp::arg("src"), bp::arg("sum"), bp::arg("sqsum"), bp::arg("sdepth")=(int)(-0x000000001) ) );
    
    }

    { //::cv::integral
    
        typedef void ( *integral_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "integral"
            , integral_function_type( &::cv::integral )
            , ( bp::arg("src"), bp::arg("sum"), bp::arg("sdepth")=(int)(-0x000000001) ) );
    
    }

    { //::cv::invertAffineTransform
    
        typedef void ( *invertAffineTransform_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "invertAffineTransform"
            , invertAffineTransform_function_type( &::cv::invertAffineTransform )
            , ( bp::arg("M"), bp::arg("iM") ) );
    
    }

    { //::cv::isContourConvex
    
        typedef bool ( *isContourConvex_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "isContourConvex"
            , isContourConvex_function_type( &::cv::isContourConvex )
            , ( bp::arg("contour") ) );
    
    }

    { //::cv::matMulDeriv
    
        typedef void ( *matMulDeriv_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat & );
        
        bp::def( 
            "matMulDeriv"
            , matMulDeriv_function_type( &::cv::matMulDeriv )
            , ( bp::arg("A"), bp::arg("B"), bp::arg("dABdA"), bp::arg("dABdB") ) );
    
    }

    { //::cv::matchShapes
    
        typedef double ( *matchShapes_function_type )( ::cv::Mat const &,::cv::Mat const &,int,double );
        
        bp::def( 
            "matchShapes"
            , matchShapes_function_type( &::cv::matchShapes )
            , ( bp::arg("contour1"), bp::arg("contour2"), bp::arg("method"), bp::arg("parameter") ) );
    
    }

    { //::cv::matchTemplate
    
        typedef void ( *matchTemplate_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "matchTemplate"
            , matchTemplate_function_type( &::cv::matchTemplate )
            , ( bp::arg("image"), bp::arg("templ"), bp::arg("result"), bp::arg("method") ) );
    
    }

    { //::cv::meanShift
    
        typedef int ( *meanShift_function_type )( ::cv::Mat const &,::cv::Rect &,::cv::TermCriteria );
        
        bp::def( 
            "meanShift"
            , meanShift_function_type( &::cv::meanShift )
            , ( bp::arg("probImage"), bp::arg("window"), bp::arg("criteria") ) );
    
    }

    { //::cv::medianBlur
    
        typedef void ( *medianBlur_function_type )( ::cv::Mat const &,::cv::Mat &,int );
        
        bp::def( 
            "medianBlur"
            , medianBlur_function_type( &::cv::medianBlur )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize") ) );
    
    }

    { //::cv::minAreaRect
    
        typedef ::cv::RotatedRect ( *minAreaRect_function_type )( ::cv::Mat const & );
        
        bp::def( 
            "minAreaRect"
            , minAreaRect_function_type( &::cv::minAreaRect )
            , ( bp::arg("points") ) );
    
    }

    { //::cv::moments
    
        typedef ::cv::Moments ( *moments_function_type )( ::cv::Mat const &,bool );
        
        bp::def( 
            "moments"
            , moments_function_type( &::cv::moments )
            , ( bp::arg("array"), bp::arg("binaryImage")=(bool)(false) ) );
    
    }

    { //::cv::morphologyDefaultBorderValue
    
        typedef ::cv::Scalar ( *morphologyDefaultBorderValue_function_type )(  );
        
        bp::def( 
            "morphologyDefaultBorderValue"
            , morphologyDefaultBorderValue_function_type( &::cv::morphologyDefaultBorderValue ) );
    
    }

    { //::cv::morphologyEx
    
        typedef void ( *morphologyEx_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Mat const &,::cv::Point,int,int,::cv::Scalar const & );
        
        bp::def( 
            "morphologyEx"
            , morphologyEx_function_type( &::cv::morphologyEx )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("op"), bp::arg("kernel"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("iterations")=(int)(1), bp::arg("borderType")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::morphologyDefaultBorderValue( ) ) );
    
    }

    { //::cv::pointPolygonTest
    
        typedef double ( *pointPolygonTest_function_type )( ::cv::Mat const &,::cv::Point2f,bool );
        
        bp::def( 
            "pointPolygonTest"
            , pointPolygonTest_function_type( &::cv::pointPolygonTest )
            , ( bp::arg("contour"), bp::arg("pt"), bp::arg("measureDist") ) );
    
    }

    { //::cv::preCornerDetect
    
        typedef void ( *preCornerDetect_function_type )( ::cv::Mat const &,::cv::Mat &,int,int );
        
        bp::def( 
            "preCornerDetect"
            , preCornerDetect_function_type( &::cv::preCornerDetect )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ksize"), bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::pyrDown
    
        typedef void ( *pyrDown_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size const & );
        
        bp::def( 
            "pyrDown"
            , pyrDown_function_type( &::cv::pyrDown )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("dstsize")=cv::Size_<int>() ) );
    
    }

    { //::cv::pyrUp
    
        typedef void ( *pyrUp_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size const & );
        
        bp::def( 
            "pyrUp"
            , pyrUp_function_type( &::cv::pyrUp )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("dstsize")=cv::Size_<int>() ) );
    
    }

    { //::cv::remap
    
        typedef void ( *remap_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Mat const &,int,int,::cv::Scalar const & );
        
        bp::def( 
            "remap"
            , remap_function_type( &::cv::remap )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("map1"), bp::arg("map2"), bp::arg("interpolation"), bp::arg("borderMode")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::reprojectImageTo3D
    
        typedef void ( *reprojectImageTo3D_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,bool );
        
        bp::def( 
            "reprojectImageTo3D"
            , reprojectImageTo3D_function_type( &::cv::reprojectImageTo3D )
            , ( bp::arg("disparity"), bp::arg("_3dImage"), bp::arg("Q"), bp::arg("handleMissingValues")=(bool)(false) ) );
    
    }

    { //::cv::resize
    
        typedef void ( *resize_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Size,double,double,int );
        
        bp::def( 
            "resize"
            , resize_function_type( &::cv::resize )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("dsize"), bp::arg("fx")=0, bp::arg("fy")=0, bp::arg("interpolation")=int(::cv::INTER_LINEAR) ) );
    
    }

    { //::cv::sepFilter2D
    
        typedef void ( *sepFilter2D_function_type )( ::cv::Mat const &,::cv::Mat &,int,::cv::Mat const &,::cv::Mat const &,::cv::Point,double,int );
        
        bp::def( 
            "sepFilter2D"
            , sepFilter2D_function_type( &::cv::sepFilter2D )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("ddepth"), bp::arg("kernelX"), bp::arg("kernelY"), bp::arg("anchor")=cv::Point_<int>(-0x000000001, -0x000000001), bp::arg("delta")=0, bp::arg("borderType")=int(::cv::BORDER_REFLECT_101) ) );
    
    }

    { //::cv::solvePnP
    
        typedef void ( *solvePnP_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,bool );
        
        bp::def( 
            "solvePnP"
            , solvePnP_function_type( &::cv::solvePnP )
            , ( bp::arg("objectPoints"), bp::arg("imagePoints"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("rvec"), bp::arg("tvec"), bp::arg("useExtrinsicGuess")=(bool)(false) ) );
    
    }

    { //::cv::stereoCalibrate
    
        typedef double ( *stereoCalibrate_function_type )( ::std::vector< std::vector< cv::Point3_<float> > > const &,::std::vector< std::vector< cv::Point_<float> > > const &,::std::vector< std::vector< cv::Point_<float> > > const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Size,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::TermCriteria,int );
        
        bp::def( 
            "stereoCalibrate"
            , stereoCalibrate_function_type( &::cv::stereoCalibrate )
            , ( bp::arg("objectPoints"), bp::arg("imagePoints1"), bp::arg("imagePoints2"), bp::arg("cameraMatrix1"), bp::arg("distCoeffs1"), bp::arg("cameraMatrix2"), bp::arg("distCoeffs2"), bp::arg("imageSize"), bp::arg("R"), bp::arg("T"), bp::arg("E"), bp::arg("F"), bp::arg("criteria")=cv::TermCriteria(3, 30, 9.99999999999999954748111825886258685613938723691e-7), bp::arg("flags")=int(::cv::CALIB_FIX_INTRINSIC) ) );
    
    }

    { //::cv::stereoRectify
    
        typedef void ( *stereoRectify_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Size,::cv::Mat const &,::cv::Mat const &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,::cv::Mat &,int );
        
        bp::def( 
            "stereoRectify"
            , stereoRectify_function_type( &::cv::stereoRectify )
            , ( bp::arg("cameraMatrix1"), bp::arg("distCoeffs1"), bp::arg("cameraMatrix2"), bp::arg("distCoeffs2"), bp::arg("imageSize"), bp::arg("R"), bp::arg("T"), bp::arg("R1"), bp::arg("R2"), bp::arg("P1"), bp::arg("P2"), bp::arg("Q"), bp::arg("flags")=int(::cv::CALIB_ZERO_DISPARITY) ) );
    
    }

    { //::cv::stereoRectifyUncalibrated
    
        typedef bool ( *stereoRectifyUncalibrated_function_type )( ::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Size,::cv::Mat &,::cv::Mat &,double );
        
        bp::def( 
            "stereoRectifyUncalibrated"
            , stereoRectifyUncalibrated_function_type( &::cv::stereoRectifyUncalibrated )
            , ( bp::arg("points1"), bp::arg("points2"), bp::arg("F"), bp::arg("imgSize"), bp::arg("H1"), bp::arg("H2"), bp::arg("threshold")=5 ) );
    
    }

    { //::cv::threshold
    
        typedef double ( *threshold_function_type )( ::cv::Mat const &,::cv::Mat &,double,double,int );
        
        bp::def( 
            "threshold"
            , threshold_function_type( &::cv::threshold )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("thresh"), bp::arg("maxval"), bp::arg("type") ) );
    
    }

    { //::cv::undistort
    
        typedef void ( *undistort_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "undistort"
            , undistort_function_type( &::cv::undistort )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("newCameraMatrix")=cv::Mat() ) );
    
    }

    { //::cv::undistortPoints
    
        typedef void ( *undistortPoints_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const &,::cv::Mat const & );
        
        bp::def( 
            "undistortPoints"
            , undistortPoints_function_type( &::cv::undistortPoints )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("cameraMatrix"), bp::arg("distCoeffs"), bp::arg("R")=cv::Mat(), bp::arg("P")=cv::Mat() ) );
    
    }

    { //::cv::updateMotionHistory
    
        typedef void ( *updateMotionHistory_function_type )( ::cv::Mat const &,::cv::Mat &,double,double );
        
        bp::def( 
            "updateMotionHistory"
            , updateMotionHistory_function_type( &::cv::updateMotionHistory )
            , ( bp::arg("silhouette"), bp::arg("mhi"), bp::arg("timestamp"), bp::arg("duration") ) );
    
    }

    { //::cv::validateDisparity
    
        typedef void ( *validateDisparity_function_type )( ::cv::Mat &,::cv::Mat const &,int,int,int );
        
        bp::def( 
            "validateDisparity"
            , validateDisparity_function_type( &::cv::validateDisparity )
            , ( bp::arg("disparity"), bp::arg("cost"), bp::arg("minDisparity"), bp::arg("numberOfDisparities"), bp::arg("disp12MaxDisp")=(int)(1) ) );
    
    }

    { //::cv::warpAffine
    
        typedef void ( *warpAffine_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Size,int,int,::cv::Scalar const & );
        
        bp::def( 
            "warpAffine"
            , warpAffine_function_type( &::cv::warpAffine )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("M"), bp::arg("dsize"), bp::arg("flags")=int(::cv::INTER_LINEAR), bp::arg("borderMode")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::warpPerspective
    
        typedef void ( *warpPerspective_function_type )( ::cv::Mat const &,::cv::Mat &,::cv::Mat const &,::cv::Size,int,int,::cv::Scalar const & );
        
        bp::def( 
            "warpPerspective"
            , warpPerspective_function_type( &::cv::warpPerspective )
            , ( bp::arg("src"), bp::arg("dst"), bp::arg("M"), bp::arg("dsize"), bp::arg("flags")=int(::cv::INTER_LINEAR), bp::arg("borderMode")=int(::cv::BORDER_CONSTANT), bp::arg("borderValue")=cv::Scalar_<double>() ) );
    
    }

    { //::cv::watershed
    
        typedef void ( *watershed_function_type )( ::cv::Mat const &,::cv::Mat & );
        
        bp::def( 
            "watershed"
            , watershed_function_type( &::cv::watershed )
            , ( bp::arg("image"), bp::arg("markers") ) );
    
    }

    { //::cv::write
    
        typedef void ( *write_list_of_KeyPoint_function_type )( ::cv::FileStorage &,::std::string const &,::std::vector< cv::KeyPoint > const & );
        
        bp::def( 
            "write_list_of_KeyPoint"
            , write_list_of_KeyPoint_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("keypoints") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_SparseMat_function_type )( ::cv::FileStorage &,::std::string const &,::cv::SparseMat const & );
        
        bp::def( 
            "write_SparseMat"
            , write_SparseMat_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_MatND_function_type )( ::cv::FileStorage &,::std::string const &,::cv::MatND const & );
        
        bp::def( 
            "write_MatND"
            , write_MatND_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_Mat_function_type )( ::cv::FileStorage &,::std::string const &,::cv::Mat const & );
        
        bp::def( 
            "write_Mat"
            , write_Mat_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_Range_function_type )( ::cv::FileStorage &,::std::string const &,::cv::Range const & );
        
        bp::def( 
            "write_Range"
            , write_Range_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("r") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_Range_function_type )( ::cv::FileStorage &,::cv::Range const & );
        
        bp::def( 
            "write_Range"
            , write_Range_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("r") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_int_function_type )( ::cv::FileStorage &,int const & );
        
        bp::def( 
            "write_int"
            , write_int_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_str_function_type )( ::cv::FileStorage &,::std::string const & );
        
        bp::def( 
            "write_str"
            , write_str_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_float64_function_type )( ::cv::FileStorage &,double const & );
        
        bp::def( 
            "write_float64"
            , write_float64_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_float32_function_type )( ::cv::FileStorage &,float const & );
        
        bp::def( 
            "write_float32"
            , write_float32_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_str_function_type )( ::cv::FileStorage &,::std::string const &,::std::string const & );
        
        bp::def( 
            "write_str"
            , write_str_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_float64_function_type )( ::cv::FileStorage &,::std::string const &,double );
        
        bp::def( 
            "write_float64"
            , write_float64_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_float32_function_type )( ::cv::FileStorage &,::std::string const &,float );
        
        bp::def( 
            "write_float32"
            , write_float32_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

    { //::cv::write
    
        typedef void ( *write_int_function_type )( ::cv::FileStorage &,::std::string const &,int );
        
        bp::def( 
            "write_int"
            , write_int_function_type( &::cv::write )
            , ( bp::arg("fs"), bp::arg("name"), bp::arg("value") )
            , "\nWrapped function:"
    "\n    write" );
    
    }

}
