"""
Contants for HTTP status codes. Merely to increase code readability.

This was originally implemented using ``int`` values. We then switched to using
the IntEnums in :mod:`http`, which uses names without ``HTTP_[0-9]{3}_``
prefixes. This module will preserve the mapping to the built-in IntEnums for
projects that haven't switched yet.
"""

from http import HTTPStatus
import warnings

warnings.warn("These constants are deprecated. Use the built-in"
              " http.HTTPStatus instead.", DeprecationWarning)

HTTP_100_CONTINUE = HTTPStatus.CONTINUE
HTTP_101_SWITCHING_PROTOCOLS = HTTPStatus.SWITCHING_PROTOCOLS
HTTP_200_OK = HTTPStatus.OK
HTTP_201_CREATED = HTTPStatus.CREATED
HTTP_202_ACCEPTED = HTTPStatus.ACCEPTED
HTTP_203_NON_AUTHORITATIVE_INFORMATION = \
    HTTPStatus.NON_AUTHORITATIVE_INFORMATION
HTTP_204_NO_CONTENT = HTTPStatus.NO_CONTENT
HTTP_205_RESET_CONTENT = HTTPStatus.RESET_CONTENT
HTTP_206_PARTIAL_CONTENT = HTTPStatus.PARTIAL_CONTENT
HTTP_300_MULTIPLE_CHOICES = HTTPStatus.MULTIPLE_CHOICES
HTTP_301_MOVED_PERMANENTLY = HTTPStatus.MOVED_PERMANENTLY
HTTP_302_FOUND = HTTPStatus.FOUND
HTTP_303_SEE_OTHER = HTTPStatus.SEE_OTHER
HTTP_304_NOT_MODIFIED = HTTPStatus.NOT_MODIFIED
HTTP_305_USE_PROXY = HTTPStatus.USE_PROXY
HTTP_306_RESERVED = 306
HTTP_307_TEMPORARY_REDIRECT = HTTPStatus.TEMPORARY_REDIRECT
HTTP_400_BAD_REQUEST = HTTPStatus.BAD_REQUEST
HTTP_401_UNAUTHORIZED = HTTPStatus.UNAUTHORIZED
HTTP_402_PAYMENT_REQUIRED = HTTPStatus.PAYMENT_REQUIRED
HTTP_403_FORBIDDEN = HTTPStatus.FORBIDDEN
HTTP_404_NOT_FOUND = HTTPStatus.NOT_FOUND
HTTP_405_METHOD_NOT_ALLOWED = HTTPStatus.METHOD_NOT_ALLOWED
HTTP_406_NOT_ACCEPTABLE = HTTPStatus.NOT_ACCEPTABLE
HTTP_407_PROXY_AUTHENTICATION_REQUIRED = \
    HTTPStatus.PROXY_AUTHENTICATION_REQUIRED
HTTP_408_REQUEST_TIMEOUT = HTTPStatus.REQUEST_TIMEOUT
HTTP_409_CONFLICT = HTTPStatus.CONFLICT
HTTP_410_GONE = HTTPStatus.GONE
HTTP_411_LENGTH_REQUIRED = HTTPStatus.LENGTH_REQUIRED
HTTP_412_PRECONDITION_FAILED = HTTPStatus.PRECONDITION_FAILED
HTTP_413_REQUEST_ENTITY_TOO_LARGE = HTTPStatus.REQUEST_ENTITY_TOO_LARGE
HTTP_414_REQUEST_URI_TOO_LONG = HTTPStatus.REQUEST_URI_TOO_LONG
HTTP_415_UNSUPPORTED_MEDIA_TYPE = HTTPStatus.UNSUPPORTED_MEDIA_TYPE
HTTP_416_REQUESTED_RANGE_NOT_SATISFIABLE = \
    HTTPStatus.REQUESTED_RANGE_NOT_SATISFIABLE
HTTP_417_EXPECTATION_FAILED = HTTPStatus.EXPECTATION_FAILED
HTTP_428_PRECONDITION_REQUIRED = HTTPStatus.PRECONDITION_REQUIRED
HTTP_429_TOO_MANY_REQUESTS = HTTPStatus.TOO_MANY_REQUESTS
HTTP_431_REQUEST_HEADER_FIELDS_TOO_LARGE = \
    HTTPStatus.REQUEST_HEADER_FIELDS_TOO_LARGE
HTTP_500_INTERNAL_SERVER_ERROR = HTTPStatus.INTERNAL_SERVER_ERROR
HTTP_501_NOT_IMPLEMENTED = HTTPStatus.NOT_IMPLEMENTED
HTTP_502_BAD_GATEWAY = HTTPStatus.BAD_GATEWAY
HTTP_503_SERVICE_UNAVAILABLE = HTTPStatus.SERVICE_UNAVAILABLE
HTTP_504_GATEWAY_TIMEOUT = HTTPStatus.GATEWAY_TIMEOUT
HTTP_505_HTTP_VERSION_NOT_SUPPORTED = HTTPStatus.HTTP_VERSION_NOT_SUPPORTED
HTTP_511_NETWORK_AUTHENTICATION_REQUIRED = \
    HTTPStatus.NETWORK_AUTHENTICATION_REQUIRED
