"""
String Constants used in Hops-Util: Environment variables, Kafka Config, SSL Config etc.
"""


class HTTP_CONFIG:
    """
    HTTP String constants
    """
    HTTP_CONTENT_TYPE = "Content-type"
    HTTP_APPLICATION_JSON = "application/json"
    HTTP_AUTHORIZATION = "Authorization"
    HTTP_POST = "POST"
    HTTP_PUT = "PUT"
    HTTP_GET = "GET"
    HTTP_DELETE = "DELETE"
    HTTP_UNAUTHORIZED = 401


class ENV_VARIABLES:
    """
    Environment variable names (accessible in os.environ)
    """
    LIVY_VERSION_ENV_VAR = "LIVY_VERSION"
    REST_ENDPOINT_END_VAR = "REST_ENDPOINT"
    HOPSWORKS_PROJECT_ID_ENV_VAR = "HOPSWORKS_PROJECT_ID"
    HOPSWORKS_PROJECT_NAME_ENV_VAR = "HOPSWORKS_PROJECT_NAME"
    REGION_NAME_ENV_VAR = "REGION_NAME"
    API_KEY_ENV_VAR = "API_KEY"
    CERT_KEY_ENV_VAR = "CERT_KEY"
    CERT_FOLDER_ENV_VAR = "CERT_FOLDER"


class FEATURE_STORE:
    """
     Featurestore constants
    """
    TRAINING_DATASET_CSV_FORMAT = "csv"
    TRAINING_DATASET_TSV_FORMAT = "tsv"
    TRAINING_DATASET_PARQUET_FORMAT = "parquet"
    TRAINING_DATASET_TFRECORDS_FORMAT = "tfrecords"
    TRAINING_DATASET_AVRO_FORMAT = "avro"
    TRAINING_DATASET_ORC_FORMAT = "orc"
    TRAINING_DATASET_NPY_FORMAT = "npy"
    TRAINING_DATASET_IMAGE_FORMAT = "image"
    TRAINING_DATASET_HDF5_FORMAT = "hdf5"
    TRAINING_DATASET_PETASTORM_FORMAT = "petastorm"
    TRAINING_DATASET_NPY_SUFFIX = ".npy"
    TRAINING_DATASET_HDF5_SUFFIX = ".hdf5"
    TRAINING_DATASET_CSV_SUFFIX = ".csv"
    TRAINING_DATASET_TSV_SUFFIX = ".tsv"
    TRAINING_DATASET_PARQUET_SUFFIX = ".parquet"
    TRAINING_DATASET_AVRO_SUFFIX = ".avro"
    TRAINING_DATASET_ORC_SUFFIX = ".orc"
    TRAINING_DATASET_IMAGE_SUFFIX = ".image"
    TRAINING_DATASET_TFRECORDS_SUFFIX = ".tfrecords"
    TRAINING_DATASET_PETASTORM_SUFFIX = ".petastorm"
    TRAINING_DATASET_SUPPORTED_FORMATS = [
        TRAINING_DATASET_TSV_FORMAT,
        TRAINING_DATASET_CSV_FORMAT,
        TRAINING_DATASET_PARQUET_FORMAT,
        TRAINING_DATASET_TFRECORDS_FORMAT,
        TRAINING_DATASET_NPY_FORMAT,
        TRAINING_DATASET_HDF5_FORMAT,
        TRAINING_DATASET_AVRO_FORMAT,
        TRAINING_DATASET_ORC_FORMAT,
        TRAINING_DATASET_IMAGE_FORMAT,
        TRAINING_DATASET_PETASTORM_FORMAT
    ]
    CLUSTERING_ANALYSIS_CLUSTERS_OUTPUT_COLUMN = "clusters"
    DESCRIPTIVE_STATS_METRIC_NAME_COL = "metricName"
    DESCRIPTIVE_STATS_VALUE_COL = "value"
    FEATURESTORE_SUFFIX = "_featurestore"


class REST_CONFIG:
    """
    REST endpoints and JSON properties used for communicating with Hopsworks REST API
    """
    JSON_FEATURESTORE_ENABLE_ONLINE_QUERY_PARAM = "enableOnline"
    JSON_FEATURESTORE_DISABLE_ONLINE_QUERY_PARAM = "disableOnline"
    JSON_FEATURESTORE_SETTINGS_CACHED_FEATUREGROUP_DTO_TYPE = "cachedFeaturegroupDtoType"
    JSON_FEATURESTORE_SETTINGS_CACHED_FEATUREGROUP_TYPE = "cachedFeaturegroupType"
    JSON_FEATURESTORE_SETTINGS_EXTERNAL_TRAINING_DATASET_TYPE = "externalTrainingDatasetType"
    JSON_FEATURESTORE_SETTINGS_FEATUREGROUP_TYPE = "featuregroupType"
    JSON_FEATURESTORE_SETTINGS_FEATURESTORE_REGEX = "featurestoreRegex"
    JSON_FEATURESTORE_SETTINGS_ENTITY_NAME_MAX_LENGTH = "featurestoreEntityNameMaxLength"
    JSON_FEATURESTORE_SETTINGS_ENTITY_DESCRIPTION_MAX_LENGTH = "featurestoreEntityDescriptionMaxLength"
    JSON_FEATURESTORE_SETTINGS_MAX_CORRELATIONS = "featurestoreStatisticsMaxCorrelations"
    JSON_FEATURESTORE_SETTINGS_HOPSFS_CONNECTOR_DTO_TYPE = "hopsfsConnectorDtoType"
    JSON_FEATURESTORE_SETTINGS_HOPSFS_CONNECTOR_TYPE = "hopsfsConnectorType"
    JSON_FEATURESTORE_SETTINGS_HOPSFS_TRAINING_DATASET_TYPE = "hopsfsTrainingDatasetType"
    JSON_FEATURESTORE_SETTINGS_JDBC_CONNECTOR_DTO_TYPE = "jdbcConnectorDtoType"
    JSON_FEATURESTORE_SETTINGS_JDBC_CONNECTOR_TYPE = "jdbcConnectorType"
    JSON_FEATURESTORE_SETTINGS_JDBC_CONNECTOR_ARGUMENTS_MAX_LEN = "jdbcStorageConnectorArgumentsMaxLength"
    JSON_FEATURESTORE_SETTINGS_JDBC_CONNECTOR_CONNECTION_STRING_MAX_LEN = \
        "jdbcStorageConnectorConnectionstringMaxLength"
    JSON_FEATURESTORE_SETTINGS_ON_DEMAND_FEATUREGROUP_DTO_TYPE = "onDemandFeaturegroupDtoType"
    JSON_FEATURESTORE_SETTINGS_ON_DEMAND_FEATUREGROUP_SQL_QUERY_MAX_LEN = "onDemandFeaturegroupSqlQueryMaxLength"
    JSON_FEATURESTORE_SETTINGS_ON_DEMAND_FEATUREGROUP_TYPE = "onDemandFeaturegroupType"
    JSON_FEATURESTORE_SETTINGS_S3_CONNECTOR_DTO_TYPE = "s3ConnectorDtoType"
    JSON_FEATURESTORE_SETTINGS_S3_CONNECTOR_TYPE = "s3ConnectorType"
    JSON_FEATURESTORE_SETTINGS_S3_CONNECTOR_ACCESS_KEY_MAX_LEN = "s3StorageConnectorAccesskeyMaxLength"
    JSON_FEATURESTORE_SETTINGS_S3_CONNECTOR_BUCKET_MAX_LEN = "s3StorageConnectorBucketMaxLength"
    JSON_FEATURESTORE_SETTINGS_S3_CONNECTOR_SECRET_KEY_MAX_LEN = "s3StorageConnectorSecretkeyMaxLength"
    JSON_FEATURESTORE_SETTINGS_STORAGE_CONNECTOR_DESCRIPTION_MAX_LEN = "storageConnectorDescriptionMaxLength"
    JSON_FEATURESTORE_SETTINGS_STORAGE_CONNECTOR_NAME_MAX_LEN = "storageConnectorDescriptionMaxLength"
    JSON_FEATURESTORE_SETTINGS_HIVE_SUGGESTED_FEATURE_TYPES = "suggestedHiveFeatureTypes"
    JSON_FEATURESTORE_SETTINGS_MYSQL_SUGGESTED_FEATURE_TYPES = "suggestedMysqlFeatureTypes"
    JSON_FEATURESTORE_SETTINGS_TRAINING_DATASET_DATA_FORMATS = "trainingDatasetDataFormats"
    JSON_FEATURESTORE_SETTINGS_TRAINING_DATASET_TYPE = "trainingDatasetType"
    JSON_FEATURESTORE_SETTINGS = "settings"
    JSON_FEATURESTORE_STORAGE_CONNECTORS = "storageConnectors"
    JSON_FEATURESTORE_SETTINGS_IMPORT_CONNECTORS = "featureImportConnectors"
    JSON_FEATURESTORE_SETTINGS_ONLINE_ENABLED = "onlineFeaturestoreEnabled"

    JSON_FEATUREGROUP_ON_DEMAND_TYPE = "ON_DEMAND_FEATURE_GROUP"
    JSON_FEATUREGROUP_CACHED_TYPE = "CACHED_FEATURE_GROUP"
    JSON_FEATUREGROUP_HIVE_TABLE_TYPE = "hiveTableType"
    JSON_FEATUREGROUP_INPUT_FORMAT = "inputFormat"
    JSON_FEATUREGROUP_HDFS_STORE_PATHS = "hdfsStorePaths"
    JSON_FEATUREGROUP_HIVE_TBL_ID = "hiveTableId"
    JSON_FEATUREGROUP_ON_DEMAND_QUERY = "query"
    JSON_FEATUREGROUP_JDBC_CONNECTOR_NAME = "jdbcConnectorName"
    JSON_FEATUREGROUP_JDBC_CONNECTOR_ID = "jdbcConnectorId"
    JSON_FEATUREGROUP_TYPE = "type"
    JSON_FEATUREGROUP_NAME = "name"
    JSON_FEATUREGROUP_ID = "id"
    JSON_FEATUREGROUP_VERSION = "version"
    JSON_FEATUREGROUP_FEATURES = "features"
    JSON_FEATUREGROUP_DESCRIPTION = "description"
    JSON_FEATUREGROUP_CREATED = "created"
    JSON_FEATUREGROUP_CREATOR = "creator"
    JSON_FEATUREGROUP_FEATURE_CORRELATION = "featureCorrelationMatrix"
    JSON_FEATUREGROUP_DESC_STATS = "descriptiveStatistics"
    JSON_FEATUREGROUP_FEATURES_HISTOGRAM = "featuresHistogram"
    JSON_FEATUREGROUP_FEATURES_CLUSTERS = "clusterAnalysis"
    JSON_FEATUREGROUPS = "featuregroups"
    JSON_FEATUREGROUP_ONLINE = "onlineEnabled"
    JSON_FEATUREGROUP_HUDI = "hudiEnabled"

    JSON_ONLINE_FEATUREGROUP_ID = "id"
    JSON_ONLINE_FEATUREGROUP_DB = "dbName"
    JSON_ONLINE_FEATUREGROUP_TABLE = "tableName"
    JSON_ONLINE_FEATUREGROUP_TABLE_TYPE = "tableType"
    JSON_ONLINE_FEATUREGROUP_TABLE_ROWS = "tableRows"
    JSON_ONLINE_FEATUREGROUP_SIZE = "size"

    JSON_FEATURESTORE = "featurestore"
    JSON_FEATURESTORE_ID = "featurestoreId"
    JSON_FEATURESTORE_NAME = "featurestoreName"
    JSON_FEATURESTORE_PROJECT_ID = "projectId"
    JSON_FEATURESTORE_PROJECT_NAME = "projectName"
    JSON_FEATURESTORE_INODE_ID = "inodeId"
    JSON_FEATURESTORE_DESCRIPTION = "featurestoreDescription"
    JSON_FEATURESTORE_HDFS_PATH = "hdfsStorePath"
    JSON_FEATURESTORE_ONLINE_CONNECTOR = "onlineFeaturestoreConnector"
    JSON_FEATURESTORE_ONLINE_ENABLED = "onlineEnabled"
    JSON_FEATURESTORE_ONLINE_FEATURESTORE_TYPE = "onlineFeaturestoreType"
    JSON_FEATURESTORE_OFFLINE_FEATURESTORE_TYPE = "offlineFeaturestoreType"
    JSON_FEATURESTORE_ONLINE_FEATURESTORE_NAME = "onlineFeaturestoreName"
    JSON_FEATURESTORE_OFFLINE_FEATURESTORE_NAME = "offlineFeaturestoreName"

    JSON_FEATURE_NAME = "name"
    JSON_FEATURE_TYPE = "type"
    JSON_FEATURE_DESCRIPTION = "description"
    JSON_FEATURE_PRIMARY = "primary"
    JSON_FEATURE_PARTITION = "partition"
    JSON_FEATURE_ONLINE_TYPE = "onlineType"

    JSON_TRAINING_DATASET_EXTERNAL_TYPE = "EXTERNAL_TRAINING_DATASET"
    JSON_TRAINING_DATASET_HOPSFS_TYPE = "HOPSFS_TRAINING_DATASET"
    JSON_TRAINING_DATASET_TYPE = "trainingDatasetType"
    JSON_TRAINING_DATASET_HOPSFS_CONNECTOR_NAME = "hopsfsConnectorName"
    JSON_TRAINING_DATASET_HOPSFS_CONNECTOR_ID = "hopsfsConnectorId"
    JSON_TRAINING_DATASET_SIZE = "size"
    JSON_TRAINING_DATASET_S3_CONNECTOR_NAME = "s3ConnectorName"
    JSON_TRAINING_DATASET_S3_CONNECTOR_ID = "s3ConnectorId"
    JSON_TRAINING_DATASET_ID = "id"
    JSON_TRAINING_DATASET_NAME = "name"
    JSON_TRAINING_DATASETS = "trainingDatasets"
    JSON_TRAINING_DATASET_HDFS_STORE_PATH = "hdfsStorePath"
    JSON_TRAINING_DATASET_FORMAT = "dataFormat"
    JSON_TRAINING_DATASET_VERSION = "version"
    JSON_TRAINING_DATASET_CREATOR = "creator"
    JSON_TRAINING_DATASET_CREATED = "created"
    JSON_TRAINING_DATASET_DESCRIPTION = "description"
    JSON_TRAINING_DATASET_INODE_ID = "inodeId"
    JSON_TRAINING_DATASET_FEATURES = "features"
    JSON_TRAINING_DATASET_LOCATION = "location"

    JSON_FEATURESTORE_HOPSFS_CONNECTOR_HOPSFS_PATH = "hopsfsPath"
    JSON_FEATURESTORE_HOPSFS_CONNECTOR_DATASET_NAME = "datasetName"

    JSON_FEATURESTORE_JDBC_CONNECTOR_CONNECTION_STRING = "connectionString"
    JSON_FEATURESTORE_JDBC_CONNECTOR_ARGUMENTS = "arguments"

    JSON_FEATURESTORE_S3_ACCESS_KEY = "accessKey"
    JSON_FEATURESTORE_S3_SECRET_KEY = "secretKey"
    JSON_FEATURESTORE_S3_BUCKET = "bucket"

    JSON_FEATURESTORE_CONNECTOR_NAME = "name"
    JSON_FEATURESTORE_CONNECTOR_DESCRIPTION = "description"
    JSON_FEATURESTORE_CONNECTOR_ID = "id"
    JSON_FEATURESTORE_CONNECTOR_FEATURESTORE_ID = "featurestoreId"
    JSON_FEATURESTORE_CONNECTOR_TYPE = "storageConnectorType"

    HOPSWORKS_REST_RESOURCE = "hopsworks-api/api"
    HOPSWORKS_FEATURESTORES_RESOURCE = "featurestores"
    HOPSWORKS_FEATURESTORE_METADATA_RESOURCE = "metadata"
    HOPSWORKS_FEATUREGROUPS_RESOURCE = "featuregroups"
    HOPSWORKS_TRAININGDATASETS_RESOURCE = "trainingdatasets"
    HOPSWORKS_FEATURESTORES_STORAGE_CONNECTORS_RESOURCE = "storageconnectors"
    HOPSWORKS_ONLINE_FEATURESTORE_STORAGE_CONNECTOR_RESOURCE = "onlinefeaturestore"
    HOPSWORKS_FEATUREGROUP_IMPORT_RESOURCE = "importjob"
    HOPSWORKS_TRAININGDATASETS_CREATION_RESOURCE = "trainingdatasetjob"
    HOPSWORKS_FEATUREGROUPS_XATTRS_RESOURCE = "xattrs"

    HOPSWORKS_PROJECT_RESOURCE = "project"
    HOPSWORKS_PROJECT_INFO_RESOURCE = "getProjectInfo"
    HOPSWORKS_PROJECT_CREDENTIALS_RESOURCE = "credentials"

    JSON_DESCRIPTIVE_STATS_FEATURE_NAME = "featureName"
    JSON_DESCRIPTIVE_STATS_METRIC_VALUES = "metricValues"
    JSON_DESCRIPTIVE_STATS = "descriptiveStats"

    JSON_CLUSTERING_ANALYSIS_DATA_POINT_NAME = "datapointName"
    JSON_CLUSTERING_ANALYSIS_FIRST_DIMENSION = "firstDimension"
    JSON_CLUSTERING_ANALYSIS_SECOND_DIMENSION = "secondDimension"
    JSON_CLUSTERING_ANALYSIS_CLUSTER = "cluster"
    JSON_CLUSTERING_ANALYSIS_DATA_POINTS = "dataPoints"

    JSON_HISTOGRAM_FREQUENCY = "frequency"
    JSON_HISTOGRAM_BIN = "bin"
    JSON_HISTOGRAM_FEATURE_NAME = "featureName"
    JSON_HISTOGRAM_FREQUENCY_DISTRIBUTION = "frequencyDistribution"
    JSON_HISTOGRAM_FEATURE_DISTRIBUTIONS = "featureDistributions"

    JSON_CORRELATION_FEATURE_NAME = "featureName"
    JSON_CORRELATION = "correlation"
    JSON_CORRELATION_VALUES = "correlationValues"

    JSON_FEATURE_CORRELATIONS = "featureCorrelations"

    JSON_ERROR_CODE = "errorCode"
    JSON_ERROR_MSG = "errorMsg"
    JSON_USR_MSG = "usrMsg"


class DELIMITERS:
    """
    String delimiters constants
    """
    SLASH_DELIMITER = "/"
    COMMA_DELIMITER = ","
    TAB_DELIMITER = "\t"
    COLON_DELIMITER = ":"
    AMPERSAND_DELIMITER = "&"
    SEMI_COLON_DELIMITER = ";"
    JDBC_CONNECTION_STRING_VALUE_DELIMITER = "="
    JDBC_CONNECTION_STRING_DELIMITER = ";"


class AWS:
    DEFAULT_REGION = "default"
    SECRETS_MANAGER = "secretsmanager"
    PARAMETER_STORE = "parameterstore"
    SSM = "SSM"

class LOCAL:
    LOCAL_STORE = "local"
