import { IPrincipal, IRole } from '@aws-cdk/aws-iam';
import { Resource, Stack } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { InstanceType } from '.';
import { Connections } from './connections';
import { IInstance, Instance } from './instance';
import { IMachineImage } from './machine-image';
import { IPeer } from './peer';
import { ISecurityGroup } from './security-group';
import { BlockDevice } from './volume';
import { IVpc, SubnetSelection } from './vpc';
/**
 * (experimental) Properties of the bastion host.
 *
 * @experimental
 */
export interface BastionHostLinuxProps {
    /**
     * (experimental) In which AZ to place the instance within the VPC.
     *
     * @default - Random zone.
     * @experimental
     */
    readonly availabilityZone?: string;
    /**
     * (experimental) VPC to launch the instance in.
     *
     * @experimental
     */
    readonly vpc: IVpc;
    /**
     * (experimental) The name of the instance.
     *
     * @default 'BastionHost'
     * @experimental
     */
    readonly instanceName?: string;
    /**
     * (experimental) Select the subnets to run the bastion host in.
     *
     * Set this to PUBLIC if you need to connect to this instance via the internet and cannot use SSM.
     * You have to allow port 22 manually by using the connections field
     *
     * @default - private subnets of the supplied VPC
     * @experimental
     */
    readonly subnetSelection?: SubnetSelection;
    /**
     * (experimental) Security Group to assign to this instance.
     *
     * @default - create new security group with no inbound and all outbound traffic allowed
     * @experimental
     */
    readonly securityGroup?: ISecurityGroup;
    /**
     * (experimental) Type of instance to launch.
     *
     * @default 't3.nano'
     * @experimental
     */
    readonly instanceType?: InstanceType;
    /**
     * (experimental) The machine image to use, assumed to have SSM Agent preinstalled.
     *
     * @default - An Amazon Linux 2 image which is kept up-to-date automatically (the instance
     * may be replaced on every deployment) and already has SSM Agent installed.
     * @experimental
     */
    readonly machineImage?: IMachineImage;
    /**
     * (experimental) Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     *
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     *
     * @default - Uses the block device mapping of the AMI
     * @see https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html
     * @experimental
     */
    readonly blockDevices?: BlockDevice[];
}
/**
 * (experimental) This creates a linux bastion host you can use to connect to other instances or services in your VPC.
 *
 * The recommended way to connect to the bastion host is by using AWS Systems Manager Session Manager.
 *
 * The operating system is Amazon Linux 2 with the latest SSM agent installed
 *
 * You can also configure this bastion host to allow connections via SSH
 *
 * @experimental
 * @resource AWS::EC2::Instance
 */
export declare class BastionHostLinux extends Resource implements IInstance {
    /**
     * (experimental) The stack in which this resource is defined.
     *
     * @experimental
     */
    readonly stack: Stack;
    /**
     * (experimental) Allows specify security group connections for the instance.
     *
     * @experimental
     */
    readonly connections: Connections;
    /**
     * (experimental) The IAM role assumed by the instance.
     *
     * @experimental
     */
    readonly role: IRole;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) The underlying instance resource.
     *
     * @experimental
     */
    readonly instance: Instance;
    /**
     * (experimental) The instance's ID.
     *
     * @experimental
     * @attribute true
     */
    readonly instanceId: string;
    /**
     * (experimental) The availability zone the instance was launched in.
     *
     * @experimental
     * @attribute true
     */
    readonly instanceAvailabilityZone: string;
    /**
     * (experimental) Private DNS name for this instance.
     *
     * @experimental
     * @attribute true
     */
    readonly instancePrivateDnsName: string;
    /**
     * (experimental) Private IP for this instance.
     *
     * @experimental
     * @attribute true
     */
    readonly instancePrivateIp: string;
    /**
     * (experimental) Publicly-routable DNS name for this instance.
     *
     * (May be an empty string if the instance does not have a public name).
     *
     * @experimental
     * @attribute true
     */
    readonly instancePublicDnsName: string;
    /**
     * (experimental) Publicly-routable IP  address for this instance.
     *
     * (May be an empty string if the instance does not have a public IP).
     *
     * @experimental
     * @attribute true
     */
    readonly instancePublicIp: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BastionHostLinuxProps);
    /**
     * Returns the AmazonLinuxCpuType corresponding to the given instance architecture
     * @param architecture the instance architecture value to convert
     */
    private toAmazonLinuxCpuType;
    /**
     * (experimental) Allow SSH access from the given peer or peers.
     *
     * Necessary if you want to connect to the instance using ssh. If not
     * called, you should use SSM Session Manager to connect to the instance.
     *
     * @experimental
     */
    allowSshAccessFrom(...peer: IPeer[]): void;
}
