[![Downloads](https://pepy.tech/badge/enterpriseattack)](https://pepy.tech/project/enterpriseattack)
[![PyPI version](https://badge.fury.io/py/enterpriseattack.svg)](https://badge.fury.io/py/enterpriseattack)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![image](https://img.shields.io/pypi/pyversions/enterpriseattack.svg)](https://pypi.org/project/enterpriseattack/)


## enterpriseattack - MITRE's Enterprise Att&ck

A lightweight Python module to interact with the [MITRE ATT&CK](https://attack.mitre.org/) Enterprise dataset. Built to be used in production applications due to it's speed and minimal depedancies. [Read the docs](https://github.com/xakepnz/enterpriseattack/tree/main/docs) for more info.

## MITRE Att&ck

MITRE ATT&CK® is a globally-accessible knowledge base of adversary tactics and techniques based on real-world observations. The ATT&CK knowledge base is used as a foundation for the development of specific threat models and methodologies in the private sector, in government, and in the cybersecurity product and service community.

### Dependancies

* Python 3.x
* ujson >= 3.0.0
* requests >= 2.9.2

## Installation

### Install via Pip:
   ```sh
   pip install enterpriseattack
   ```

### Alternatively clone the repository:
   ```sh
   git clone https://github.com/xakepnz/enterpriseattack.git
   cd enterpriseattack
   python3 setup.py install
   ```

<p align="right">(<a href="#top">back to top</a>)</p>

## Usage

### Initialise an Attack object:
```py
import enterpriseattack

attack = enterpriseattack.Attack()
```

### Example: Passing custom args:
In this example, you can choose where to download the official Mitre Att&ck json from, including proxies to pass through. Alternatively, if you want to save the json file in a separate location, you can alter the enterprise_json arg. By default this is saved within your default site-packages location.

* update - boolean forces a refresh download (each time this is called), overwriting the previous file.
* include_deprecated - boolean to include Mitre Att&ck deprecated objects (from previous Att&ck versions).

```py
attack = enterpriseattack.Attack(
   enterprise_json=None,
   url='https://raw.githubusercontent.com/mitre/cti/master/enterprise-attack/enterprise-attack.json',
   include_deprecated=False,
   update=False,
   proxies={'http':'http://127.0.0.1:1337'}
)
```

### Example: Iterate over tactics/techniques/sub_techniques:
```py
for tactic in attack.tactics:
   print(tactic.name)
   for technique in tactic.techniques:
      print(technique.name)
      print(technique.detection)

for software in attack.software:
    for technique in software.techniques:
        for sub_technique in technique.sub_techniques:
            print(software.name, technique.name, sub_technique.name)
```

### Example: Create a json object of any tactic/technique/sub_technique/group/software/datasource:
```py
for tactic in attack.tactics:
   print(tactic.to_json())

for group in attack.groups:
   print(group.to_json())

...
```

For more examples, please refer to the [Documentation](https://github.com/xakepnz/enterpriseattack/tree/main/docs)

<p align="right">(<a href="#top">back to top</a>)</p>
