# -*- coding: utf-8 -*-

# Copyright (c) 2014 - 2022 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing mimetype dependent functions.
"""

import mimetypes

from eric7 import Preferences


def isTextFile(filename):
    """
    Function to test, if the given file is a text (i.e. editable) file.

    @param filename name of the file to be checked
    @type str
    @return flag indicating an editable file
    @rtype bool
    """
    mimetype = mimetypes.guess_type(filename)[0]
    return (mimetype is None and Preferences.getUI("LoadUnknownMimeTypeFiles")) or (
        mimetype is not None
        and (
            mimetype.split("/")[0] == "text"
            or mimetype in Preferences.getUI("TextMimeTypes")
        )
    )


def mimeType(filename):
    """
    Function to get the mime type of a file.

    @param filename name of the file to be checked
    @type str
    @return mime type of the file
    @rtype str
    """
    return mimetypes.guess_type(filename)[0]
