# -*- coding: utf-8 -*-

# Copyright (c) 2007 - 2022 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Package implementing lexers for the various supported programming languages.
"""

import importlib


def getCompleter(language, editor, parent=None):
    """
    Module function to instantiate a lexer object for a given language.

    @param language language of the lexer (string)
    @param editor reference to the editor object (QScintilla.Editor)
    @param parent reference to the parent object (QObject)
    @return reference to the instanciated lexer object (QsciLexer)
    """
    languageCompleterMapping = {
        "Python": ".CompleterPython",
        "Python3": ".CompleterPython",
        "MicroPython": ".CompleterPython",
        "Cython": ".CompleterPython",
        "Ruby": ".CompleterRuby",
        "YAML": ".CompleterYaml",
    }

    if language in languageCompleterMapping:
        mod = importlib.import_module(languageCompleterMapping[language], __package__)
        if mod:
            return mod.createCompleter(editor, parent)

    return None
