# -*- coding: utf-8 -*-
# Generated by Django 1.10.5 on 2017-05-11 18:29
import re
import uuid

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
from django.db import migrations, models

import openwisp_utils.base
import openwisp_utils.utils

from .. import settings as app_settings


class Migration(migrations.Migration):

    dependencies = [
        ('openwisp_users', '0001_initial'),
        ('config', '0003_template_tags'),
    ]

    operations = [
        migrations.CreateModel(
            name='Device',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ('name', models.CharField(max_length=64, unique=True)),
                (
                    'mac_address',
                    models.CharField(
                        help_text='primary mac address',
                        max_length=17,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                re.compile(
                                    '^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})', 32
                                ),
                                code='invalid',
                                message='Must be a valid mac address.',
                            )
                        ],
                    ),
                ),
                (
                    'key',
                    openwisp_utils.base.KeyField(
                        db_index=True,
                        default=openwisp_utils.utils.get_random_key,
                        help_text='unique device key',
                        max_length=64,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                re.compile('^[^\\s/\\.]+$'),
                                code='invalid',
                                message=(
                                    'This value must not contain spaces, dots or '
                                    'slashes.'
                                ),
                            )
                        ],
                    ),
                ),
                (
                    'model',
                    models.CharField(
                        blank=True,
                        help_text='device model and manufacturer',
                        max_length=64,
                    ),
                ),
                (
                    'os',
                    models.CharField(
                        blank=True,
                        help_text='operating system identifier',
                        max_length=128,
                        verbose_name='operating system',
                    ),
                ),
                ('notes', models.TextField(blank=True)),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'organization',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to='openwisp_users.Organization',
                        verbose_name='organization',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'verbose_name': app_settings.DEVICE_VERBOSE_NAME[0],
                'verbose_name_plural': app_settings.DEVICE_VERBOSE_NAME[1],
            },
        ),
        migrations.AddField(
            model_name='config',
            name='device',
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to='config.Device',
            ),
        ),
    ]
