"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kafka_generated_1 = require("./kafka.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return kafka_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::KAFKA::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::KAFKA::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new kafka_generated_1.RosInstance(this, id, {
            deployType: props.deployType,
            eipMax: props.eipMax,
            specType: props.specType,
            ioMax: props.ioMax,
            payType: props.payType === undefined || props.payType === null ? 'Hour' : props.payType,
            diskType: props.diskType,
            deployOption: props.deployOption,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            ioMaxSpec: props.ioMaxSpec,
            diskSize: props.diskSize,
            topicQuota: props.topicQuota,
            tags: props.tags,
            openConnector: props.openConnector === undefined || props.openConnector === null ? false : props.openConnector,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrName = rosInstance.attrName;
        this.attrOrderId = rosInstance.attrOrderId;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsdURBQWdEO0FBRXhCLGlHQUZmLDZCQUFXLE9BRW9CO0FBeUZ4Qzs7R0FFRztBQUNILE1BQWEsUUFBUyxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBc0J0Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW9CLEVBQUUsbUNBQTJDLElBQUk7UUFDL0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFdBQVcsR0FBRyxJQUFJLDZCQUFXLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUMzQyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsT0FBTyxFQUFFLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxPQUFPLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxPQUFPO1lBQ3ZGLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxhQUFhLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFhO1lBQzlHLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWEsS0FBSyxTQUFTLElBQUksS0FBSyxDQUFDLGFBQWEsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGFBQWE7U0FDakgsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyxXQUFXLENBQUM7UUFDNUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxXQUFXLENBQUMsY0FBYyxDQUFDO1FBQ2pELElBQUksQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDLFFBQVEsQ0FBQztRQUNyQyxJQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQyxXQUFXLENBQUM7SUFDL0MsQ0FBQztDQUNKO0FBcERELDRCQW9EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvcyBmcm9tICdAYWxpY2xvdWQvcm9zLWNkay1jb3JlJztcbmltcG9ydCB7IFJvc0luc3RhbmNlIH0gZnJvbSAnLi9rYWZrYS5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NJbnN0YW5jZSBhcyBJbnN0YW5jZVByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpLQUZLQTo6SW5zdGFuY2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW5zdGFuY2VQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZXBsb3lUeXBlOiBUaGUgZGVwbG95bWVudCBtb2RlIG9mIHRoZSBNZXNzYWdlIFF1ZXVlIGZvciBBcGFjaGUgS2Fma2EgaW5zdGFuY2UuIFZhbGlkIHZhbHVlczogXG4gICAgICogICA0OiBJbnN0YW5jZSBvZiB0aGUgcHVibGljIHR5cGUgXG4gICAgICogICA1OiBJbnN0YW5jZSBvZiB0aGUgVlBDIHR5cGVcbiAgICAgKi9cbiAgICByZWFkb25seSBkZXBsb3lUeXBlOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkaXNrU2l6ZTogVGhlIHNpemUgb2YgdGhlIGRpc2sgdG8gYmUgY29uZmlndXJlZCBmb3IgdGhlIE1lc3NhZ2UgUXVldWUgZm9yIEFwYWNoZSBLYWZrYSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkaXNrU2l6ZTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGlza1R5cGU6IFRoZSB0eXBlIG9mIHRoZSBkaXNrIHRvIGJlIGNvbmZpZ3VyZWQgZm9yIHRoZSBNZXNzYWdlIFF1ZXVlIGZvciBBcGFjaGUgS2Fma2EgaW5zdGFuY2UuIFZhbGlkIHZhbHVlczogXG4gICAgICogMDogVWx0cmEgZGlzayBcbiAgICAgKiAxOiBTU0RcbiAgICAgKi9cbiAgICByZWFkb25seSBkaXNrVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdG9waWNRdW90YTogVGhlIG51bWJlciBvZiB0b3BpY3MgdG8gYmUgY29uZmlndXJlZCBmb3IgdGhlIE1lc3NhZ2UgUXVldWUgZm9yIEFwYWNoZSBLYWZrYSBpbnN0YW5jZS4gXG4gICAgICogVGhlIGRlZmF1bHQgdmFsdWUgb2YgdGhpcyBwYXJhbWV0ZXIgdmFyaWVzIHdpdGggZGlmZmVyZW50IHBlYWsgdHJhZmZpYyB2YWx1ZXMuIFxuICAgICAqIEFkZGl0aW9uYWwgZmVlcyBhcmUgY2hhcmdlZCBpZiB0aGUgZGVmYXVsdCB2YWx1ZXMgYXJlIGV4Y2VlZGVkLlxuICAgICAqICBEaWZmZXJlbnQgc3BlY2lmaWNhdGlvbnMgaGF2ZSBkaWZmZXJlbnQgZGVmYXVsdCB2YWx1ZXMsIGFuZCBleHRyYSBmZWVzIGFyZSBjaGFyZ2VkLiBcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIEJpbGxpbmcuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdG9waWNRdW90YTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZGVsZXRpb25Gb3JjZTogV2hldGhlciBkZWxldGUgYWxsIHRvcGljcywgY29uc3VtZXIgZ3JvdXBzIG9mIHRoZSBrYWZrYSBpbnN0YW5jZSBhbmQgdGhlbiBkZWxldGUgaW5zdGFuY2UuIERlZmF1bHQgaXMgZmFsc2VcbiAgICAgKi9cbiAgICByZWFkb25seSBkZWxldGlvbkZvcmNlPzogYm9vbGVhbiB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGRlcGxveU9wdGlvbjogSWYgeW91IHdhbnQgdG8gZGVwbG95IGluc3RhbmNlIGFmdGVyIGNyZWF0ZSBhdCBvbmNlLCB0aGUgVlN3aXRjaElkIGFuZCBEZXBsb3lNb2R1bGUgcGFyYW1ldGVycyBpcyByZXF1aXJlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlcGxveU9wdGlvbj86IFJvc0luc3RhbmNlLkRlcGxveU9wdGlvblByb3BlcnR5IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgZWlwTWF4OiBUaGUgcHVibGljIHRyYWZmaWMgdG8gYmUgY29uZmlndXJlZCBmb3IgdGhlIE1lc3NhZ2UgUXVldWUgZm9yIEFwYWNoZSBLYWZrYSBpbnN0YW5jZS4gXG4gICAgICogVGhpcyBwYXJhbWV0ZXIgbXVzdCBiZSBzcGVjaWZpZWQgd2hlbiB0aGUgRGVwbG95VHlwZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIDQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZWlwTWF4PzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgaW9NYXg6IFRoZSBwZWFrIHRyYWZmaWMgdG8gYmUgY29uZmlndXJlZCBmb3IgdGhlIE1lc3NhZ2UgUXVldWUgZm9yIEFwYWNoZSBLYWZrYSBpbnN0YW5jZS4gXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHZhbHVlIHJhbmdlLCBzZWUgQmlsbGluZy5cbiAgICAgKi9cbiAgICByZWFkb25seSBpb01heD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IGlvTWF4U3BlYzogRmxvdyBzcGVjaWZpY2F0aW9uIChyZWNvbW1lbmRlZCkgXG4gICAgICogVGhlIElvTWF4IGFuZCBJb01heFNwZWMgbXVzdCBiZSBvcHRpb25hbC4gXG4gICAgICogV2hlbiBmaWxsaW5nIGluIGF0IHRoZSBzYW1lIHRpbWUsIHN1YmplY3QgdG8gSW9NYXhTcGVjLiBcbiAgICAgKiBJdCBpcyByZWNvbW1lbmRlZCB0aGF0IHlvdSBvbmx5IGZpbGwgaW4gdGhlIGZsb3cgc3BlY2lmaWNhdGlvbiBcbiAgICAgKlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGlvTWF4U3BlYz86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG9wZW5Db25uZWN0b3I6IFdoZXRoZXIgb3BlbiBrYWZrYSBjb25uZWN0b3Igb3Igbm90XG4gICAgICovXG4gICAgcmVhZG9ubHkgb3BlbkNvbm5lY3Rvcj86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXlUeXBlOiBQYXkgYnkgaG91ciBvciBtb250aC5cbiAgICAgKi9cbiAgICByZWFkb25seSBwYXlUeXBlPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgc3BlY1R5cGU6IFRoZSBlZGl0aW9uIG9mIHRoZSBNZXNzYWdlIFF1ZXVlIGZvciBBcGFjaGUgS2Fma2EgaW5zdGFuY2UuIFZhbGlkIHZhbHVlczogXG4gICAgICogcHJvZmVzc2lvbmFsOiBQcm9mZXNzaW9uYWwgRWRpdGlvbiBcbiAgICAgKiBub3JtYWw6IE5vcm1hbCB2ZXJzaW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3BlY1R5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSB0YWdzOiBUYWdzIHRvIGF0dGFjaCB0byBpbnN0YW5jZS4gTWF4IHN1cHBvcnQgMjAgdGFncyB0byBhZGQgZHVyaW5nIGNyZWF0ZSBpbnN0YW5jZS4gRWFjaCB0YWcgd2l0aCB0d28gcHJvcGVydGllcyBLZXkgYW5kIFZhbHVlLCBhbmQgS2V5IGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBSb3NJbnN0YW5jZS5UYWdzUHJvcGVydHlbXTtcbn1cblxuLyoqXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6S0FGS0E6Okluc3RhbmNlYFxuICovXG5leHBvcnQgY2xhc3MgSW5zdGFuY2UgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIEluc3RhbmNlSWQ6IElkIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckluc3RhbmNlSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBOYW1lOiBOYW1lIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck5hbWU6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBPcmRlcklkOiBJZCBvZiB0aGUgb3JkZXIuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJPcmRlcklkOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFMSVlVTjo6S0FGS0E6Okluc3RhbmNlYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBJbnN0YW5jZVByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc0luc3RhbmNlID0gbmV3IFJvc0luc3RhbmNlKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgZGVwbG95VHlwZTogcHJvcHMuZGVwbG95VHlwZSxcbiAgICAgICAgICAgIGVpcE1heDogcHJvcHMuZWlwTWF4LFxuICAgICAgICAgICAgc3BlY1R5cGU6IHByb3BzLnNwZWNUeXBlLFxuICAgICAgICAgICAgaW9NYXg6IHByb3BzLmlvTWF4LFxuICAgICAgICAgICAgcGF5VHlwZTogcHJvcHMucGF5VHlwZSA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLnBheVR5cGUgPT09IG51bGwgPyAnSG91cicgOiBwcm9wcy5wYXlUeXBlLFxuICAgICAgICAgICAgZGlza1R5cGU6IHByb3BzLmRpc2tUeXBlLFxuICAgICAgICAgICAgZGVwbG95T3B0aW9uOiBwcm9wcy5kZXBsb3lPcHRpb24sXG4gICAgICAgICAgICBkZWxldGlvbkZvcmNlOiBwcm9wcy5kZWxldGlvbkZvcmNlID09PSB1bmRlZmluZWQgfHwgcHJvcHMuZGVsZXRpb25Gb3JjZSA9PT0gbnVsbCA/IGZhbHNlIDogcHJvcHMuZGVsZXRpb25Gb3JjZSxcbiAgICAgICAgICAgIGlvTWF4U3BlYzogcHJvcHMuaW9NYXhTcGVjLFxuICAgICAgICAgICAgZGlza1NpemU6IHByb3BzLmRpc2tTaXplLFxuICAgICAgICAgICAgdG9waWNRdW90YTogcHJvcHMudG9waWNRdW90YSxcbiAgICAgICAgICAgIHRhZ3M6IHByb3BzLnRhZ3MsXG4gICAgICAgICAgICBvcGVuQ29ubmVjdG9yOiBwcm9wcy5vcGVuQ29ubmVjdG9yID09PSB1bmRlZmluZWQgfHwgcHJvcHMub3BlbkNvbm5lY3RvciA9PT0gbnVsbCA/IGZhbHNlIDogcHJvcHMub3BlbkNvbm5lY3RvcixcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NJbnN0YW5jZTtcbiAgICAgICAgdGhpcy5hdHRySW5zdGFuY2VJZCA9IHJvc0luc3RhbmNlLmF0dHJJbnN0YW5jZUlkO1xuICAgICAgICB0aGlzLmF0dHJOYW1lID0gcm9zSW5zdGFuY2UuYXR0ck5hbWU7XG4gICAgICAgIHRoaXMuYXR0ck9yZGVySWQgPSByb3NJbnN0YW5jZS5hdHRyT3JkZXJJZDtcbiAgICB9XG59XG4iXX0=