/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.io.Closeable;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import main.Pedigree;
import vcf.GeneticMap;
import vcf.Samples;
import vcf.Window;

public interface SlidingWindow
extends Closeable {
    public Samples targSamples();

    public Pedigree ped();

    public GeneticMap genMap();

    public int cumTargMarkers();

    public int cumMarkers();

    public Optional<Window> nextWindow();

    @Override
    public void close();

    public static <E> E takeFromQ(BlockingQueue<E> blockingQueue) {
        E e = null;
        try {
            e = blockingQueue.take();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        return e;
    }

    public static <E> void addToQ(BlockingQueue<E> blockingQueue, E e) {
        try {
            blockingQueue.put(e);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

