/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.InputIt;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import bref.Bref3It;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import main.Par;
import main.Pedigree;
import vcf.BasicGT;
import vcf.FilterUtil;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.IntervalVcfIt;
import vcf.Marker;
import vcf.MarkerIndices;
import vcf.RefGT;
import vcf.RefGTRec;
import vcf.RefIt;
import vcf.Samples;
import vcf.SlidingWindow;
import vcf.VcfIt;
import vcf.Window;

public class RefTargSlidingWindow
implements SlidingWindow {
    private final SampleFileIt<GTRec> targIt;
    private final SampleFileIt<RefGTRec> refIt;
    private final Pedigree ped;
    private final GeneticMap genMap;
    private final BlockingQueue<Window> q;
    private final Reader reader;
    private int cumTargMarkers;
    private int cumRefMarkers;
    private boolean noMoreWindows;

    public static RefTargSlidingWindow instance(Par par) {
        RefTargSlidingWindow refTargSlidingWindow = new RefTargSlidingWindow(par);
        Thread thread = new Thread(refTargSlidingWindow.reader);
        thread.setDaemon(true);
        thread.start();
        return refTargSlidingWindow;
    }

    private RefTargSlidingWindow(Par par) {
        Filter<String> filter = FilterUtil.sampleFilter(par.excludesamples());
        Filter<Marker> filter2 = FilterUtil.markerFilter(par.excludemarkers());
        this.targIt = RefTargSlidingWindow.targIt(par, filter, filter2);
        this.refIt = RefTargSlidingWindow.refIt(par, filter, filter2);
        this.ped = new Pedigree(this.targIt.samples(), par.ped());
        this.genMap = GeneticMap.geneticMap(par.map(), par.chromInt());
        this.q = new ArrayBlockingQueue<Window>(1);
        this.reader = new Reader(par, this.genMap, this.refIt, this.targIt, this.q);
        this.cumTargMarkers = 0;
        this.cumRefMarkers = 0;
        this.noMoreWindows = false;
    }

    private static SampleFileIt<GTRec> targIt(Par par, Filter<String> filter, Filter<Marker> filter2) {
        InputIt inputIt = InputIt.fromGzipFile(par.gt());
        SampleFileIt<GTRec> sampleFileIt = VcfIt.create(inputIt, filter, filter2, VcfIt.TO_LOWMEM_GT_REC);
        if (par.chromInt() != null) {
            sampleFileIt = new IntervalVcfIt<GTRec>(sampleFileIt, par.chromInt());
        }
        return sampleFileIt;
    }

    private static SampleFileIt<RefGTRec> refIt(Par par, Filter<String> filter, Filter<Marker> filter2) {
        SampleFileIt<RefGTRec> sampleFileIt;
        Object object;
        String string = par.ref().toString();
        if (string.endsWith(".bref")) {
            object = Const.nl + "ERROR: bref format (.bref) is not supported" + Const.nl + "       Reference files should be in bref3 format (.bref3)";
            Utilities.exit((String)object);
        }
        if (string.endsWith(".bref3")) {
            sampleFileIt = new Bref3It(par.ref(), filter2);
        } else {
            if (!string.endsWith(".vcf") && !string.endsWith(".vcf.gz")) {
                System.err.println(Const.nl + "WARNING: unrecognized reference file type (expected \".bref3\", \".vcf\", or \".vcf.gz\")" + Const.nl);
            }
            object = InputIt.fromGzipFile(par.ref());
            sampleFileIt = RefIt.create((FileIt<String>)object, filter, filter2);
        }
        if (par.chromInt() != null) {
            sampleFileIt = new IntervalVcfIt<RefGTRec>(sampleFileIt, par.chromInt());
        }
        return sampleFileIt;
    }

    @Override
    public Samples targSamples() {
        return this.targIt.samples();
    }

    @Override
    public Pedigree ped() {
        return this.ped;
    }

    @Override
    public GeneticMap genMap() {
        return this.genMap;
    }

    @Override
    public int cumTargMarkers() {
        return this.cumTargMarkers;
    }

    @Override
    public int cumMarkers() {
        return this.cumRefMarkers;
    }

    @Override
    public Optional<Window> nextWindow() {
        if (this.noMoreWindows) {
            return Optional.empty();
        }
        Window window = SlidingWindow.takeFromQ(this.q);
        if (window.lastWindow()) {
            this.noMoreWindows = true;
        }
        MarkerIndices markerIndices = window.indices();
        this.cumTargMarkers += markerIndices.nTargMarkers() - markerIndices.targOverlapEnd();
        this.cumRefMarkers += markerIndices.nMarkers() - markerIndices.overlapEnd();
        return Optional.of(window);
    }

    @Override
    public void close() {
        this.noMoreWindows = true;
        this.targIt.close();
        this.refIt.close();
    }

    public String toString() {
        return RefTargSlidingWindow.class.toString();
    }

    private static class Reader
    implements Runnable {
        private final GeneticMap genMap;
        private final float windowCM;
        private final float overlapCM;
        private final boolean impute;
        private final SampleFileIt<RefGTRec> refIt;
        private final SampleFileIt<GTRec> targIt;
        private final BlockingQueue<Window> q;
        private final ArrayList<GTRec> targOverlap;
        private final ArrayList<RefGTRec> refOverlap;
        private final ArrayList<Boolean> inTargOverlap;
        private final ArrayList<GTRec> targRecs;
        private final ArrayList<RefGTRec> refRecs;
        private final ArrayList<Boolean> inTarg;
        private GTRec nextTargRec;
        private RefGTRec nextRefRec;

        public Reader(Par par, GeneticMap geneticMap, SampleFileIt<RefGTRec> sampleFileIt, SampleFileIt<GTRec> sampleFileIt2, BlockingQueue<Window> blockingQueue) {
            this.genMap = geneticMap;
            this.windowCM = par.window();
            this.overlapCM = par.overlap();
            this.impute = par.impute();
            this.targIt = sampleFileIt2;
            this.refIt = sampleFileIt;
            this.q = blockingQueue;
            this.targOverlap = new ArrayList();
            this.refOverlap = new ArrayList();
            this.inTargOverlap = new ArrayList();
            this.targRecs = new ArrayList(10000);
            this.refRecs = new ArrayList(10000);
            this.inTarg = new ArrayList(10000);
        }

        @Override
        public void run() {
            try {
                if (!this.targIt.hasNext() || !this.refIt.hasNext()) {
                    throw new IllegalArgumentException("no genotype data");
                }
                this.nextTargRec = (GTRec)this.targIt.next();
                this.nextRefRec = (RefGTRec)this.refIt.next();
                int n = 0;
                double d = Double.NaN;
                while (this.nextTargRec != null && this.nextRefRec != null) {
                    int n2 = this.nextTargRec.marker().chromIndex();
                    this.advanceRefItToChrom(this.refIt, n2);
                    d = this.nextEndCm(d);
                    int n3 = this.genMap.basePos(n2, d);
                    Window window = this.readWindow(n2, n3, ++n);
                    SlidingWindow.addToQ(this.q, window);
                    int n4 = window.indices().targOverlapStart();
                    int n5 = window.indices().overlapStart();
                    this.targOverlap.addAll(this.targRecs.subList(n4, this.targRecs.size()));
                    this.refOverlap.addAll(this.refRecs.subList(n5, this.refRecs.size()));
                    this.inTargOverlap.addAll(this.inTarg.subList(n5, this.inTarg.size()));
                }
            }
            catch (Throwable throwable) {
                Utilities.exit(throwable);
            }
        }

        private double nextEndCm(double d) {
            d = this.refOverlap.isEmpty() ? this.genMap.genPos(this.nextRefRec.marker()) + (double)this.windowCM : (d += (double)(this.windowCM - this.overlapCM));
            return d;
        }

        private Window readWindow(int n, int n2, int n3) {
            int n4 = this.refOverlap.size();
            this.resetLists();
            while (this.nextTargRec != null && this.nextTargRec.marker().chromIndex() == n && this.nextTargRec.marker().pos() < n2) {
                Marker marker = this.nextTargRec.marker();
                int n5 = marker.pos();
                while (this.nextRefRec != null && this.nextRefRec.marker().chromIndex() == n && (this.nextRefRec.marker().pos() < n5 || this.nextRefRec.marker().pos() == n5 && !marker.equals(this.nextRefRec.marker()))) {
                    if (this.impute) {
                        this.refRecs.add(this.nextRefRec);
                        this.inTarg.add(Boolean.FALSE);
                    }
                    this.nextRefRec = this.refIt.hasNext() ? (RefGTRec)this.refIt.next() : null;
                }
                if (this.nextRefRec != null && this.nextRefRec.marker().equals(marker)) {
                    this.targRecs.add(this.nextTargRec);
                    this.refRecs.add(this.nextRefRec);
                    this.inTarg.add(Boolean.TRUE);
                    this.nextRefRec = this.refIt.hasNext() ? (RefGTRec)this.refIt.next() : null;
                }
                this.nextTargRec = this.targIt.hasNext() ? (GTRec)this.targIt.next() : null;
            }
            if (this.impute) {
                while (this.nextRefRec != null && this.nextRefRec.marker().chromIndex() == n && this.nextRefRec.marker().pos() < n2) {
                    this.refRecs.add(this.nextRefRec);
                    this.inTarg.add(Boolean.FALSE);
                    this.nextRefRec = this.refIt.hasNext() ? (RefGTRec)this.refIt.next() : null;
                }
            }
            return this.window(n4, n3);
        }

        private void resetLists() {
            this.targRecs.clear();
            this.refRecs.clear();
            this.inTarg.clear();
            this.targRecs.addAll(this.targOverlap);
            this.refRecs.addAll(this.refOverlap);
            this.inTarg.addAll(this.inTargOverlap);
            this.targOverlap.clear();
            this.refOverlap.clear();
            this.inTargOverlap.clear();
        }

        private Window window(int n, int n2) {
            if (this.refRecs.isEmpty()) {
                String string = Const.nl + Const.nl + "Marker window contains no reference markers. Do the reference and" + Const.nl + "target VCF files contain the same chromosomes in the same order?" + Const.nl;
                throw new IllegalArgumentException(string);
            }
            RefGT refGT = new RefGT(this.refRecs.toArray(new RefGTRec[0]));
            BasicGT basicGT = new BasicGT(this.targRecs.toArray(new GTRec[0]));
            boolean bl = this.nextTargRec == null || this.nextRefRec == null;
            MarkerIndices markerIndices = this.markerIndices(refGT, bl, n);
            return new Window(this.genMap, n2, bl, markerIndices, refGT, basicGT);
        }

        private MarkerIndices markerIndices(RefGT refGT, boolean bl, int n) {
            boolean bl2 = bl || this.refRecs.get(0).marker().chromIndex() != this.nextRefRec.marker().chromIndex();
            int n2 = this.overlapStart(refGT, bl2, this.overlapCM);
            boolean[] blArray = new boolean[this.inTarg.size()];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = this.inTarg.get(i);
            }
            return new MarkerIndices(blArray, n, n2);
        }

        private int overlapStart(RefGT refGT, boolean bl, float f) {
            if (bl) {
                return refGT.nMarkers();
            }
            int n = refGT.nMarkers() - 1;
            Marker marker = refGT.marker(n);
            double d = this.genMap.genPos(marker);
            double d2 = d - (double)f;
            int n2 = this.genMap.basePos(marker.chromIndex(), d2);
            int n3 = 0;
            int n4 = n;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                int n6 = refGT.marker(n5).pos();
                if (n6 < n2) {
                    n3 = n5 + 1;
                    continue;
                }
                if (n6 > n2) {
                    n4 = n5 - 1;
                    continue;
                }
                return this.firstIndexWithPos(refGT, n5);
            }
            assert (n4 < n3);
            return this.firstIndexWithPos(refGT, Math.max(0, n4));
        }

        private int firstIndexWithPos(RefGT refGT, int n) {
            int n2 = refGT.marker(n).pos();
            while (n > 0 && refGT.marker(n - 1).pos() == n2) {
                --n;
            }
            return n;
        }

        private void advanceRefItToChrom(SampleFileIt<RefGTRec> sampleFileIt, int n) {
            while (this.nextRefRec != null && this.nextRefRec.marker().chromIndex() != n && sampleFileIt.hasNext()) {
                this.nextRefRec = (RefGTRec)sampleFileIt.next();
            }
        }
    }
}

