/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntArray;
import vcf.GTRec;
import vcf.LowMafRefDiallelicGTRec;
import vcf.LowMafRefGTRec;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfRecGTParser;

public interface RefGTRec
extends GTRec {
    public static RefGTRec alleleCodedInstance(RefGTRec refGTRec) {
        if (refGTRec.isAlleleCoded()) {
            return refGTRec;
        }
        if (refGTRec.marker().nAlleles() == 2) {
            return new LowMafRefDiallelicGTRec(refGTRec);
        }
        return new LowMafRefGTRec(refGTRec);
    }

    public static RefGTRec alleleCodedInstance(VcfRecGTParser vcfRecGTParser) {
        if (vcfRecGTParser.nAlleles() == 2) {
            return new LowMafRefDiallelicGTRec(vcfRecGTParser);
        }
        return new LowMafRefGTRec(vcfRecGTParser);
    }

    public static RefGTRec hapCodedInstance(Marker marker, Samples samples, int[][] nArray) {
        if (marker.nAlleles() == 2) {
            return new LowMafRefDiallelicGTRec(marker, samples, nArray);
        }
        return new LowMafRefGTRec(marker, samples, nArray);
    }

    public int[][] hapIndices();

    @Override
    public boolean isPhased(int var1);

    @Override
    public boolean isPhased();

    public boolean isAlleleCoded();

    public int majorAllele();

    public int[] alleleCounts();

    public int alleleCount(int var1);

    public int hapIndex(int var1, int var2);

    public boolean isCarrier(int var1, int var2);

    public int nMaps();

    public IntArray[] maps();

    public IntArray map(int var1);
}

