/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntArray;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.LowMafRefGTRec;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;
import vcf.VcfRecGTParser;

public final class LowMafRefDiallelicGTRec
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int majorAllele;
    private final int minorAllele;
    private final int[] minorAlleles;

    public LowMafRefDiallelicGTRec(RefGTRec refGTRec) {
        if (refGTRec.marker().nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(refGTRec.marker().nAlleles() != 2));
        }
        int[][] nArray = refGTRec.hapIndices();
        int n = 0;
        while (nArray[n] != null) {
            ++n;
        }
        this.marker = refGTRec.marker();
        this.samples = refGTRec.samples();
        this.nHaps = refGTRec.size();
        this.majorAllele = n;
        this.minorAllele = 1 - n;
        this.minorAlleles = nArray[this.minorAllele];
    }

    public LowMafRefDiallelicGTRec(VcfRecGTParser vcfRecGTParser) {
        if (vcfRecGTParser.nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(vcfRecGTParser.nAlleles()));
        }
        int[][] nArray = vcfRecGTParser.nonMajRefIndices();
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        this.nHaps = 2 * vcfRecGTParser.nSamples();
        this.majorAllele = nArray[0] == null ? 0 : 1;
        this.minorAllele = 1 - this.majorAllele;
        this.minorAlleles = nArray[this.minorAllele];
    }

    public LowMafRefDiallelicGTRec(Marker marker, Samples samples, int[][] nArray) {
        if (marker.nAlleles() != 2) {
            throw new IllegalArgumentException(String.valueOf(marker.nAlleles()));
        }
        this.marker = marker;
        this.samples = samples;
        this.nHaps = 2 * samples.size();
        this.majorAllele = LowMafRefGTRec.checkIndicesAndReturnNullIndex(nArray, this.nHaps);
        this.minorAllele = 1 - this.majorAllele;
        this.minorAlleles = (int[])nArray[this.minorAllele].clone();
    }

    @Override
    public int[][] hapIndices() {
        int[][] nArrayArray = new int[2][];
        nArrayArray[this.minorAllele] = (int[])this.minorAlleles.clone();
        return nArrayArray;
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.samples().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.nHaps;
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int allele1(int n) {
        return this.get(n << 1);
    }

    @Override
    public int allele2(int n) {
        return this.get(n << 1 | 1);
    }

    @Override
    public int get(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (Arrays.binarySearch(this.minorAlleles, n) >= 0) {
            return this.minorAllele;
        }
        return this.majorAllele;
    }

    @Override
    public int[] alleles() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int n2 : this.minorAlleles) {
            nArray[n2] = this.minorAllele;
        }
        return nArray;
    }

    @Override
    public boolean isAlleleCoded() {
        return true;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele;
    }

    @Override
    public int[] alleleCounts() {
        int[] nArray = new int[2];
        nArray[this.majorAllele] = this.nHaps - this.minorAlleles.length;
        nArray[this.minorAllele] = this.minorAlleles.length;
        return nArray;
    }

    @Override
    public int alleleCount(int n) {
        if (n == this.majorAllele) {
            throw new IllegalArgumentException("major allele");
        }
        return this.minorAlleles.length;
    }

    @Override
    public int hapIndex(int n, int n2) {
        if (n == this.majorAllele) {
            throw new IllegalArgumentException("major allele");
        }
        return this.minorAlleles[n2];
    }

    @Override
    public boolean isCarrier(int n, int n2) {
        return this.get(n2) == n;
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }

    @Override
    public int nMaps() {
        return 1;
    }

    @Override
    public IntArray[] maps() {
        return new IntArray[]{this.toIntArray()};
    }

    @Override
    public IntArray map(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.toIntArray();
    }

    private IntArray toIntArray() {
        int[] nArray = IntStream.range(0, this.nHaps).map(n -> this.majorAllele).toArray();
        for (int n2 : this.minorAlleles) {
            nArray[n2] = this.minorAllele;
        }
        return IntArray.packedCreate(nArray, 2);
    }
}

