/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import java.util.stream.IntStream;
import vcf.GT;
import vcf.GTRec;
import vcf.Marker;
import vcf.Markers;
import vcf.Samples;

public final class BasicGT
implements GT {
    private final Samples samples;
    private final Markers markers;
    private final GTRec[] recs;
    private final boolean isRefData;

    public static int genotype(int n, int n2) {
        if (n <= n2) {
            if (n < 0) {
                String string = "allele < 0: " + n + " " + n2;
                throw new IllegalArgumentException(string);
            }
            return n2 * (n2 + 1) / 2 + n;
        }
        if (n2 < 0) {
            String string = "allele < 0: " + n + " " + n2;
            throw new IllegalArgumentException(string);
        }
        return n * (n + 1) / 2 + n2;
    }

    public BasicGT(GTRec[] gTRecArray) {
        this(gTRecArray[0].samples(), gTRecArray);
    }

    public BasicGT(Samples samples, GTRec[] gTRecArray) {
        BasicGT.checkSamples(samples, gTRecArray);
        this.markers = BasicGT.markers(gTRecArray);
        this.samples = samples;
        this.recs = (GTRec[])gTRecArray.clone();
        this.isRefData = BasicGT.isRefData(gTRecArray);
    }

    public BasicGT(Markers markers, Samples samples, GTRec[] gTRecArray) {
        BasicGT.checkMarkersAndSamples(markers, samples, gTRecArray);
        this.markers = markers;
        this.samples = samples;
        this.recs = (GTRec[])gTRecArray.clone();
        this.isRefData = BasicGT.isRefData(gTRecArray);
    }

    private static void checkSamples(Samples samples, GTRec[] gTRecArray) {
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (gTRecArray[i].samples().equals(samples)) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static void checkMarkersAndSamples(Markers markers, Samples samples, GTRec[] gTRecArray) {
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (!gTRecArray[i].marker().equals(markers.marker(i))) {
                throw new IllegalArgumentException("inconsistent markers");
            }
            if (gTRecArray[i].samples().equals(samples)) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static Markers markers(GTRec[] gTRecArray) {
        Marker[] markerArray = new Marker[gTRecArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = gTRecArray[i].marker();
        }
        return Markers.create(markerArray);
    }

    private static boolean isRefData(GTRec[] gTRecArray) {
        boolean bl = true;
        for (int i = 0; i < gTRecArray.length && bl; ++i) {
            if (gTRecArray[i].isPhased()) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public int nMarkers() {
        return this.recs.length;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.size();
    }

    @Override
    public int nSamples() {
        return this.samples.size();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public boolean isPhased() {
        return this.isRefData;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.recs[n].allele1(n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.recs[n].allele2(n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.recs[n].get(n2);
    }

    public static BasicGT restrict(BasicGT basicGT, int[] nArray) {
        Markers markers = basicGT.markers.restrict(nArray);
        GTRec[] gTRecArray = (GTRec[])IntStream.range(0, nArray.length).mapToObj(n -> basicGT.recs[nArray[n]]).toArray(GTRec[]::new);
        return new BasicGT(markers, basicGT.samples, gTRecArray);
    }

    @Override
    public BasicGT restrict(Markers markers, int[] nArray) {
        GTRec[] gTRecArray = (GTRec[])IntStream.range(0, nArray.length).mapToObj(n -> this.recs[nArray[n]]).toArray(GTRec[]::new);
        return new BasicGT(markers, this.samples, gTRecArray);
    }

    @Override
    public BasicGT restrict(int n2, int n3) {
        Markers markers = this.markers.restrict(n2, n3);
        GTRec[] gTRecArray = (GTRec[])IntStream.range(n2, n3).mapToObj(n -> this.recs[n]).toArray(GTRec[]::new);
        return new BasicGT(markers, this.samples, gTRecArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BasicGT: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        for (GTRec gTRec : this.recs) {
            stringBuilder.append(Const.nl);
            stringBuilder.append(gTRec);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

