/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.MultiThreadUtils;
import blbutil.Utilities;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import main.Par;
import phase.FixedPhaseData;
import phase.HmmParamData;
import phase.LowFreqPhaseIbs;
import phase.ParamEstimates;
import phase.PbwtPhaseIbs;
import phase.PhaseBaum1;
import phase.PhaseData;
import phase.Stage2Baum;
import phase.Stage2Haps;

public class PhaseLS {
    private PhaseLS() {
    }

    public static void runStage1(PhaseData phaseData) {
        Serializable serializable;
        Par par = phaseData.fpd().par();
        int n = phaseData.it();
        int n2 = par.nthreads();
        int n3 = phaseData.fpd().targGT().nSamples();
        int n4 = par.burnin();
        PbwtPhaseIbs pbwtPhaseIbs = PhaseLS.pbwtPhaseIbs(phaseData);
        if (par.em()) {
            serializable = new Random(phaseData.seed());
            if (n == 0) {
                PhaseLS.initializeParameters(pbwtPhaseIbs, (Random)serializable);
            } else if (n < n4) {
                PhaseLS.updateParameters(pbwtPhaseIbs, (Random)serializable);
            }
        }
        serializable = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n2);
        for (int i = 0; i < n2; ++i) {
            executorService.submit(() -> PhaseLS.lambda$runStage1$0(pbwtPhaseIbs, (AtomicInteger)serializable, n3));
        }
        MultiThreadUtils.shutdownExecService(executorService);
    }

    private static PbwtPhaseIbs pbwtPhaseIbs(PhaseData phaseData) {
        boolean bl = (phaseData.it() & 1) == 0;
        return new PbwtPhaseIbs(phaseData, phaseData.codedSteps(), bl);
    }

    private static void initializeParameters(PbwtPhaseIbs pbwtPhaseIbs, Random random) {
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        float f = phaseData.recombIntensity();
        int n = 15;
        for (int i = 0; i < n; ++i) {
            PhaseLS.updateParameters(pbwtPhaseIbs, random);
            float f2 = phaseData.recombIntensity();
            if ((double)Math.abs(f2 - f) <= 0.1 * (double)f) break;
            f = f2;
        }
    }

    private static void updateParameters(PbwtPhaseIbs pbwtPhaseIbs, Random random) {
        ParamEstimates paramEstimates = PhaseLS.getParamEst(pbwtPhaseIbs, random);
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        float f = phaseData.pMismatch();
        float f2 = paramEstimates.pMismatch();
        float f3 = paramEstimates.recombIntensity();
        if (Float.isFinite(f2) && f2 > f) {
            phaseData.updatePMismatch(f2);
        }
        if (Float.isFinite(f3) && f3 > 0.0f) {
            phaseData.updateRecombIntensity(f3);
        }
    }

    private static ParamEstimates getParamEst(PbwtPhaseIbs pbwtPhaseIbs, Random random) {
        ParamEstimates paramEstimates = new ParamEstimates();
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        int[] nArray = PhaseLS.samplesToAnalyze(phaseData, random);
        int n = Math.min(fixedPhaseData.par().nthreads(), nArray.length);
        double d = 20000.0 / (double)n;
        int n2 = 50;
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    HmmParamData hmmParamData = new HmmParamData(pbwtPhaseIbs);
                    int n2 = atomicInteger.getAndIncrement();
                    while ((hmmParamData.sumSwitchProbs() < d || n2 < n2) && n2 < nArray.length) {
                        hmmParamData.update(nArray[n2]);
                        n2 = atomicInteger.getAndIncrement();
                        hmmParamData.addEstimationData(paramEstimates);
                    }
                }
                catch (Throwable throwable) {
                    Utilities.exit(throwable);
                }
            });
        }
        MultiThreadUtils.shutdownExecService(executorService);
        return paramEstimates;
    }

    private static int[] samplesToAnalyze(PhaseData phaseData, Random random) {
        int n = 500;
        int n2 = phaseData.fpd().targGT().nSamples();
        int[] nArray = IntStream.range(0, n2).parallel().toArray();
        if (n2 <= n) {
            return nArray;
        }
        Utilities.shuffle(nArray, n, random);
        return Arrays.copyOf(nArray, n);
    }

    public static Stage2Haps runStage2(PhaseData phaseData) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        int n = fixedPhaseData.par().nthreads();
        int n2 = fixedPhaseData.targGT().nSamples();
        LowFreqPhaseIbs lowFreqPhaseIbs = new LowFreqPhaseIbs(phaseData);
        Stage2Haps stage2Haps = new Stage2Haps(phaseData);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    Stage2Baum stage2Baum = new Stage2Baum(lowFreqPhaseIbs, stage2Haps);
                    int n2 = atomicInteger.getAndIncrement();
                    while (n2 < n2) {
                        stage2Baum.phase(n2);
                        n2 = atomicInteger.getAndIncrement();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.exit(throwable);
                }
            });
        }
        MultiThreadUtils.shutdownExecService(executorService);
        return stage2Haps;
    }

    private static /* synthetic */ void lambda$runStage1$0(PbwtPhaseIbs pbwtPhaseIbs, AtomicInteger atomicInteger, int n) {
        try {
            PhaseBaum1 phaseBaum1 = new PhaseBaum1(pbwtPhaseIbs);
            int n2 = atomicInteger.getAndIncrement();
            while (n2 < n) {
                phaseBaum1.phase(n2);
                n2 = atomicInteger.getAndIncrement();
            }
        }
        catch (Throwable throwable) {
            Utilities.exit(throwable);
        }
    }
}

