/*
 * Decompiled with CFR 0.152.
 */
package phase;

import beagleutil.PbwtDivUpdater;
import ints.IndexArray;
import ints.WrappedIntArray;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import phase.CodedSteps;
import phase.FixedPhaseData;
import phase.Ibs2;
import phase.PbwtIbsData;
import phase.PhaseData;
import vcf.Steps;
import vcf.XRefGT;

public final class PbwtPhaseIbs {
    private final PhaseData phaseData;
    private final XRefGT allHaps;
    private final WrappedIntArray[] ibsHaps;

    public PbwtPhaseIbs(PhaseData phaseData, CodedSteps codedSteps, boolean bl) {
        PbwtPhaseIbs.checkConsistency(phaseData, codedSteps);
        this.phaseData = phaseData;
        this.allHaps = codedSteps.allHaps();
        PbwtIbsData pbwtIbsData = new PbwtIbsData(phaseData, codedSteps);
        this.ibsHaps = bl ? (WrappedIntArray[])IntStream.range(0, pbwtIbsData.nBatches()).parallel().mapToObj(n -> this.bwdIbsHaps(pbwtIbsData, n)).flatMap(wrappedIntArrayArray -> Arrays.stream(wrappedIntArrayArray)).toArray(WrappedIntArray[]::new) : (WrappedIntArray[])IntStream.range(0, pbwtIbsData.nBatches()).parallel().mapToObj(n -> this.fwdIbsHaps(pbwtIbsData, n)).flatMap(wrappedIntArrayArray -> Arrays.stream(wrappedIntArrayArray)).toArray(WrappedIntArray[]::new);
    }

    private static void checkConsistency(PhaseData phaseData, CodedSteps codedSteps) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        if (fixedPhaseData.stage1Steps() != codedSteps.steps() || fixedPhaseData.stage1XRefGT() != codedSteps.refHaps() || fixedPhaseData.targGT().samples() != codedSteps.targSamples()) {
            throw new IllegalArgumentException("inconsistent data");
        }
    }

    private WrappedIntArray[] bwdIbsHaps(PbwtIbsData pbwtIbsData, int n) {
        IndexArray indexArray;
        int n3;
        int n4 = pbwtIbsData.codedSteps().steps().size();
        int n5 = n * pbwtIbsData.stepsPerBatch();
        int n6 = Math.min(n5 + pbwtIbsData.stepsPerBatch(), n4);
        int n7 = Math.min(n6 + pbwtIbsData.nOverlapSteps(), n4);
        assert (n5 < n4);
        WrappedIntArray[] wrappedIntArrayArray = new WrappedIntArray[n6 - n5];
        int n8 = pbwtIbsData.nHaps();
        PbwtDivUpdater pbwtDivUpdater = new PbwtDivUpdater(n8);
        int[] nArray = IntStream.range(0, n8).toArray();
        int[] nArray2 = IntStream.range(0, n8 + 1).map(n2 -> n7 - 1).toArray();
        for (n3 = n7 - 1; n3 >= n6; --n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.bwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
        }
        for (n3 = n6 - 1; n3 >= n5; --n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.bwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
            wrappedIntArrayArray[n3 - n5] = this.getBwdIbsHaps(n3, nArray, nArray2, pbwtIbsData);
        }
        return wrappedIntArrayArray;
    }

    private WrappedIntArray[] fwdIbsHaps(PbwtIbsData pbwtIbsData, int n) {
        IndexArray indexArray;
        int n3;
        int n4 = pbwtIbsData.codedSteps().steps().size();
        int n5 = n * pbwtIbsData.stepsPerBatch();
        int n6 = Math.min(n5 + pbwtIbsData.stepsPerBatch(), n4);
        int n7 = Math.max(0, n5 - pbwtIbsData.nOverlapSteps());
        assert (n5 < n4);
        WrappedIntArray[] wrappedIntArrayArray = new WrappedIntArray[n6 - n5];
        int n8 = pbwtIbsData.nHaps();
        PbwtDivUpdater pbwtDivUpdater = new PbwtDivUpdater(n8);
        int[] nArray = IntStream.range(0, n8).toArray();
        int[] nArray2 = IntStream.range(0, n8 + 1).map(n2 -> n7).toArray();
        for (n3 = n7; n3 < n5; ++n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.fwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
        }
        for (n3 = n5; n3 < n6; ++n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.fwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
            wrappedIntArrayArray[n3 - n5] = this.getfwdIbsHaps(n3, nArray, nArray2, pbwtIbsData);
        }
        return wrappedIntArrayArray;
    }

    private WrappedIntArray getBwdIbsHaps(int n, int[] nArray, int[] nArray2, PbwtIbsData pbwtIbsData) {
        Random random = new Random(this.phaseData.seed() + (long)n);
        int n2 = pbwtIbsData.codedSteps().steps().start(n);
        int n3 = pbwtIbsData.codedSteps().steps().end(n) - 1;
        int[] nArray3 = new int[pbwtIbsData.nTargHaps()];
        Ibs2 ibs2 = this.phaseData.fpd().stage1Ibs2();
        int n4 = n - 2;
        nArray2[nArray.length] = n4;
        nArray2[0] = n4;
        block0: for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= pbwtIbsData.nTargHaps()) continue;
            int n5 = nArray[i];
            int n6 = n5 >> 1;
            int n7 = i;
            int n8 = i + 1;
            int n9 = nArray2[n7];
            int n10 = nArray2[n8];
            while (n8 - n7 < pbwtIbsData.nCandidates() && (n <= n9 || n <= n10)) {
                if (n9 <= n10) {
                    n10 = Math.min(nArray2[++n8], n10);
                    continue;
                }
                n9 = Math.min(nArray2[--n7], n9);
            }
            int n11 = n8 - n7;
            nArray3[n5] = -1;
            if (n11 <= 1) continue;
            int n12 = n7 + random.nextInt(n11);
            int n13 = 0;
            while (n13 < n11) {
                if (n12 == n8) {
                    n12 = n7;
                }
                if (n12 != i && !ibs2.areIbs2(n6, nArray[n12] >> 1, n2, n3)) {
                    nArray3[n5] = nArray[n12];
                    continue block0;
                }
                ++n13;
                ++n12;
            }
        }
        return new WrappedIntArray(nArray3);
    }

    private WrappedIntArray getfwdIbsHaps(int n, int[] nArray, int[] nArray2, PbwtIbsData pbwtIbsData) {
        Steps steps = this.phaseData.fpd().stage1Steps();
        Random random = new Random(this.phaseData.seed() + (long)n);
        int n2 = this.phaseData.fpd().targGT().nHaps();
        int n3 = steps.start(n);
        int n4 = steps.end(n) - 1;
        int[] nArray3 = new int[n2];
        Ibs2 ibs2 = this.phaseData.fpd().stage1Ibs2();
        int n5 = n + 2;
        nArray2[nArray.length] = n5;
        nArray2[0] = n5;
        block0: for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n2) continue;
            int n6 = nArray[i];
            int n7 = n6 >> 1;
            int n8 = i;
            int n9 = i + 1;
            int n10 = nArray2[n8];
            int n11 = nArray2[n9];
            while (n9 - n8 < pbwtIbsData.nCandidates() && (n10 <= n || n11 <= n)) {
                if (n11 <= n10) {
                    n11 = Math.max(nArray2[++n9], n11);
                    continue;
                }
                n10 = Math.max(nArray2[--n8], n10);
            }
            int n12 = n9 - n8;
            nArray3[n6] = -1;
            if (n12 <= 1) continue;
            int n13 = n8 + random.nextInt(n12);
            int n14 = 0;
            while (n14 < n12) {
                if (n13 == n9) {
                    n13 = n8;
                }
                if (n13 != i && !ibs2.areIbs2(n7, nArray[n13] >> 1, n3, n4)) {
                    nArray3[n6] = nArray[n13];
                    continue block0;
                }
                ++n14;
                ++n13;
            }
        }
        return new WrappedIntArray(nArray3);
    }

    public PhaseData phaseData() {
        return this.phaseData;
    }

    public XRefGT allHaps() {
        return this.allHaps;
    }

    public int ibsHap(int n, int n2) {
        return this.ibsHaps[n2].get(n);
    }
}

