/*
 * Decompiled with CFR 0.152.
 */
package phase;

import java.util.concurrent.ConcurrentLinkedQueue;

public class ParamEstimates {
    private final ConcurrentLinkedQueue<RecombData> switchData = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<MismatchData> mismatchData = new ConcurrentLinkedQueue();

    public void addMismatchData(int n, double d) {
        if (n > 0 && d > 0.0 && Double.isFinite(d)) {
            this.mismatchData.add(new MismatchData(n, d));
        }
    }

    public void addSwitchData(double d, double d2) {
        if (d > 0.0 && d2 > 0.0 && Double.isFinite(d) && Double.isFinite(d2)) {
            this.switchData.add(new RecombData(d, d2));
        }
    }

    public float pMismatch() {
        MismatchData[] mismatchDataArray = (MismatchData[])this.mismatchData.stream().sorted().toArray(MismatchData[]::new);
        long l = 0L;
        double d = 0.0;
        for (MismatchData mismatchData : mismatchDataArray) {
            l += (long)mismatchData.markerCnt;
            d += mismatchData.pMismatchSum;
        }
        return l == 0L ? Float.NaN : (float)(d / (double)l);
    }

    public float recombIntensity() {
        RecombData[] recombDataArray = (RecombData[])this.switchData.stream().sorted().toArray(RecombData[]::new);
        double d = 0.0;
        double d2 = 0.0;
        for (RecombData recombData : recombDataArray) {
            d += recombData.switchProb;
            d2 += recombData.genDistance;
        }
        return d2 == 0.0 ? Float.NaN : (float)(d / d2);
    }

    public void clear() {
        this.switchData.clear();
        this.mismatchData.clear();
    }

    private static class MismatchData
    implements Comparable<MismatchData> {
        private final int markerCnt;
        private final double pMismatchSum;

        public MismatchData(int n, double d) {
            this.markerCnt = n;
            this.pMismatchSum = d;
        }

        @Override
        public int compareTo(MismatchData mismatchData) {
            int n = Double.compare(this.pMismatchSum, mismatchData.pMismatchSum);
            return n != 0 ? n : Integer.compare(this.markerCnt, mismatchData.markerCnt);
        }
    }

    private static class RecombData
    implements Comparable<RecombData> {
        private final double genDistance;
        private final double switchProb;

        public RecombData(double d, double d2) {
            this.genDistance = d;
            this.switchProb = d2;
        }

        @Override
        public int compareTo(RecombData recombData) {
            int n = Double.compare(this.genDistance, recombData.genDistance);
            return n != 0 ? n : Double.compare(this.switchProb, recombData.switchProb);
        }
    }
}

