/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.DoubleArray;
import blbutil.FloatArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import phase.Ibs2Markers;
import phase.Ibs2Sets;
import phase.SampleSeg;
import vcf.GT;
import vcf.MarkerMap;

public final class Ibs2 {
    private static final float MIN_IBS2_CM = 2.0f;
    private static final float MAX_IBD_GAP_CM = 4.0f;
    private static final Comparator<SampleSeg> sampComparator = SampleSeg.sampleComp();
    private final int nMarkers;
    private final SampleSeg[][] sampleSegs;

    public Ibs2(GT gT, MarkerMap markerMap, FloatArray floatArray) {
        Ibs2Markers ibs2Markers = new Ibs2Markers(gT, markerMap, floatArray);
        Ibs2Sets ibs2Sets = new Ibs2Sets(gT, ibs2Markers);
        DoubleArray doubleArray = markerMap.genPos();
        this.nMarkers = gT.nMarkers();
        this.sampleSegs = (SampleSeg[][])IntStream.range(0, gT.nSamples()).parallel().mapToObj(n -> Ibs2.ibs2Segments(gT, doubleArray, ibs2Sets, n)).toArray(n -> new SampleSeg[n][]);
    }

    private static SampleSeg[] ibs2Segments(GT gT, DoubleArray doubleArray, Ibs2Sets ibs2Sets, int n) {
        SampleSeg[] sampleSegArray = ibs2Sets.segList(n);
        Arrays.sort(sampleSegArray, sampComparator);
        sampleSegArray = Ibs2.mergeSegments(sampleSegArray, doubleArray);
        sampleSegArray = Ibs2.extendSegments(gT, n, sampleSegArray);
        sampleSegArray = Ibs2.mergeSegments(sampleSegArray, doubleArray);
        return Ibs2.applyLengthFilter(sampleSegArray, doubleArray);
    }

    private static SampleSeg[] mergeSegments(SampleSeg[] sampleSegArray, DoubleArray doubleArray) {
        if (sampleSegArray.length < 2) {
            return sampleSegArray;
        }
        ArrayList<SampleSeg> arrayList = new ArrayList<SampleSeg>();
        SampleSeg sampleSeg = sampleSegArray[0];
        for (int i = 1; i < sampleSegArray.length; ++i) {
            SampleSeg sampleSeg2 = sampleSegArray[i];
            if (sampleSeg.sample() == sampleSeg2.sample() && Ibs2.gapCM(sampleSeg, sampleSeg2, doubleArray) <= 4.0) {
                assert (sampleSeg.inclEnd() <= sampleSeg2.inclEnd());
                sampleSeg = new SampleSeg(sampleSeg.sample(), sampleSeg.start(), sampleSeg2.inclEnd());
                continue;
            }
            arrayList.add(sampleSeg);
            sampleSeg = sampleSeg2;
        }
        arrayList.add(sampleSeg);
        return arrayList.toArray(new SampleSeg[0]);
    }

    private static double gapCM(SampleSeg sampleSeg, SampleSeg sampleSeg2, DoubleArray doubleArray) {
        return doubleArray.get(sampleSeg2.start()) - doubleArray.get(sampleSeg.inclEnd());
    }

    private static SampleSeg[] extendSegments(GT gT, int n, SampleSeg[] sampleSegArray) {
        return (SampleSeg[])Arrays.stream(sampleSegArray).map(sampleSeg -> Ibs2.extend(gT, n, sampleSeg)).toArray(SampleSeg[]::new);
    }

    private static SampleSeg extend(GT gT, int n, SampleSeg sampleSeg) {
        int n2;
        int n3 = gT.nMarkers();
        int n4 = sampleSeg.sample();
        int n5 = sampleSeg.inclEnd() + 1;
        for (n2 = sampleSeg.start(); n2 > 0 && Ibs2.ibs2(gT, n2 - 1, n, n4); --n2) {
        }
        while (n5 < n3 && Ibs2.ibs2(gT, n5, n, n4)) {
            ++n5;
        }
        return new SampleSeg(n4, n2, n5 - 1);
    }

    private static boolean ibs2(GT gT, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = gT.allele1(n, n2);
        return Ibs2.arePhaseConsistent(n7, n6 = gT.allele2(n, n2), n5 = gT.allele1(n, n3), n4 = gT.allele2(n, n3)) || Ibs2.arePhaseConsistent(n7, n6, n4, n5);
    }

    private static boolean arePhaseConsistent(int n, int n2, int n3, int n4) {
        return !(n >= 0 && n3 >= 0 && n != n3 || n2 >= 0 && n4 >= 0 && n2 != n4);
    }

    private static SampleSeg[] applyLengthFilter(SampleSeg[] sampleSegArray, DoubleArray doubleArray) {
        Predicate<SampleSeg> predicate = sampleSeg -> doubleArray.get(sampleSeg.inclEnd()) - doubleArray.get(sampleSeg.start()) >= 2.0;
        return (SampleSeg[])Arrays.stream(sampleSegArray).filter(predicate).toArray(SampleSeg[]::new);
    }

    public int nMarkers() {
        return this.nMarkers;
    }

    public int nTargSamples() {
        return this.sampleSegs.length;
    }

    public int nIbs2Segments(int n) {
        return this.sampleSegs[n].length;
    }

    public boolean areIbs2(int n, int n2, int n3) {
        if (n >= this.sampleSegs.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 < 0 || n3 >= this.nMarkers) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        if (n == n2) {
            return true;
        }
        if (this.sampleSegs[n].length > 0 && n2 < this.sampleSegs.length) {
            for (SampleSeg sampleSeg : this.sampleSegs[n]) {
                if (sampleSeg.sample() != n2 || sampleSeg.start() > n3 || n3 > sampleSeg.inclEnd()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areIbs2(int n, int n2, int n3, int n4) {
        boolean bl;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl2 = bl = n == n2;
        if (this.sampleSegs[n].length == 0 || bl) {
            return bl;
        }
        for (SampleSeg sampleSeg : this.sampleSegs[n]) {
            if (sampleSeg.sample() != n2 || n3 > sampleSeg.inclEnd() || sampleSeg.start() > n4) continue;
            return true;
        }
        return false;
    }
}

