/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.BitArray;
import java.util.stream.IntStream;
import phase.FixedPhaseData;
import phase.PbwtRecPhaser;
import phase.RevPbwtPhaser;
import vcf.GT;

public class FwdPbwtPhaser {
    private final GT targGT;
    private final int start;
    private final int end;
    private final int[] bitsPerAllele;
    private final BitArray[] markerToBits;

    public FwdPbwtPhaser(FixedPhaseData fixedPhaseData, int n2, int n3, long l) {
        if (n2 < 0 || n3 > fixedPhaseData.targGT().nMarkers() || n2 >= n3) {
            throw new IllegalArgumentException(String.valueOf(n2));
        }
        this.targGT = fixedPhaseData.stage1TargGT();
        this.start = n2;
        this.end = n3;
        this.bitsPerAllele = IntStream.range(n2, n3).map(n -> this.targGT.markers().marker(n).bitsPerAllele()).toArray();
        this.markerToBits = FwdPbwtPhaser.phase(fixedPhaseData, n2, n3, l);
    }

    private static BitArray[] phase(FixedPhaseData fixedPhaseData, int n2, int n3, long l) {
        int n4 = fixedPhaseData.stage1Overlap();
        GT gT = fixedPhaseData.stage1TargGT();
        PbwtRecPhaser pbwtRecPhaser = new PbwtRecPhaser(fixedPhaseData);
        RevPbwtPhaser revPbwtPhaser = new RevPbwtPhaser(fixedPhaseData, n2, n3, l);
        boolean[] blArray = new boolean[gT.nSamples()];
        boolean[] blArray2 = new boolean[gT.nSamples()];
        int[] nArray = IntStream.range(0, gT.nSamples()).map(n -> -1).toArray();
        int[] nArray2 = new int[fixedPhaseData.nHaps()];
        BitArray[] bitArrayArray = new BitArray[n3 - n2];
        int n5 = -1;
        int n6 = n2;
        while (n6 < n3) {
            pbwtRecPhaser.phase(n5, nArray2, n6, blArray, blArray2);
            if (n6 >= n4) {
                FwdPbwtPhaser.finishPhasing(bitArrayArray, revPbwtPhaser, n2, n6, nArray2, nArray, blArray2);
            }
            bitArrayArray[n6 - n2] = FwdPbwtPhaser.storePhasing(gT, n6, nArray2);
            FwdPbwtPhaser.updateLastHet(nArray2, blArray, nArray, n6);
            n5 = n6++;
        }
        return bitArrayArray;
    }

    private static void finishPhasing(BitArray[] bitArrayArray, RevPbwtPhaser revPbwtPhaser, int n, int n2, int[] nArray, int[] nArray2, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            int n3 = i << 1;
            int n4 = n3 | 1;
            if (blArray[i]) {
                int n5 = nArray2[i];
                if (n5 >= 0) {
                    boolean bl;
                    int n6 = revPbwtPhaser.allele(n5, n3);
                    int n7 = revPbwtPhaser.allele(n5, n4);
                    int n8 = revPbwtPhaser.allele(n2, n3);
                    int n9 = revPbwtPhaser.allele(n2, n4);
                    boolean bl2 = n6 < n7 == n8 < n9;
                    int n10 = revPbwtPhaser.bitsPerAllele(n5);
                    int n11 = FwdPbwtPhaser.allele(bitArrayArray[n5 - n], n3, n10);
                    int n12 = FwdPbwtPhaser.allele(bitArrayArray[n5 - n], n4, n10);
                    boolean bl3 = bl = n11 < n12 == nArray[n3] < nArray[n4];
                    if (bl2 != bl) {
                        int n13 = nArray[n3];
                        nArray[n3] = nArray[n4];
                        nArray[n4] = n13;
                    }
                }
                blArray[i] = false;
                continue;
            }
            if (nArray[n3] == -1) {
                nArray[n3] = FwdPbwtPhaser.imputeAllele(bitArrayArray, revPbwtPhaser, n, nArray2[i], n2, n3);
            }
            if (nArray[n4] != -1) continue;
            nArray[n4] = FwdPbwtPhaser.imputeAllele(bitArrayArray, revPbwtPhaser, n, nArray2[i], n2, n4);
        }
    }

    private static int imputeAllele(BitArray[] bitArrayArray, RevPbwtPhaser revPbwtPhaser, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (n2 < 0) {
            return revPbwtPhaser.allele(n3, n4);
        }
        int n9 = n4 ^ 1;
        int n10 = revPbwtPhaser.allele(n2, n4);
        if (n10 < (n8 = revPbwtPhaser.allele(n2, n9)) == (n7 = FwdPbwtPhaser.allele(bitArrayArray[n2 - n], n4, n6 = revPbwtPhaser.bitsPerAllele(n2))) < (n5 = FwdPbwtPhaser.allele(bitArrayArray[n2 - n], n9, n6))) {
            return revPbwtPhaser.allele(n3, n4);
        }
        return revPbwtPhaser.allele(n3, n9);
    }

    private static BitArray storePhasing(GT gT, int n, int[] nArray) {
        int n2 = gT.nHaps();
        int n3 = gT.markers().marker(n).bitsPerAllele();
        BitArray bitArray = new BitArray(gT.nHaps() * n3);
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 1;
            int n6 = 0;
            while (n6 < n3) {
                if ((nArray[i] & n5) == n5) {
                    bitArray.set(n4);
                }
                n5 <<= 1;
                ++n6;
                ++n4;
            }
        }
        return bitArray;
    }

    private static void updateLastHet(int[] nArray, boolean[] blArray, int[] nArray2, int n) {
        for (int i = 0; i < blArray.length; ++i) {
            int n2 = i << 1;
            int n3 = n2 | 1;
            if (blArray[i] || nArray[n2] == nArray[n3]) continue;
            nArray2[i] = n;
        }
    }

    private static int allele(BitArray bitArray, int n, int n2) {
        int n3 = n * n2;
        if (n2 == 1) {
            return bitArray.get(n3) ? 1 : 0;
        }
        int n4 = n3 + n2;
        int n5 = 0;
        int n6 = 1;
        for (int i = n3; i < n4; ++i) {
            if (bitArray.get(i)) {
                n5 |= n6;
            }
            n6 <<= 1;
        }
        return n5;
    }

    public GT targGT() {
        return this.targGT;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int allele(int n, int n2) {
        int n3 = n - this.start;
        return FwdPbwtPhaser.allele(this.markerToBits[n3], n2, this.bitsPerAllele[n3]);
    }
}

