/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.DoubleArray;
import blbutil.FloatArray;
import blbutil.Utilities;
import ints.IntArray;
import ints.WrappedIntArray;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.stream.IntStream;
import main.Par;
import main.Pedigree;
import phase.Ibs2;
import vcf.BasicGT;
import vcf.GT;
import vcf.GeneticMap;
import vcf.MarkerMap;
import vcf.Markers;
import vcf.RefGT;
import vcf.SplicedGT;
import vcf.Steps;
import vcf.Window;
import vcf.XRefGT;

public class FixedPhaseData {
    private static final float MAX_HIFREQ_PROP = 0.75f;
    private final Par par;
    private final Pedigree ped;
    private final int window;
    private final MarkerMap map;
    private final Steps stage1Steps;
    private final GT targGT;
    private final Optional<RefGT> refGT;
    private final int overlap;
    private final MarkerMap stage1Map;
    private final float ibsStep;
    private final GT stage1TargGT;
    private final Optional<RefGT> stage1RefGT;
    private final Optional<XRefGT> stage1XRefGT;
    private final FloatArray stage1Maf;
    private final int stage1Overlap;
    private final Ibs2 stage1Ibs2;
    private final int nHaps;
    private final IntArray[][] carriers;
    private final IntArray stage1To2;
    private final int[] prevStage1Marker;
    private final float[] prevStage1Wt;

    public FixedPhaseData(Par par, Pedigree pedigree, Window window, GT gT) {
        Object object;
        FixedPhaseData.checkData(window, gT);
        int n = window.targGT().nMarkers();
        this.par = par;
        this.ped = pedigree;
        this.window = window.windowIndex();
        this.map = FixedPhaseData.markerMap(window.genMap(), window.targGT().markers());
        this.targGT = gT == null ? window.targGT() : new SplicedGT(gT, window.targGT());
        this.refGT = window.restrictRefGT();
        this.overlap = gT == null ? 0 : gT.nMarkers();
        this.nHaps = FixedPhaseData.nHaps(window);
        IntArray[][] intArrayArray = FixedPhaseData.carriers(par, window);
        int[] nArray = FixedPhaseData.hiFreqIndices(intArrayArray);
        if (nArray.length < 2 || (float)nArray.length > 0.75f * (float)n) {
            nArray = IntStream.range(0, n).toArray();
            FixedPhaseData.ignoreLowFreqCarriers(intArrayArray);
            this.carriers = intArrayArray;
            this.stage1Map = this.map;
            this.ibsStep = par.step_scale() * FixedPhaseData.medianDiff(this.stage1Map.genPos());
            this.stage1Steps = new Steps(this.stage1Map, this.ibsStep);
            this.stage1TargGT = this.targGT;
            this.stage1RefGT = this.refGT;
            this.stage1XRefGT = this.stage1RefGT.isPresent() ? Optional.of(XRefGT.fromPhasedGT(this.stage1RefGT.get(), par.nthreads())) : Optional.empty();
            this.stage1Overlap = this.overlap;
            this.stage1To2 = new WrappedIntArray(nArray);
            this.prevStage1Marker = IntStream.range(0, this.targGT.nMarkers()).parallel().toArray();
            object = new float[this.targGT.nMarkers()];
            Arrays.fill((float[])object, 1.0f);
            this.prevStage1Wt = (float[])object;
        } else {
            object = this.targGT.markers().restrict(nArray);
            this.carriers = intArrayArray;
            this.stage1Map = this.map.restrict(nArray);
            this.ibsStep = par.step_scale() * FixedPhaseData.medianDiff(this.stage1Map.genPos());
            this.stage1Steps = new Steps(this.stage1Map, this.ibsStep);
            this.stage1TargGT = this.targGT.restrict((Markers)object, nArray);
            this.stage1RefGT = FixedPhaseData.restrict(this.refGT, (Markers)object, nArray);
            this.stage1XRefGT = this.stage1RefGT.isPresent() ? Optional.of(XRefGT.fromPhasedGT(this.stage1RefGT.get(), par.nthreads())) : Optional.empty();
            this.stage1Overlap = FixedPhaseData.stage1TargOverlap(gT, nArray);
            this.stage1To2 = new WrappedIntArray(nArray);
            this.prevStage1Marker = FixedPhaseData.prevStage1Marker(this.targGT.nMarkers(), this.stage1To2);
            this.prevStage1Wt = FixedPhaseData.prevWt(this.map, this.stage1To2);
        }
        int n2 = 10000;
        this.stage1Maf = FixedPhaseData.maf(this.stage1RefGT, this.stage1TargGT, n2, par.seed());
        this.stage1Ibs2 = new Ibs2(this.stage1TargGT, this.stage1Map, this.stage1Maf);
    }

    private static MarkerMap markerMap(GeneticMap geneticMap, Markers markers) {
        double d = MarkerMap.meanSingleBaseGenDist(geneticMap, markers);
        return MarkerMap.create(geneticMap, d, markers);
    }

    private static Optional<RefGT> restrict(Optional<RefGT> optional, Markers markers, int[] nArray) {
        if (optional.isPresent()) {
            return Optional.of(optional.get().restrict(markers, nArray));
        }
        return optional;
    }

    private static void ignoreLowFreqCarriers(IntArray[][] intArrayArray) {
        for (int i = 0; i < intArrayArray.length; ++i) {
            Arrays.fill(intArrayArray[i], Window.HIGH_FREQ_ARRAY);
        }
    }

    private static float medianDiff(DoubleArray doubleArray) {
        double[] dArray = IntStream.range(1, doubleArray.size()).parallel().mapToDouble(n -> doubleArray.get(n) - doubleArray.get(n - 1)).sorted().toArray();
        int n2 = dArray.length;
        return 0.5f * (float)(dArray[n2 - 1 >> 1] + dArray[n2 >> 1]);
    }

    private static void checkData(Window window, GT gT) {
        if (gT != null) {
            BasicGT basicGT = window.targGT();
            if (!gT.isPhased()) {
                throw new IllegalArgumentException("unphased");
            }
            if (!basicGT.samples().equals(gT.samples())) {
                throw new IllegalArgumentException("inconsistent data");
            }
            if (gT.nMarkers() > basicGT.nMarkers()) {
                throw new IllegalArgumentException("inconsistent data");
            }
            int n = gT.nMarkers();
            for (int i = 0; i < n; ++i) {
                if (gT.marker(i).equals(basicGT.marker(i))) continue;
                throw new IllegalArgumentException("inconsistent data");
            }
        }
    }

    private static int nHaps(Window window) {
        Optional<RefGT> optional = window.refGT();
        int n = optional.isPresent() ? optional.get().nHaps() : 0;
        return window.targGT().nHaps() + n;
    }

    private static IntArray[][] carriers(Par par, Window window) {
        Optional<RefGT> optional = window.refGT();
        int n = optional.isPresent() ? optional.get().nSamples() : 0;
        int n2 = window.targGT().nSamples() + n;
        int n3 = Math.max(3, (int)Math.floor((float)n2 * par.rare()));
        return window.carriers(n3);
    }

    private static int[] hiFreqIndices(IntArray[][] intArrayArray) {
        return IntStream.range(0, intArrayArray.length).parallel().filter(n -> 1L < Arrays.stream(intArrayArray[n]).filter(intArray -> intArray == Window.HIGH_FREQ_ARRAY).count()).toArray();
    }

    private static FloatArray maf(Optional<RefGT> optional, GT gT, int n2, long l) {
        int[] nArray;
        Random random = new Random(l);
        int[] nArray2 = FixedPhaseData.randHaps(gT, n2, random);
        if (nArray2.length < n2 && optional.isPresent()) {
            int n3 = n2 - nArray2.length;
            nArray = FixedPhaseData.randHaps(optional.get(), n3, random);
        } else {
            nArray = new int[]{};
        }
        double[] dArray = IntStream.range(0, gT.nMarkers()).parallel().mapToDouble(n -> FixedPhaseData.maf(gT, optional, nArray2, nArray, n)).toArray();
        return new FloatArray(dArray);
    }

    private static int[] randHaps(GT gT, int n, Random random) {
        int n2 = gT.nHaps();
        int[] nArray = IntStream.range(0, n2).parallel().toArray();
        if (n2 > n) {
            Utilities.shuffle(nArray, n, random);
            nArray = Arrays.copyOf(nArray, n);
            Arrays.sort(nArray);
        }
        return nArray;
    }

    private static double maf(GT gT, Optional<RefGT> optional, int[] nArray, int[] nArray2, int n) {
        int[] nArray3 = new int[gT.marker(n).nAlleles() + 1];
        Object object = nArray;
        int n2 = ((int[])object).length;
        for (int i = 0; i < n2; ++i) {
            int n3 = object[i];
            int n4 = gT.allele(n, n3) + 1;
            nArray3[n4] = nArray3[n4] + 1;
        }
        if (optional.isPresent() && nArray2.length > 0) {
            object = optional.get();
            for (int n5 : nArray2) {
                int n6 = ((RefGT)object).allele(n, n5) + 1;
                nArray3[n6] = nArray3[n6] + 1;
            }
        }
        nArray3[0] = 0;
        Arrays.sort(nArray3);
        int n7 = 0;
        for (n2 = 1; n2 < nArray3.length; ++n2) {
            n7 += nArray3[n2];
        }
        return n7 == 0 ? 0.0 : (double)nArray3[nArray3.length - 2] / (double)n7;
    }

    private static int stage1TargOverlap(GT gT, int[] nArray) {
        if (gT == null) {
            return 0;
        }
        int n = Arrays.binarySearch(nArray, gT.nMarkers());
        return n < 0 ? -n - 1 : n;
    }

    private static int[] prevStage1Marker(int n, IntArray intArray) {
        int[] nArray = new int[n];
        int n2 = intArray.size();
        int n3 = intArray.get(1);
        for (int i = 2; i < n2; ++i) {
            int n4 = intArray.get(i);
            Arrays.fill(nArray, n3, n4, i - 1);
            n3 = n4;
        }
        Arrays.fill(nArray, n3, n, n2 - 1);
        return nArray;
    }

    private static float[] prevWt(MarkerMap markerMap, IntArray intArray) {
        DoubleArray doubleArray = markerMap.genPos();
        float[] fArray = new float[doubleArray.size()];
        Arrays.fill(fArray, 0, intArray.get(0), 1.0f);
        int n = intArray.get(0);
        int n2 = intArray.size();
        for (int i = 1; i < n2; ++i) {
            int n3 = intArray.get(i);
            double d = doubleArray.get(n);
            double d2 = doubleArray.get(n3);
            double d3 = d2 - d;
            fArray[n] = 1.0f;
            for (int j = n + 1; j < n3; ++j) {
                fArray[j] = (float)((d2 - doubleArray.get(j)) / d3);
            }
            n = n3;
        }
        Arrays.fill(fArray, n, doubleArray.size(), 1.0f);
        return fArray;
    }

    public Par par() {
        return this.par;
    }

    public int window() {
        return this.window;
    }

    public Pedigree ped() {
        return this.ped;
    }

    public MarkerMap map() {
        return this.map;
    }

    public Optional<RefGT> refGT() {
        return this.refGT;
    }

    public GT targGT() {
        return this.targGT;
    }

    public int overlap() {
        return this.overlap;
    }

    public MarkerMap stage1Map() {
        return this.stage1Map;
    }

    public float ibsStep() {
        return this.ibsStep;
    }

    public Steps stage1Steps() {
        return this.stage1Steps;
    }

    public Optional<RefGT> stage1RefGT() {
        return this.stage1RefGT;
    }

    public Optional<XRefGT> stage1XRefGT() {
        return this.stage1XRefGT;
    }

    public GT stage1TargGT() {
        return this.stage1TargGT;
    }

    public FloatArray stage1Maf() {
        return this.stage1Maf;
    }

    public int stage1Overlap() {
        return this.stage1Overlap;
    }

    public int nHaps() {
        return this.nHaps;
    }

    public IntArray stage1To2() {
        return this.stage1To2;
    }

    public Ibs2 stage1Ibs2() {
        return this.stage1Ibs2;
    }

    public IntArray carriers(int n, int n2) {
        return this.carriers[n][n2];
    }

    public boolean isLowFreq(int n, int n2) {
        return this.carriers[n][n2] != Window.HIGH_FREQ_ARRAY;
    }

    public int prevStage1Marker(int n) {
        return this.prevStage1Marker[n];
    }

    public float prevStage1Wt(int n) {
        return this.prevStage1Wt[n];
    }
}

