/*
 * Decompiled with CFR 0.152.
 */
package phase;

import ints.IndexArray;
import ints.IntIntMap;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import phase.EstPhase;
import phase.FixedPhaseData;
import vcf.Samples;
import vcf.Steps;
import vcf.XRefGT;

public class CodedSteps {
    private final Samples targSamples;
    private final Optional<XRefGT> refHaps;
    private final XRefGT allHaps;
    private final Steps steps;
    private final IndexArray[] codedSteps;

    public CodedSteps(EstPhase estPhase) {
        FixedPhaseData fixedPhaseData = estPhase.fpd();
        XRefGT xRefGT = estPhase.phasedHaps();
        this.targSamples = xRefGT.samples();
        this.refHaps = fixedPhaseData.stage1XRefGT();
        this.allHaps = this.refHaps.isPresent() ? XRefGT.combine(xRefGT, this.refHaps.get()) : xRefGT;
        this.steps = fixedPhaseData.stage1Steps();
        this.codedSteps = CodedSteps.codedSteps(this.allHaps, this.steps, fixedPhaseData.par().nthreads());
    }

    private static IndexArray[] codedSteps(XRefGT xRefGT, Steps steps, int n) {
        int n3 = 512;
        int n4 = (steps.size() + n - 1) / n;
        while (n4 > n3) {
            n4 = n4 + 1 >> 1;
        }
        int n5 = n4;
        int n6 = (steps.size() + (n5 - 1)) / n5;
        return (IndexArray[])IntStream.range(0, n6).parallel().boxed().flatMap(n2 -> CodedSteps.codedSteps(xRefGT, steps, n2, n5)).toArray(IndexArray[]::new);
    }

    private static Stream<IndexArray> codedSteps(XRefGT xRefGT, Steps steps, int n2, int n3) {
        int n4 = -1;
        int n5 = n2 * n3;
        int n6 = Math.min(n5 + n3, steps.size());
        int n7 = n6 - n5;
        int[][] nArray = new int[n7][xRefGT.nHaps()];
        int[] nArray2 = new int[n7];
        IntIntMap[] intIntMapArray = (IntIntMap[])IntStream.range(0, n7).mapToObj(n -> new IntIntMap(8)).toArray(IntIntMap[]::new);
        int n8 = xRefGT.nHaps();
        for (int i = 0; i < n8; ++i) {
            int n9 = steps.start(n5);
            for (int j = 0; j < n7; ++j) {
                int n10 = steps.end(n5 + j);
                int n11 = xRefGT.hash(i, n9, n10);
                int n12 = intIntMapArray[j].get(n11, n4);
                if (n12 == n4) {
                    int n13 = j;
                    int n14 = nArray2[n13];
                    nArray2[n13] = n14 + 1;
                    n12 = n14;
                    intIntMapArray[j].put(n11, n12);
                }
                nArray[j][i] = n12;
                n9 = n10;
            }
        }
        return IntStream.range(0, n7).mapToObj(n -> new IndexArray(nArray[n], nArray2[n]));
    }

    public IndexArray get(int n) {
        return this.codedSteps[n];
    }

    public Samples targSamples() {
        return this.targSamples;
    }

    public Optional<XRefGT> refHaps() {
        return this.refHaps;
    }

    public XRefGT allHaps() {
        return this.allHaps;
    }

    public Steps steps() {
        return this.steps;
    }
}

