/*
 * Decompiled with CFR 0.152.
 */
package phase;

import beagleutil.CompHapSegment;
import blbutil.BitArray;
import blbutil.Utilities;
import ints.IntIntMap;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.stream.IntStream;
import phase.MarkerCluster;
import phase.PbwtPhaseIbs;
import phase.PhaseData;
import phase.SamplePhase;
import vcf.Markers;
import vcf.Steps;
import vcf.XRefGT;

public final class BasicPhaseStates {
    private static final int NIL = -103;
    private final PbwtPhaseIbs ibsHaps;
    private final PhaseData phaseData;
    private final Steps steps;
    private final XRefGT allHaps;
    private final Markers markers;
    private final int nMarkers;
    private final int maxStates;
    private final int minSteps;
    private final IntIntMap hapToEnd;
    private final PriorityQueue<CompHapSegment> q;
    private final BitArray[] compHaps;

    public BasicPhaseStates(PbwtPhaseIbs pbwtPhaseIbs, int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.ibsHaps = pbwtPhaseIbs;
        this.phaseData = pbwtPhaseIbs.phaseData();
        this.steps = this.phaseData.fpd().stage1Steps();
        this.allHaps = pbwtPhaseIbs.allHaps();
        this.markers = this.allHaps.markers();
        this.nMarkers = this.allHaps.nMarkers();
        this.maxStates = n;
        float f = this.phaseData.fpd().ibsStep();
        this.minSteps = Math.max(200, (int)Math.ceil(1.0f / f));
        this.hapToEnd = new IntIntMap(n);
        this.q = new PriorityQueue(n);
        int n3 = this.markers.sumHapBits();
        this.compHaps = (BitArray[])IntStream.range(0, n).mapToObj(n2 -> new BitArray(n3)).toArray(BitArray[]::new);
    }

    public int nTargSamples() {
        return this.phaseData.fpd().targGT().nSamples();
    }

    public int nMarkers() {
        return this.phaseData.fpd().targGT().nMarkers();
    }

    public int maxStates() {
        return this.maxStates;
    }

    public int ibsStates(int n, MarkerCluster markerCluster, List<int[]> list, byte[][][] byArray) {
        int n2 = this.setCompRefHaps(n);
        this.copyData(n, markerCluster, n2, list, byArray);
        return n2;
    }

    public int ibsStates(int n, byte[][][] byArray) {
        int n2 = this.setCompRefHaps(n);
        this.copyData(n, n2, byArray);
        return n2;
    }

    private int setCompRefHaps(int n) {
        int n2;
        int n3 = n << 1;
        int n4 = n3 | 1;
        this.q.clear();
        this.hapToEnd.clear();
        int n5 = this.steps.size();
        for (n2 = 0; n2 < n5; ++n2) {
            int n6;
            int n7 = this.ibsHaps.ibsHap(n3, n2);
            if (n7 >= 0) {
                this.addIbsHap(n7, n2);
            }
            if ((n6 = this.ibsHaps.ibsHap(n4, n2)) < 0) continue;
            this.addIbsHap(n6, n2);
        }
        if (this.q.isEmpty()) {
            this.fillQWithRandomHaps(n);
        }
        n2 = this.copyFinalRefSegs();
        return n2;
    }

    private void addIbsHap(int n, int n2) {
        if (this.hapToEnd.get(n, -103) == -103) {
            this.updateHeadOfQ();
            if (this.q.size() == this.maxStates || !this.q.isEmpty() && n2 - this.q.peek().ibsStep() >= this.minSteps) {
                CompHapSegment compHapSegment = this.q.poll();
                int n3 = compHapSegment.compHapIndex();
                int n4 = compHapSegment.hap();
                int n5 = compHapSegment.startMarker();
                int n6 = this.steps.start(compHapSegment.ibsStep() + n2 >>> 1);
                this.hapToEnd.remove(compHapSegment.hap());
                this.allHaps.copyTo(n4, n5, n6, this.compHaps[n3]);
                compHapSegment.updateSegment(n, n6, n2);
                this.q.offer(compHapSegment);
            } else {
                int n7 = this.q.size();
                int n8 = 0;
                this.q.offer(new CompHapSegment(n, n8, n2, n7));
            }
        }
        this.hapToEnd.put(n, n2);
    }

    private void updateHeadOfQ() {
        CompHapSegment compHapSegment = this.q.peek();
        if (compHapSegment != null) {
            int n = this.hapToEnd.get(compHapSegment.hap(), -103);
            while (compHapSegment.ibsStep() != n) {
                compHapSegment = this.q.poll();
                compHapSegment.updateStep(n);
                this.q.offer(compHapSegment);
                compHapSegment = this.q.peek();
                n = this.hapToEnd.get(compHapSegment.hap(), -103);
            }
        }
    }

    private int copyFinalRefSegs() {
        int n = this.q.size();
        CompHapSegment compHapSegment = this.q.poll();
        while (compHapSegment != null) {
            int n2 = compHapSegment.compHapIndex();
            int n3 = compHapSegment.hap();
            int n4 = compHapSegment.startMarker();
            this.allHaps.copyTo(n3, n4, this.nMarkers, this.compHaps[n2]);
            compHapSegment = this.q.poll();
        }
        return n;
    }

    private void copyData(int n, MarkerCluster markerCluster, int n2, List<int[]> list, byte[][][] byArray) {
        SamplePhase samplePhase = this.phaseData.estPhase().get(n);
        BitArray bitArray = samplePhase.hap1();
        BitArray bitArray2 = samplePhase.hap2();
        int n3 = 0;
        int n4 = markerCluster.nClusters();
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            Arrays.fill(byArray[0][i], 0, n2, (byte)0);
            Arrays.fill(byArray[1][i], 0, n2, (byte)0);
            Arrays.fill(byArray[2][i], 0, n2, (byte)0);
            int n7 = markerCluster.clusterStart(i);
            int n8 = markerCluster.clusterEnd(i);
            if (markerCluster.clustHasMissingGT(i)) {
                assert (n8 - n7 == 1);
                int[] nArray = list.get(n3++);
                for (n6 = 0; n6 < n2; ++n6) {
                    nArray[n6] = this.markers.allele(this.compHaps[n6], n7);
                }
                continue;
            }
            int n9 = this.markers.sumHapBits(n7);
            if (bitArray.equal(bitArray2, n9, n6 = this.markers.sumHapBits(n8))) {
                for (n5 = 0; n5 < n2; ++n5) {
                    if (bitArray.equal(this.compHaps[n5], n9, n6)) continue;
                    byArray[0][i][n5] = 1;
                    byArray[1][i][n5] = 1;
                    byArray[2][i][n5] = 1;
                }
                continue;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                if (!bitArray.equal(this.compHaps[n5], n9, n6)) {
                    byArray[1][i][n5] = 1;
                }
                if (bitArray2.equal(this.compHaps[n5], n9, n6)) continue;
                byArray[2][i][n5] = 1;
            }
        }
    }

    private int copyData(int n, int n2, byte[][][] byArray) {
        byte[][] byArray2 = byArray[0];
        byte[][] byArray3 = byArray[1];
        int n3 = n << 1;
        int n4 = n3 | 1;
        for (int i = 0; i < this.nMarkers; ++i) {
            int n5 = this.allHaps.allele(i, n3);
            int n6 = this.allHaps.allele(i, n4);
            for (int j = 0; j < n2; ++j) {
                int n7 = this.markers.allele(this.compHaps[j], i);
                byArray2[i][j] = n7 == n5 ? (byte)0 : 1;
                byArray3[i][j] = n7 == n6 ? (byte)0 : 1;
            }
        }
        return n2;
    }

    private void fillQWithRandomHaps(int n) {
        assert (this.q.isEmpty());
        int n2 = this.allHaps.nHaps();
        int n3 = Math.min(n2 - 2, this.maxStates);
        if (n3 <= 0) {
            Utilities.exit("ERROR: there is only one sample");
        } else {
            Random random = new Random(this.phaseData.seed() + (long)n);
            int n4 = this.steps.size() - 1;
            for (int i = 0; i < n3; ++i) {
                int n5 = random.nextInt(n2);
                while (n5 >> 1 == n) {
                    n5 = random.nextInt(n2);
                }
                this.q.add(new CompHapSegment(n5, 0, n4, i));
            }
        }
    }
}

