/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.FileIt;
import blbutil.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class InputIt
implements FileIt<String> {
    private final File file;
    private final BufferedReader in;
    private String next = null;

    private InputIt(InputStream inputStream, File file) {
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            this.next = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error reading " + file);
        }
        this.in = bufferedReader;
        this.file = file;
    }

    private InputIt(InputStream inputStream, File file, int n) {
        BufferedReader bufferedReader = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader, n);
            this.next = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error reading " + file);
        }
        this.in = bufferedReader;
        this.file = file;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String string = this.next;
        try {
            this.next = this.in.readLine();
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error reading " + this.file);
        }
        return string;
    }

    @Override
    public void remove() {
        String string = this.getClass().toString() + ".remove()";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error closing " + this.in);
        }
        this.next = null;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("[file= ");
        stringBuilder.append(this.file);
        stringBuilder.append("; next=\"");
        stringBuilder.append(this.next);
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }

    public static InputIt fromStdIn() {
        File file = null;
        return new InputIt(System.in, file);
    }

    public static InputIt fromStdIn(int n) {
        File file = null;
        return new InputIt(System.in, file, n);
    }

    public static InputIt fromGzipFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                return new InputIt(new GZIPInputStream(fileInputStream), file);
            }
            return new InputIt(fileInputStream, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit(fileNotFoundException, "Error opening " + file);
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error reading " + file);
        }
        assert (false);
        return null;
    }

    public static InputIt fromGzipFile(File file, int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                return new InputIt(new GZIPInputStream(fileInputStream), file, n);
            }
            return new InputIt(fileInputStream, file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit(fileNotFoundException, "Error opening " + file);
        }
        catch (IOException iOException) {
            Utilities.exit(iOException, "Error reading " + file);
        }
        assert (false);
        return null;
    }

    public static InputIt fromTextFile(File file) {
        try {
            return new InputIt(new FileInputStream(file), file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit(fileNotFoundException, "Error opening " + file);
            assert (false);
            return null;
        }
    }

    public static InputIt fromTextFile(File file, int n) {
        try {
            return new InputIt(new FileInputStream(file), file, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit(fileNotFoundException, "Error opening " + file);
            assert (false);
            return null;
        }
    }
}

