/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class FloatArray {
    private final float[] values;

    public FloatArray(float[] fArray) {
        this.values = (float[])fArray.clone();
    }

    public FloatArray(double[] dArray) {
        this.values = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.values[i] = (float)dArray[i];
        }
    }

    public static FloatArray fromIntBits(int[] nArray) {
        return new FloatArray(nArray);
    }

    private FloatArray(int[] nArray) {
        this.values = new float[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.values[i] = Float.intBitsToFloat(nArray[i]);
        }
    }

    public float get(int n) {
        return this.values[n];
    }

    public int size() {
        return this.values.length;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public int binarySearch(float f) {
        return Arrays.binarySearch(this.values, f);
    }

    public int binarySearch(int n, int n2, float f) {
        return Arrays.binarySearch(this.values, n, n2, f);
    }

    public float[] toArray() {
        return (float[])this.values.clone();
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

