/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class BitArray {
    private static final int LOG2_BITS_PER_WORD = 6;
    private static final long WORD_MASK = -1L;
    private static final int BIT_INDEX_MASK = 63;
    private final long[] words;
    private final int size;

    public BitArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = (n + 64 - 1) / 64;
        this.words = new long[n2];
        this.size = n;
    }

    public BitArray(long[] lArray, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = (n + 64 - 1) / 64;
        if (lArray.length != n2) {
            throw new IllegalArgumentException(String.valueOf(lArray.length));
        }
        this.words = Arrays.copyOf(lArray, n2);
        this.size = n;
    }

    public BitArray(BitArray bitArray) {
        this.words = (long[])bitArray.words.clone();
        this.size = bitArray.size;
    }

    public int size() {
        return this.size;
    }

    public boolean get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n >> 6;
        return (this.words[n2] & 1L << n) != 0L;
    }

    public int getAsInt(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n >> 6;
        return (int)((this.words[n2] & 1L << n) >> n);
    }

    public void set(int n) {
        int n2;
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = n2 = n >> 6;
        this.words[n3] = this.words[n3] | 1L << n;
    }

    public void clear(int n) {
        int n2;
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = n2 = n >> 6;
        this.words[n3] = this.words[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        Arrays.fill(this.words, 0L);
    }

    public BitArray restrict(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n == n2) {
            return new BitArray(0);
        }
        BitArray bitArray = new BitArray(n2 - n);
        int n3 = bitArray.words.length - 1;
        boolean bl = (n & 0x3F) == 0;
        int n4 = n >> 6;
        int n5 = 0;
        while (n5 < n3) {
            bitArray.words[n5] = bl ? this.words[n4] : this.words[n4] >>> n | this.words[n4 + 1] << -n;
            ++n5;
            ++n4;
        }
        long l = -1L >>> -n2;
        bitArray.words[n3] = (n2 - 1 & 0x3F) < (n & 0x3F) ? this.words[n4] >>> n | (this.words[n4 + 1] & l) << -n : (this.words[n4] & l) >>> n;
        return bitArray;
    }

    public void copyFrom(BitArray bitArray, int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.size || n2 > bitArray.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n == n2) {
            return;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            long l3 = l & l2;
            int n5 = n3;
            this.words[n5] = this.words[n5] ^ (this.words[n3] ^ bitArray.words[n3]) & l3;
        } else {
            int n6 = n3;
            this.words[n6] = this.words[n6] ^ (this.words[n3] ^ bitArray.words[n3]) & l;
            for (int i = n3 + 1; i < n4; ++i) {
                this.words[i] = bitArray.words[i];
            }
            int n7 = n4;
            this.words[n7] = this.words[n7] ^ (this.words[n4] ^ bitArray.words[n4]) & l2;
        }
    }

    public int hash(int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n == n2) {
            return 0;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            long l3 = l & l2;
            return Long.hashCode(this.words[n3] & l3);
        }
        long l4 = this.words[n3] & l;
        for (int i = n3 + 1; i < n4; ++i) {
            l4 ^= this.words[i];
        }
        return Long.hashCode(l4 ^= this.words[n4] & l2);
    }

    public static void swapBits(BitArray bitArray, BitArray bitArray2, int n, int n2) {
        if (bitArray.size() != bitArray2.size()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (n < 0 || n > n2 || n2 > bitArray.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n == n2) {
            return;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            long l3 = l & l2;
            int n5 = n3;
            bitArray.words[n5] = bitArray.words[n5] ^ bitArray2.words[n3] & l3;
            int n6 = n3;
            bitArray2.words[n6] = bitArray2.words[n6] ^ bitArray.words[n3] & l3;
            int n7 = n3;
            bitArray.words[n7] = bitArray.words[n7] ^ bitArray2.words[n3] & l3;
        } else {
            int n8 = n3;
            bitArray.words[n8] = bitArray.words[n8] ^ bitArray2.words[n3] & l;
            int n9 = n3;
            bitArray2.words[n9] = bitArray2.words[n9] ^ bitArray.words[n3] & l;
            int n10 = n3;
            bitArray.words[n10] = bitArray.words[n10] ^ bitArray2.words[n3] & l;
            for (int i = n3 + 1; i < n4; ++i) {
                int n11 = i;
                bitArray.words[n11] = bitArray.words[n11] ^ bitArray2.words[i];
                int n12 = i;
                bitArray2.words[n12] = bitArray2.words[n12] ^ bitArray.words[i];
                int n13 = i;
                bitArray.words[n13] = bitArray.words[n13] ^ bitArray2.words[i];
            }
            int n14 = n4;
            bitArray.words[n14] = bitArray.words[n14] ^ bitArray2.words[n4] & l2;
            int n15 = n4;
            bitArray2.words[n15] = bitArray2.words[n15] ^ bitArray.words[n4] & l2;
            int n16 = n4;
            bitArray.words[n16] = bitArray.words[n16] ^ bitArray2.words[n4] & l2;
        }
    }

    public boolean equal(BitArray bitArray, int n, int n2) {
        if (n < 0 || n > n2 || n2 > this.size || n2 > bitArray.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n == n2) {
            return true;
        }
        int n3 = n >> 6;
        int n4 = n2 - 1 >> 6;
        long l = -1L << n;
        long l2 = -1L >>> -n2;
        if (n3 == n4) {
            long l3 = l & l2;
            return ((this.words[n3] ^ bitArray.words[n3]) & l3) == 0L;
        }
        boolean bl = true;
        bl &= ((this.words[n3] ^ bitArray.words[n3]) & l) == 0L;
        for (int i = n3 + 1; i < n4; ++i) {
            bl &= this.words[i] == bitArray.words[i];
        }
        return bl &= ((this.words[n4] ^ bitArray.words[n4]) & l2) == 0L;
    }

    public long[] toLongArray() {
        return (long[])this.words.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.get(i) ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    public static boolean equals(BitArray bitArray, BitArray bitArray2) {
        return bitArray.size() == bitArray2.size() && Arrays.equals(bitArray.words, bitArray2.words);
    }
}

