# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthUserActionArgs', 'FusionAuthUserAction']

@pulumi.input_type
class FusionAuthUserActionArgs:
    def __init__(__self__, *,
                 cancel_email_template_id: Optional[pulumi.Input[str]] = None,
                 end_email_template_id: Optional[pulumi.Input[str]] = None,
                 include_email_in_event_json: Optional[pulumi.Input[bool]] = None,
                 localized_names: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 modify_email_template_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]]] = None,
                 prevent_login: Optional[pulumi.Input[bool]] = None,
                 send_end_event: Optional[pulumi.Input[bool]] = None,
                 start_email_template_id: Optional[pulumi.Input[str]] = None,
                 temporal: Optional[pulumi.Input[bool]] = None,
                 user_action_id: Optional[pulumi.Input[str]] = None,
                 user_emailing_enabled: Optional[pulumi.Input[bool]] = None,
                 user_notifications_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a FusionAuthUserAction resource.
        :param pulumi.Input[str] cancel_email_template_id: The Id of the Email Template that is used when User Actions are canceled.
        :param pulumi.Input[str] end_email_template_id: The Id of the Email Template that is used when User Actions expired automatically (end).
        :param pulumi.Input[bool] include_email_in_event_json: Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        :param pulumi.Input[Mapping[str, Any]] localized_names: A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        :param pulumi.Input[str] modify_email_template_id: The Id of the Email Template that is used when User Actions are modified.
        :param pulumi.Input[str] name: The name of this User Action Option.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]] options: The list of User Action Options.
        :param pulumi.Input[bool] prevent_login: Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        :param pulumi.Input[bool] send_end_event: Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        :param pulumi.Input[str] start_email_template_id: The Id of the Email Template that is used when User Actions are started (created).
        :param pulumi.Input[bool] temporal: Whether or not this User Action is time-based (temporal).
        :param pulumi.Input[str] user_action_id: The id of this User Action.
        :param pulumi.Input[bool] user_emailing_enabled: Whether or not email is enabled for this User Action.
        :param pulumi.Input[bool] user_notifications_enabled: Whether or not user notifications are enabled for this User Action.
        """
        if cancel_email_template_id is not None:
            pulumi.set(__self__, "cancel_email_template_id", cancel_email_template_id)
        if end_email_template_id is not None:
            pulumi.set(__self__, "end_email_template_id", end_email_template_id)
        if include_email_in_event_json is not None:
            pulumi.set(__self__, "include_email_in_event_json", include_email_in_event_json)
        if localized_names is not None:
            pulumi.set(__self__, "localized_names", localized_names)
        if modify_email_template_id is not None:
            pulumi.set(__self__, "modify_email_template_id", modify_email_template_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if prevent_login is not None:
            pulumi.set(__self__, "prevent_login", prevent_login)
        if send_end_event is not None:
            pulumi.set(__self__, "send_end_event", send_end_event)
        if start_email_template_id is not None:
            pulumi.set(__self__, "start_email_template_id", start_email_template_id)
        if temporal is not None:
            pulumi.set(__self__, "temporal", temporal)
        if user_action_id is not None:
            pulumi.set(__self__, "user_action_id", user_action_id)
        if user_emailing_enabled is not None:
            pulumi.set(__self__, "user_emailing_enabled", user_emailing_enabled)
        if user_notifications_enabled is not None:
            pulumi.set(__self__, "user_notifications_enabled", user_notifications_enabled)

    @property
    @pulumi.getter(name="cancelEmailTemplateId")
    def cancel_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions are canceled.
        """
        return pulumi.get(self, "cancel_email_template_id")

    @cancel_email_template_id.setter
    def cancel_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cancel_email_template_id", value)

    @property
    @pulumi.getter(name="endEmailTemplateId")
    def end_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions expired automatically (end).
        """
        return pulumi.get(self, "end_email_template_id")

    @end_email_template_id.setter
    def end_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_email_template_id", value)

    @property
    @pulumi.getter(name="includeEmailInEventJson")
    def include_email_in_event_json(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        """
        return pulumi.get(self, "include_email_in_event_json")

    @include_email_in_event_json.setter
    def include_email_in_event_json(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_email_in_event_json", value)

    @property
    @pulumi.getter(name="localizedNames")
    def localized_names(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        """
        return pulumi.get(self, "localized_names")

    @localized_names.setter
    def localized_names(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "localized_names", value)

    @property
    @pulumi.getter(name="modifyEmailTemplateId")
    def modify_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions are modified.
        """
        return pulumi.get(self, "modify_email_template_id")

    @modify_email_template_id.setter
    def modify_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_email_template_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this User Action Option.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]]]:
        """
        The list of User Action Options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="preventLogin")
    def prevent_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        """
        return pulumi.get(self, "prevent_login")

    @prevent_login.setter
    def prevent_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_login", value)

    @property
    @pulumi.getter(name="sendEndEvent")
    def send_end_event(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        """
        return pulumi.get(self, "send_end_event")

    @send_end_event.setter
    def send_end_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_end_event", value)

    @property
    @pulumi.getter(name="startEmailTemplateId")
    def start_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions are started (created).
        """
        return pulumi.get(self, "start_email_template_id")

    @start_email_template_id.setter
    def start_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_email_template_id", value)

    @property
    @pulumi.getter
    def temporal(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this User Action is time-based (temporal).
        """
        return pulumi.get(self, "temporal")

    @temporal.setter
    def temporal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporal", value)

    @property
    @pulumi.getter(name="userActionId")
    def user_action_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of this User Action.
        """
        return pulumi.get(self, "user_action_id")

    @user_action_id.setter
    def user_action_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_action_id", value)

    @property
    @pulumi.getter(name="userEmailingEnabled")
    def user_emailing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not email is enabled for this User Action.
        """
        return pulumi.get(self, "user_emailing_enabled")

    @user_emailing_enabled.setter
    def user_emailing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_emailing_enabled", value)

    @property
    @pulumi.getter(name="userNotificationsEnabled")
    def user_notifications_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not user notifications are enabled for this User Action.
        """
        return pulumi.get(self, "user_notifications_enabled")

    @user_notifications_enabled.setter
    def user_notifications_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_notifications_enabled", value)


@pulumi.input_type
class _FusionAuthUserActionState:
    def __init__(__self__, *,
                 cancel_email_template_id: Optional[pulumi.Input[str]] = None,
                 end_email_template_id: Optional[pulumi.Input[str]] = None,
                 include_email_in_event_json: Optional[pulumi.Input[bool]] = None,
                 localized_names: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 modify_email_template_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]]] = None,
                 prevent_login: Optional[pulumi.Input[bool]] = None,
                 send_end_event: Optional[pulumi.Input[bool]] = None,
                 start_email_template_id: Optional[pulumi.Input[str]] = None,
                 temporal: Optional[pulumi.Input[bool]] = None,
                 user_action_id: Optional[pulumi.Input[str]] = None,
                 user_emailing_enabled: Optional[pulumi.Input[bool]] = None,
                 user_notifications_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering FusionAuthUserAction resources.
        :param pulumi.Input[str] cancel_email_template_id: The Id of the Email Template that is used when User Actions are canceled.
        :param pulumi.Input[str] end_email_template_id: The Id of the Email Template that is used when User Actions expired automatically (end).
        :param pulumi.Input[bool] include_email_in_event_json: Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        :param pulumi.Input[Mapping[str, Any]] localized_names: A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        :param pulumi.Input[str] modify_email_template_id: The Id of the Email Template that is used when User Actions are modified.
        :param pulumi.Input[str] name: The name of this User Action Option.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]] options: The list of User Action Options.
        :param pulumi.Input[bool] prevent_login: Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        :param pulumi.Input[bool] send_end_event: Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        :param pulumi.Input[str] start_email_template_id: The Id of the Email Template that is used when User Actions are started (created).
        :param pulumi.Input[bool] temporal: Whether or not this User Action is time-based (temporal).
        :param pulumi.Input[str] user_action_id: The id of this User Action.
        :param pulumi.Input[bool] user_emailing_enabled: Whether or not email is enabled for this User Action.
        :param pulumi.Input[bool] user_notifications_enabled: Whether or not user notifications are enabled for this User Action.
        """
        if cancel_email_template_id is not None:
            pulumi.set(__self__, "cancel_email_template_id", cancel_email_template_id)
        if end_email_template_id is not None:
            pulumi.set(__self__, "end_email_template_id", end_email_template_id)
        if include_email_in_event_json is not None:
            pulumi.set(__self__, "include_email_in_event_json", include_email_in_event_json)
        if localized_names is not None:
            pulumi.set(__self__, "localized_names", localized_names)
        if modify_email_template_id is not None:
            pulumi.set(__self__, "modify_email_template_id", modify_email_template_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if prevent_login is not None:
            pulumi.set(__self__, "prevent_login", prevent_login)
        if send_end_event is not None:
            pulumi.set(__self__, "send_end_event", send_end_event)
        if start_email_template_id is not None:
            pulumi.set(__self__, "start_email_template_id", start_email_template_id)
        if temporal is not None:
            pulumi.set(__self__, "temporal", temporal)
        if user_action_id is not None:
            pulumi.set(__self__, "user_action_id", user_action_id)
        if user_emailing_enabled is not None:
            pulumi.set(__self__, "user_emailing_enabled", user_emailing_enabled)
        if user_notifications_enabled is not None:
            pulumi.set(__self__, "user_notifications_enabled", user_notifications_enabled)

    @property
    @pulumi.getter(name="cancelEmailTemplateId")
    def cancel_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions are canceled.
        """
        return pulumi.get(self, "cancel_email_template_id")

    @cancel_email_template_id.setter
    def cancel_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cancel_email_template_id", value)

    @property
    @pulumi.getter(name="endEmailTemplateId")
    def end_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions expired automatically (end).
        """
        return pulumi.get(self, "end_email_template_id")

    @end_email_template_id.setter
    def end_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_email_template_id", value)

    @property
    @pulumi.getter(name="includeEmailInEventJson")
    def include_email_in_event_json(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        """
        return pulumi.get(self, "include_email_in_event_json")

    @include_email_in_event_json.setter
    def include_email_in_event_json(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_email_in_event_json", value)

    @property
    @pulumi.getter(name="localizedNames")
    def localized_names(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        """
        return pulumi.get(self, "localized_names")

    @localized_names.setter
    def localized_names(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "localized_names", value)

    @property
    @pulumi.getter(name="modifyEmailTemplateId")
    def modify_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions are modified.
        """
        return pulumi.get(self, "modify_email_template_id")

    @modify_email_template_id.setter
    def modify_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_email_template_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this User Action Option.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]]]:
        """
        The list of User Action Options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserActionOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="preventLogin")
    def prevent_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        """
        return pulumi.get(self, "prevent_login")

    @prevent_login.setter
    def prevent_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_login", value)

    @property
    @pulumi.getter(name="sendEndEvent")
    def send_end_event(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        """
        return pulumi.get(self, "send_end_event")

    @send_end_event.setter
    def send_end_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_end_event", value)

    @property
    @pulumi.getter(name="startEmailTemplateId")
    def start_email_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Email Template that is used when User Actions are started (created).
        """
        return pulumi.get(self, "start_email_template_id")

    @start_email_template_id.setter
    def start_email_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_email_template_id", value)

    @property
    @pulumi.getter
    def temporal(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not this User Action is time-based (temporal).
        """
        return pulumi.get(self, "temporal")

    @temporal.setter
    def temporal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporal", value)

    @property
    @pulumi.getter(name="userActionId")
    def user_action_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of this User Action.
        """
        return pulumi.get(self, "user_action_id")

    @user_action_id.setter
    def user_action_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_action_id", value)

    @property
    @pulumi.getter(name="userEmailingEnabled")
    def user_emailing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not email is enabled for this User Action.
        """
        return pulumi.get(self, "user_emailing_enabled")

    @user_emailing_enabled.setter
    def user_emailing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_emailing_enabled", value)

    @property
    @pulumi.getter(name="userNotificationsEnabled")
    def user_notifications_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not user notifications are enabled for this User Action.
        """
        return pulumi.get(self, "user_notifications_enabled")

    @user_notifications_enabled.setter
    def user_notifications_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_notifications_enabled", value)


class FusionAuthUserAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cancel_email_template_id: Optional[pulumi.Input[str]] = None,
                 end_email_template_id: Optional[pulumi.Input[str]] = None,
                 include_email_in_event_json: Optional[pulumi.Input[bool]] = None,
                 localized_names: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 modify_email_template_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserActionOptionArgs']]]]] = None,
                 prevent_login: Optional[pulumi.Input[bool]] = None,
                 send_end_event: Optional[pulumi.Input[bool]] = None,
                 start_email_template_id: Optional[pulumi.Input[str]] = None,
                 temporal: Optional[pulumi.Input[bool]] = None,
                 user_action_id: Optional[pulumi.Input[str]] = None,
                 user_emailing_enabled: Optional[pulumi.Input[bool]] = None,
                 user_notifications_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## # User Action Resource

        [User Actions API](https://fusionauth.io/docs/v1/tech/apis/user-actions/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthUserAction("example",
            prevent_login=True,
            temporal=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cancel_email_template_id: The Id of the Email Template that is used when User Actions are canceled.
        :param pulumi.Input[str] end_email_template_id: The Id of the Email Template that is used when User Actions expired automatically (end).
        :param pulumi.Input[bool] include_email_in_event_json: Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        :param pulumi.Input[Mapping[str, Any]] localized_names: A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        :param pulumi.Input[str] modify_email_template_id: The Id of the Email Template that is used when User Actions are modified.
        :param pulumi.Input[str] name: The name of this User Action Option.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserActionOptionArgs']]]] options: The list of User Action Options.
        :param pulumi.Input[bool] prevent_login: Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        :param pulumi.Input[bool] send_end_event: Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        :param pulumi.Input[str] start_email_template_id: The Id of the Email Template that is used when User Actions are started (created).
        :param pulumi.Input[bool] temporal: Whether or not this User Action is time-based (temporal).
        :param pulumi.Input[str] user_action_id: The id of this User Action.
        :param pulumi.Input[bool] user_emailing_enabled: Whether or not email is enabled for this User Action.
        :param pulumi.Input[bool] user_notifications_enabled: Whether or not user notifications are enabled for this User Action.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FusionAuthUserActionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # User Action Resource

        [User Actions API](https://fusionauth.io/docs/v1/tech/apis/user-actions/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthUserAction("example",
            prevent_login=True,
            temporal=True)
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthUserActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthUserActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cancel_email_template_id: Optional[pulumi.Input[str]] = None,
                 end_email_template_id: Optional[pulumi.Input[str]] = None,
                 include_email_in_event_json: Optional[pulumi.Input[bool]] = None,
                 localized_names: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 modify_email_template_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserActionOptionArgs']]]]] = None,
                 prevent_login: Optional[pulumi.Input[bool]] = None,
                 send_end_event: Optional[pulumi.Input[bool]] = None,
                 start_email_template_id: Optional[pulumi.Input[str]] = None,
                 temporal: Optional[pulumi.Input[bool]] = None,
                 user_action_id: Optional[pulumi.Input[str]] = None,
                 user_emailing_enabled: Optional[pulumi.Input[bool]] = None,
                 user_notifications_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthUserActionArgs.__new__(FusionAuthUserActionArgs)

            __props__.__dict__["cancel_email_template_id"] = cancel_email_template_id
            __props__.__dict__["end_email_template_id"] = end_email_template_id
            __props__.__dict__["include_email_in_event_json"] = include_email_in_event_json
            __props__.__dict__["localized_names"] = localized_names
            __props__.__dict__["modify_email_template_id"] = modify_email_template_id
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["prevent_login"] = prevent_login
            __props__.__dict__["send_end_event"] = send_end_event
            __props__.__dict__["start_email_template_id"] = start_email_template_id
            __props__.__dict__["temporal"] = temporal
            __props__.__dict__["user_action_id"] = user_action_id
            __props__.__dict__["user_emailing_enabled"] = user_emailing_enabled
            __props__.__dict__["user_notifications_enabled"] = user_notifications_enabled
        super(FusionAuthUserAction, __self__).__init__(
            'fusionauth:index/fusionAuthUserAction:FusionAuthUserAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cancel_email_template_id: Optional[pulumi.Input[str]] = None,
            end_email_template_id: Optional[pulumi.Input[str]] = None,
            include_email_in_event_json: Optional[pulumi.Input[bool]] = None,
            localized_names: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            modify_email_template_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserActionOptionArgs']]]]] = None,
            prevent_login: Optional[pulumi.Input[bool]] = None,
            send_end_event: Optional[pulumi.Input[bool]] = None,
            start_email_template_id: Optional[pulumi.Input[str]] = None,
            temporal: Optional[pulumi.Input[bool]] = None,
            user_action_id: Optional[pulumi.Input[str]] = None,
            user_emailing_enabled: Optional[pulumi.Input[bool]] = None,
            user_notifications_enabled: Optional[pulumi.Input[bool]] = None) -> 'FusionAuthUserAction':
        """
        Get an existing FusionAuthUserAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cancel_email_template_id: The Id of the Email Template that is used when User Actions are canceled.
        :param pulumi.Input[str] end_email_template_id: The Id of the Email Template that is used when User Actions expired automatically (end).
        :param pulumi.Input[bool] include_email_in_event_json: Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        :param pulumi.Input[Mapping[str, Any]] localized_names: A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        :param pulumi.Input[str] modify_email_template_id: The Id of the Email Template that is used when User Actions are modified.
        :param pulumi.Input[str] name: The name of this User Action Option.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserActionOptionArgs']]]] options: The list of User Action Options.
        :param pulumi.Input[bool] prevent_login: Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        :param pulumi.Input[bool] send_end_event: Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        :param pulumi.Input[str] start_email_template_id: The Id of the Email Template that is used when User Actions are started (created).
        :param pulumi.Input[bool] temporal: Whether or not this User Action is time-based (temporal).
        :param pulumi.Input[str] user_action_id: The id of this User Action.
        :param pulumi.Input[bool] user_emailing_enabled: Whether or not email is enabled for this User Action.
        :param pulumi.Input[bool] user_notifications_enabled: Whether or not user notifications are enabled for this User Action.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthUserActionState.__new__(_FusionAuthUserActionState)

        __props__.__dict__["cancel_email_template_id"] = cancel_email_template_id
        __props__.__dict__["end_email_template_id"] = end_email_template_id
        __props__.__dict__["include_email_in_event_json"] = include_email_in_event_json
        __props__.__dict__["localized_names"] = localized_names
        __props__.__dict__["modify_email_template_id"] = modify_email_template_id
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["prevent_login"] = prevent_login
        __props__.__dict__["send_end_event"] = send_end_event
        __props__.__dict__["start_email_template_id"] = start_email_template_id
        __props__.__dict__["temporal"] = temporal
        __props__.__dict__["user_action_id"] = user_action_id
        __props__.__dict__["user_emailing_enabled"] = user_emailing_enabled
        __props__.__dict__["user_notifications_enabled"] = user_notifications_enabled
        return FusionAuthUserAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cancelEmailTemplateId")
    def cancel_email_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of the Email Template that is used when User Actions are canceled.
        """
        return pulumi.get(self, "cancel_email_template_id")

    @property
    @pulumi.getter(name="endEmailTemplateId")
    def end_email_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of the Email Template that is used when User Actions expired automatically (end).
        """
        return pulumi.get(self, "end_email_template_id")

    @property
    @pulumi.getter(name="includeEmailInEventJson")
    def include_email_in_event_json(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to include the email information in the JSON that is sent to the Webhook when a user action is taken.
        """
        return pulumi.get(self, "include_email_in_event_json")

    @property
    @pulumi.getter(name="localizedNames")
    def localized_names(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of localized names for this User Action Option. The key is the Locale and the value is the name of the User Action Option for that language.
        """
        return pulumi.get(self, "localized_names")

    @property
    @pulumi.getter(name="modifyEmailTemplateId")
    def modify_email_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of the Email Template that is used when User Actions are modified.
        """
        return pulumi.get(self, "modify_email_template_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this User Action Option.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthUserActionOption']]]:
        """
        The list of User Action Options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="preventLogin")
    def prevent_login(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this User Action will prevent user login. When this value is set to true the action must also be marked as a time based action. See `temporal`.
        """
        return pulumi.get(self, "prevent_login")

    @property
    @pulumi.getter(name="sendEndEvent")
    def send_end_event(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not FusionAuth will send events to any registered Webhooks when this User Action expires.
        """
        return pulumi.get(self, "send_end_event")

    @property
    @pulumi.getter(name="startEmailTemplateId")
    def start_email_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of the Email Template that is used when User Actions are started (created).
        """
        return pulumi.get(self, "start_email_template_id")

    @property
    @pulumi.getter
    def temporal(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not this User Action is time-based (temporal).
        """
        return pulumi.get(self, "temporal")

    @property
    @pulumi.getter(name="userActionId")
    def user_action_id(self) -> pulumi.Output[str]:
        """
        The id of this User Action.
        """
        return pulumi.get(self, "user_action_id")

    @property
    @pulumi.getter(name="userEmailingEnabled")
    def user_emailing_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not email is enabled for this User Action.
        """
        return pulumi.get(self, "user_emailing_enabled")

    @property
    @pulumi.getter(name="userNotificationsEnabled")
    def user_notifications_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not user notifications are enabled for this User Action.
        """
        return pulumi.get(self, "user_notifications_enabled")

