# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthUserArgs', 'FusionAuthUser']

@pulumi.input_type
class FusionAuthUserArgs:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 birth_date: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 disable_domain_block: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 encryption_scheme: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[int]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 parent_email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_change_required: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_set_password_email: Optional[pulumi.Input[bool]] = None,
                 skip_verification: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 two_factor_methods: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserTwoFactorMethodArgs']]]] = None,
                 two_factor_recovery_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthUser resource.
        :param pulumi.Input[str] application_id: -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] birth_date: An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        :param pulumi.Input[str] data: An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        :param pulumi.Input[bool] disable_domain_block: An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] email: The value of the email address for this method.
        :param pulumi.Input[str] encryption_scheme: The method for encrypting the User’s password.
        :param pulumi.Input[int] expiry: The expiration instant of the User’s account. An expired user is not permitted to login.
        :param pulumi.Input[str] first_name: The first name of the User.
        :param pulumi.Input[str] full_name: The User’s full name as a separate field that is not calculated from firstName and lastName.
        :param pulumi.Input[str] image_url: The URL that points to an image file that is the User’s profile image.
        :param pulumi.Input[str] last_name: The User’s last name.
        :param pulumi.Input[str] middle_name: The User’s middle name.
        :param pulumi.Input[str] mobile_phone: The value of the mobile phone for this method.
        :param pulumi.Input[str] parent_email: The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        :param pulumi.Input[str] password: The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        :param pulumi.Input[bool] password_change_required: Indicates that the User’s password needs to be changed during their next login attempt.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        :param pulumi.Input[bool] send_set_password_email: Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        :param pulumi.Input[bool] skip_verification: Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        :param pulumi.Input[str] timezone: The User’s preferred timezone. The string must be in an IANA time zone format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] two_factor_recovery_codes: A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        :param pulumi.Input[str] user_id: The Id to use for the new User. If not specified a secure random UUID will be generated..
        :param pulumi.Input[str] username: The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        :param pulumi.Input[str] username_status: The current status of the username. This is used if you are moderating usernames via CleanSpeak.
               * `two_factor_methods`
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if birth_date is not None:
            pulumi.set(__self__, "birth_date", birth_date)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_domain_block is not None:
            pulumi.set(__self__, "disable_domain_block", disable_domain_block)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if encryption_scheme is not None:
            pulumi.set(__self__, "encryption_scheme", encryption_scheme)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if parent_email is not None:
            pulumi.set(__self__, "parent_email", parent_email)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_change_required is not None:
            pulumi.set(__self__, "password_change_required", password_change_required)
        if preferred_languages is not None:
            pulumi.set(__self__, "preferred_languages", preferred_languages)
        if send_set_password_email is not None:
            pulumi.set(__self__, "send_set_password_email", send_set_password_email)
        if skip_verification is not None:
            pulumi.set(__self__, "skip_verification", skip_verification)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if two_factor_methods is not None:
            pulumi.set(__self__, "two_factor_methods", two_factor_methods)
        if two_factor_recovery_codes is not None:
            pulumi.set(__self__, "two_factor_recovery_codes", two_factor_recovery_codes)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_status is not None:
            pulumi.set(__self__, "username_status", username_status)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> Optional[pulumi.Input[str]]:
        """
        An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        """
        return pulumi.get(self, "birth_date")

    @birth_date.setter
    def birth_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "birth_date", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="disableDomainBlock")
    def disable_domain_block(self) -> Optional[pulumi.Input[bool]]:
        """
        An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        """
        return pulumi.get(self, "disable_domain_block")

    @disable_domain_block.setter
    def disable_domain_block(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_domain_block", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the email address for this method.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="encryptionScheme")
    def encryption_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The method for encrypting the User’s password.
        """
        return pulumi.get(self, "encryption_scheme")

    @encryption_scheme.setter
    def encryption_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_scheme", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[int]]:
        """
        The expiration instant of the User’s account. An expired user is not permitted to login.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The first name of the User.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s full name as a separate field that is not calculated from firstName and lastName.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that points to an image file that is the User’s profile image.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "middle_name", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the mobile phone for this method.
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="parentEmail")
    def parent_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        """
        return pulumi.get(self, "parent_email")

    @parent_email.setter
    def parent_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_email", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordChangeRequired")
    def password_change_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the User’s password needs to be changed during their next login attempt.
        """
        return pulumi.get(self, "password_change_required")

    @password_change_required.setter
    def password_change_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_change_required", value)

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        """
        return pulumi.get(self, "preferred_languages")

    @preferred_languages.setter
    def preferred_languages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_languages", value)

    @property
    @pulumi.getter(name="sendSetPasswordEmail")
    def send_set_password_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        """
        return pulumi.get(self, "send_set_password_email")

    @send_set_password_email.setter
    def send_set_password_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_set_password_email", value)

    @property
    @pulumi.getter(name="skipVerification")
    def skip_verification(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        """
        return pulumi.get(self, "skip_verification")

    @skip_verification.setter
    def skip_verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_verification", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s preferred timezone. The string must be in an IANA time zone format.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="twoFactorMethods")
    def two_factor_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserTwoFactorMethodArgs']]]]:
        return pulumi.get(self, "two_factor_methods")

    @two_factor_methods.setter
    def two_factor_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserTwoFactorMethodArgs']]]]):
        pulumi.set(self, "two_factor_methods", value)

    @property
    @pulumi.getter(name="twoFactorRecoveryCodes")
    def two_factor_recovery_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        """
        return pulumi.get(self, "two_factor_recovery_codes")

    @two_factor_recovery_codes.setter
    def two_factor_recovery_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "two_factor_recovery_codes", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new User. If not specified a secure random UUID will be generated..
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="usernameStatus")
    def username_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the username. This is used if you are moderating usernames via CleanSpeak.
        * `two_factor_methods`
        """
        return pulumi.get(self, "username_status")

    @username_status.setter
    def username_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_status", value)


@pulumi.input_type
class _FusionAuthUserState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 birth_date: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 disable_domain_block: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 encryption_scheme: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[int]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 parent_email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_change_required: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_set_password_email: Optional[pulumi.Input[bool]] = None,
                 skip_verification: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 two_factor_methods: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserTwoFactorMethodArgs']]]] = None,
                 two_factor_recovery_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthUser resources.
        :param pulumi.Input[str] application_id: -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] birth_date: An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        :param pulumi.Input[str] data: An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        :param pulumi.Input[bool] disable_domain_block: An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] email: The value of the email address for this method.
        :param pulumi.Input[str] encryption_scheme: The method for encrypting the User’s password.
        :param pulumi.Input[int] expiry: The expiration instant of the User’s account. An expired user is not permitted to login.
        :param pulumi.Input[str] first_name: The first name of the User.
        :param pulumi.Input[str] full_name: The User’s full name as a separate field that is not calculated from firstName and lastName.
        :param pulumi.Input[str] image_url: The URL that points to an image file that is the User’s profile image.
        :param pulumi.Input[str] last_name: The User’s last name.
        :param pulumi.Input[str] middle_name: The User’s middle name.
        :param pulumi.Input[str] mobile_phone: The value of the mobile phone for this method.
        :param pulumi.Input[str] parent_email: The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        :param pulumi.Input[str] password: The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        :param pulumi.Input[bool] password_change_required: Indicates that the User’s password needs to be changed during their next login attempt.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        :param pulumi.Input[bool] send_set_password_email: Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        :param pulumi.Input[bool] skip_verification: Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        :param pulumi.Input[str] timezone: The User’s preferred timezone. The string must be in an IANA time zone format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] two_factor_recovery_codes: A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        :param pulumi.Input[str] user_id: The Id to use for the new User. If not specified a secure random UUID will be generated..
        :param pulumi.Input[str] username: The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        :param pulumi.Input[str] username_status: The current status of the username. This is used if you are moderating usernames via CleanSpeak.
               * `two_factor_methods`
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if birth_date is not None:
            pulumi.set(__self__, "birth_date", birth_date)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if disable_domain_block is not None:
            pulumi.set(__self__, "disable_domain_block", disable_domain_block)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if encryption_scheme is not None:
            pulumi.set(__self__, "encryption_scheme", encryption_scheme)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if middle_name is not None:
            pulumi.set(__self__, "middle_name", middle_name)
        if mobile_phone is not None:
            pulumi.set(__self__, "mobile_phone", mobile_phone)
        if parent_email is not None:
            pulumi.set(__self__, "parent_email", parent_email)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_change_required is not None:
            pulumi.set(__self__, "password_change_required", password_change_required)
        if preferred_languages is not None:
            pulumi.set(__self__, "preferred_languages", preferred_languages)
        if send_set_password_email is not None:
            pulumi.set(__self__, "send_set_password_email", send_set_password_email)
        if skip_verification is not None:
            pulumi.set(__self__, "skip_verification", skip_verification)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if two_factor_methods is not None:
            pulumi.set(__self__, "two_factor_methods", two_factor_methods)
        if two_factor_recovery_codes is not None:
            pulumi.set(__self__, "two_factor_recovery_codes", two_factor_recovery_codes)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_status is not None:
            pulumi.set(__self__, "username_status", username_status)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> Optional[pulumi.Input[str]]:
        """
        An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        """
        return pulumi.get(self, "birth_date")

    @birth_date.setter
    def birth_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "birth_date", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="disableDomainBlock")
    def disable_domain_block(self) -> Optional[pulumi.Input[bool]]:
        """
        An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        """
        return pulumi.get(self, "disable_domain_block")

    @disable_domain_block.setter
    def disable_domain_block(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_domain_block", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the email address for this method.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="encryptionScheme")
    def encryption_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The method for encrypting the User’s password.
        """
        return pulumi.get(self, "encryption_scheme")

    @encryption_scheme.setter
    def encryption_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_scheme", value)

    @property
    @pulumi.getter
    def expiry(self) -> Optional[pulumi.Input[int]]:
        """
        The expiration instant of the User’s account. An expired user is not permitted to login.
        """
        return pulumi.get(self, "expiry")

    @expiry.setter
    def expiry(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiry", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The first name of the User.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s full name as a separate field that is not calculated from firstName and lastName.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL that points to an image file that is the User’s profile image.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s last name.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @middle_name.setter
    def middle_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "middle_name", value)

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the mobile phone for this method.
        """
        return pulumi.get(self, "mobile_phone")

    @mobile_phone.setter
    def mobile_phone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mobile_phone", value)

    @property
    @pulumi.getter(name="parentEmail")
    def parent_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        """
        return pulumi.get(self, "parent_email")

    @parent_email.setter
    def parent_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_email", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordChangeRequired")
    def password_change_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the User’s password needs to be changed during their next login attempt.
        """
        return pulumi.get(self, "password_change_required")

    @password_change_required.setter
    def password_change_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_change_required", value)

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        """
        return pulumi.get(self, "preferred_languages")

    @preferred_languages.setter
    def preferred_languages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_languages", value)

    @property
    @pulumi.getter(name="sendSetPasswordEmail")
    def send_set_password_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        """
        return pulumi.get(self, "send_set_password_email")

    @send_set_password_email.setter
    def send_set_password_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_set_password_email", value)

    @property
    @pulumi.getter(name="skipVerification")
    def skip_verification(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        """
        return pulumi.get(self, "skip_verification")

    @skip_verification.setter
    def skip_verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_verification", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The User’s preferred timezone. The string must be in an IANA time zone format.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="twoFactorMethods")
    def two_factor_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserTwoFactorMethodArgs']]]]:
        return pulumi.get(self, "two_factor_methods")

    @two_factor_methods.setter
    def two_factor_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthUserTwoFactorMethodArgs']]]]):
        pulumi.set(self, "two_factor_methods", value)

    @property
    @pulumi.getter(name="twoFactorRecoveryCodes")
    def two_factor_recovery_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        """
        return pulumi.get(self, "two_factor_recovery_codes")

    @two_factor_recovery_codes.setter
    def two_factor_recovery_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "two_factor_recovery_codes", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new User. If not specified a secure random UUID will be generated..
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="usernameStatus")
    def username_status(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of the username. This is used if you are moderating usernames via CleanSpeak.
        * `two_factor_methods`
        """
        return pulumi.get(self, "username_status")

    @username_status.setter
    def username_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_status", value)


class FusionAuthUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 birth_date: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 disable_domain_block: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 encryption_scheme: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[int]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 parent_email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_change_required: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_set_password_email: Optional[pulumi.Input[bool]] = None,
                 skip_verification: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 two_factor_methods: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserTwoFactorMethodArgs']]]]] = None,
                 two_factor_recovery_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # User Resource

        [Users API](https://fusionauth.io/docs/v1/tech/apis/users)

        ## Example Usage

        ```python
        import pulumi
        import json
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthUser("example",
            user_id="4c4511df-0d0d-4029-8c2b-f6c01b9e138d",
            birth_date="1976-05-30",
            data=json.dumps({
                "displayName": "Johnny Boy",
                "favoriteColors": [
                    "Red",
                    "Blue",
                ],
            }),
            email="example@fusionauth.io",
            encryption_scheme="salted-sha256",
            expiry=1571786483322,
            first_name="John",
            full_name="John Doe",
            image_url="http://65.media.tumblr.com/tumblr_l7dbl0MHbU1qz50x3o1_500.png",
            last_name="Doe",
            middle_name="William",
            mobile_phone="303-555-1234",
            password_change_required=False,
            preferred_languages=[
                "en",
                "fr",
            ],
            timezone="America/Denver",
            username_status="ACTIVE",
            username="johnny123")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] birth_date: An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        :param pulumi.Input[str] data: An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        :param pulumi.Input[bool] disable_domain_block: An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] email: The value of the email address for this method.
        :param pulumi.Input[str] encryption_scheme: The method for encrypting the User’s password.
        :param pulumi.Input[int] expiry: The expiration instant of the User’s account. An expired user is not permitted to login.
        :param pulumi.Input[str] first_name: The first name of the User.
        :param pulumi.Input[str] full_name: The User’s full name as a separate field that is not calculated from firstName and lastName.
        :param pulumi.Input[str] image_url: The URL that points to an image file that is the User’s profile image.
        :param pulumi.Input[str] last_name: The User’s last name.
        :param pulumi.Input[str] middle_name: The User’s middle name.
        :param pulumi.Input[str] mobile_phone: The value of the mobile phone for this method.
        :param pulumi.Input[str] parent_email: The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        :param pulumi.Input[str] password: The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        :param pulumi.Input[bool] password_change_required: Indicates that the User’s password needs to be changed during their next login attempt.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        :param pulumi.Input[bool] send_set_password_email: Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        :param pulumi.Input[bool] skip_verification: Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        :param pulumi.Input[str] timezone: The User’s preferred timezone. The string must be in an IANA time zone format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] two_factor_recovery_codes: A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        :param pulumi.Input[str] user_id: The Id to use for the new User. If not specified a secure random UUID will be generated..
        :param pulumi.Input[str] username: The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        :param pulumi.Input[str] username_status: The current status of the username. This is used if you are moderating usernames via CleanSpeak.
               * `two_factor_methods`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FusionAuthUserArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # User Resource

        [Users API](https://fusionauth.io/docs/v1/tech/apis/users)

        ## Example Usage

        ```python
        import pulumi
        import json
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthUser("example",
            user_id="4c4511df-0d0d-4029-8c2b-f6c01b9e138d",
            birth_date="1976-05-30",
            data=json.dumps({
                "displayName": "Johnny Boy",
                "favoriteColors": [
                    "Red",
                    "Blue",
                ],
            }),
            email="example@fusionauth.io",
            encryption_scheme="salted-sha256",
            expiry=1571786483322,
            first_name="John",
            full_name="John Doe",
            image_url="http://65.media.tumblr.com/tumblr_l7dbl0MHbU1qz50x3o1_500.png",
            last_name="Doe",
            middle_name="William",
            mobile_phone="303-555-1234",
            password_change_required=False,
            preferred_languages=[
                "en",
                "fr",
            ],
            timezone="America/Denver",
            username_status="ACTIVE",
            username="johnny123")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 birth_date: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 disable_domain_block: Optional[pulumi.Input[bool]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 encryption_scheme: Optional[pulumi.Input[str]] = None,
                 expiry: Optional[pulumi.Input[int]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 middle_name: Optional[pulumi.Input[str]] = None,
                 mobile_phone: Optional[pulumi.Input[str]] = None,
                 parent_email: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_change_required: Optional[pulumi.Input[bool]] = None,
                 preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_set_password_email: Optional[pulumi.Input[bool]] = None,
                 skip_verification: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 two_factor_methods: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserTwoFactorMethodArgs']]]]] = None,
                 two_factor_recovery_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 username_status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthUserArgs.__new__(FusionAuthUserArgs)

            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["birth_date"] = birth_date
            __props__.__dict__["data"] = data
            __props__.__dict__["disable_domain_block"] = disable_domain_block
            __props__.__dict__["email"] = email
            __props__.__dict__["encryption_scheme"] = encryption_scheme
            __props__.__dict__["expiry"] = expiry
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["full_name"] = full_name
            __props__.__dict__["image_url"] = image_url
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["middle_name"] = middle_name
            __props__.__dict__["mobile_phone"] = mobile_phone
            __props__.__dict__["parent_email"] = parent_email
            __props__.__dict__["password"] = password
            __props__.__dict__["password_change_required"] = password_change_required
            __props__.__dict__["preferred_languages"] = preferred_languages
            __props__.__dict__["send_set_password_email"] = send_set_password_email
            __props__.__dict__["skip_verification"] = skip_verification
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["two_factor_methods"] = two_factor_methods
            __props__.__dict__["two_factor_recovery_codes"] = two_factor_recovery_codes
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["username"] = username
            __props__.__dict__["username_status"] = username_status
        super(FusionAuthUser, __self__).__init__(
            'fusionauth:index/fusionAuthUser:FusionAuthUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[str]] = None,
            birth_date: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[str]] = None,
            disable_domain_block: Optional[pulumi.Input[bool]] = None,
            email: Optional[pulumi.Input[str]] = None,
            encryption_scheme: Optional[pulumi.Input[str]] = None,
            expiry: Optional[pulumi.Input[int]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            full_name: Optional[pulumi.Input[str]] = None,
            image_url: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            middle_name: Optional[pulumi.Input[str]] = None,
            mobile_phone: Optional[pulumi.Input[str]] = None,
            parent_email: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_change_required: Optional[pulumi.Input[bool]] = None,
            preferred_languages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            send_set_password_email: Optional[pulumi.Input[bool]] = None,
            skip_verification: Optional[pulumi.Input[bool]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            two_factor_methods: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthUserTwoFactorMethodArgs']]]]] = None,
            two_factor_recovery_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            username_status: Optional[pulumi.Input[str]] = None) -> 'FusionAuthUser':
        """
        Get an existing FusionAuthUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_id: -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] birth_date: An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        :param pulumi.Input[str] data: An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        :param pulumi.Input[bool] disable_domain_block: An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        :param pulumi.Input[str] email: The value of the email address for this method.
        :param pulumi.Input[str] encryption_scheme: The method for encrypting the User’s password.
        :param pulumi.Input[int] expiry: The expiration instant of the User’s account. An expired user is not permitted to login.
        :param pulumi.Input[str] first_name: The first name of the User.
        :param pulumi.Input[str] full_name: The User’s full name as a separate field that is not calculated from firstName and lastName.
        :param pulumi.Input[str] image_url: The URL that points to an image file that is the User’s profile image.
        :param pulumi.Input[str] last_name: The User’s last name.
        :param pulumi.Input[str] middle_name: The User’s middle name.
        :param pulumi.Input[str] mobile_phone: The value of the mobile phone for this method.
        :param pulumi.Input[str] parent_email: The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        :param pulumi.Input[str] password: The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        :param pulumi.Input[bool] password_change_required: Indicates that the User’s password needs to be changed during their next login attempt.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] preferred_languages: An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        :param pulumi.Input[bool] send_set_password_email: Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        :param pulumi.Input[bool] skip_verification: Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        :param pulumi.Input[str] tenant_id: The unique Id of the tenant used to scope this API request.
        :param pulumi.Input[str] timezone: The User’s preferred timezone. The string must be in an IANA time zone format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] two_factor_recovery_codes: A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        :param pulumi.Input[str] user_id: The Id to use for the new User. If not specified a secure random UUID will be generated..
        :param pulumi.Input[str] username: The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        :param pulumi.Input[str] username_status: The current status of the username. This is used if you are moderating usernames via CleanSpeak.
               * `two_factor_methods`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthUserState.__new__(_FusionAuthUserState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["birth_date"] = birth_date
        __props__.__dict__["data"] = data
        __props__.__dict__["disable_domain_block"] = disable_domain_block
        __props__.__dict__["email"] = email
        __props__.__dict__["encryption_scheme"] = encryption_scheme
        __props__.__dict__["expiry"] = expiry
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["middle_name"] = middle_name
        __props__.__dict__["mobile_phone"] = mobile_phone
        __props__.__dict__["parent_email"] = parent_email
        __props__.__dict__["password"] = password
        __props__.__dict__["password_change_required"] = password_change_required
        __props__.__dict__["preferred_languages"] = preferred_languages
        __props__.__dict__["send_set_password_email"] = send_set_password_email
        __props__.__dict__["skip_verification"] = skip_verification
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["two_factor_methods"] = two_factor_methods
        __props__.__dict__["two_factor_recovery_codes"] = two_factor_recovery_codes
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["username"] = username
        __props__.__dict__["username_status"] = username_status
        return FusionAuthUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[str]]:
        """
        -An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="birthDate")
    def birth_date(self) -> pulumi.Output[Optional[str]]:
        """
        An ISO-8601 formatted date of the User’s birthdate such as YYYY-MM-DD.
        """
        return pulumi.get(self, "birth_date")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[str]]:
        """
        An object that can hold any information about a User that should be persisted. Must be a JSON serialised string.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="disableDomainBlock")
    def disable_domain_block(self) -> pulumi.Output[Optional[bool]]:
        """
        An optional Application Id. When this value is provided, it will be used to resolve an application specific email template if you have configured transactional emails such as setup password, email verification and others.
        """
        return pulumi.get(self, "disable_domain_block")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[str]]:
        """
        The value of the email address for this method.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="encryptionScheme")
    def encryption_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        The method for encrypting the User’s password.
        """
        return pulumi.get(self, "encryption_scheme")

    @property
    @pulumi.getter
    def expiry(self) -> pulumi.Output[Optional[int]]:
        """
        The expiration instant of the User’s account. An expired user is not permitted to login.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[str]]:
        """
        The first name of the User.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[Optional[str]]:
        """
        The User’s full name as a separate field that is not calculated from firstName and lastName.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL that points to an image file that is the User’s profile image.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[str]]:
        """
        The User’s last name.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> pulumi.Output[Optional[str]]:
        """
        The User’s middle name.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="mobilePhone")
    def mobile_phone(self) -> pulumi.Output[Optional[str]]:
        """
        The value of the mobile phone for this method.
        """
        return pulumi.get(self, "mobile_phone")

    @property
    @pulumi.getter(name="parentEmail")
    def parent_email(self) -> pulumi.Output[Optional[str]]:
        """
        The email address of the user’s parent or guardian. This field is used to allow a child user to identify their parent so FusionAuth can make a request to the parent to confirm the parent relationship.
        """
        return pulumi.get(self, "parent_email")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The User’s plain texts password. This password will be hashed and the provided value will never be stored and cannot be retrieved.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordChangeRequired")
    def password_change_required(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates that the User’s password needs to be changed during their next login attempt.
        """
        return pulumi.get(self, "password_change_required")

    @property
    @pulumi.getter(name="preferredLanguages")
    def preferred_languages(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        An array of locale strings that give, in order, the User’s preferred languages. These are important for email templates and other localizable text.
        """
        return pulumi.get(self, "preferred_languages")

    @property
    @pulumi.getter(name="sendSetPasswordEmail")
    def send_set_password_email(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates to FusionAuth to send the User an email asking them to set their password. The Email Template that is used is configured in the System Configuration setting for Set Password Email Template.
        """
        return pulumi.get(self, "send_set_password_email")

    @property
    @pulumi.getter(name="skipVerification")
    def skip_verification(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates to FusionAuth that it should skip email verification even if it is enabled. This is useful for creating admin or internal User accounts.
        """
        return pulumi.get(self, "skip_verification")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        The User’s preferred timezone. The string must be in an IANA time zone format.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="twoFactorMethods")
    def two_factor_methods(self) -> pulumi.Output[Sequence['outputs.FusionAuthUserTwoFactorMethod']]:
        return pulumi.get(self, "two_factor_methods")

    @property
    @pulumi.getter(name="twoFactorRecoveryCodes")
    def two_factor_recovery_codes(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of recovery codes. These may be used in place of a code provided by an MFA factor. They are single use. If a recovery code is used in a disable request, all MFA methods are removed. If, after that, a Multi-Factor method is added, a new set of recovery codes will be generated.
        """
        return pulumi.get(self, "two_factor_recovery_codes")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        The Id to use for the new User. If not specified a secure random UUID will be generated..
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The username of the User. The username is stored and returned as a case sensitive value, however a username is considered unique regardless of the case. bob is considered equal to BoB so either version of this username can be used whenever providing it as input to an API.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameStatus")
    def username_status(self) -> pulumi.Output[Optional[str]]:
        """
        The current status of the username. This is used if you are moderating usernames via CleanSpeak.
        * `two_factor_methods`
        """
        return pulumi.get(self, "username_status")

