# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthTenantArgs', 'FusionAuthTenant']

@pulumi.input_type
class FusionAuthTenantArgs:
    def __init__(__self__, *,
                 email_configuration: pulumi.Input['FusionAuthTenantEmailConfigurationArgs'],
                 external_identifier_configuration: pulumi.Input['FusionAuthTenantExternalIdentifierConfigurationArgs'],
                 issuer: pulumi.Input[str],
                 jwt_configurations: pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantJwtConfigurationArgs']]],
                 theme_id: pulumi.Input[str],
                 access_control_configuration: Optional[pulumi.Input['FusionAuthTenantAccessControlConfigurationArgs']] = None,
                 captcha_configuration: Optional[pulumi.Input['FusionAuthTenantCaptchaConfigurationArgs']] = None,
                 connector_policies: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 event_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantEventConfigurationArgs']]]] = None,
                 failed_authentication_configuration: Optional[pulumi.Input['FusionAuthTenantFailedAuthenticationConfigurationArgs']] = None,
                 family_configuration: Optional[pulumi.Input['FusionAuthTenantFamilyConfigurationArgs']] = None,
                 form_configuration: Optional[pulumi.Input['FusionAuthTenantFormConfigurationArgs']] = None,
                 http_session_max_inactive_interval: Optional[pulumi.Input[int]] = None,
                 login_configuration: Optional[pulumi.Input['FusionAuthTenantLoginConfigurationArgs']] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 maximum_password_age: Optional[pulumi.Input['FusionAuthTenantMaximumPasswordAgeArgs']] = None,
                 minimum_password_age: Optional[pulumi.Input['FusionAuthTenantMinimumPasswordAgeArgs']] = None,
                 multi_factor_configuration: Optional[pulumi.Input['FusionAuthTenantMultiFactorConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantOauthConfigurationArgs']]]] = None,
                 password_encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]] = None,
                 password_validation_rules: Optional[pulumi.Input['FusionAuthTenantPasswordValidationRulesArgs']] = None,
                 source_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 user_delete_policy: Optional[pulumi.Input['FusionAuthTenantUserDeletePolicyArgs']] = None,
                 username_configuration: Optional[pulumi.Input['FusionAuthTenantUsernameConfigurationArgs']] = None):
        """
        The set of arguments for constructing a FusionAuthTenant resource.
        :param pulumi.Input[str] issuer: The named issuer used to sign tokens, this is generally your public fully qualified domain.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]] connector_policies: A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Tenant that should be persisted.
        :param pulumi.Input[int] http_session_max_inactive_interval: Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        :param pulumi.Input[str] logout_url: The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        :param pulumi.Input[str] name: The unique name of the Tenant.
        :param pulumi.Input[str] source_tenant_id: The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        :param pulumi.Input[str] tenant_id: The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        """
        pulumi.set(__self__, "email_configuration", email_configuration)
        pulumi.set(__self__, "external_identifier_configuration", external_identifier_configuration)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "jwt_configurations", jwt_configurations)
        pulumi.set(__self__, "theme_id", theme_id)
        if access_control_configuration is not None:
            pulumi.set(__self__, "access_control_configuration", access_control_configuration)
        if captcha_configuration is not None:
            pulumi.set(__self__, "captcha_configuration", captcha_configuration)
        if connector_policies is not None:
            pulumi.set(__self__, "connector_policies", connector_policies)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if event_configurations is not None:
            pulumi.set(__self__, "event_configurations", event_configurations)
        if failed_authentication_configuration is not None:
            pulumi.set(__self__, "failed_authentication_configuration", failed_authentication_configuration)
        if family_configuration is not None:
            pulumi.set(__self__, "family_configuration", family_configuration)
        if form_configuration is not None:
            pulumi.set(__self__, "form_configuration", form_configuration)
        if http_session_max_inactive_interval is not None:
            pulumi.set(__self__, "http_session_max_inactive_interval", http_session_max_inactive_interval)
        if login_configuration is not None:
            pulumi.set(__self__, "login_configuration", login_configuration)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if maximum_password_age is not None:
            pulumi.set(__self__, "maximum_password_age", maximum_password_age)
        if minimum_password_age is not None:
            pulumi.set(__self__, "minimum_password_age", minimum_password_age)
        if multi_factor_configuration is not None:
            pulumi.set(__self__, "multi_factor_configuration", multi_factor_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_configurations is not None:
            pulumi.set(__self__, "oauth_configurations", oauth_configurations)
        if password_encryption_configurations is not None:
            pulumi.set(__self__, "password_encryption_configurations", password_encryption_configurations)
        if password_validation_rules is not None:
            pulumi.set(__self__, "password_validation_rules", password_validation_rules)
        if source_tenant_id is not None:
            pulumi.set(__self__, "source_tenant_id", source_tenant_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if user_delete_policy is not None:
            pulumi.set(__self__, "user_delete_policy", user_delete_policy)
        if username_configuration is not None:
            pulumi.set(__self__, "username_configuration", username_configuration)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> pulumi.Input['FusionAuthTenantEmailConfigurationArgs']:
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: pulumi.Input['FusionAuthTenantEmailConfigurationArgs']):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="externalIdentifierConfiguration")
    def external_identifier_configuration(self) -> pulumi.Input['FusionAuthTenantExternalIdentifierConfigurationArgs']:
        return pulumi.get(self, "external_identifier_configuration")

    @external_identifier_configuration.setter
    def external_identifier_configuration(self, value: pulumi.Input['FusionAuthTenantExternalIdentifierConfigurationArgs']):
        pulumi.set(self, "external_identifier_configuration", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[str]:
        """
        The named issuer used to sign tokens, this is generally your public fully qualified domain.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="jwtConfigurations")
    def jwt_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantJwtConfigurationArgs']]]:
        return pulumi.get(self, "jwt_configurations")

    @jwt_configurations.setter
    def jwt_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantJwtConfigurationArgs']]]):
        pulumi.set(self, "jwt_configurations", value)

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> pulumi.Input[str]:
        """
        The unique Id of the theme to be used to style the login page and other end user templates.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "theme_id", value)

    @property
    @pulumi.getter(name="accessControlConfiguration")
    def access_control_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantAccessControlConfigurationArgs']]:
        return pulumi.get(self, "access_control_configuration")

    @access_control_configuration.setter
    def access_control_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantAccessControlConfigurationArgs']]):
        pulumi.set(self, "access_control_configuration", value)

    @property
    @pulumi.getter(name="captchaConfiguration")
    def captcha_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantCaptchaConfigurationArgs']]:
        return pulumi.get(self, "captcha_configuration")

    @captcha_configuration.setter
    def captcha_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantCaptchaConfigurationArgs']]):
        pulumi.set(self, "captcha_configuration", value)

    @property
    @pulumi.getter(name="connectorPolicies")
    def connector_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]]]:
        """
        A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        """
        return pulumi.get(self, "connector_policies")

    @connector_policies.setter
    def connector_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]]]):
        pulumi.set(self, "connector_policies", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Tenant that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="eventConfigurations")
    def event_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantEventConfigurationArgs']]]]:
        return pulumi.get(self, "event_configurations")

    @event_configurations.setter
    def event_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantEventConfigurationArgs']]]]):
        pulumi.set(self, "event_configurations", value)

    @property
    @pulumi.getter(name="failedAuthenticationConfiguration")
    def failed_authentication_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantFailedAuthenticationConfigurationArgs']]:
        return pulumi.get(self, "failed_authentication_configuration")

    @failed_authentication_configuration.setter
    def failed_authentication_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantFailedAuthenticationConfigurationArgs']]):
        pulumi.set(self, "failed_authentication_configuration", value)

    @property
    @pulumi.getter(name="familyConfiguration")
    def family_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantFamilyConfigurationArgs']]:
        return pulumi.get(self, "family_configuration")

    @family_configuration.setter
    def family_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantFamilyConfigurationArgs']]):
        pulumi.set(self, "family_configuration", value)

    @property
    @pulumi.getter(name="formConfiguration")
    def form_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantFormConfigurationArgs']]:
        return pulumi.get(self, "form_configuration")

    @form_configuration.setter
    def form_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantFormConfigurationArgs']]):
        pulumi.set(self, "form_configuration", value)

    @property
    @pulumi.getter(name="httpSessionMaxInactiveInterval")
    def http_session_max_inactive_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        """
        return pulumi.get(self, "http_session_max_inactive_interval")

    @http_session_max_inactive_interval.setter
    def http_session_max_inactive_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_session_max_inactive_interval", value)

    @property
    @pulumi.getter(name="loginConfiguration")
    def login_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantLoginConfigurationArgs']]:
        return pulumi.get(self, "login_configuration")

    @login_configuration.setter
    def login_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantLoginConfigurationArgs']]):
        pulumi.set(self, "login_configuration", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[str]]:
        """
        The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter(name="maximumPasswordAge")
    def maximum_password_age(self) -> Optional[pulumi.Input['FusionAuthTenantMaximumPasswordAgeArgs']]:
        return pulumi.get(self, "maximum_password_age")

    @maximum_password_age.setter
    def maximum_password_age(self, value: Optional[pulumi.Input['FusionAuthTenantMaximumPasswordAgeArgs']]):
        pulumi.set(self, "maximum_password_age", value)

    @property
    @pulumi.getter(name="minimumPasswordAge")
    def minimum_password_age(self) -> Optional[pulumi.Input['FusionAuthTenantMinimumPasswordAgeArgs']]:
        return pulumi.get(self, "minimum_password_age")

    @minimum_password_age.setter
    def minimum_password_age(self, value: Optional[pulumi.Input['FusionAuthTenantMinimumPasswordAgeArgs']]):
        pulumi.set(self, "minimum_password_age", value)

    @property
    @pulumi.getter(name="multiFactorConfiguration")
    def multi_factor_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantMultiFactorConfigurationArgs']]:
        return pulumi.get(self, "multi_factor_configuration")

    @multi_factor_configuration.setter
    def multi_factor_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantMultiFactorConfigurationArgs']]):
        pulumi.set(self, "multi_factor_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the Tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthConfigurations")
    def oauth_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantOauthConfigurationArgs']]]]:
        return pulumi.get(self, "oauth_configurations")

    @oauth_configurations.setter
    def oauth_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantOauthConfigurationArgs']]]]):
        pulumi.set(self, "oauth_configurations", value)

    @property
    @pulumi.getter(name="passwordEncryptionConfigurations")
    def password_encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]:
        return pulumi.get(self, "password_encryption_configurations")

    @password_encryption_configurations.setter
    def password_encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "password_encryption_configurations", value)

    @property
    @pulumi.getter(name="passwordValidationRules")
    def password_validation_rules(self) -> Optional[pulumi.Input['FusionAuthTenantPasswordValidationRulesArgs']]:
        return pulumi.get(self, "password_validation_rules")

    @password_validation_rules.setter
    def password_validation_rules(self, value: Optional[pulumi.Input['FusionAuthTenantPasswordValidationRulesArgs']]):
        pulumi.set(self, "password_validation_rules", value)

    @property
    @pulumi.getter(name="sourceTenantId")
    def source_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        """
        return pulumi.get(self, "source_tenant_id")

    @source_tenant_id.setter
    def source_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_tenant_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="userDeletePolicy")
    def user_delete_policy(self) -> Optional[pulumi.Input['FusionAuthTenantUserDeletePolicyArgs']]:
        return pulumi.get(self, "user_delete_policy")

    @user_delete_policy.setter
    def user_delete_policy(self, value: Optional[pulumi.Input['FusionAuthTenantUserDeletePolicyArgs']]):
        pulumi.set(self, "user_delete_policy", value)

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantUsernameConfigurationArgs']]:
        return pulumi.get(self, "username_configuration")

    @username_configuration.setter
    def username_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantUsernameConfigurationArgs']]):
        pulumi.set(self, "username_configuration", value)


@pulumi.input_type
class _FusionAuthTenantState:
    def __init__(__self__, *,
                 access_control_configuration: Optional[pulumi.Input['FusionAuthTenantAccessControlConfigurationArgs']] = None,
                 captcha_configuration: Optional[pulumi.Input['FusionAuthTenantCaptchaConfigurationArgs']] = None,
                 connector_policies: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input['FusionAuthTenantEmailConfigurationArgs']] = None,
                 event_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantEventConfigurationArgs']]]] = None,
                 external_identifier_configuration: Optional[pulumi.Input['FusionAuthTenantExternalIdentifierConfigurationArgs']] = None,
                 failed_authentication_configuration: Optional[pulumi.Input['FusionAuthTenantFailedAuthenticationConfigurationArgs']] = None,
                 family_configuration: Optional[pulumi.Input['FusionAuthTenantFamilyConfigurationArgs']] = None,
                 form_configuration: Optional[pulumi.Input['FusionAuthTenantFormConfigurationArgs']] = None,
                 http_session_max_inactive_interval: Optional[pulumi.Input[int]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 jwt_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantJwtConfigurationArgs']]]] = None,
                 login_configuration: Optional[pulumi.Input['FusionAuthTenantLoginConfigurationArgs']] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 maximum_password_age: Optional[pulumi.Input['FusionAuthTenantMaximumPasswordAgeArgs']] = None,
                 minimum_password_age: Optional[pulumi.Input['FusionAuthTenantMinimumPasswordAgeArgs']] = None,
                 multi_factor_configuration: Optional[pulumi.Input['FusionAuthTenantMultiFactorConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantOauthConfigurationArgs']]]] = None,
                 password_encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]] = None,
                 password_validation_rules: Optional[pulumi.Input['FusionAuthTenantPasswordValidationRulesArgs']] = None,
                 source_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 user_delete_policy: Optional[pulumi.Input['FusionAuthTenantUserDeletePolicyArgs']] = None,
                 username_configuration: Optional[pulumi.Input['FusionAuthTenantUsernameConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering FusionAuthTenant resources.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]] connector_policies: A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Tenant that should be persisted.
        :param pulumi.Input[int] http_session_max_inactive_interval: Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        :param pulumi.Input[str] issuer: The named issuer used to sign tokens, this is generally your public fully qualified domain.
        :param pulumi.Input[str] logout_url: The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        :param pulumi.Input[str] name: The unique name of the Tenant.
        :param pulumi.Input[str] source_tenant_id: The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        :param pulumi.Input[str] tenant_id: The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        """
        if access_control_configuration is not None:
            pulumi.set(__self__, "access_control_configuration", access_control_configuration)
        if captcha_configuration is not None:
            pulumi.set(__self__, "captcha_configuration", captcha_configuration)
        if connector_policies is not None:
            pulumi.set(__self__, "connector_policies", connector_policies)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if event_configurations is not None:
            pulumi.set(__self__, "event_configurations", event_configurations)
        if external_identifier_configuration is not None:
            pulumi.set(__self__, "external_identifier_configuration", external_identifier_configuration)
        if failed_authentication_configuration is not None:
            pulumi.set(__self__, "failed_authentication_configuration", failed_authentication_configuration)
        if family_configuration is not None:
            pulumi.set(__self__, "family_configuration", family_configuration)
        if form_configuration is not None:
            pulumi.set(__self__, "form_configuration", form_configuration)
        if http_session_max_inactive_interval is not None:
            pulumi.set(__self__, "http_session_max_inactive_interval", http_session_max_inactive_interval)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwt_configurations is not None:
            pulumi.set(__self__, "jwt_configurations", jwt_configurations)
        if login_configuration is not None:
            pulumi.set(__self__, "login_configuration", login_configuration)
        if logout_url is not None:
            pulumi.set(__self__, "logout_url", logout_url)
        if maximum_password_age is not None:
            pulumi.set(__self__, "maximum_password_age", maximum_password_age)
        if minimum_password_age is not None:
            pulumi.set(__self__, "minimum_password_age", minimum_password_age)
        if multi_factor_configuration is not None:
            pulumi.set(__self__, "multi_factor_configuration", multi_factor_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth_configurations is not None:
            pulumi.set(__self__, "oauth_configurations", oauth_configurations)
        if password_encryption_configurations is not None:
            pulumi.set(__self__, "password_encryption_configurations", password_encryption_configurations)
        if password_validation_rules is not None:
            pulumi.set(__self__, "password_validation_rules", password_validation_rules)
        if source_tenant_id is not None:
            pulumi.set(__self__, "source_tenant_id", source_tenant_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if theme_id is not None:
            pulumi.set(__self__, "theme_id", theme_id)
        if user_delete_policy is not None:
            pulumi.set(__self__, "user_delete_policy", user_delete_policy)
        if username_configuration is not None:
            pulumi.set(__self__, "username_configuration", username_configuration)

    @property
    @pulumi.getter(name="accessControlConfiguration")
    def access_control_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantAccessControlConfigurationArgs']]:
        return pulumi.get(self, "access_control_configuration")

    @access_control_configuration.setter
    def access_control_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantAccessControlConfigurationArgs']]):
        pulumi.set(self, "access_control_configuration", value)

    @property
    @pulumi.getter(name="captchaConfiguration")
    def captcha_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantCaptchaConfigurationArgs']]:
        return pulumi.get(self, "captcha_configuration")

    @captcha_configuration.setter
    def captcha_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantCaptchaConfigurationArgs']]):
        pulumi.set(self, "captcha_configuration", value)

    @property
    @pulumi.getter(name="connectorPolicies")
    def connector_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]]]:
        """
        A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        """
        return pulumi.get(self, "connector_policies")

    @connector_policies.setter
    def connector_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantConnectorPolicyArgs']]]]):
        pulumi.set(self, "connector_policies", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Tenant that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantEmailConfigurationArgs']]:
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="eventConfigurations")
    def event_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantEventConfigurationArgs']]]]:
        return pulumi.get(self, "event_configurations")

    @event_configurations.setter
    def event_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantEventConfigurationArgs']]]]):
        pulumi.set(self, "event_configurations", value)

    @property
    @pulumi.getter(name="externalIdentifierConfiguration")
    def external_identifier_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantExternalIdentifierConfigurationArgs']]:
        return pulumi.get(self, "external_identifier_configuration")

    @external_identifier_configuration.setter
    def external_identifier_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantExternalIdentifierConfigurationArgs']]):
        pulumi.set(self, "external_identifier_configuration", value)

    @property
    @pulumi.getter(name="failedAuthenticationConfiguration")
    def failed_authentication_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantFailedAuthenticationConfigurationArgs']]:
        return pulumi.get(self, "failed_authentication_configuration")

    @failed_authentication_configuration.setter
    def failed_authentication_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantFailedAuthenticationConfigurationArgs']]):
        pulumi.set(self, "failed_authentication_configuration", value)

    @property
    @pulumi.getter(name="familyConfiguration")
    def family_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantFamilyConfigurationArgs']]:
        return pulumi.get(self, "family_configuration")

    @family_configuration.setter
    def family_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantFamilyConfigurationArgs']]):
        pulumi.set(self, "family_configuration", value)

    @property
    @pulumi.getter(name="formConfiguration")
    def form_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantFormConfigurationArgs']]:
        return pulumi.get(self, "form_configuration")

    @form_configuration.setter
    def form_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantFormConfigurationArgs']]):
        pulumi.set(self, "form_configuration", value)

    @property
    @pulumi.getter(name="httpSessionMaxInactiveInterval")
    def http_session_max_inactive_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        """
        return pulumi.get(self, "http_session_max_inactive_interval")

    @http_session_max_inactive_interval.setter
    def http_session_max_inactive_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_session_max_inactive_interval", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The named issuer used to sign tokens, this is generally your public fully qualified domain.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="jwtConfigurations")
    def jwt_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantJwtConfigurationArgs']]]]:
        return pulumi.get(self, "jwt_configurations")

    @jwt_configurations.setter
    def jwt_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantJwtConfigurationArgs']]]]):
        pulumi.set(self, "jwt_configurations", value)

    @property
    @pulumi.getter(name="loginConfiguration")
    def login_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantLoginConfigurationArgs']]:
        return pulumi.get(self, "login_configuration")

    @login_configuration.setter
    def login_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantLoginConfigurationArgs']]):
        pulumi.set(self, "login_configuration", value)

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> Optional[pulumi.Input[str]]:
        """
        The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        """
        return pulumi.get(self, "logout_url")

    @logout_url.setter
    def logout_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_url", value)

    @property
    @pulumi.getter(name="maximumPasswordAge")
    def maximum_password_age(self) -> Optional[pulumi.Input['FusionAuthTenantMaximumPasswordAgeArgs']]:
        return pulumi.get(self, "maximum_password_age")

    @maximum_password_age.setter
    def maximum_password_age(self, value: Optional[pulumi.Input['FusionAuthTenantMaximumPasswordAgeArgs']]):
        pulumi.set(self, "maximum_password_age", value)

    @property
    @pulumi.getter(name="minimumPasswordAge")
    def minimum_password_age(self) -> Optional[pulumi.Input['FusionAuthTenantMinimumPasswordAgeArgs']]:
        return pulumi.get(self, "minimum_password_age")

    @minimum_password_age.setter
    def minimum_password_age(self, value: Optional[pulumi.Input['FusionAuthTenantMinimumPasswordAgeArgs']]):
        pulumi.set(self, "minimum_password_age", value)

    @property
    @pulumi.getter(name="multiFactorConfiguration")
    def multi_factor_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantMultiFactorConfigurationArgs']]:
        return pulumi.get(self, "multi_factor_configuration")

    @multi_factor_configuration.setter
    def multi_factor_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantMultiFactorConfigurationArgs']]):
        pulumi.set(self, "multi_factor_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the Tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauthConfigurations")
    def oauth_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantOauthConfigurationArgs']]]]:
        return pulumi.get(self, "oauth_configurations")

    @oauth_configurations.setter
    def oauth_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantOauthConfigurationArgs']]]]):
        pulumi.set(self, "oauth_configurations", value)

    @property
    @pulumi.getter(name="passwordEncryptionConfigurations")
    def password_encryption_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]:
        return pulumi.get(self, "password_encryption_configurations")

    @password_encryption_configurations.setter
    def password_encryption_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]):
        pulumi.set(self, "password_encryption_configurations", value)

    @property
    @pulumi.getter(name="passwordValidationRules")
    def password_validation_rules(self) -> Optional[pulumi.Input['FusionAuthTenantPasswordValidationRulesArgs']]:
        return pulumi.get(self, "password_validation_rules")

    @password_validation_rules.setter
    def password_validation_rules(self, value: Optional[pulumi.Input['FusionAuthTenantPasswordValidationRulesArgs']]):
        pulumi.set(self, "password_validation_rules", value)

    @property
    @pulumi.getter(name="sourceTenantId")
    def source_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        """
        return pulumi.get(self, "source_tenant_id")

    @source_tenant_id.setter
    def source_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_tenant_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the theme to be used to style the login page and other end user templates.
        """
        return pulumi.get(self, "theme_id")

    @theme_id.setter
    def theme_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "theme_id", value)

    @property
    @pulumi.getter(name="userDeletePolicy")
    def user_delete_policy(self) -> Optional[pulumi.Input['FusionAuthTenantUserDeletePolicyArgs']]:
        return pulumi.get(self, "user_delete_policy")

    @user_delete_policy.setter
    def user_delete_policy(self, value: Optional[pulumi.Input['FusionAuthTenantUserDeletePolicyArgs']]):
        pulumi.set(self, "user_delete_policy", value)

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> Optional[pulumi.Input['FusionAuthTenantUsernameConfigurationArgs']]:
        return pulumi.get(self, "username_configuration")

    @username_configuration.setter
    def username_configuration(self, value: Optional[pulumi.Input['FusionAuthTenantUsernameConfigurationArgs']]):
        pulumi.set(self, "username_configuration", value)


class FusionAuthTenant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantAccessControlConfigurationArgs']]] = None,
                 captcha_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantCaptchaConfigurationArgs']]] = None,
                 connector_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantConnectorPolicyArgs']]]]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantEmailConfigurationArgs']]] = None,
                 event_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantEventConfigurationArgs']]]]] = None,
                 external_identifier_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantExternalIdentifierConfigurationArgs']]] = None,
                 failed_authentication_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFailedAuthenticationConfigurationArgs']]] = None,
                 family_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFamilyConfigurationArgs']]] = None,
                 form_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFormConfigurationArgs']]] = None,
                 http_session_max_inactive_interval: Optional[pulumi.Input[int]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 jwt_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantJwtConfigurationArgs']]]]] = None,
                 login_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantLoginConfigurationArgs']]] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 maximum_password_age: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMaximumPasswordAgeArgs']]] = None,
                 minimum_password_age: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMinimumPasswordAgeArgs']]] = None,
                 multi_factor_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMultiFactorConfigurationArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantOauthConfigurationArgs']]]]] = None,
                 password_encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]] = None,
                 password_validation_rules: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantPasswordValidationRulesArgs']]] = None,
                 source_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 user_delete_policy: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantUserDeletePolicyArgs']]] = None,
                 username_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantUsernameConfigurationArgs']]] = None,
                 __props__=None):
        """
        ## # Tenant Resource

        A FusionAuth Tenant is a named object that represents a discrete namespace for Users, Applications and Groups. A user is unique by email address or username within a tenant.

        Tenants may be useful to support a multi-tenant application where you wish to use a single instance of FusionAuth but require the ability to have duplicate users across the tenants in your own application. In this scenario a user may exist multiple times with the same email address and different passwords across tenants.

        Tenants may also be useful in a test or staging environment to allow multiple users to call APIs and create and modify users without possibility of collision.

        [Tenants API](https://fusionauth.io/docs/v1/tech/apis/tenants)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthTenant("example",
            connector_policies=[fusionauth.FusionAuthTenantConnectorPolicyArgs(
                connector_id="b57b3d0f-f7a4-4831-a838-549717362ea8",
                domains=["*"],
                migrate=False,
            )],
            email_configuration=fusionauth.FusionAuthTenantEmailConfigurationArgs(
                forgot_password_email_template_id=fusionauth_email["ForgotPassword_Example"]["id"],
                host="smtp.sendgrid.net",
                password="password",
                passwordless_email_template_id=fusionauth_email["PasswordlessLogin_Example"]["id"],
                port=587,
                security="TLS",
                set_password_email_template_id=fusionauth_email["SetupPassword_Example"]["id"],
                username="username",
                verify_email=True,
                verify_email_when_changed=True,
            ),
            event_configurations=[
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.delete",
                    enabled=True,
                    transaction_type="None",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.create",
                    enabled=True,
                    transaction_type="None",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.update",
                    enabled=True,
                    transaction_type="None",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.deactivate",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.bulk.create",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.reactivate",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="jwt.refresh-token.revoke",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="jwt.refresh",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="jwt.public-key.update",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.login.success",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.login.failed",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.create",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.update",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.delete",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.verified",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.email.verified",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.identity-provider.link",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.identity-provider.unlink",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.password.breach",
                    enabled=False,
                    transaction_type="None",
                ),
            ],
            external_identifier_configuration=fusionauth.FusionAuthTenantExternalIdentifierConfigurationArgs(
                authorization_grant_id_time_to_live_in_seconds=30,
                change_password_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationChangePasswordIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                change_password_id_time_to_live_in_seconds=600,
                device_code_time_to_live_in_seconds=1800,
                device_user_code_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationDeviceUserCodeIdGeneratorArgs(
                    length=6,
                    type="randomAlphaNumeric",
                ),
                email_verification_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationEmailVerificationIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                email_verification_id_time_to_live_in_seconds=86400,
                email_verification_one_time_code_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationEmailVerificationOneTimeCodeGeneratorArgs(
                    length=6,
                    type="randomAlphaNumeric",
                ),
                external_authentication_id_time_to_live_in_seconds=300,
                one_time_password_time_to_live_in_seconds=60,
                passwordless_login_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationPasswordlessLoginGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                passwordless_login_time_to_live_in_seconds=600,
                registration_verification_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationRegistrationVerificationIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                registration_verification_id_time_to_live_in_seconds=86400,
                registration_verification_one_time_code_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationRegistrationVerificationOneTimeCodeGeneratorArgs(
                    length=6,
                    type="randomAlphaNumeric",
                ),
                saml_v2_authn_request_id_ttl_seconds=300,
                setup_password_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationSetupPasswordIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                setup_password_id_time_to_live_in_seconds=86400,
                two_factor_id_time_to_live_in_seconds=300,
                two_factor_one_time_code_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationTwoFactorOneTimeCodeIdGeneratorArgs(
                    length=6,
                    type="randomDigits",
                ),
                two_factor_trust_id_time_to_live_in_seconds=2592000,
            ),
            failed_authentication_configuration=fusionauth.FusionAuthTenantFailedAuthenticationConfigurationArgs(
                action_duration=3,
                action_duration_unit="MINUTES",
                reset_count_in_seconds=60,
                too_many_attempts=5,
            ),
            family_configuration=fusionauth.FusionAuthTenantFamilyConfigurationArgs(
                allow_child_registrations=True,
                delete_orphaned_accounts=False,
                delete_orphaned_accounts_days=30,
                enabled=True,
                maximum_child_age=12,
                minimum_owner_age=21,
                parent_email_required=False,
            ),
            form_configuration=fusionauth.FusionAuthTenantFormConfigurationArgs(
                admin_user_form_id="e92751a5-25f4-4bca-ad91-66cdf67725d2",
            ),
            http_session_max_inactive_interval=3600,
            issuer="https://example.com",
            jwt_configurations=[fusionauth.FusionAuthTenantJwtConfigurationArgs(
                access_token_key_id=fusionauth_key["accesstoken"]["id"],
                id_token_key_id=fusionauth_key["idtoken"]["id"],
                refresh_token_time_to_live_in_minutes=43200,
                time_to_live_in_seconds=3600,
            )],
            login_configuration=fusionauth.FusionAuthTenantLoginConfigurationArgs(
                require_authentication=True,
            ),
            maximum_password_age=fusionauth.FusionAuthTenantMaximumPasswordAgeArgs(
                days=180,
                enabled=False,
            ),
            minimum_password_age=fusionauth.FusionAuthTenantMinimumPasswordAgeArgs(
                enabled=False,
                seconds=30,
            ),
            oauth_configurations=[fusionauth.FusionAuthTenantOauthConfigurationArgs(
                client_credentials_access_token_populate_lambda_id=fusionauth_lambda["client_jwt_populate"]["id"],
            )],
            password_encryption_configurations=[fusionauth.FusionAuthTenantPasswordEncryptionConfigurationArgs(
                encryption_scheme="salted-pbkdf2-hmac-sha256",
                encryption_scheme_factor=24000,
                modify_encryption_scheme_on_login=False,
            )],
            password_validation_rules=fusionauth.FusionAuthTenantPasswordValidationRulesArgs(
                max_length=256,
                min_length=7,
                remember_previous_passwords=fusionauth.FusionAuthTenantPasswordValidationRulesRememberPreviousPasswordsArgs(
                    count=1,
                    enabled=False,
                ),
                required_mixed_case=False,
                require_non_alpha=False,
                require_number=False,
                validate_on_login=False,
            ),
            theme_id=fusionauth_theme["example_theme"]["id"],
            user_delete_policy=fusionauth.FusionAuthTenantUserDeletePolicyArgs(
                unverified_enabled=False,
                unverified_number_of_days_to_retain=30,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantConnectorPolicyArgs']]]] connector_policies: A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Tenant that should be persisted.
        :param pulumi.Input[int] http_session_max_inactive_interval: Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        :param pulumi.Input[str] issuer: The named issuer used to sign tokens, this is generally your public fully qualified domain.
        :param pulumi.Input[str] logout_url: The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        :param pulumi.Input[str] name: The unique name of the Tenant.
        :param pulumi.Input[str] source_tenant_id: The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        :param pulumi.Input[str] tenant_id: The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthTenantArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Tenant Resource

        A FusionAuth Tenant is a named object that represents a discrete namespace for Users, Applications and Groups. A user is unique by email address or username within a tenant.

        Tenants may be useful to support a multi-tenant application where you wish to use a single instance of FusionAuth but require the ability to have duplicate users across the tenants in your own application. In this scenario a user may exist multiple times with the same email address and different passwords across tenants.

        Tenants may also be useful in a test or staging environment to allow multiple users to call APIs and create and modify users without possibility of collision.

        [Tenants API](https://fusionauth.io/docs/v1/tech/apis/tenants)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        example = fusionauth.FusionAuthTenant("example",
            connector_policies=[fusionauth.FusionAuthTenantConnectorPolicyArgs(
                connector_id="b57b3d0f-f7a4-4831-a838-549717362ea8",
                domains=["*"],
                migrate=False,
            )],
            email_configuration=fusionauth.FusionAuthTenantEmailConfigurationArgs(
                forgot_password_email_template_id=fusionauth_email["ForgotPassword_Example"]["id"],
                host="smtp.sendgrid.net",
                password="password",
                passwordless_email_template_id=fusionauth_email["PasswordlessLogin_Example"]["id"],
                port=587,
                security="TLS",
                set_password_email_template_id=fusionauth_email["SetupPassword_Example"]["id"],
                username="username",
                verify_email=True,
                verify_email_when_changed=True,
            ),
            event_configurations=[
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.delete",
                    enabled=True,
                    transaction_type="None",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.create",
                    enabled=True,
                    transaction_type="None",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.update",
                    enabled=True,
                    transaction_type="None",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.deactivate",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.bulk.create",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.reactivate",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="jwt.refresh-token.revoke",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="jwt.refresh",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="jwt.public-key.update",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.login.success",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.login.failed",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.create",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.update",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.delete",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.registration.verified",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.email.verified",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.identity-provider.link",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.identity-provider.unlink",
                    enabled=True,
                    transaction_type="Any",
                ),
                fusionauth.FusionAuthTenantEventConfigurationArgs(
                    event="user.password.breach",
                    enabled=False,
                    transaction_type="None",
                ),
            ],
            external_identifier_configuration=fusionauth.FusionAuthTenantExternalIdentifierConfigurationArgs(
                authorization_grant_id_time_to_live_in_seconds=30,
                change_password_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationChangePasswordIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                change_password_id_time_to_live_in_seconds=600,
                device_code_time_to_live_in_seconds=1800,
                device_user_code_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationDeviceUserCodeIdGeneratorArgs(
                    length=6,
                    type="randomAlphaNumeric",
                ),
                email_verification_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationEmailVerificationIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                email_verification_id_time_to_live_in_seconds=86400,
                email_verification_one_time_code_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationEmailVerificationOneTimeCodeGeneratorArgs(
                    length=6,
                    type="randomAlphaNumeric",
                ),
                external_authentication_id_time_to_live_in_seconds=300,
                one_time_password_time_to_live_in_seconds=60,
                passwordless_login_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationPasswordlessLoginGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                passwordless_login_time_to_live_in_seconds=600,
                registration_verification_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationRegistrationVerificationIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                registration_verification_id_time_to_live_in_seconds=86400,
                registration_verification_one_time_code_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationRegistrationVerificationOneTimeCodeGeneratorArgs(
                    length=6,
                    type="randomAlphaNumeric",
                ),
                saml_v2_authn_request_id_ttl_seconds=300,
                setup_password_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationSetupPasswordIdGeneratorArgs(
                    length=32,
                    type="randomBytes",
                ),
                setup_password_id_time_to_live_in_seconds=86400,
                two_factor_id_time_to_live_in_seconds=300,
                two_factor_one_time_code_id_generator=fusionauth.FusionAuthTenantExternalIdentifierConfigurationTwoFactorOneTimeCodeIdGeneratorArgs(
                    length=6,
                    type="randomDigits",
                ),
                two_factor_trust_id_time_to_live_in_seconds=2592000,
            ),
            failed_authentication_configuration=fusionauth.FusionAuthTenantFailedAuthenticationConfigurationArgs(
                action_duration=3,
                action_duration_unit="MINUTES",
                reset_count_in_seconds=60,
                too_many_attempts=5,
            ),
            family_configuration=fusionauth.FusionAuthTenantFamilyConfigurationArgs(
                allow_child_registrations=True,
                delete_orphaned_accounts=False,
                delete_orphaned_accounts_days=30,
                enabled=True,
                maximum_child_age=12,
                minimum_owner_age=21,
                parent_email_required=False,
            ),
            form_configuration=fusionauth.FusionAuthTenantFormConfigurationArgs(
                admin_user_form_id="e92751a5-25f4-4bca-ad91-66cdf67725d2",
            ),
            http_session_max_inactive_interval=3600,
            issuer="https://example.com",
            jwt_configurations=[fusionauth.FusionAuthTenantJwtConfigurationArgs(
                access_token_key_id=fusionauth_key["accesstoken"]["id"],
                id_token_key_id=fusionauth_key["idtoken"]["id"],
                refresh_token_time_to_live_in_minutes=43200,
                time_to_live_in_seconds=3600,
            )],
            login_configuration=fusionauth.FusionAuthTenantLoginConfigurationArgs(
                require_authentication=True,
            ),
            maximum_password_age=fusionauth.FusionAuthTenantMaximumPasswordAgeArgs(
                days=180,
                enabled=False,
            ),
            minimum_password_age=fusionauth.FusionAuthTenantMinimumPasswordAgeArgs(
                enabled=False,
                seconds=30,
            ),
            oauth_configurations=[fusionauth.FusionAuthTenantOauthConfigurationArgs(
                client_credentials_access_token_populate_lambda_id=fusionauth_lambda["client_jwt_populate"]["id"],
            )],
            password_encryption_configurations=[fusionauth.FusionAuthTenantPasswordEncryptionConfigurationArgs(
                encryption_scheme="salted-pbkdf2-hmac-sha256",
                encryption_scheme_factor=24000,
                modify_encryption_scheme_on_login=False,
            )],
            password_validation_rules=fusionauth.FusionAuthTenantPasswordValidationRulesArgs(
                max_length=256,
                min_length=7,
                remember_previous_passwords=fusionauth.FusionAuthTenantPasswordValidationRulesRememberPreviousPasswordsArgs(
                    count=1,
                    enabled=False,
                ),
                required_mixed_case=False,
                require_non_alpha=False,
                require_number=False,
                validate_on_login=False,
            ),
            theme_id=fusionauth_theme["example_theme"]["id"],
            user_delete_policy=fusionauth.FusionAuthTenantUserDeletePolicyArgs(
                unverified_enabled=False,
                unverified_number_of_days_to_retain=30,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthTenantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthTenantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantAccessControlConfigurationArgs']]] = None,
                 captcha_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantCaptchaConfigurationArgs']]] = None,
                 connector_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantConnectorPolicyArgs']]]]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 email_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantEmailConfigurationArgs']]] = None,
                 event_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantEventConfigurationArgs']]]]] = None,
                 external_identifier_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantExternalIdentifierConfigurationArgs']]] = None,
                 failed_authentication_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFailedAuthenticationConfigurationArgs']]] = None,
                 family_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFamilyConfigurationArgs']]] = None,
                 form_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFormConfigurationArgs']]] = None,
                 http_session_max_inactive_interval: Optional[pulumi.Input[int]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 jwt_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantJwtConfigurationArgs']]]]] = None,
                 login_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantLoginConfigurationArgs']]] = None,
                 logout_url: Optional[pulumi.Input[str]] = None,
                 maximum_password_age: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMaximumPasswordAgeArgs']]] = None,
                 minimum_password_age: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMinimumPasswordAgeArgs']]] = None,
                 multi_factor_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMultiFactorConfigurationArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantOauthConfigurationArgs']]]]] = None,
                 password_encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]] = None,
                 password_validation_rules: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantPasswordValidationRulesArgs']]] = None,
                 source_tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 theme_id: Optional[pulumi.Input[str]] = None,
                 user_delete_policy: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantUserDeletePolicyArgs']]] = None,
                 username_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantUsernameConfigurationArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthTenantArgs.__new__(FusionAuthTenantArgs)

            __props__.__dict__["access_control_configuration"] = access_control_configuration
            __props__.__dict__["captcha_configuration"] = captcha_configuration
            __props__.__dict__["connector_policies"] = connector_policies
            __props__.__dict__["data"] = data
            if email_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'email_configuration'")
            __props__.__dict__["email_configuration"] = email_configuration
            __props__.__dict__["event_configurations"] = event_configurations
            if external_identifier_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'external_identifier_configuration'")
            __props__.__dict__["external_identifier_configuration"] = external_identifier_configuration
            __props__.__dict__["failed_authentication_configuration"] = failed_authentication_configuration
            __props__.__dict__["family_configuration"] = family_configuration
            __props__.__dict__["form_configuration"] = form_configuration
            __props__.__dict__["http_session_max_inactive_interval"] = http_session_max_inactive_interval
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            if jwt_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'jwt_configurations'")
            __props__.__dict__["jwt_configurations"] = jwt_configurations
            __props__.__dict__["login_configuration"] = login_configuration
            __props__.__dict__["logout_url"] = logout_url
            __props__.__dict__["maximum_password_age"] = maximum_password_age
            __props__.__dict__["minimum_password_age"] = minimum_password_age
            __props__.__dict__["multi_factor_configuration"] = multi_factor_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth_configurations"] = oauth_configurations
            __props__.__dict__["password_encryption_configurations"] = password_encryption_configurations
            __props__.__dict__["password_validation_rules"] = password_validation_rules
            __props__.__dict__["source_tenant_id"] = source_tenant_id
            __props__.__dict__["tenant_id"] = tenant_id
            if theme_id is None and not opts.urn:
                raise TypeError("Missing required property 'theme_id'")
            __props__.__dict__["theme_id"] = theme_id
            __props__.__dict__["user_delete_policy"] = user_delete_policy
            __props__.__dict__["username_configuration"] = username_configuration
        super(FusionAuthTenant, __self__).__init__(
            'fusionauth:index/fusionAuthTenant:FusionAuthTenant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantAccessControlConfigurationArgs']]] = None,
            captcha_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantCaptchaConfigurationArgs']]] = None,
            connector_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantConnectorPolicyArgs']]]]] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            email_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantEmailConfigurationArgs']]] = None,
            event_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantEventConfigurationArgs']]]]] = None,
            external_identifier_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantExternalIdentifierConfigurationArgs']]] = None,
            failed_authentication_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFailedAuthenticationConfigurationArgs']]] = None,
            family_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFamilyConfigurationArgs']]] = None,
            form_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantFormConfigurationArgs']]] = None,
            http_session_max_inactive_interval: Optional[pulumi.Input[int]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            jwt_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantJwtConfigurationArgs']]]]] = None,
            login_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantLoginConfigurationArgs']]] = None,
            logout_url: Optional[pulumi.Input[str]] = None,
            maximum_password_age: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMaximumPasswordAgeArgs']]] = None,
            minimum_password_age: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMinimumPasswordAgeArgs']]] = None,
            multi_factor_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantMultiFactorConfigurationArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantOauthConfigurationArgs']]]]] = None,
            password_encryption_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantPasswordEncryptionConfigurationArgs']]]]] = None,
            password_validation_rules: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantPasswordValidationRulesArgs']]] = None,
            source_tenant_id: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            theme_id: Optional[pulumi.Input[str]] = None,
            user_delete_policy: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantUserDeletePolicyArgs']]] = None,
            username_configuration: Optional[pulumi.Input[pulumi.InputType['FusionAuthTenantUsernameConfigurationArgs']]] = None) -> 'FusionAuthTenant':
        """
        Get an existing FusionAuthTenant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthTenantConnectorPolicyArgs']]]] connector_policies: A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Tenant that should be persisted.
        :param pulumi.Input[int] http_session_max_inactive_interval: Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        :param pulumi.Input[str] issuer: The named issuer used to sign tokens, this is generally your public fully qualified domain.
        :param pulumi.Input[str] logout_url: The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        :param pulumi.Input[str] name: The unique name of the Tenant.
        :param pulumi.Input[str] source_tenant_id: The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        :param pulumi.Input[str] tenant_id: The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] theme_id: The unique Id of the theme to be used to style the login page and other end user templates.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthTenantState.__new__(_FusionAuthTenantState)

        __props__.__dict__["access_control_configuration"] = access_control_configuration
        __props__.__dict__["captcha_configuration"] = captcha_configuration
        __props__.__dict__["connector_policies"] = connector_policies
        __props__.__dict__["data"] = data
        __props__.__dict__["email_configuration"] = email_configuration
        __props__.__dict__["event_configurations"] = event_configurations
        __props__.__dict__["external_identifier_configuration"] = external_identifier_configuration
        __props__.__dict__["failed_authentication_configuration"] = failed_authentication_configuration
        __props__.__dict__["family_configuration"] = family_configuration
        __props__.__dict__["form_configuration"] = form_configuration
        __props__.__dict__["http_session_max_inactive_interval"] = http_session_max_inactive_interval
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["jwt_configurations"] = jwt_configurations
        __props__.__dict__["login_configuration"] = login_configuration
        __props__.__dict__["logout_url"] = logout_url
        __props__.__dict__["maximum_password_age"] = maximum_password_age
        __props__.__dict__["minimum_password_age"] = minimum_password_age
        __props__.__dict__["multi_factor_configuration"] = multi_factor_configuration
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth_configurations"] = oauth_configurations
        __props__.__dict__["password_encryption_configurations"] = password_encryption_configurations
        __props__.__dict__["password_validation_rules"] = password_validation_rules
        __props__.__dict__["source_tenant_id"] = source_tenant_id
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["theme_id"] = theme_id
        __props__.__dict__["user_delete_policy"] = user_delete_policy
        __props__.__dict__["username_configuration"] = username_configuration
        return FusionAuthTenant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessControlConfiguration")
    def access_control_configuration(self) -> pulumi.Output[Optional['outputs.FusionAuthTenantAccessControlConfiguration']]:
        return pulumi.get(self, "access_control_configuration")

    @property
    @pulumi.getter(name="captchaConfiguration")
    def captcha_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantCaptchaConfiguration']:
        return pulumi.get(self, "captcha_configuration")

    @property
    @pulumi.getter(name="connectorPolicies")
    def connector_policies(self) -> pulumi.Output[Sequence['outputs.FusionAuthTenantConnectorPolicy']]:
        """
        A list of Connector policies. Users will be authenticated against Connectors in order. Each Connector can be included in this list at most once and must exist.
        """
        return pulumi.get(self, "connector_policies")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Tenant that should be persisted.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantEmailConfiguration']:
        return pulumi.get(self, "email_configuration")

    @property
    @pulumi.getter(name="eventConfigurations")
    def event_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthTenantEventConfiguration']]]:
        return pulumi.get(self, "event_configurations")

    @property
    @pulumi.getter(name="externalIdentifierConfiguration")
    def external_identifier_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantExternalIdentifierConfiguration']:
        return pulumi.get(self, "external_identifier_configuration")

    @property
    @pulumi.getter(name="failedAuthenticationConfiguration")
    def failed_authentication_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantFailedAuthenticationConfiguration']:
        return pulumi.get(self, "failed_authentication_configuration")

    @property
    @pulumi.getter(name="familyConfiguration")
    def family_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantFamilyConfiguration']:
        return pulumi.get(self, "family_configuration")

    @property
    @pulumi.getter(name="formConfiguration")
    def form_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantFormConfiguration']:
        return pulumi.get(self, "form_configuration")

    @property
    @pulumi.getter(name="httpSessionMaxInactiveInterval")
    def http_session_max_inactive_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Time in seconds until an inactive session will be invalidated. Used when creating a new session in the FusionAuth OAuth frontend.
        """
        return pulumi.get(self, "http_session_max_inactive_interval")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        The named issuer used to sign tokens, this is generally your public fully qualified domain.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="jwtConfigurations")
    def jwt_configurations(self) -> pulumi.Output[Sequence['outputs.FusionAuthTenantJwtConfiguration']]:
        return pulumi.get(self, "jwt_configurations")

    @property
    @pulumi.getter(name="loginConfiguration")
    def login_configuration(self) -> pulumi.Output[Optional['outputs.FusionAuthTenantLoginConfiguration']]:
        return pulumi.get(self, "login_configuration")

    @property
    @pulumi.getter(name="logoutUrl")
    def logout_url(self) -> pulumi.Output[Optional[str]]:
        """
        The logout redirect URL when sending the user’s browser to the /oauth2/logout URI of the FusionAuth Front End. This value is only used when a logout URL is not defined in your Application.
        """
        return pulumi.get(self, "logout_url")

    @property
    @pulumi.getter(name="maximumPasswordAge")
    def maximum_password_age(self) -> pulumi.Output['outputs.FusionAuthTenantMaximumPasswordAge']:
        return pulumi.get(self, "maximum_password_age")

    @property
    @pulumi.getter(name="minimumPasswordAge")
    def minimum_password_age(self) -> pulumi.Output['outputs.FusionAuthTenantMinimumPasswordAge']:
        return pulumi.get(self, "minimum_password_age")

    @property
    @pulumi.getter(name="multiFactorConfiguration")
    def multi_factor_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantMultiFactorConfiguration']:
        return pulumi.get(self, "multi_factor_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique name of the Tenant.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthConfigurations")
    def oauth_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthTenantOauthConfiguration']]]:
        return pulumi.get(self, "oauth_configurations")

    @property
    @pulumi.getter(name="passwordEncryptionConfigurations")
    def password_encryption_configurations(self) -> pulumi.Output[Sequence['outputs.FusionAuthTenantPasswordEncryptionConfiguration']]:
        return pulumi.get(self, "password_encryption_configurations")

    @property
    @pulumi.getter(name="passwordValidationRules")
    def password_validation_rules(self) -> pulumi.Output['outputs.FusionAuthTenantPasswordValidationRules']:
        return pulumi.get(self, "password_validation_rules")

    @property
    @pulumi.getter(name="sourceTenantId")
    def source_tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        The optional Id of an existing Tenant to make a copy of. If present, the tenant.id and tenant.name values of the request body will be applied to the new Tenant, all other values will be copied from the source Tenant to the new Tenant.
        """
        return pulumi.get(self, "source_tenant_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The Id to use for the new Tenant. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="themeId")
    def theme_id(self) -> pulumi.Output[str]:
        """
        The unique Id of the theme to be used to style the login page and other end user templates.
        """
        return pulumi.get(self, "theme_id")

    @property
    @pulumi.getter(name="userDeletePolicy")
    def user_delete_policy(self) -> pulumi.Output['outputs.FusionAuthTenantUserDeletePolicy']:
        return pulumi.get(self, "user_delete_policy")

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> pulumi.Output['outputs.FusionAuthTenantUsernameConfiguration']:
        return pulumi.get(self, "username_configuration")

