# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthIdpSamlv2Args', 'FusionAuthIdpSamlv2']

@pulumi.input_type
class FusionAuthIdpSamlv2Args:
    def __init__(__self__, *,
                 button_text: pulumi.Input[str],
                 key_id: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email_claim: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_endpoint: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 request_signing_key: Optional[pulumi.Input[str]] = None,
                 sign_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]]] = None,
                 use_name_for_email: Optional[pulumi.Input[bool]] = None,
                 xml_signature_canonicalization_method: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthIdpSamlv2 resource.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] key_id: The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[str] email_claim: The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_endpoint: The SAML v2 login page of the identity provider.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] name_id_format: Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[str] request_signing_key: TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        :param pulumi.Input[bool] sign_request: When true authentication requests sent to the identity provider will be signed.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[bool] use_name_for_email: Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        :param pulumi.Input[str] xml_signature_canonicalization_method: The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        pulumi.set(__self__, "button_text", button_text)
        pulumi.set(__self__, "key_id", key_id)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_image_url is not None:
            pulumi.set(__self__, "button_image_url", button_image_url)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if email_claim is not None:
            pulumi.set(__self__, "email_claim", email_claim)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_endpoint is not None:
            pulumi.set(__self__, "idp_endpoint", idp_endpoint)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if post_request is not None:
            pulumi.set(__self__, "post_request", post_request)
        if request_signing_key is not None:
            pulumi.set(__self__, "request_signing_key", request_signing_key)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)
        if use_name_for_email is not None:
            pulumi.set(__self__, "use_name_for_email", use_name_for_email)
        if xml_signature_canonicalization_method is not None:
            pulumi.set(__self__, "xml_signature_canonicalization_method", xml_signature_canonicalization_method)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Input[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonImageUrl")
    def button_image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_image_url")

    @button_image_url.setter
    def button_image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_image_url", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="emailClaim")
    def email_claim(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        """
        return pulumi.get(self, "email_claim")

    @email_claim.setter
    def email_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_claim", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpEndpoint")
    def idp_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The SAML v2 login page of the identity provider.
        """
        return pulumi.get(self, "idp_endpoint")

    @idp_endpoint.setter
    def idp_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_endpoint", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this OpenID Connect identity provider. This is only used for display purposes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        """
        return pulumi.get(self, "name_id_format")

    @name_id_format.setter
    def name_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_id_format", value)

    @property
    @pulumi.getter(name="postRequest")
    def post_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        """
        return pulumi.get(self, "post_request")

    @post_request.setter
    def post_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "post_request", value)

    @property
    @pulumi.getter(name="requestSigningKey")
    def request_signing_key(self) -> Optional[pulumi.Input[str]]:
        """
        TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        """
        return pulumi.get(self, "request_signing_key")

    @request_signing_key.setter
    def request_signing_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_signing_key", value)

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[pulumi.Input[bool]]:
        """
        When true authentication requests sent to the identity provider will be signed.
        """
        return pulumi.get(self, "sign_request")

    @sign_request.setter
    def sign_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_request", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)

    @property
    @pulumi.getter(name="useNameForEmail")
    def use_name_for_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        """
        return pulumi.get(self, "use_name_for_email")

    @use_name_for_email.setter
    def use_name_for_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_name_for_email", value)

    @property
    @pulumi.getter(name="xmlSignatureCanonicalizationMethod")
    def xml_signature_canonicalization_method(self) -> Optional[pulumi.Input[str]]:
        """
        The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        return pulumi.get(self, "xml_signature_canonicalization_method")

    @xml_signature_canonicalization_method.setter
    def xml_signature_canonicalization_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xml_signature_canonicalization_method", value)


@pulumi.input_type
class _FusionAuthIdpSamlv2State:
    def __init__(__self__, *,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email_claim: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_endpoint: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 request_signing_key: Optional[pulumi.Input[str]] = None,
                 sign_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]]] = None,
                 use_name_for_email: Optional[pulumi.Input[bool]] = None,
                 xml_signature_canonicalization_method: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthIdpSamlv2 resources.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[str] email_claim: The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_endpoint: The SAML v2 login page of the identity provider.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] key_id: The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] name_id_format: Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[str] request_signing_key: TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        :param pulumi.Input[bool] sign_request: When true authentication requests sent to the identity provider will be signed.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[bool] use_name_for_email: Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        :param pulumi.Input[str] xml_signature_canonicalization_method: The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_image_url is not None:
            pulumi.set(__self__, "button_image_url", button_image_url)
        if button_text is not None:
            pulumi.set(__self__, "button_text", button_text)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if email_claim is not None:
            pulumi.set(__self__, "email_claim", email_claim)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_endpoint is not None:
            pulumi.set(__self__, "idp_endpoint", idp_endpoint)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if post_request is not None:
            pulumi.set(__self__, "post_request", post_request)
        if request_signing_key is not None:
            pulumi.set(__self__, "request_signing_key", request_signing_key)
        if sign_request is not None:
            pulumi.set(__self__, "sign_request", sign_request)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)
        if use_name_for_email is not None:
            pulumi.set(__self__, "use_name_for_email", use_name_for_email)
        if xml_signature_canonicalization_method is not None:
            pulumi.set(__self__, "xml_signature_canonicalization_method", xml_signature_canonicalization_method)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonImageUrl")
    def button_image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_image_url")

    @button_image_url.setter
    def button_image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_image_url", value)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="emailClaim")
    def email_claim(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        """
        return pulumi.get(self, "email_claim")

    @email_claim.setter
    def email_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_claim", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpEndpoint")
    def idp_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The SAML v2 login page of the identity provider.
        """
        return pulumi.get(self, "idp_endpoint")

    @idp_endpoint.setter
    def idp_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_endpoint", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this OpenID Connect identity provider. This is only used for display purposes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        """
        return pulumi.get(self, "name_id_format")

    @name_id_format.setter
    def name_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_id_format", value)

    @property
    @pulumi.getter(name="postRequest")
    def post_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        """
        return pulumi.get(self, "post_request")

    @post_request.setter
    def post_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "post_request", value)

    @property
    @pulumi.getter(name="requestSigningKey")
    def request_signing_key(self) -> Optional[pulumi.Input[str]]:
        """
        TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        """
        return pulumi.get(self, "request_signing_key")

    @request_signing_key.setter
    def request_signing_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_signing_key", value)

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> Optional[pulumi.Input[bool]]:
        """
        When true authentication requests sent to the identity provider will be signed.
        """
        return pulumi.get(self, "sign_request")

    @sign_request.setter
    def sign_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_request", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)

    @property
    @pulumi.getter(name="useNameForEmail")
    def use_name_for_email(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        """
        return pulumi.get(self, "use_name_for_email")

    @use_name_for_email.setter
    def use_name_for_email(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_name_for_email", value)

    @property
    @pulumi.getter(name="xmlSignatureCanonicalizationMethod")
    def xml_signature_canonicalization_method(self) -> Optional[pulumi.Input[str]]:
        """
        The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        return pulumi.get(self, "xml_signature_canonicalization_method")

    @xml_signature_canonicalization_method.setter
    def xml_signature_canonicalization_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xml_signature_canonicalization_method", value)


class FusionAuthIdpSamlv2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email_claim: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_endpoint: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 request_signing_key: Optional[pulumi.Input[str]] = None,
                 sign_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]] = None,
                 use_name_for_email: Optional[pulumi.Input[bool]] = None,
                 xml_signature_canonicalization_method: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # SAML v2 Identity Provider Resource

        SAML v2 identity providers connect to external SAML v2 login systems. This type of login will optionally provide a Login with …​ button on FusionAuth’s login page. This button is customizable by using different properties of the identity provider.

        Optionally, this identity provider can define one or more domains it is associated with. This is useful for allowing employees to log in with their corporate credentials. As long as the company has an identity solution that provides SAML v2, you can leverage this feature. This is referred to as a Domain Based Identity Provider. If you enable domains for an identity provider, the Login with …​ button will not be displayed. Instead, only the email form field will be displayed initially on the FusionAuth login page. Once the user types in their email address, FusionAuth will determine if the user is logging in locally or if they should be redirected to this identity provider. This is determined by extracting the domain from their email address and comparing it to the domains associated with the identity provider.

        FusionAuth will locate the user’s email address in the SAML assertion which will be used to create or lookup the existing user. Additional claims from the SAML response can be used to reconcile the User to FusionAuth by using a SAML v2 Reconcile Lambda. Unless you assign a reconcile lambda to this provider, on the email address will be used from the available assertions returned by the SAML v2 identity provider.

        [SAML v2 Connect Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/samlv2/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        saml = fusionauth.FusionAuthIdpSamlv2("saml",
            application_configurations=[fusionauth.FusionAuthIdpSamlv2ApplicationConfigurationArgs(
                application_id=fusionauth_application["myapp"]["id"],
                button_text="Login with SAML (app text)",
                create_registration=True,
                enabled=True,
            )],
            button_text="Login with SAML",
            debug=False,
            email_claim="email",
            idp_endpoint="https://www.example.com/login",
            post_request=True,
            request_signing_key="3168129b-91fa-46f4-9676-947f5509fdce",
            sign_request=True,
            use_name_for_email=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[str] email_claim: The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_endpoint: The SAML v2 login page of the identity provider.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] key_id: The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] name_id_format: Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[str] request_signing_key: TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        :param pulumi.Input[bool] sign_request: When true authentication requests sent to the identity provider will be signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2TenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[bool] use_name_for_email: Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        :param pulumi.Input[str] xml_signature_canonicalization_method: The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthIdpSamlv2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # SAML v2 Identity Provider Resource

        SAML v2 identity providers connect to external SAML v2 login systems. This type of login will optionally provide a Login with …​ button on FusionAuth’s login page. This button is customizable by using different properties of the identity provider.

        Optionally, this identity provider can define one or more domains it is associated with. This is useful for allowing employees to log in with their corporate credentials. As long as the company has an identity solution that provides SAML v2, you can leverage this feature. This is referred to as a Domain Based Identity Provider. If you enable domains for an identity provider, the Login with …​ button will not be displayed. Instead, only the email form field will be displayed initially on the FusionAuth login page. Once the user types in their email address, FusionAuth will determine if the user is logging in locally or if they should be redirected to this identity provider. This is determined by extracting the domain from their email address and comparing it to the domains associated with the identity provider.

        FusionAuth will locate the user’s email address in the SAML assertion which will be used to create or lookup the existing user. Additional claims from the SAML response can be used to reconcile the User to FusionAuth by using a SAML v2 Reconcile Lambda. Unless you assign a reconcile lambda to this provider, on the email address will be used from the available assertions returned by the SAML v2 identity provider.

        [SAML v2 Connect Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/samlv2/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        saml = fusionauth.FusionAuthIdpSamlv2("saml",
            application_configurations=[fusionauth.FusionAuthIdpSamlv2ApplicationConfigurationArgs(
                application_id=fusionauth_application["myapp"]["id"],
                button_text="Login with SAML (app text)",
                create_registration=True,
                enabled=True,
            )],
            button_text="Login with SAML",
            debug=False,
            email_claim="email",
            idp_endpoint="https://www.example.com/login",
            post_request=True,
            request_signing_key="3168129b-91fa-46f4-9676-947f5509fdce",
            sign_request=True,
            use_name_for_email=True)
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthIdpSamlv2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthIdpSamlv2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 email_claim: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_endpoint: Optional[pulumi.Input[str]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 request_signing_key: Optional[pulumi.Input[str]] = None,
                 sign_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]] = None,
                 use_name_for_email: Optional[pulumi.Input[bool]] = None,
                 xml_signature_canonicalization_method: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthIdpSamlv2Args.__new__(FusionAuthIdpSamlv2Args)

            __props__.__dict__["application_configurations"] = application_configurations
            __props__.__dict__["button_image_url"] = button_image_url
            if button_text is None and not opts.urn:
                raise TypeError("Missing required property 'button_text'")
            __props__.__dict__["button_text"] = button_text
            __props__.__dict__["debug"] = debug
            __props__.__dict__["domains"] = domains
            __props__.__dict__["email_claim"] = email_claim
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["idp_endpoint"] = idp_endpoint
            __props__.__dict__["idp_id"] = idp_id
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
            __props__.__dict__["linking_strategy"] = linking_strategy
            __props__.__dict__["name"] = name
            __props__.__dict__["name_id_format"] = name_id_format
            __props__.__dict__["post_request"] = post_request
            __props__.__dict__["request_signing_key"] = request_signing_key
            __props__.__dict__["sign_request"] = sign_request
            __props__.__dict__["tenant_configurations"] = tenant_configurations
            __props__.__dict__["use_name_for_email"] = use_name_for_email
            __props__.__dict__["xml_signature_canonicalization_method"] = xml_signature_canonicalization_method
        super(FusionAuthIdpSamlv2, __self__).__init__(
            'fusionauth:index/fusionAuthIdpSamlv2:FusionAuthIdpSamlv2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]]] = None,
            button_image_url: Optional[pulumi.Input[str]] = None,
            button_text: Optional[pulumi.Input[str]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            email_claim: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            idp_endpoint: Optional[pulumi.Input[str]] = None,
            idp_id: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
            linking_strategy: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_id_format: Optional[pulumi.Input[str]] = None,
            post_request: Optional[pulumi.Input[bool]] = None,
            request_signing_key: Optional[pulumi.Input[str]] = None,
            sign_request: Optional[pulumi.Input[bool]] = None,
            tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2TenantConfigurationArgs']]]]] = None,
            use_name_for_email: Optional[pulumi.Input[bool]] = None,
            xml_signature_canonicalization_method: Optional[pulumi.Input[str]] = None) -> 'FusionAuthIdpSamlv2':
        """
        Get an existing FusionAuthIdpSamlv2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2ApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[str] email_claim: The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_endpoint: The SAML v2 login page of the identity provider.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] key_id: The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] name_id_format: Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[str] request_signing_key: TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        :param pulumi.Input[bool] sign_request: When true authentication requests sent to the identity provider will be signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpSamlv2TenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        :param pulumi.Input[bool] use_name_for_email: Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        :param pulumi.Input[str] xml_signature_canonicalization_method: The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthIdpSamlv2State.__new__(_FusionAuthIdpSamlv2State)

        __props__.__dict__["application_configurations"] = application_configurations
        __props__.__dict__["button_image_url"] = button_image_url
        __props__.__dict__["button_text"] = button_text
        __props__.__dict__["debug"] = debug
        __props__.__dict__["domains"] = domains
        __props__.__dict__["email_claim"] = email_claim
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["idp_endpoint"] = idp_endpoint
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
        __props__.__dict__["linking_strategy"] = linking_strategy
        __props__.__dict__["name"] = name
        __props__.__dict__["name_id_format"] = name_id_format
        __props__.__dict__["post_request"] = post_request
        __props__.__dict__["request_signing_key"] = request_signing_key
        __props__.__dict__["sign_request"] = sign_request
        __props__.__dict__["tenant_configurations"] = tenant_configurations
        __props__.__dict__["use_name_for_email"] = use_name_for_email
        __props__.__dict__["xml_signature_canonicalization_method"] = xml_signature_canonicalization_method
        return FusionAuthIdpSamlv2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpSamlv2ApplicationConfiguration']]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="buttonImageUrl")
    def button_image_url(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_image_url")

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Output[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="emailClaim")
    def email_claim(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the email claim (Attribute in the Assertion element) in the SAML response that FusionAuth uses to uniquely identity the user. If this is not set, the `use_name_for_email` flag must be true.
        """
        return pulumi.get(self, "email_claim")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idpEndpoint")
    def idp_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The SAML v2 login page of the identity provider.
        """
        return pulumi.get(self, "idp_endpoint")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        The id of the key stored in Key Master that is used to verify the SAML response sent back to FusionAuth from the identity provider. This key must be a verification only key or certificate (meaning that it only has a public key component).
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> pulumi.Output[str]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this OpenID Connect identity provider. This is only used for display purposes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> pulumi.Output[str]:
        """
        Either urn:oasis:names:tc:SAML:2.0:nameid-format:persistent or urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress depending on which NameId format you wish to use.
        """
        return pulumi.get(self, "name_id_format")

    @property
    @pulumi.getter(name="postRequest")
    def post_request(self) -> pulumi.Output[Optional[bool]]:
        """
        Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        """
        return pulumi.get(self, "post_request")

    @property
    @pulumi.getter(name="requestSigningKey")
    def request_signing_key(self) -> pulumi.Output[Optional[str]]:
        """
        TThe key pair Id to use to sign the SAML request. Required when `sign_request` is true.
        """
        return pulumi.get(self, "request_signing_key")

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> pulumi.Output[Optional[bool]]:
        """
        When true authentication requests sent to the identity provider will be signed.
        """
        return pulumi.get(self, "sign_request")

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpSamlv2TenantConfiguration']]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @property
    @pulumi.getter(name="useNameForEmail")
    def use_name_for_email(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not FusionAuth will use the NameID element value as the email address of the user for reconciliation processing. If this is false, then the `email_claim` property must be set.
        """
        return pulumi.get(self, "use_name_for_email")

    @property
    @pulumi.getter(name="xmlSignatureCanonicalizationMethod")
    def xml_signature_canonicalization_method(self) -> pulumi.Output[Optional[str]]:
        """
        The XML signature canonicalization method used when digesting and signing the SAML request.
        """
        return pulumi.get(self, "xml_signature_canonicalization_method")

