# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthIdpOpenIdConnectArgs', 'FusionAuthIdpOpenIdConnect']

@pulumi.input_type
class FusionAuthIdpOpenIdConnectArgs:
    def __init__(__self__, *,
                 button_text: pulumi.Input[str],
                 oauth2_client_id: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_client_authentication_method: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth2_email_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_issuer: Optional[pulumi.Input[str]] = None,
                 oauth2_scope: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_unique_id_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_user_info_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_username_claim: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a FusionAuthIdpOpenIdConnect resource.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] oauth2_client_id: The top-level client id for your Application.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_client_authentication_method: The client authentication method to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_client_secret: The top-level client secret to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_email_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        :param pulumi.Input[str] oauth2_issuer: The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        :param pulumi.Input[str] oauth2_scope: The top-level scope that you are requesting from the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_token_endpoint: The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_unique_id_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        :param pulumi.Input[str] oauth2_user_info_endpoint: The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_username_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        pulumi.set(__self__, "button_text", button_text)
        pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_image_url is not None:
            pulumi.set(__self__, "button_image_url", button_image_url)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorization_endpoint is not None:
            pulumi.set(__self__, "oauth2_authorization_endpoint", oauth2_authorization_endpoint)
        if oauth2_client_authentication_method is not None:
            pulumi.set(__self__, "oauth2_client_authentication_method", oauth2_client_authentication_method)
        if oauth2_client_secret is not None:
            pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)
        if oauth2_email_claim is not None:
            pulumi.set(__self__, "oauth2_email_claim", oauth2_email_claim)
        if oauth2_issuer is not None:
            pulumi.set(__self__, "oauth2_issuer", oauth2_issuer)
        if oauth2_scope is not None:
            pulumi.set(__self__, "oauth2_scope", oauth2_scope)
        if oauth2_token_endpoint is not None:
            pulumi.set(__self__, "oauth2_token_endpoint", oauth2_token_endpoint)
        if oauth2_unique_id_claim is not None:
            pulumi.set(__self__, "oauth2_unique_id_claim", oauth2_unique_id_claim)
        if oauth2_user_info_endpoint is not None:
            pulumi.set(__self__, "oauth2_user_info_endpoint", oauth2_user_info_endpoint)
        if oauth2_username_claim is not None:
            pulumi.set(__self__, "oauth2_username_claim", oauth2_username_claim)
        if post_request is not None:
            pulumi.set(__self__, "post_request", post_request)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Input[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> pulumi.Input[str]:
        """
        The top-level client id for your Application.
        """
        return pulumi.get(self, "oauth2_client_id")

    @oauth2_client_id.setter
    def oauth2_client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "oauth2_client_id", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonImageUrl")
    def button_image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_image_url")

    @button_image_url.setter
    def button_image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_image_url", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this OpenID Connect identity provider. This is only used for display purposes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauth2AuthorizationEndpoint")
    def oauth2_authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_authorization_endpoint")

    @oauth2_authorization_endpoint.setter
    def oauth2_authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorization_endpoint", value)

    @property
    @pulumi.getter(name="oauth2ClientAuthenticationMethod")
    def oauth2_client_authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        The client authentication method to use with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_client_authentication_method")

    @oauth2_client_authentication_method.setter
    def oauth2_client_authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_authentication_method", value)

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level client secret to use with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_client_secret")

    @oauth2_client_secret.setter
    def oauth2_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_secret", value)

    @property
    @pulumi.getter(name="oauth2EmailClaim")
    def oauth2_email_claim(self) -> Optional[pulumi.Input[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        """
        return pulumi.get(self, "oauth2_email_claim")

    @oauth2_email_claim.setter
    def oauth2_email_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_email_claim", value)

    @property
    @pulumi.getter(name="oauth2Issuer")
    def oauth2_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        """
        return pulumi.get(self, "oauth2_issuer")

    @oauth2_issuer.setter
    def oauth2_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_issuer", value)

    @property
    @pulumi.getter(name="oauth2Scope")
    def oauth2_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level scope that you are requesting from the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_scope")

    @oauth2_scope.setter
    def oauth2_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_scope", value)

    @property
    @pulumi.getter(name="oauth2TokenEndpoint")
    def oauth2_token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_token_endpoint")

    @oauth2_token_endpoint.setter
    def oauth2_token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_token_endpoint", value)

    @property
    @pulumi.getter(name="oauth2UniqueIdClaim")
    def oauth2_unique_id_claim(self) -> Optional[pulumi.Input[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        """
        return pulumi.get(self, "oauth2_unique_id_claim")

    @oauth2_unique_id_claim.setter
    def oauth2_unique_id_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_unique_id_claim", value)

    @property
    @pulumi.getter(name="oauth2UserInfoEndpoint")
    def oauth2_user_info_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_user_info_endpoint")

    @oauth2_user_info_endpoint.setter
    def oauth2_user_info_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_user_info_endpoint", value)

    @property
    @pulumi.getter(name="oauth2UsernameClaim")
    def oauth2_username_claim(self) -> Optional[pulumi.Input[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        """
        return pulumi.get(self, "oauth2_username_claim")

    @oauth2_username_claim.setter
    def oauth2_username_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_username_claim", value)

    @property
    @pulumi.getter(name="postRequest")
    def post_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        """
        return pulumi.get(self, "post_request")

    @post_request.setter
    def post_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "post_request", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


@pulumi.input_type
class _FusionAuthIdpOpenIdConnectState:
    def __init__(__self__, *,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_client_authentication_method: Optional[pulumi.Input[str]] = None,
                 oauth2_client_id: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth2_email_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_issuer: Optional[pulumi.Input[str]] = None,
                 oauth2_scope: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_unique_id_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_user_info_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_username_claim: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering FusionAuthIdpOpenIdConnect resources.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_client_authentication_method: The client authentication method to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_client_id: The top-level client id for your Application.
        :param pulumi.Input[str] oauth2_client_secret: The top-level client secret to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_email_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        :param pulumi.Input[str] oauth2_issuer: The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        :param pulumi.Input[str] oauth2_scope: The top-level scope that you are requesting from the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_token_endpoint: The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_unique_id_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        :param pulumi.Input[str] oauth2_user_info_endpoint: The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_username_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_image_url is not None:
            pulumi.set(__self__, "button_image_url", button_image_url)
        if button_text is not None:
            pulumi.set(__self__, "button_text", button_text)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorization_endpoint is not None:
            pulumi.set(__self__, "oauth2_authorization_endpoint", oauth2_authorization_endpoint)
        if oauth2_client_authentication_method is not None:
            pulumi.set(__self__, "oauth2_client_authentication_method", oauth2_client_authentication_method)
        if oauth2_client_id is not None:
            pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        if oauth2_client_secret is not None:
            pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)
        if oauth2_email_claim is not None:
            pulumi.set(__self__, "oauth2_email_claim", oauth2_email_claim)
        if oauth2_issuer is not None:
            pulumi.set(__self__, "oauth2_issuer", oauth2_issuer)
        if oauth2_scope is not None:
            pulumi.set(__self__, "oauth2_scope", oauth2_scope)
        if oauth2_token_endpoint is not None:
            pulumi.set(__self__, "oauth2_token_endpoint", oauth2_token_endpoint)
        if oauth2_unique_id_claim is not None:
            pulumi.set(__self__, "oauth2_unique_id_claim", oauth2_unique_id_claim)
        if oauth2_user_info_endpoint is not None:
            pulumi.set(__self__, "oauth2_user_info_endpoint", oauth2_user_info_endpoint)
        if oauth2_username_claim is not None:
            pulumi.set(__self__, "oauth2_username_claim", oauth2_username_claim)
        if post_request is not None:
            pulumi.set(__self__, "post_request", post_request)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonImageUrl")
    def button_image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_image_url")

    @button_image_url.setter
    def button_image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_image_url", value)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_id", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this OpenID Connect identity provider. This is only used for display purposes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oauth2AuthorizationEndpoint")
    def oauth2_authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_authorization_endpoint")

    @oauth2_authorization_endpoint.setter
    def oauth2_authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_authorization_endpoint", value)

    @property
    @pulumi.getter(name="oauth2ClientAuthenticationMethod")
    def oauth2_client_authentication_method(self) -> Optional[pulumi.Input[str]]:
        """
        The client authentication method to use with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_client_authentication_method")

    @oauth2_client_authentication_method.setter
    def oauth2_client_authentication_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_authentication_method", value)

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level client id for your Application.
        """
        return pulumi.get(self, "oauth2_client_id")

    @oauth2_client_id.setter
    def oauth2_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_id", value)

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level client secret to use with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_client_secret")

    @oauth2_client_secret.setter
    def oauth2_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_client_secret", value)

    @property
    @pulumi.getter(name="oauth2EmailClaim")
    def oauth2_email_claim(self) -> Optional[pulumi.Input[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        """
        return pulumi.get(self, "oauth2_email_claim")

    @oauth2_email_claim.setter
    def oauth2_email_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_email_claim", value)

    @property
    @pulumi.getter(name="oauth2Issuer")
    def oauth2_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        """
        return pulumi.get(self, "oauth2_issuer")

    @oauth2_issuer.setter
    def oauth2_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_issuer", value)

    @property
    @pulumi.getter(name="oauth2Scope")
    def oauth2_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level scope that you are requesting from the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_scope")

    @oauth2_scope.setter
    def oauth2_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_scope", value)

    @property
    @pulumi.getter(name="oauth2TokenEndpoint")
    def oauth2_token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_token_endpoint")

    @oauth2_token_endpoint.setter
    def oauth2_token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_token_endpoint", value)

    @property
    @pulumi.getter(name="oauth2UniqueIdClaim")
    def oauth2_unique_id_claim(self) -> Optional[pulumi.Input[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        """
        return pulumi.get(self, "oauth2_unique_id_claim")

    @oauth2_unique_id_claim.setter
    def oauth2_unique_id_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_unique_id_claim", value)

    @property
    @pulumi.getter(name="oauth2UserInfoEndpoint")
    def oauth2_user_info_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_user_info_endpoint")

    @oauth2_user_info_endpoint.setter
    def oauth2_user_info_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_user_info_endpoint", value)

    @property
    @pulumi.getter(name="oauth2UsernameClaim")
    def oauth2_username_claim(self) -> Optional[pulumi.Input[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        """
        return pulumi.get(self, "oauth2_username_claim")

    @oauth2_username_claim.setter
    def oauth2_username_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oauth2_username_claim", value)

    @property
    @pulumi.getter(name="postRequest")
    def post_request(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        """
        return pulumi.get(self, "post_request")

    @post_request.setter
    def post_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "post_request", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


class FusionAuthIdpOpenIdConnect(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_client_authentication_method: Optional[pulumi.Input[str]] = None,
                 oauth2_client_id: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth2_email_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_issuer: Optional[pulumi.Input[str]] = None,
                 oauth2_scope: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_unique_id_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_user_info_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_username_claim: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        """
        ## # OpenID Connect Identity Provider Resource

        OpenID Connect identity providers connect to external OpenID Connect login systems. This type of login will optionally provide a Login with …​ button on FusionAuth’s login page. This button is customizable by using different properties of the identity provider.

        Optionally, this identity provider can define one or more domains it is associated with. This is useful for allowing employees to log in with their corporate credentials. As long as the company has an identity solution that provides OpenID Connect, you can leverage this feature. This is referred to as a Domain Based Identity Provider. If you enable domains for an identity provider, the Login with …​ button will not be displayed. Instead, only the email form field will be displayed initially on the FusionAuth login page. Once the user types in their email address, FusionAuth will determine if the user is logging in locally or if they should be redirected to this identity provider. This is determined by extracting the domain from their email address and comparing it to the domains associated with the identity provider.

        FusionAuth will also leverage the /userinfo API that is part of the OpenID Connect specification. The email address returned from the Userinfo response will be used to create or lookup the existing user. Additional claims from the Userinfo response can be used to reconcile the User in FusionAuth by using an OpenID Connect Reconcile Lambda. Unless you assign a reconcile lambda to this provider, on the email address will be used from the available claims returned by the OpenID Connect identity provider.

        If the external OpenID Connect identity provider returns a refresh token, it will be stored in the UserRegistration object inside the tokens Map. This Map stores the tokens from the various identity providers so that you can use them in your application to call their APIs.

        [OpenID Connect Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/openid-connect)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        open_id = fusionauth.FusionAuthIdpOpenIdConnect("openID",
            application_configurations=[fusionauth.FusionAuthIdpOpenIdConnectApplicationConfigurationArgs(
                application_id=fusionauth_application["myapp"]["id"],
                create_registration=True,
                enabled=True,
            )],
            oauth2_authorization_endpoint="https://acme.com/oauth2/authorization",
            oauth2_client_id="191c23dc-b772-4558-bd21-dc1cbf74ae21",
            oauth2_client_secret="SUsnoP0pWUYfXvWbSe5pvj8Di5nAxOvO",
            oauth2_client_authentication_method="client_secret_basic",
            oauth2_scope="openid offline_access",
            oauth2_token_endpoint="https://acme.com/oauth2/token",
            oauth2_user_info_endpoint="https://acme.com/oauth2/userinfo",
            button_text="Login with OpenID Connect",
            debug=False,
            enabled=True,
            tenant_configurations=[fusionauth.FusionAuthIdpOpenIdConnectTenantConfigurationArgs(
                tenant_id=fusionauth_tenant["example"]["id"],
                limit_user_link_count_enabled=False,
                limit_user_link_count_maximum_links=42,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_client_authentication_method: The client authentication method to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_client_id: The top-level client id for your Application.
        :param pulumi.Input[str] oauth2_client_secret: The top-level client secret to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_email_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        :param pulumi.Input[str] oauth2_issuer: The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        :param pulumi.Input[str] oauth2_scope: The top-level scope that you are requesting from the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_token_endpoint: The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_unique_id_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        :param pulumi.Input[str] oauth2_user_info_endpoint: The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_username_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthIdpOpenIdConnectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # OpenID Connect Identity Provider Resource

        OpenID Connect identity providers connect to external OpenID Connect login systems. This type of login will optionally provide a Login with …​ button on FusionAuth’s login page. This button is customizable by using different properties of the identity provider.

        Optionally, this identity provider can define one or more domains it is associated with. This is useful for allowing employees to log in with their corporate credentials. As long as the company has an identity solution that provides OpenID Connect, you can leverage this feature. This is referred to as a Domain Based Identity Provider. If you enable domains for an identity provider, the Login with …​ button will not be displayed. Instead, only the email form field will be displayed initially on the FusionAuth login page. Once the user types in their email address, FusionAuth will determine if the user is logging in locally or if they should be redirected to this identity provider. This is determined by extracting the domain from their email address and comparing it to the domains associated with the identity provider.

        FusionAuth will also leverage the /userinfo API that is part of the OpenID Connect specification. The email address returned from the Userinfo response will be used to create or lookup the existing user. Additional claims from the Userinfo response can be used to reconcile the User in FusionAuth by using an OpenID Connect Reconcile Lambda. Unless you assign a reconcile lambda to this provider, on the email address will be used from the available claims returned by the OpenID Connect identity provider.

        If the external OpenID Connect identity provider returns a refresh token, it will be stored in the UserRegistration object inside the tokens Map. This Map stores the tokens from the various identity providers so that you can use them in your application to call their APIs.

        [OpenID Connect Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/openid-connect)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        open_id = fusionauth.FusionAuthIdpOpenIdConnect("openID",
            application_configurations=[fusionauth.FusionAuthIdpOpenIdConnectApplicationConfigurationArgs(
                application_id=fusionauth_application["myapp"]["id"],
                create_registration=True,
                enabled=True,
            )],
            oauth2_authorization_endpoint="https://acme.com/oauth2/authorization",
            oauth2_client_id="191c23dc-b772-4558-bd21-dc1cbf74ae21",
            oauth2_client_secret="SUsnoP0pWUYfXvWbSe5pvj8Di5nAxOvO",
            oauth2_client_authentication_method="client_secret_basic",
            oauth2_scope="openid offline_access",
            oauth2_token_endpoint="https://acme.com/oauth2/token",
            oauth2_user_info_endpoint="https://acme.com/oauth2/userinfo",
            button_text="Login with OpenID Connect",
            debug=False,
            enabled=True,
            tenant_configurations=[fusionauth.FusionAuthIdpOpenIdConnectTenantConfigurationArgs(
                tenant_id=fusionauth_tenant["example"]["id"],
                limit_user_link_count_enabled=False,
                limit_user_link_count_maximum_links=42,
            )])
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthIdpOpenIdConnectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthIdpOpenIdConnectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]] = None,
                 button_image_url: Optional[pulumi.Input[str]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 idp_id: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_client_authentication_method: Optional[pulumi.Input[str]] = None,
                 oauth2_client_id: Optional[pulumi.Input[str]] = None,
                 oauth2_client_secret: Optional[pulumi.Input[str]] = None,
                 oauth2_email_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_issuer: Optional[pulumi.Input[str]] = None,
                 oauth2_scope: Optional[pulumi.Input[str]] = None,
                 oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_unique_id_claim: Optional[pulumi.Input[str]] = None,
                 oauth2_user_info_endpoint: Optional[pulumi.Input[str]] = None,
                 oauth2_username_claim: Optional[pulumi.Input[str]] = None,
                 post_request: Optional[pulumi.Input[bool]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthIdpOpenIdConnectArgs.__new__(FusionAuthIdpOpenIdConnectArgs)

            __props__.__dict__["application_configurations"] = application_configurations
            __props__.__dict__["button_image_url"] = button_image_url
            if button_text is None and not opts.urn:
                raise TypeError("Missing required property 'button_text'")
            __props__.__dict__["button_text"] = button_text
            __props__.__dict__["debug"] = debug
            __props__.__dict__["domains"] = domains
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
            __props__.__dict__["linking_strategy"] = linking_strategy
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth2_authorization_endpoint"] = oauth2_authorization_endpoint
            __props__.__dict__["oauth2_client_authentication_method"] = oauth2_client_authentication_method
            if oauth2_client_id is None and not opts.urn:
                raise TypeError("Missing required property 'oauth2_client_id'")
            __props__.__dict__["oauth2_client_id"] = oauth2_client_id
            __props__.__dict__["oauth2_client_secret"] = oauth2_client_secret
            __props__.__dict__["oauth2_email_claim"] = oauth2_email_claim
            __props__.__dict__["oauth2_issuer"] = oauth2_issuer
            __props__.__dict__["oauth2_scope"] = oauth2_scope
            __props__.__dict__["oauth2_token_endpoint"] = oauth2_token_endpoint
            __props__.__dict__["oauth2_unique_id_claim"] = oauth2_unique_id_claim
            __props__.__dict__["oauth2_user_info_endpoint"] = oauth2_user_info_endpoint
            __props__.__dict__["oauth2_username_claim"] = oauth2_username_claim
            __props__.__dict__["post_request"] = post_request
            __props__.__dict__["tenant_configurations"] = tenant_configurations
        super(FusionAuthIdpOpenIdConnect, __self__).__init__(
            'fusionauth:index/fusionAuthIdpOpenIdConnect:FusionAuthIdpOpenIdConnect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]]] = None,
            button_image_url: Optional[pulumi.Input[str]] = None,
            button_text: Optional[pulumi.Input[str]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            idp_id: Optional[pulumi.Input[str]] = None,
            lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
            linking_strategy: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            oauth2_authorization_endpoint: Optional[pulumi.Input[str]] = None,
            oauth2_client_authentication_method: Optional[pulumi.Input[str]] = None,
            oauth2_client_id: Optional[pulumi.Input[str]] = None,
            oauth2_client_secret: Optional[pulumi.Input[str]] = None,
            oauth2_email_claim: Optional[pulumi.Input[str]] = None,
            oauth2_issuer: Optional[pulumi.Input[str]] = None,
            oauth2_scope: Optional[pulumi.Input[str]] = None,
            oauth2_token_endpoint: Optional[pulumi.Input[str]] = None,
            oauth2_unique_id_claim: Optional[pulumi.Input[str]] = None,
            oauth2_user_info_endpoint: Optional[pulumi.Input[str]] = None,
            oauth2_username_claim: Optional[pulumi.Input[str]] = None,
            post_request: Optional[pulumi.Input[bool]] = None,
            tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]]] = None) -> 'FusionAuthIdpOpenIdConnect':
        """
        Get an existing FusionAuthIdpOpenIdConnect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_image_url: The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] idp_id: The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        :param pulumi.Input[str] name: The name of this OpenID Connect identity provider. This is only used for display purposes.
        :param pulumi.Input[str] oauth2_authorization_endpoint: The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_client_authentication_method: The client authentication method to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_client_id: The top-level client id for your Application.
        :param pulumi.Input[str] oauth2_client_secret: The top-level client secret to use with the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_email_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        :param pulumi.Input[str] oauth2_issuer: The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        :param pulumi.Input[str] oauth2_scope: The top-level scope that you are requesting from the OpenID Connect identity provider.
        :param pulumi.Input[str] oauth2_token_endpoint: The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_unique_id_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        :param pulumi.Input[str] oauth2_user_info_endpoint: The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        :param pulumi.Input[str] oauth2_username_claim: An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        :param pulumi.Input[bool] post_request: Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpOpenIdConnectTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthIdpOpenIdConnectState.__new__(_FusionAuthIdpOpenIdConnectState)

        __props__.__dict__["application_configurations"] = application_configurations
        __props__.__dict__["button_image_url"] = button_image_url
        __props__.__dict__["button_text"] = button_text
        __props__.__dict__["debug"] = debug
        __props__.__dict__["domains"] = domains
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
        __props__.__dict__["linking_strategy"] = linking_strategy
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth2_authorization_endpoint"] = oauth2_authorization_endpoint
        __props__.__dict__["oauth2_client_authentication_method"] = oauth2_client_authentication_method
        __props__.__dict__["oauth2_client_id"] = oauth2_client_id
        __props__.__dict__["oauth2_client_secret"] = oauth2_client_secret
        __props__.__dict__["oauth2_email_claim"] = oauth2_email_claim
        __props__.__dict__["oauth2_issuer"] = oauth2_issuer
        __props__.__dict__["oauth2_scope"] = oauth2_scope
        __props__.__dict__["oauth2_token_endpoint"] = oauth2_token_endpoint
        __props__.__dict__["oauth2_unique_id_claim"] = oauth2_unique_id_claim
        __props__.__dict__["oauth2_user_info_endpoint"] = oauth2_user_info_endpoint
        __props__.__dict__["oauth2_username_claim"] = oauth2_username_claim
        __props__.__dict__["post_request"] = post_request
        __props__.__dict__["tenant_configurations"] = tenant_configurations
        return FusionAuthIdpOpenIdConnect(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpOpenIdConnectApplicationConfiguration']]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="buttonImageUrl")
    def button_image_url(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level button image (URL) to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_image_url")

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Output[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, each time this provider is invoked to reconcile a login an Event Log will be created.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        This is an optional list of domains that this OpenID Connect provider should be used for. This converts the FusionAuth login form to a domain-based login form. This type of form first asks the user for their email. FusionAuth then uses their email to determine if an OpenID Connect identity provider should be used. If an OpenID Connect provider should be used, the browser is redirected to the authorization endpoint of that identity provider. Otherwise, the password field is revealed on the form so that the user can login using FusionAuth.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID to use for the new identity provider. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "idp_id")

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> pulumi.Output[str]:
        """
        The linking strategy to use when creating the link between the {idp_display_name} Identity Provider and the user.
        """
        return pulumi.get(self, "linking_strategy")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this OpenID Connect identity provider. This is only used for display purposes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauth2AuthorizationEndpoint")
    def oauth2_authorization_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level authorization endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the authorization endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_authorization_endpoint")

    @property
    @pulumi.getter(name="oauth2ClientAuthenticationMethod")
    def oauth2_client_authentication_method(self) -> pulumi.Output[Optional[str]]:
        """
        The client authentication method to use with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_client_authentication_method")

    @property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> pulumi.Output[str]:
        """
        The top-level client id for your Application.
        """
        return pulumi.get(self, "oauth2_client_id")

    @property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level client secret to use with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_client_secret")

    @property
    @pulumi.getter(name="oauth2EmailClaim")
    def oauth2_email_claim(self) -> pulumi.Output[Optional[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the email address.
        """
        return pulumi.get(self, "oauth2_email_claim")

    @property
    @pulumi.getter(name="oauth2Issuer")
    def oauth2_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level issuer URI for the OpenID Connect identity provider. If this is provided, the authorization endpoint, token endpoint and userinfo endpoint will all be resolved using the issuer URI plus /.well-known/openid-configuration.
        """
        return pulumi.get(self, "oauth2_issuer")

    @property
    @pulumi.getter(name="oauth2Scope")
    def oauth2_scope(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level scope that you are requesting from the OpenID Connect identity provider.
        """
        return pulumi.get(self, "oauth2_scope")

    @property
    @pulumi.getter(name="oauth2TokenEndpoint")
    def oauth2_token_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level token endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the token endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_token_endpoint")

    @property
    @pulumi.getter(name="oauth2UniqueIdClaim")
    def oauth2_unique_id_claim(self) -> pulumi.Output[Optional[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the user Id.
        """
        return pulumi.get(self, "oauth2_unique_id_claim")

    @property
    @pulumi.getter(name="oauth2UserInfoEndpoint")
    def oauth2_user_info_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level userinfo endpoint for the OpenID Connect identity provider. You can leave this blank if you provide the issuer field, which will be used to make a request to the OpenID Connect .well-known endpoint in order to dynamically resolve the userinfo endpoint. If you provide an issuer then this field will be ignored.
        """
        return pulumi.get(self, "oauth2_user_info_endpoint")

    @property
    @pulumi.getter(name="oauth2UsernameClaim")
    def oauth2_username_claim(self) -> pulumi.Output[Optional[str]]:
        """
        An optional configuration to modify the expected name of the claim returned by the IdP that contains the username.
        """
        return pulumi.get(self, "oauth2_username_claim")

    @property
    @pulumi.getter(name="postRequest")
    def post_request(self) -> pulumi.Output[Optional[bool]]:
        """
        Set this value equal to true if you wish to use POST bindings with this OpenID Connect identity provider. The default value of false means that a redirect binding which uses a GET request will be used.
        """
        return pulumi.get(self, "post_request")

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpOpenIdConnectTenantConfiguration']]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

