# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthIdpFacebookArgs', 'FusionAuthIdpFacebook']

@pulumi.input_type
class FusionAuthIdpFacebookArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 button_text: pulumi.Input[str],
                 client_secret: pulumi.Input[str],
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 login_method: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a FusionAuthIdpFacebook resource.
        :param pulumi.Input[str] app_id: The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_secret: The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] fields: The top-level fields that you are requesting from Facebook.
               Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
               The valid values are:
        :param pulumi.Input[str] login_method: The login method to use for this Identity Provider.
               The valid values are:
        :param pulumi.Input[str] permissions: The top-level permissions that your application is asking of the user’s Facebook account.
               Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "button_text", button_text)
        pulumi.set(__self__, "client_secret", client_secret)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if login_method is not None:
            pulumi.set(__self__, "login_method", login_method)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Input[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: pulumi.Input[str]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level fields that you are requesting from Facebook.
        Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
        The valid values are:
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter(name="loginMethod")
    def login_method(self) -> Optional[pulumi.Input[str]]:
        """
        The login method to use for this Identity Provider.
        The valid values are:
        """
        return pulumi.get(self, "login_method")

    @login_method.setter
    def login_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_method", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level permissions that your application is asking of the user’s Facebook account.
        Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


@pulumi.input_type
class _FusionAuthIdpFacebookState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 login_method: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering FusionAuthIdpFacebook resources.
        :param pulumi.Input[str] app_id: The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_secret: The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] fields: The top-level fields that you are requesting from Facebook.
               Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
               The valid values are:
        :param pulumi.Input[str] login_method: The login method to use for this Identity Provider.
               The valid values are:
        :param pulumi.Input[str] permissions: The top-level permissions that your application is asking of the user’s Facebook account.
               Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        :param pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if application_configurations is not None:
            pulumi.set(__self__, "application_configurations", application_configurations)
        if button_text is not None:
            pulumi.set(__self__, "button_text", button_text)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if lambda_reconcile_id is not None:
            pulumi.set(__self__, "lambda_reconcile_id", lambda_reconcile_id)
        if linking_strategy is not None:
            pulumi.set(__self__, "linking_strategy", linking_strategy)
        if login_method is not None:
            pulumi.set(__self__, "login_method", login_method)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if tenant_configurations is not None:
            pulumi.set(__self__, "tenant_configurations", tenant_configurations)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @application_configurations.setter
    def application_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]):
        pulumi.set(self, "application_configurations", value)

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @button_text.setter
    def button_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_text", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def debug(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        """
        return pulumi.get(self, "debug")

    @debug.setter
    def debug(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level fields that you are requesting from Facebook.
        Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @lambda_reconcile_id.setter
    def lambda_reconcile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_reconcile_id", value)

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
        The valid values are:
        """
        return pulumi.get(self, "linking_strategy")

    @linking_strategy.setter
    def linking_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "linking_strategy", value)

    @property
    @pulumi.getter(name="loginMethod")
    def login_method(self) -> Optional[pulumi.Input[str]]:
        """
        The login method to use for this Identity Provider.
        The valid values are:
        """
        return pulumi.get(self, "login_method")

    @login_method.setter
    def login_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_method", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        The top-level permissions that your application is asking of the user’s Facebook account.
        Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

    @tenant_configurations.setter
    def tenant_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FusionAuthIdpFacebookTenantConfigurationArgs']]]]):
        pulumi.set(self, "tenant_configurations", value)


class FusionAuthIdpFacebook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 login_method: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        """
        ## # Facebook Identity Provider Resource

        The Facebook identity provider type will use the Facebook OAuth login API. It will provide a `Login with Facebook` button on FusionAuth’s login page that will leverage the Facebook login pop-up dialog. Additionally, this identity provider will call Facebook’s Graph API to load additional details about the user and store them in FusionAuth.

        The email address returned by the Facebook Graph API will be used to create or lookup the existing user. Additional claims returned by Facebook can be used to reconcile the User to FusionAuth by using a Facebook Reconcile Lambda. Unless you assign a reconcile lambda to this provider, on the `email` address will be used from the available claims returned by Facebook.

        When the `picture` field is not requested FusionAuth will also call Facebook’s `/me/picture` API to load the user’s profile image and store it as the `imageUrl` in FusionAuth. When the `picture` field is requested, the user’s profile image will be returned by the `/me` API and a second request to the `/me/picture` endpoint will not be required.

        Finally, FusionAuth will call Facebook’s `/oauth/access_token` API to exchange the login token for a long-lived Facebook token. This token is stored in the `UserRegistration` object inside the `tokens` Map. This Map stores the tokens from the various identity providers so that you can use them in your application to call their APIs.

        Please note if an `idp_hint` is appended to the OAuth Authorize endpoint, then the interaction behavior will be defaulted to `redirect`, even if popup interaction is explicitly configured.

        [Facebook Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/facebook)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        facebook = fusionauth.FusionAuthIdpFacebook("facebook",
            application_configurations=[fusionauth.FusionAuthIdpFacebookApplicationConfigurationArgs(
                application_id=fusionauth_application["myapp"]["id"],
                create_registration=True,
                enabled=True,
            )],
            button_text="Login with Facebook",
            debug=False,
            enabled=True,
            app_id="9876543210",
            client_secret="716a572f917640698cdb99e9d7e64115",
            fields="email",
            permissions="email")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_secret: The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] fields: The top-level fields that you are requesting from Facebook.
               Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
               The valid values are:
        :param pulumi.Input[str] login_method: The login method to use for this Identity Provider.
               The valid values are:
        :param pulumi.Input[str] permissions: The top-level permissions that your application is asking of the user’s Facebook account.
               Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthIdpFacebookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Facebook Identity Provider Resource

        The Facebook identity provider type will use the Facebook OAuth login API. It will provide a `Login with Facebook` button on FusionAuth’s login page that will leverage the Facebook login pop-up dialog. Additionally, this identity provider will call Facebook’s Graph API to load additional details about the user and store them in FusionAuth.

        The email address returned by the Facebook Graph API will be used to create or lookup the existing user. Additional claims returned by Facebook can be used to reconcile the User to FusionAuth by using a Facebook Reconcile Lambda. Unless you assign a reconcile lambda to this provider, on the `email` address will be used from the available claims returned by Facebook.

        When the `picture` field is not requested FusionAuth will also call Facebook’s `/me/picture` API to load the user’s profile image and store it as the `imageUrl` in FusionAuth. When the `picture` field is requested, the user’s profile image will be returned by the `/me` API and a second request to the `/me/picture` endpoint will not be required.

        Finally, FusionAuth will call Facebook’s `/oauth/access_token` API to exchange the login token for a long-lived Facebook token. This token is stored in the `UserRegistration` object inside the `tokens` Map. This Map stores the tokens from the various identity providers so that you can use them in your application to call their APIs.

        Please note if an `idp_hint` is appended to the OAuth Authorize endpoint, then the interaction behavior will be defaulted to `redirect`, even if popup interaction is explicitly configured.

        [Facebook Identity Providers API](https://fusionauth.io/docs/v1/tech/apis/identity-providers/facebook)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        facebook = fusionauth.FusionAuthIdpFacebook("facebook",
            application_configurations=[fusionauth.FusionAuthIdpFacebookApplicationConfigurationArgs(
                application_id=fusionauth_application["myapp"]["id"],
                create_registration=True,
                enabled=True,
            )],
            button_text="Login with Facebook",
            debug=False,
            enabled=True,
            app_id="9876543210",
            client_secret="716a572f917640698cdb99e9d7e64115",
            fields="email",
            permissions="email")
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthIdpFacebookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthIdpFacebookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]] = None,
                 button_text: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 debug: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
                 linking_strategy: Optional[pulumi.Input[str]] = None,
                 login_method: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[str]] = None,
                 tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookTenantConfigurationArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthIdpFacebookArgs.__new__(FusionAuthIdpFacebookArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["application_configurations"] = application_configurations
            if button_text is None and not opts.urn:
                raise TypeError("Missing required property 'button_text'")
            __props__.__dict__["button_text"] = button_text
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["debug"] = debug
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["fields"] = fields
            __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
            __props__.__dict__["linking_strategy"] = linking_strategy
            __props__.__dict__["login_method"] = login_method
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["tenant_configurations"] = tenant_configurations
        super(FusionAuthIdpFacebook, __self__).__init__(
            'fusionauth:index/fusionAuthIdpFacebook:FusionAuthIdpFacebook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            application_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookApplicationConfigurationArgs']]]]] = None,
            button_text: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            debug: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            fields: Optional[pulumi.Input[str]] = None,
            lambda_reconcile_id: Optional[pulumi.Input[str]] = None,
            linking_strategy: Optional[pulumi.Input[str]] = None,
            login_method: Optional[pulumi.Input[str]] = None,
            permissions: Optional[pulumi.Input[str]] = None,
            tenant_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookTenantConfigurationArgs']]]]] = None) -> 'FusionAuthIdpFacebook':
        """
        Get an existing FusionAuthIdpFacebook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookApplicationConfigurationArgs']]]] application_configurations: The configuration for each Application that the identity provider is enabled for.
        :param pulumi.Input[str] button_text: The top-level button text to use on the FusionAuth login page for this Identity Provider.
        :param pulumi.Input[str] client_secret: The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        :param pulumi.Input[bool] debug: Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        :param pulumi.Input[bool] enabled: Determines if this provider is enabled. If it is false then it will be disabled globally.
        :param pulumi.Input[str] fields: The top-level fields that you are requesting from Facebook.
               Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        :param pulumi.Input[str] lambda_reconcile_id: The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        :param pulumi.Input[str] linking_strategy: The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
               The valid values are:
        :param pulumi.Input[str] login_method: The login method to use for this Identity Provider.
               The valid values are:
        :param pulumi.Input[str] permissions: The top-level permissions that your application is asking of the user’s Facebook account.
               Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FusionAuthIdpFacebookTenantConfigurationArgs']]]] tenant_configurations: The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthIdpFacebookState.__new__(_FusionAuthIdpFacebookState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["application_configurations"] = application_configurations
        __props__.__dict__["button_text"] = button_text
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["debug"] = debug
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["fields"] = fields
        __props__.__dict__["lambda_reconcile_id"] = lambda_reconcile_id
        __props__.__dict__["linking_strategy"] = linking_strategy
        __props__.__dict__["login_method"] = login_method
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["tenant_configurations"] = tenant_configurations
        return FusionAuthIdpFacebook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The top-level Facebook `appId` for your Application. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="applicationConfigurations")
    def application_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpFacebookApplicationConfiguration']]]:
        """
        The configuration for each Application that the identity provider is enabled for.
        """
        return pulumi.get(self, "application_configurations")

    @property
    @pulumi.getter(name="buttonText")
    def button_text(self) -> pulumi.Output[str]:
        """
        The top-level button text to use on the FusionAuth login page for this Identity Provider.
        """
        return pulumi.get(self, "button_text")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        The top-level client secret, also known as 'App Secret', to use with the Facebook Identity Provider when retrieving the long-lived token. This value is retrieved from the Facebook developer website when you setup your Facebook developer account.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def debug(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if debug is enabled for this provider. When enabled, an Event Log is created each time this provider is invoked to reconcile a login.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if this provider is enabled. If it is false then it will be disabled globally.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level fields that you are requesting from Facebook.
        Field values are documented at [Facebook Graph API](https://developers.facebook.com/docs/graph-api/using-graph-api/)
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="lambdaReconcileId")
    def lambda_reconcile_id(self) -> pulumi.Output[str]:
        """
        The unique Id of the lambda to used during the user reconcile process to map custom claims from the external identity provider to the FusionAuth user.
        """
        return pulumi.get(self, "lambda_reconcile_id")

    @property
    @pulumi.getter(name="linkingStrategy")
    def linking_strategy(self) -> pulumi.Output[str]:
        """
        The linking strategy to use when creating the link between the Facebook Identity Provider and the user.
        The valid values are:
        """
        return pulumi.get(self, "linking_strategy")

    @property
    @pulumi.getter(name="loginMethod")
    def login_method(self) -> pulumi.Output[Optional[str]]:
        """
        The login method to use for this Identity Provider.
        The valid values are:
        """
        return pulumi.get(self, "login_method")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[str]]:
        """
        The top-level permissions that your application is asking of the user’s Facebook account.
        Permission values are documented at [Facebook Login API](https://developers.facebook.com/docs/permissions/reference)
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="tenantConfigurations")
    def tenant_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.FusionAuthIdpFacebookTenantConfiguration']]]:
        """
        The configuration for each Tenant that limits the number of links a user may have for a particular identity provider.
        """
        return pulumi.get(self, "tenant_configurations")

