"use strict";
const assert_1 = require("@aws-cdk/assert");
const core_1 = require("@aws-cdk/core");
const glue = require("../lib");
module.exports = {
    'default database does not create a bucket'(test) {
        const stack = new core_1.Stack();
        new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
        });
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            Name: "test_database"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'explicit locationURI'(test) {
        const stack = new core_1.Stack();
        new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
            locationUri: 's3://my-uri/'
        });
        assert_1.expect(stack).toMatch({
            Resources: {
                DatabaseB269D8BB: {
                    Type: 'AWS::Glue::Database',
                    Properties: {
                        CatalogId: {
                            Ref: "AWS::AccountId"
                        },
                        DatabaseInput: {
                            LocationUri: 's3://my-uri/',
                            Name: "test_database"
                        }
                    }
                }
            }
        });
        test.done();
    },
    'fromDatabase'(test) {
        // GIVEN
        const stack = new core_1.Stack();
        // WHEN
        const database = glue.Database.fromDatabaseArn(stack, 'import', 'arn:aws:glue:us-east-1:123456789012:database/db1');
        // THEN
        test.deepEqual(database.databaseArn, 'arn:aws:glue:us-east-1:123456789012:database/db1');
        test.deepEqual(database.databaseName, 'db1');
        test.deepEqual(stack.resolve(database.catalogArn), { 'Fn::Join': ['',
                ['arn:', { Ref: 'AWS::Partition' }, ':glue:', { Ref: 'AWS::Region' }, ':', { Ref: 'AWS::AccountId' }, ':catalog']] });
        test.deepEqual(stack.resolve(database.catalogId), { Ref: 'AWS::AccountId' });
        test.done();
    },
    'locationUri length must be >= 1'(test) {
        const stack = new core_1.Stack();
        test.throws(() => new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
            locationUri: ''
        }));
        test.done();
    },
    'locationUri length must be <= 1024'(test) {
        const stack = new core_1.Stack();
        test.throws(() => new glue.Database(stack, 'Database', {
            databaseName: 'test_database',
            locationUri: 'a'.repeat(1025)
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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