# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, email=None, id=None, is_email_verified=None, is_imported_from_identity_provider=None, is_password_expired=None, is_two_factor_auth_enabled=None, is_user_locked=None, name=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_email_verified and not isinstance(is_email_verified, bool):
            raise TypeError("Expected argument 'is_email_verified' to be a bool")
        pulumi.set(__self__, "is_email_verified", is_email_verified)
        if is_imported_from_identity_provider and not isinstance(is_imported_from_identity_provider, bool):
            raise TypeError("Expected argument 'is_imported_from_identity_provider' to be a bool")
        pulumi.set(__self__, "is_imported_from_identity_provider", is_imported_from_identity_provider)
        if is_password_expired and not isinstance(is_password_expired, bool):
            raise TypeError("Expected argument 'is_password_expired' to be a bool")
        pulumi.set(__self__, "is_password_expired", is_password_expired)
        if is_two_factor_auth_enabled and not isinstance(is_two_factor_auth_enabled, bool):
            raise TypeError("Expected argument 'is_two_factor_auth_enabled' to be a bool")
        pulumi.set(__self__, "is_two_factor_auth_enabled", is_two_factor_auth_enabled)
        if is_user_locked and not isinstance(is_user_locked, bool):
            raise TypeError("Expected argument 'is_user_locked' to be a bool")
        pulumi.set(__self__, "is_user_locked", is_user_locked)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier of the user
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEmailVerified")
    def is_email_verified(self) -> bool:
        """
        Flag indicating whether or not the users email has been verified.
        """
        return pulumi.get(self, "is_email_verified")

    @property
    @pulumi.getter(name="isImportedFromIdentityProvider")
    def is_imported_from_identity_provider(self) -> bool:
        """
        Flag indicating whether or not the user was imported from an identity provider.
        """
        return pulumi.get(self, "is_imported_from_identity_provider")

    @property
    @pulumi.getter(name="isPasswordExpired")
    def is_password_expired(self) -> bool:
        """
        Flag indicating whether or not the users password has expired.
        """
        return pulumi.get(self, "is_password_expired")

    @property
    @pulumi.getter(name="isTwoFactorAuthEnabled")
    def is_two_factor_auth_enabled(self) -> bool:
        """
        Flag indicating whether or not two-factor authentication is enabled for the user.
        """
        return pulumi.get(self, "is_two_factor_auth_enabled")

    @property
    @pulumi.getter(name="isUserLocked")
    def is_user_locked(self) -> bool:
        """
        Flag indicating whether or not the user is locked out.
        """
        return pulumi.get(self, "is_user_locked")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            email=self.email,
            id=self.id,
            is_email_verified=self.is_email_verified,
            is_imported_from_identity_provider=self.is_imported_from_identity_provider,
            is_password_expired=self.is_password_expired,
            is_two_factor_auth_enabled=self.is_two_factor_auth_enabled,
            is_user_locked=self.is_user_locked,
            name=self.name)


def get_user(email: Optional[str] = None,
             id: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Data source for retrieving a Harness user


    :param str email: The email of the user.
    :param str id: Unique identifier of the user
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('harness:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        email=__ret__.email,
        id=__ret__.id,
        is_email_verified=__ret__.is_email_verified,
        is_imported_from_identity_provider=__ret__.is_imported_from_identity_provider,
        is_password_expired=__ret__.is_password_expired,
        is_two_factor_auth_enabled=__ret__.is_two_factor_auth_enabled,
        is_user_locked=__ret__.is_user_locked,
        name=__ret__.name)


@_utilities.lift_output_func(get_user)
def get_user_output(email: Optional[pulumi.Input[Optional[str]]] = None,
                    id: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Data source for retrieving a Harness user


    :param str email: The email of the user.
    :param str id: Unique identifier of the user
    """
    ...
