# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_container.configuration import Configuration


class RepositorySign(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'manifest_signing_service': 'str',
        'future_base_path': 'str',
        'tags_list': 'list[object]'
    }

    attribute_map = {
        'manifest_signing_service': 'manifest_signing_service',
        'future_base_path': 'future_base_path',
        'tags_list': 'tags_list'
    }

    def __init__(self, manifest_signing_service=None, future_base_path=None, tags_list=None, local_vars_configuration=None):  # noqa: E501
        """RepositorySign - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._manifest_signing_service = None
        self._future_base_path = None
        self._tags_list = None
        self.discriminator = None

        self.manifest_signing_service = manifest_signing_service
        if future_base_path is not None:
            self.future_base_path = future_base_path
        if tags_list is not None:
            self.tags_list = tags_list

    @property
    def manifest_signing_service(self):
        """Gets the manifest_signing_service of this RepositorySign.  # noqa: E501

        A signing service to sign with. This will override a signing service set on the repo.  # noqa: E501

        :return: The manifest_signing_service of this RepositorySign.  # noqa: E501
        :rtype: str
        """
        return self._manifest_signing_service

    @manifest_signing_service.setter
    def manifest_signing_service(self, manifest_signing_service):
        """Sets the manifest_signing_service of this RepositorySign.

        A signing service to sign with. This will override a signing service set on the repo.  # noqa: E501

        :param manifest_signing_service: The manifest_signing_service of this RepositorySign.  # noqa: E501
        :type: str
        """

        self._manifest_signing_service = manifest_signing_service

    @property
    def future_base_path(self):
        """Gets the future_base_path of this RepositorySign.  # noqa: E501

        Future base path content will be distributed at for sync repos  # noqa: E501

        :return: The future_base_path of this RepositorySign.  # noqa: E501
        :rtype: str
        """
        return self._future_base_path

    @future_base_path.setter
    def future_base_path(self, future_base_path):
        """Sets the future_base_path of this RepositorySign.

        Future base path content will be distributed at for sync repos  # noqa: E501

        :param future_base_path: The future_base_path of this RepositorySign.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                future_base_path is not None and len(future_base_path) < 1):
            raise ValueError("Invalid value for `future_base_path`, length must be greater than or equal to `1`")  # noqa: E501

        self._future_base_path = future_base_path

    @property
    def tags_list(self):
        """Gets the tags_list of this RepositorySign.  # noqa: E501

        A list of tags to sign.  # noqa: E501

        :return: The tags_list of this RepositorySign.  # noqa: E501
        :rtype: list[object]
        """
        return self._tags_list

    @tags_list.setter
    def tags_list(self, tags_list):
        """Sets the tags_list of this RepositorySign.

        A list of tags to sign.  # noqa: E501

        :param tags_list: The tags_list of this RepositorySign.  # noqa: E501
        :type: list[object]
        """

        self._tags_list = tags_list

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositorySign):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositorySign):
            return True

        return self.to_dict() != other.to_dict()
