# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[_builtins.str],
                 zone: pulumi.Input[_builtins.str],
                 boot_order: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.int]] = None,
                 hot_resize: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input['ServerLoginArgs']] = None,
                 mem: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]]] = None,
                 nic_model: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_backup: Optional[pulumi.Input['ServerSimpleBackupArgs']] = None,
                 storage_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input['ServerTemplateArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 video_model: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[_builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[_builtins.str] zone: The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        :param pulumi.Input[_builtins.str] boot_order: The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        :param pulumi.Input[_builtins.int] cpu: The number of CPU cores for the server
        :param pulumi.Input[_builtins.bool] firewall: Are firewall rules active for the server
        :param pulumi.Input[_builtins.int] host: Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        :param pulumi.Input[_builtins.bool] hot_resize: If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the server.
        :param pulumi.Input['ServerLoginArgs'] login: Configure access credentials to the server
        :param pulumi.Input[_builtins.int] mem: The amount of memory for the server (in megabytes)
        :param pulumi.Input[_builtins.bool] metadata: Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        :param pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]] network_interfaces: One or more blocks describing the network interfaces of the server.
               
                   In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.
               
                   We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        :param pulumi.Input[_builtins.str] nic_model: The model of the server's network interfaces
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the server. You can list available server plans with `upctl server plans`
        :param pulumi.Input[_builtins.str] server_group: The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        :param pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]] storage_devices: A set of storage devices associated with the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The server related tags
        :param pulumi.Input['ServerTemplateArgs'] template: Block describing the preconfigured operating system
        :param pulumi.Input[_builtins.str] timezone: The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        :param pulumi.Input[_builtins.str] title: A short, informational description of the server.
        :param pulumi.Input[_builtins.str] user_data: Defines URL for a server setup script, or the script body itself
        :param pulumi.Input[_builtins.str] video_model: The model of the server's video interface
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "zone", zone)
        if boot_order is not None:
            pulumi.set(__self__, "boot_order", boot_order)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if firewall is not None:
            pulumi.set(__self__, "firewall", firewall)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if hot_resize is not None:
            pulumi.set(__self__, "hot_resize", hot_resize)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if mem is not None:
            pulumi.set(__self__, "mem", mem)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if nic_model is not None:
            pulumi.set(__self__, "nic_model", nic_model)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if server_group is not None:
            pulumi.set(__self__, "server_group", server_group)
        if simple_backup is not None:
            pulumi.set(__self__, "simple_backup", simple_backup)
        if storage_devices is not None:
            pulumi.set(__self__, "storage_devices", storage_devices)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if video_model is not None:
            pulumi.set(__self__, "video_model", video_model)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        """
        return pulumi.get(self, "boot_order")

    @boot_order.setter
    def boot_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_order", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPU cores for the server
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are firewall rules active for the server
        """
        return pulumi.get(self, "firewall")

    @firewall.setter
    def firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firewall", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hotResize")
    def hot_resize(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        """
        return pulumi.get(self, "hot_resize")

    @hot_resize.setter
    def hot_resize(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hot_resize", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the server.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['ServerLoginArgs']]:
        """
        Configure access credentials to the server
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['ServerLoginArgs']]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def mem(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory for the server (in megabytes)
        """
        return pulumi.get(self, "mem")

    @mem.setter
    def mem(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mem", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]]]:
        """
        One or more blocks describing the network interfaces of the server.

            In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.

            We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="nicModel")
    def nic_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model of the server's network interfaces
        """
        return pulumi.get(self, "nic_model")

    @nic_model.setter
    def nic_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nic_model", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing plan used for the server. You can list available server plans with `upctl server plans`
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="serverGroup")
    def server_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        """
        return pulumi.get(self, "server_group")

    @server_group.setter
    def server_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group", value)

    @_builtins.property
    @pulumi.getter(name="simpleBackup")
    def simple_backup(self) -> Optional[pulumi.Input['ServerSimpleBackupArgs']]:
        return pulumi.get(self, "simple_backup")

    @simple_backup.setter
    def simple_backup(self, value: Optional[pulumi.Input['ServerSimpleBackupArgs']]):
        pulumi.set(self, "simple_backup", value)

    @_builtins.property
    @pulumi.getter(name="storageDevices")
    def storage_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]]]:
        """
        A set of storage devices associated with the server
        """
        return pulumi.get(self, "storage_devices")

    @storage_devices.setter
    def storage_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]]]):
        pulumi.set(self, "storage_devices", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The server related tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServerTemplateArgs']]:
        """
        Block describing the preconfigured operating system
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServerTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short, informational description of the server.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines URL for a server setup script, or the script body itself
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="videoModel")
    def video_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model of the server's video interface
        """
        return pulumi.get(self, "video_model")

    @video_model.setter
    def video_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "video_model", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 boot_order: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.int]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 hot_resize: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input['ServerLoginArgs']] = None,
                 mem: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]]] = None,
                 nic_model: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_backup: Optional[pulumi.Input['ServerSimpleBackupArgs']] = None,
                 storage_devices: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input['ServerTemplateArgs']] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 video_model: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[_builtins.str] boot_order: The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        :param pulumi.Input[_builtins.int] cpu: The number of CPU cores for the server
        :param pulumi.Input[_builtins.bool] firewall: Are firewall rules active for the server
        :param pulumi.Input[_builtins.int] host: Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        :param pulumi.Input[_builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[_builtins.bool] hot_resize: If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the server.
        :param pulumi.Input['ServerLoginArgs'] login: Configure access credentials to the server
        :param pulumi.Input[_builtins.int] mem: The amount of memory for the server (in megabytes)
        :param pulumi.Input[_builtins.bool] metadata: Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        :param pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]] network_interfaces: One or more blocks describing the network interfaces of the server.
               
                   In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.
               
                   We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        :param pulumi.Input[_builtins.str] nic_model: The model of the server's network interfaces
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the server. You can list available server plans with `upctl server plans`
        :param pulumi.Input[_builtins.str] server_group: The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        :param pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]] storage_devices: A set of storage devices associated with the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The server related tags
        :param pulumi.Input['ServerTemplateArgs'] template: Block describing the preconfigured operating system
        :param pulumi.Input[_builtins.str] timezone: The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        :param pulumi.Input[_builtins.str] title: A short, informational description of the server.
        :param pulumi.Input[_builtins.str] user_data: Defines URL for a server setup script, or the script body itself
        :param pulumi.Input[_builtins.str] video_model: The model of the server's video interface
        :param pulumi.Input[_builtins.str] zone: The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        if boot_order is not None:
            pulumi.set(__self__, "boot_order", boot_order)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if firewall is not None:
            pulumi.set(__self__, "firewall", firewall)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hot_resize is not None:
            pulumi.set(__self__, "hot_resize", hot_resize)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if mem is not None:
            pulumi.set(__self__, "mem", mem)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if nic_model is not None:
            pulumi.set(__self__, "nic_model", nic_model)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if server_group is not None:
            pulumi.set(__self__, "server_group", server_group)
        if simple_backup is not None:
            pulumi.set(__self__, "simple_backup", simple_backup)
        if storage_devices is not None:
            pulumi.set(__self__, "storage_devices", storage_devices)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if video_model is not None:
            pulumi.set(__self__, "video_model", video_model)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        """
        return pulumi.get(self, "boot_order")

    @boot_order.setter
    def boot_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "boot_order", value)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPU cores for the server
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu", value)

    @_builtins.property
    @pulumi.getter
    def firewall(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Are firewall rules active for the server
        """
        return pulumi.get(self, "firewall")

    @firewall.setter
    def firewall(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "firewall", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="hotResize")
    def hot_resize(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        """
        return pulumi.get(self, "hot_resize")

    @hot_resize.setter
    def hot_resize(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hot_resize", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the server.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['ServerLoginArgs']]:
        """
        Configure access credentials to the server
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['ServerLoginArgs']]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def mem(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory for the server (in megabytes)
        """
        return pulumi.get(self, "mem")

    @mem.setter
    def mem(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mem", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]]]:
        """
        One or more blocks describing the network interfaces of the server.

            In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.

            We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="nicModel")
    def nic_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model of the server's network interfaces
        """
        return pulumi.get(self, "nic_model")

    @nic_model.setter
    def nic_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nic_model", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing plan used for the server. You can list available server plans with `upctl server plans`
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="serverGroup")
    def server_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        """
        return pulumi.get(self, "server_group")

    @server_group.setter
    def server_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_group", value)

    @_builtins.property
    @pulumi.getter(name="simpleBackup")
    def simple_backup(self) -> Optional[pulumi.Input['ServerSimpleBackupArgs']]:
        return pulumi.get(self, "simple_backup")

    @simple_backup.setter
    def simple_backup(self, value: Optional[pulumi.Input['ServerSimpleBackupArgs']]):
        pulumi.set(self, "simple_backup", value)

    @_builtins.property
    @pulumi.getter(name="storageDevices")
    def storage_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]]]:
        """
        A set of storage devices associated with the server
        """
        return pulumi.get(self, "storage_devices")

    @storage_devices.setter
    def storage_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerStorageDeviceArgs']]]]):
        pulumi.set(self, "storage_devices", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The server related tags
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServerTemplateArgs']]:
        """
        Block describing the preconfigured operating system
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServerTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A short, informational description of the server.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines URL for a server setup script, or the script body itself
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="videoModel")
    def video_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The model of the server's video interface
        """
        return pulumi.get(self, "video_model")

    @video_model.setter
    def video_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "video_model", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/server:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_order: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.int]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 hot_resize: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input[Union['ServerLoginArgs', 'ServerLoginArgsDict']]] = None,
                 mem: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerNetworkInterfaceArgs', 'ServerNetworkInterfaceArgsDict']]]]] = None,
                 nic_model: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_backup: Optional[pulumi.Input[Union['ServerSimpleBackupArgs', 'ServerSimpleBackupArgsDict']]] = None,
                 storage_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageDeviceArgs', 'ServerStorageDeviceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['ServerTemplateArgs', 'ServerTemplateArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 video_model: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The UpCloud server resource allows the creation, update and deletion of [cloud servers](https://upcloud.com/products/cloud-servers).

        > To deploy a GPU server, select a plan with `GPU-` prefix, e.g., `GPU-8xCPU-64GB-1xL40S`. Use `upctl zone devices` command to list per zone GPU availability.

        ## Example Usage

        ## Import

        ```sh
        $ pulumi import upcloud:index/server:Server example_server ead4544f-10bf-42a3-b98a-a0fea2e2ad14
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] boot_order: The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        :param pulumi.Input[_builtins.int] cpu: The number of CPU cores for the server
        :param pulumi.Input[_builtins.bool] firewall: Are firewall rules active for the server
        :param pulumi.Input[_builtins.int] host: Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        :param pulumi.Input[_builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[_builtins.bool] hot_resize: If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the server.
        :param pulumi.Input[Union['ServerLoginArgs', 'ServerLoginArgsDict']] login: Configure access credentials to the server
        :param pulumi.Input[_builtins.int] mem: The amount of memory for the server (in megabytes)
        :param pulumi.Input[_builtins.bool] metadata: Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerNetworkInterfaceArgs', 'ServerNetworkInterfaceArgsDict']]]] network_interfaces: One or more blocks describing the network interfaces of the server.
               
                   In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.
               
                   We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        :param pulumi.Input[_builtins.str] nic_model: The model of the server's network interfaces
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the server. You can list available server plans with `upctl server plans`
        :param pulumi.Input[_builtins.str] server_group: The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageDeviceArgs', 'ServerStorageDeviceArgsDict']]]] storage_devices: A set of storage devices associated with the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The server related tags
        :param pulumi.Input[Union['ServerTemplateArgs', 'ServerTemplateArgsDict']] template: Block describing the preconfigured operating system
        :param pulumi.Input[_builtins.str] timezone: The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        :param pulumi.Input[_builtins.str] title: A short, informational description of the server.
        :param pulumi.Input[_builtins.str] user_data: Defines URL for a server setup script, or the script body itself
        :param pulumi.Input[_builtins.str] video_model: The model of the server's video interface
        :param pulumi.Input[_builtins.str] zone: The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The UpCloud server resource allows the creation, update and deletion of [cloud servers](https://upcloud.com/products/cloud-servers).

        > To deploy a GPU server, select a plan with `GPU-` prefix, e.g., `GPU-8xCPU-64GB-1xL40S`. Use `upctl zone devices` command to list per zone GPU availability.

        ## Example Usage

        ## Import

        ```sh
        $ pulumi import upcloud:index/server:Server example_server ead4544f-10bf-42a3-b98a-a0fea2e2ad14
        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 boot_order: Optional[pulumi.Input[_builtins.str]] = None,
                 cpu: Optional[pulumi.Input[_builtins.int]] = None,
                 firewall: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.int]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 hot_resize: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 login: Optional[pulumi.Input[Union['ServerLoginArgs', 'ServerLoginArgsDict']]] = None,
                 mem: Optional[pulumi.Input[_builtins.int]] = None,
                 metadata: Optional[pulumi.Input[_builtins.bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerNetworkInterfaceArgs', 'ServerNetworkInterfaceArgsDict']]]]] = None,
                 nic_model: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 server_group: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_backup: Optional[pulumi.Input[Union['ServerSimpleBackupArgs', 'ServerSimpleBackupArgsDict']]] = None,
                 storage_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageDeviceArgs', 'ServerStorageDeviceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['ServerTemplateArgs', 'ServerTemplateArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 video_model: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["boot_order"] = boot_order
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["firewall"] = firewall
            __props__.__dict__["host"] = host
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["hot_resize"] = hot_resize
            __props__.__dict__["labels"] = labels
            __props__.__dict__["login"] = login
            __props__.__dict__["mem"] = mem
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["nic_model"] = nic_model
            __props__.__dict__["plan"] = plan
            __props__.__dict__["server_group"] = server_group
            __props__.__dict__["simple_backup"] = simple_backup
            __props__.__dict__["storage_devices"] = storage_devices
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template"] = template
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["title"] = title
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["video_model"] = video_model
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
        super(Server, __self__).__init__(
            'upcloud:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            boot_order: Optional[pulumi.Input[_builtins.str]] = None,
            cpu: Optional[pulumi.Input[_builtins.int]] = None,
            firewall: Optional[pulumi.Input[_builtins.bool]] = None,
            host: Optional[pulumi.Input[_builtins.int]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            hot_resize: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            login: Optional[pulumi.Input[Union['ServerLoginArgs', 'ServerLoginArgsDict']]] = None,
            mem: Optional[pulumi.Input[_builtins.int]] = None,
            metadata: Optional[pulumi.Input[_builtins.bool]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerNetworkInterfaceArgs', 'ServerNetworkInterfaceArgsDict']]]]] = None,
            nic_model: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            server_group: Optional[pulumi.Input[_builtins.str]] = None,
            simple_backup: Optional[pulumi.Input[Union['ServerSimpleBackupArgs', 'ServerSimpleBackupArgsDict']]] = None,
            storage_devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageDeviceArgs', 'ServerStorageDeviceArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            template: Optional[pulumi.Input[Union['ServerTemplateArgs', 'ServerTemplateArgsDict']]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            video_model: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] boot_order: The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        :param pulumi.Input[_builtins.int] cpu: The number of CPU cores for the server
        :param pulumi.Input[_builtins.bool] firewall: Are firewall rules active for the server
        :param pulumi.Input[_builtins.int] host: Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        :param pulumi.Input[_builtins.str] hostname: The hostname of the server.
        :param pulumi.Input[_builtins.bool] hot_resize: If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the server.
        :param pulumi.Input[Union['ServerLoginArgs', 'ServerLoginArgsDict']] login: Configure access credentials to the server
        :param pulumi.Input[_builtins.int] mem: The amount of memory for the server (in megabytes)
        :param pulumi.Input[_builtins.bool] metadata: Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerNetworkInterfaceArgs', 'ServerNetworkInterfaceArgsDict']]]] network_interfaces: One or more blocks describing the network interfaces of the server.
               
                   In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.
               
                   We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        :param pulumi.Input[_builtins.str] nic_model: The model of the server's network interfaces
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the server. You can list available server plans with `upctl server plans`
        :param pulumi.Input[_builtins.str] server_group: The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServerStorageDeviceArgs', 'ServerStorageDeviceArgsDict']]]] storage_devices: A set of storage devices associated with the server
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The server related tags
        :param pulumi.Input[Union['ServerTemplateArgs', 'ServerTemplateArgsDict']] template: Block describing the preconfigured operating system
        :param pulumi.Input[_builtins.str] timezone: The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        :param pulumi.Input[_builtins.str] title: A short, informational description of the server.
        :param pulumi.Input[_builtins.str] user_data: Defines URL for a server setup script, or the script body itself
        :param pulumi.Input[_builtins.str] video_model: The model of the server's video interface
        :param pulumi.Input[_builtins.str] zone: The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["boot_order"] = boot_order
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["firewall"] = firewall
        __props__.__dict__["host"] = host
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["hot_resize"] = hot_resize
        __props__.__dict__["labels"] = labels
        __props__.__dict__["login"] = login
        __props__.__dict__["mem"] = mem
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["nic_model"] = nic_model
        __props__.__dict__["plan"] = plan
        __props__.__dict__["server_group"] = server_group
        __props__.__dict__["simple_backup"] = simple_backup
        __props__.__dict__["storage_devices"] = storage_devices
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template"] = template
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["title"] = title
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["video_model"] = video_model
        __props__.__dict__["zone"] = zone
        return Server(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> pulumi.Output[_builtins.str]:
        """
        The boot device order, `cdrom`|`disk`|`network` or comma separated combination of those values. Defaults to `disk`
        """
        return pulumi.get(self, "boot_order")

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[_builtins.int]:
        """
        The number of CPU cores for the server
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter
    def firewall(self) -> pulumi.Output[_builtins.bool]:
        """
        Are firewall rules active for the server
        """
        return pulumi.get(self, "firewall")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.int]:
        """
        Use this to start the VM on a specific host. Refers to value from host -attribute. Only available for private cloud hosts
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="hotResize")
    def hot_resize(self) -> pulumi.Output[_builtins.bool]:
        """
        If set to true, allows changing the server plan without requiring a reboot. This enables hot resizing of the server. If hot resizing fails, the apply operation will fail.
        """
        return pulumi.get(self, "hot_resize")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User defined key-value pairs to classify the server.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional['outputs.ServerLogin']]:
        """
        Configure access credentials to the server
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def mem(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of memory for the server (in megabytes)
        """
        return pulumi.get(self, "mem")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is metadata service active for the server. The metadata service must be enabled when using recent cloud-init based templates.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ServerNetworkInterface']]]:
        """
        One or more blocks describing the network interfaces of the server.

            In addition to list order, the configured network interfaces are matched to the server's actual network interfaces by `index` and `ip_address` fields. This is to avoid public and utility network interfaces being re-assigned when the server is updated. This might result to inaccurate diffs in the plan, when interfaces are re-ordered or when interface is removed from the middle of the list.

            We recommend explicitly setting the value for `index` in configuration, when re-ordering interfaces or when removing interface from middle of the list.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="nicModel")
    def nic_model(self) -> pulumi.Output[_builtins.str]:
        """
        The model of the server's network interfaces
        """
        return pulumi.get(self, "nic_model")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The pricing plan used for the server. You can list available server plans with `upctl server plans`
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="serverGroup")
    def server_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The UUID of a server group to attach this server to. Note that the server can also be attached to a server group via the `members` property of `ServerGroup`. Only one of the these should be defined at a time. This value is only updated if it has been set to non-zero value.
        """
        return pulumi.get(self, "server_group")

    @_builtins.property
    @pulumi.getter(name="simpleBackup")
    def simple_backup(self) -> pulumi.Output[Optional['outputs.ServerSimpleBackup']]:
        return pulumi.get(self, "simple_backup")

    @_builtins.property
    @pulumi.getter(name="storageDevices")
    def storage_devices(self) -> pulumi.Output[Optional[Sequence['outputs.ServerStorageDevice']]]:
        """
        A set of storage devices associated with the server
        """
        return pulumi.get(self, "storage_devices")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The server related tags
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.ServerTemplate']]:
        """
        Block describing the preconfigured operating system
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[_builtins.str]:
        """
        The timezone of the server. The timezone must be a valid timezone string, e.g. `Europe/Helsinki`.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        A short, informational description of the server.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Defines URL for a server setup script, or the script body itself
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="videoModel")
    def video_model(self) -> pulumi.Output[_builtins.str]:
        """
        The model of the server's video interface
        """
        return pulumi.get(self, "video_model")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The zone in which the server will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

