# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDatabaseUserArgs', 'ManagedDatabaseUser']

@pulumi.input_type
class ManagedDatabaseUserArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_access_control: Optional[pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_access_control: Optional[pulumi.Input['ManagedDatabaseUserPgAccessControlArgs']] = None,
                 valkey_access_control: Optional[pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs']] = None):
        """
        The set of arguments for constructing a ManagedDatabaseUser resource.
        :param pulumi.Input[_builtins.str] service: Service's UUID for which this user belongs to
        :param pulumi.Input[_builtins.str] username: Name of the database user
        :param pulumi.Input[_builtins.str] authentication: MySQL only, authentication type.
        :param pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs'] opensearch_access_control: OpenSearch access control object.
        :param pulumi.Input[_builtins.str] password: Password for the database user. Defaults to a random value
        :param pulumi.Input['ManagedDatabaseUserPgAccessControlArgs'] pg_access_control: PostgreSQL access control object.
        :param pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs'] valkey_access_control: Valkey access control object.
        """
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "username", username)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if opensearch_access_control is not None:
            pulumi.set(__self__, "opensearch_access_control", opensearch_access_control)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pg_access_control is not None:
            pulumi.set(__self__, "pg_access_control", pg_access_control)
        if valkey_access_control is not None:
            pulumi.set(__self__, "valkey_access_control", valkey_access_control)

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Input[_builtins.str]:
        """
        Service's UUID for which this user belongs to
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the database user
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MySQL only, authentication type.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="opensearchAccessControl")
    def opensearch_access_control(self) -> Optional[pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs']]:
        """
        OpenSearch access control object.
        """
        return pulumi.get(self, "opensearch_access_control")

    @opensearch_access_control.setter
    def opensearch_access_control(self, value: Optional[pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs']]):
        pulumi.set(self, "opensearch_access_control", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the database user. Defaults to a random value
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pgAccessControl")
    def pg_access_control(self) -> Optional[pulumi.Input['ManagedDatabaseUserPgAccessControlArgs']]:
        """
        PostgreSQL access control object.
        """
        return pulumi.get(self, "pg_access_control")

    @pg_access_control.setter
    def pg_access_control(self, value: Optional[pulumi.Input['ManagedDatabaseUserPgAccessControlArgs']]):
        pulumi.set(self, "pg_access_control", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAccessControl")
    def valkey_access_control(self) -> Optional[pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs']]:
        """
        Valkey access control object.
        """
        return pulumi.get(self, "valkey_access_control")

    @valkey_access_control.setter
    def valkey_access_control(self, value: Optional[pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs']]):
        pulumi.set(self, "valkey_access_control", value)


@pulumi.input_type
class _ManagedDatabaseUserState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_access_control: Optional[pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs']] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_access_control: Optional[pulumi.Input['ManagedDatabaseUserPgAccessControlArgs']] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_access_control: Optional[pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedDatabaseUser resources.
        :param pulumi.Input[_builtins.str] authentication: MySQL only, authentication type.
        :param pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs'] opensearch_access_control: OpenSearch access control object.
        :param pulumi.Input[_builtins.str] password: Password for the database user. Defaults to a random value
        :param pulumi.Input['ManagedDatabaseUserPgAccessControlArgs'] pg_access_control: PostgreSQL access control object.
        :param pulumi.Input[_builtins.str] service: Service's UUID for which this user belongs to
        :param pulumi.Input[_builtins.str] type: Type of the user. Only normal type users can be created
        :param pulumi.Input[_builtins.str] username: Name of the database user
        :param pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs'] valkey_access_control: Valkey access control object.
        """
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if opensearch_access_control is not None:
            pulumi.set(__self__, "opensearch_access_control", opensearch_access_control)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pg_access_control is not None:
            pulumi.set(__self__, "pg_access_control", pg_access_control)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if valkey_access_control is not None:
            pulumi.set(__self__, "valkey_access_control", valkey_access_control)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MySQL only, authentication type.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication", value)

    @_builtins.property
    @pulumi.getter(name="opensearchAccessControl")
    def opensearch_access_control(self) -> Optional[pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs']]:
        """
        OpenSearch access control object.
        """
        return pulumi.get(self, "opensearch_access_control")

    @opensearch_access_control.setter
    def opensearch_access_control(self, value: Optional[pulumi.Input['ManagedDatabaseUserOpensearchAccessControlArgs']]):
        pulumi.set(self, "opensearch_access_control", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the database user. Defaults to a random value
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="pgAccessControl")
    def pg_access_control(self) -> Optional[pulumi.Input['ManagedDatabaseUserPgAccessControlArgs']]:
        """
        PostgreSQL access control object.
        """
        return pulumi.get(self, "pg_access_control")

    @pg_access_control.setter
    def pg_access_control(self, value: Optional[pulumi.Input['ManagedDatabaseUserPgAccessControlArgs']]):
        pulumi.set(self, "pg_access_control", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service's UUID for which this user belongs to
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the user. Only normal type users can be created
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the database user
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="valkeyAccessControl")
    def valkey_access_control(self) -> Optional[pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs']]:
        """
        Valkey access control object.
        """
        return pulumi.get(self, "valkey_access_control")

    @valkey_access_control.setter
    def valkey_access_control(self, value: Optional[pulumi.Input['ManagedDatabaseUserValkeyAccessControlArgs']]):
        pulumi.set(self, "valkey_access_control", value)


@pulumi.type_token("upcloud:index/managedDatabaseUser:ManagedDatabaseUser")
class ManagedDatabaseUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserOpensearchAccessControlArgs', 'ManagedDatabaseUserOpensearchAccessControlArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserPgAccessControlArgs', 'ManagedDatabaseUserPgAccessControlArgsDict']]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserValkeyAccessControlArgs', 'ManagedDatabaseUserValkeyAccessControlArgsDict']]] = None,
                 __props__=None):
        """
        This resource represents a user in managed database

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        example = upcloud.ManagedDatabasePostgresql("example",
            name="postgres",
            plan="1x1xCPU-2GB-25GB",
            title="postgres",
            zone="fi-hel1")
        example_user = upcloud.ManagedDatabaseUser("example_user",
            service=example.id,
            username="example_user",
            password="<USER_PASSWORD>")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication: MySQL only, authentication type.
        :param pulumi.Input[Union['ManagedDatabaseUserOpensearchAccessControlArgs', 'ManagedDatabaseUserOpensearchAccessControlArgsDict']] opensearch_access_control: OpenSearch access control object.
        :param pulumi.Input[_builtins.str] password: Password for the database user. Defaults to a random value
        :param pulumi.Input[Union['ManagedDatabaseUserPgAccessControlArgs', 'ManagedDatabaseUserPgAccessControlArgsDict']] pg_access_control: PostgreSQL access control object.
        :param pulumi.Input[_builtins.str] service: Service's UUID for which this user belongs to
        :param pulumi.Input[_builtins.str] username: Name of the database user
        :param pulumi.Input[Union['ManagedDatabaseUserValkeyAccessControlArgs', 'ManagedDatabaseUserValkeyAccessControlArgsDict']] valkey_access_control: Valkey access control object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDatabaseUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents a user in managed database

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        example = upcloud.ManagedDatabasePostgresql("example",
            name="postgres",
            plan="1x1xCPU-2GB-25GB",
            title="postgres",
            zone="fi-hel1")
        example_user = upcloud.ManagedDatabaseUser("example_user",
            service=example.id,
            username="example_user",
            password="<USER_PASSWORD>")
        ```

        :param str resource_name: The name of the resource.
        :param ManagedDatabaseUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDatabaseUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserOpensearchAccessControlArgs', 'ManagedDatabaseUserOpensearchAccessControlArgsDict']]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 pg_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserPgAccessControlArgs', 'ManagedDatabaseUserPgAccessControlArgsDict']]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 valkey_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserValkeyAccessControlArgs', 'ManagedDatabaseUserValkeyAccessControlArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDatabaseUserArgs.__new__(ManagedDatabaseUserArgs)

            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["opensearch_access_control"] = opensearch_access_control
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["pg_access_control"] = pg_access_control
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["valkey_access_control"] = valkey_access_control
            __props__.__dict__["type"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedDatabaseUser, __self__).__init__(
            'upcloud:index/managedDatabaseUser:ManagedDatabaseUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[_builtins.str]] = None,
            opensearch_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserOpensearchAccessControlArgs', 'ManagedDatabaseUserOpensearchAccessControlArgsDict']]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            pg_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserPgAccessControlArgs', 'ManagedDatabaseUserPgAccessControlArgsDict']]] = None,
            service: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            valkey_access_control: Optional[pulumi.Input[Union['ManagedDatabaseUserValkeyAccessControlArgs', 'ManagedDatabaseUserValkeyAccessControlArgsDict']]] = None) -> 'ManagedDatabaseUser':
        """
        Get an existing ManagedDatabaseUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication: MySQL only, authentication type.
        :param pulumi.Input[Union['ManagedDatabaseUserOpensearchAccessControlArgs', 'ManagedDatabaseUserOpensearchAccessControlArgsDict']] opensearch_access_control: OpenSearch access control object.
        :param pulumi.Input[_builtins.str] password: Password for the database user. Defaults to a random value
        :param pulumi.Input[Union['ManagedDatabaseUserPgAccessControlArgs', 'ManagedDatabaseUserPgAccessControlArgsDict']] pg_access_control: PostgreSQL access control object.
        :param pulumi.Input[_builtins.str] service: Service's UUID for which this user belongs to
        :param pulumi.Input[_builtins.str] type: Type of the user. Only normal type users can be created
        :param pulumi.Input[_builtins.str] username: Name of the database user
        :param pulumi.Input[Union['ManagedDatabaseUserValkeyAccessControlArgs', 'ManagedDatabaseUserValkeyAccessControlArgsDict']] valkey_access_control: Valkey access control object.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDatabaseUserState.__new__(_ManagedDatabaseUserState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["opensearch_access_control"] = opensearch_access_control
        __props__.__dict__["password"] = password
        __props__.__dict__["pg_access_control"] = pg_access_control
        __props__.__dict__["service"] = service
        __props__.__dict__["type"] = type
        __props__.__dict__["username"] = username
        __props__.__dict__["valkey_access_control"] = valkey_access_control
        return ManagedDatabaseUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authentication(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        MySQL only, authentication type.
        """
        return pulumi.get(self, "authentication")

    @_builtins.property
    @pulumi.getter(name="opensearchAccessControl")
    def opensearch_access_control(self) -> pulumi.Output[Optional['outputs.ManagedDatabaseUserOpensearchAccessControl']]:
        """
        OpenSearch access control object.
        """
        return pulumi.get(self, "opensearch_access_control")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        Password for the database user. Defaults to a random value
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="pgAccessControl")
    def pg_access_control(self) -> pulumi.Output[Optional['outputs.ManagedDatabaseUserPgAccessControl']]:
        """
        PostgreSQL access control object.
        """
        return pulumi.get(self, "pg_access_control")

    @_builtins.property
    @pulumi.getter
    def service(self) -> pulumi.Output[_builtins.str]:
        """
        Service's UUID for which this user belongs to
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the user. Only normal type users can be created
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the database user
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="valkeyAccessControl")
    def valkey_access_control(self) -> pulumi.Output[Optional['outputs.ManagedDatabaseUserValkeyAccessControl']]:
        """
        Valkey access control object.
        """
        return pulumi.get(self, "valkey_access_control")

