# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerFrontendRuleArgs', 'LoadbalancerFrontendRule']

@pulumi.input_type
class LoadbalancerFrontendRuleArgs:
    def __init__(__self__, *,
                 frontend: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int],
                 actions: Optional[pulumi.Input['LoadbalancerFrontendRuleActionsArgs']] = None,
                 matchers: Optional[pulumi.Input['LoadbalancerFrontendRuleMatchersArgs']] = None,
                 matching_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadbalancerFrontendRule resource.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the frontend rule is connected.
        :param pulumi.Input[_builtins.int] priority: Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        :param pulumi.Input['LoadbalancerFrontendRuleActionsArgs'] actions: Rule actions.
        :param pulumi.Input['LoadbalancerFrontendRuleMatchersArgs'] matchers: Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        :param pulumi.Input[_builtins.str] matching_condition: Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        :param pulumi.Input[_builtins.str] name: The name of the frontend rule. Must be unique within the frontend.
        """
        pulumi.set(__self__, "frontend", frontend)
        pulumi.set(__self__, "priority", priority)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if matching_condition is not None:
            pulumi.set(__self__, "matching_condition", matching_condition)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def frontend(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the load balancer frontend to which the frontend rule is connected.
        """
        return pulumi.get(self, "frontend")

    @frontend.setter
    def frontend(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "frontend", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['LoadbalancerFrontendRuleActionsArgs']]:
        """
        Rule actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['LoadbalancerFrontendRuleActionsArgs']]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def matchers(self) -> Optional[pulumi.Input['LoadbalancerFrontendRuleMatchersArgs']]:
        """
        Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        """
        return pulumi.get(self, "matchers")

    @matchers.setter
    def matchers(self, value: Optional[pulumi.Input['LoadbalancerFrontendRuleMatchersArgs']]):
        pulumi.set(self, "matchers", value)

    @_builtins.property
    @pulumi.getter(name="matchingCondition")
    def matching_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        """
        return pulumi.get(self, "matching_condition")

    @matching_condition.setter
    def matching_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "matching_condition", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the frontend rule. Must be unique within the frontend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LoadbalancerFrontendRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['LoadbalancerFrontendRuleActionsArgs']] = None,
                 frontend: Optional[pulumi.Input[_builtins.str]] = None,
                 matchers: Optional[pulumi.Input['LoadbalancerFrontendRuleMatchersArgs']] = None,
                 matching_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering LoadbalancerFrontendRule resources.
        :param pulumi.Input['LoadbalancerFrontendRuleActionsArgs'] actions: Rule actions.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the frontend rule is connected.
        :param pulumi.Input['LoadbalancerFrontendRuleMatchersArgs'] matchers: Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        :param pulumi.Input[_builtins.str] matching_condition: Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        :param pulumi.Input[_builtins.str] name: The name of the frontend rule. Must be unique within the frontend.
        :param pulumi.Input[_builtins.int] priority: Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if frontend is not None:
            pulumi.set(__self__, "frontend", frontend)
        if matchers is not None:
            pulumi.set(__self__, "matchers", matchers)
        if matching_condition is not None:
            pulumi.set(__self__, "matching_condition", matching_condition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['LoadbalancerFrontendRuleActionsArgs']]:
        """
        Rule actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['LoadbalancerFrontendRuleActionsArgs']]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def frontend(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the load balancer frontend to which the frontend rule is connected.
        """
        return pulumi.get(self, "frontend")

    @frontend.setter
    def frontend(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frontend", value)

    @_builtins.property
    @pulumi.getter
    def matchers(self) -> Optional[pulumi.Input['LoadbalancerFrontendRuleMatchersArgs']]:
        """
        Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        """
        return pulumi.get(self, "matchers")

    @matchers.setter
    def matchers(self, value: Optional[pulumi.Input['LoadbalancerFrontendRuleMatchersArgs']]):
        pulumi.set(self, "matchers", value)

    @_builtins.property
    @pulumi.getter(name="matchingCondition")
    def matching_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        """
        return pulumi.get(self, "matching_condition")

    @matching_condition.setter
    def matching_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "matching_condition", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the frontend rule. Must be unique within the frontend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)


@pulumi.type_token("upcloud:index/loadbalancerFrontendRule:LoadbalancerFrontendRule")
class LoadbalancerFrontendRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['LoadbalancerFrontendRuleActionsArgs', 'LoadbalancerFrontendRuleActionsArgsDict']]] = None,
                 frontend: Optional[pulumi.Input[_builtins.str]] = None,
                 matchers: Optional[pulumi.Input[Union['LoadbalancerFrontendRuleMatchersArgs', 'LoadbalancerFrontendRuleMatchersArgsDict']]] = None,
                 matching_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource represents load balancer frontend rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb_fe1_r1 = upcloud.LoadbalancerFrontendRule("lb_fe_1_r1",
            frontend=upcloud_loadbalancer_frontend["lbFe1"]["id"],
            name="lb-fe-1-r1-test",
            priority=10,
            matchers={
                "src_ips": [{
                    "value": "192.168.0.0/24",
                }],
            },
            actions={
                "use_backends": [{
                    "backend_name": upcloud_loadbalancer_backend["lbBe1"]["name"],
                }],
            })
        lb_fe1 = upcloud.LoadbalancerFrontend("lb_fe_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-fe-1-test",
            mode="http",
            port=8080,
            default_backend_name=upcloud_loadbalancer_backend["lbBe1"]["name"])
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            networks=[
                {
                    "type": "public",
                    "family": "IPv4",
                    "name": "public",
                },
                {
                    "type": "private",
                    "family": "IPv4",
                    "name": "private",
                    "network": upcloud_network["lbNetwork"]["id"],
                },
            ])
        lb_be1 = upcloud.LoadbalancerBackend("lb_be_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-be-1-test")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadbalancerFrontendRuleActionsArgs', 'LoadbalancerFrontendRuleActionsArgsDict']] actions: Rule actions.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the frontend rule is connected.
        :param pulumi.Input[Union['LoadbalancerFrontendRuleMatchersArgs', 'LoadbalancerFrontendRuleMatchersArgsDict']] matchers: Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        :param pulumi.Input[_builtins.str] matching_condition: Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        :param pulumi.Input[_builtins.str] name: The name of the frontend rule. Must be unique within the frontend.
        :param pulumi.Input[_builtins.int] priority: Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerFrontendRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents load balancer frontend rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        config = pulumi.Config()
        lb_zone = config.get("lbZone")
        if lb_zone is None:
            lb_zone = "fi-hel2"
        lb_network = upcloud.Network("lb_network",
            name="lb-test-net",
            zone=lb_zone,
            ip_network={
                "address": "10.0.0.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        lb_fe1_r1 = upcloud.LoadbalancerFrontendRule("lb_fe_1_r1",
            frontend=upcloud_loadbalancer_frontend["lbFe1"]["id"],
            name="lb-fe-1-r1-test",
            priority=10,
            matchers={
                "src_ips": [{
                    "value": "192.168.0.0/24",
                }],
            },
            actions={
                "use_backends": [{
                    "backend_name": upcloud_loadbalancer_backend["lbBe1"]["name"],
                }],
            })
        lb_fe1 = upcloud.LoadbalancerFrontend("lb_fe_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-fe-1-test",
            mode="http",
            port=8080,
            default_backend_name=upcloud_loadbalancer_backend["lbBe1"]["name"])
        lb = upcloud.Loadbalancer("lb",
            configured_status="started",
            name="lb-test",
            plan="development",
            zone=lb_zone,
            networks=[
                {
                    "type": "public",
                    "family": "IPv4",
                    "name": "public",
                },
                {
                    "type": "private",
                    "family": "IPv4",
                    "name": "private",
                    "network": upcloud_network["lbNetwork"]["id"],
                },
            ])
        lb_be1 = upcloud.LoadbalancerBackend("lb_be_1",
            loadbalancer=upcloud_loadbalancer["lb"]["id"],
            name="lb-be-1-test")
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerFrontendRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerFrontendRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['LoadbalancerFrontendRuleActionsArgs', 'LoadbalancerFrontendRuleActionsArgsDict']]] = None,
                 frontend: Optional[pulumi.Input[_builtins.str]] = None,
                 matchers: Optional[pulumi.Input[Union['LoadbalancerFrontendRuleMatchersArgs', 'LoadbalancerFrontendRuleMatchersArgsDict']]] = None,
                 matching_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerFrontendRuleArgs.__new__(LoadbalancerFrontendRuleArgs)

            __props__.__dict__["actions"] = actions
            if frontend is None and not opts.urn:
                raise TypeError("Missing required property 'frontend'")
            __props__.__dict__["frontend"] = frontend
            __props__.__dict__["matchers"] = matchers
            __props__.__dict__["matching_condition"] = matching_condition
            __props__.__dict__["name"] = name
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
        super(LoadbalancerFrontendRule, __self__).__init__(
            'upcloud:index/loadbalancerFrontendRule:LoadbalancerFrontendRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Union['LoadbalancerFrontendRuleActionsArgs', 'LoadbalancerFrontendRuleActionsArgsDict']]] = None,
            frontend: Optional[pulumi.Input[_builtins.str]] = None,
            matchers: Optional[pulumi.Input[Union['LoadbalancerFrontendRuleMatchersArgs', 'LoadbalancerFrontendRuleMatchersArgsDict']]] = None,
            matching_condition: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None) -> 'LoadbalancerFrontendRule':
        """
        Get an existing LoadbalancerFrontendRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LoadbalancerFrontendRuleActionsArgs', 'LoadbalancerFrontendRuleActionsArgsDict']] actions: Rule actions.
        :param pulumi.Input[_builtins.str] frontend: ID of the load balancer frontend to which the frontend rule is connected.
        :param pulumi.Input[Union['LoadbalancerFrontendRuleMatchersArgs', 'LoadbalancerFrontendRuleMatchersArgsDict']] matchers: Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        :param pulumi.Input[_builtins.str] matching_condition: Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        :param pulumi.Input[_builtins.str] name: The name of the frontend rule. Must be unique within the frontend.
        :param pulumi.Input[_builtins.int] priority: Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerFrontendRuleState.__new__(_LoadbalancerFrontendRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["frontend"] = frontend
        __props__.__dict__["matchers"] = matchers
        __props__.__dict__["matching_condition"] = matching_condition
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        return LoadbalancerFrontendRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional['outputs.LoadbalancerFrontendRuleActions']]:
        """
        Rule actions.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def frontend(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the load balancer frontend to which the frontend rule is connected.
        """
        return pulumi.get(self, "frontend")

    @_builtins.property
    @pulumi.getter
    def matchers(self) -> pulumi.Output[Optional['outputs.LoadbalancerFrontendRuleMatchers']]:
        """
        Set of rule matchers. If rule doesn't have matchers, then action applies to all incoming requests.
        """
        return pulumi.get(self, "matchers")

    @_builtins.property
    @pulumi.getter(name="matchingCondition")
    def matching_condition(self) -> pulumi.Output[_builtins.str]:
        """
        Defines boolean operator used to combine multiple matchers. Defaults to `and`.
        """
        return pulumi.get(self, "matching_condition")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the frontend rule. Must be unique within the frontend.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        Rule with the higher priority goes first. Rules with the same priority processed in alphabetical order.
        """
        return pulumi.get(self, "priority")

