# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['KubernetesClusterArgs', 'KubernetesCluster']

@pulumi.input_type
class KubernetesClusterArgs:
    def __init__(__self__, *,
                 control_plane_ip_filters: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 network: pulumi.Input[_builtins.str],
                 zone: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 private_node_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KubernetesCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_ip_filters: IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        :param pulumi.Input[_builtins.str] network: Network ID for the cluster to run in.
        :param pulumi.Input[_builtins.str] zone: Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the cluster.
        :param pulumi.Input[_builtins.str] name: Cluster name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        :param pulumi.Input[_builtins.bool] private_node_groups: Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        :param pulumi.Input[_builtins.str] storage_encryption: Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        :param pulumi.Input[_builtins.str] upgrade_strategy_type: The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        :param pulumi.Input[_builtins.str] version: Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.
               
                   Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        """
        pulumi.set(__self__, "control_plane_ip_filters", control_plane_ip_filters)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "zone", zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if private_node_groups is not None:
            pulumi.set(__self__, "private_node_groups", private_node_groups)
        if storage_encryption is not None:
            pulumi.set(__self__, "storage_encryption", storage_encryption)
        if upgrade_strategy_type is not None:
            pulumi.set(__self__, "upgrade_strategy_type", upgrade_strategy_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="controlPlaneIpFilters")
    def control_plane_ip_filters(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        """
        return pulumi.get(self, "control_plane_ip_filters")

    @control_plane_ip_filters.setter
    def control_plane_ip_filters(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "control_plane_ip_filters", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        Network ID for the cluster to run in.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster name. Needs to be unique within the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="privateNodeGroups")
    def private_node_groups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        """
        return pulumi.get(self, "private_node_groups")

    @private_node_groups.setter
    def private_node_groups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_node_groups", value)

    @_builtins.property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        """
        return pulumi.get(self, "storage_encryption")

    @storage_encryption.setter
    def storage_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_encryption", value)

    @_builtins.property
    @pulumi.getter(name="upgradeStrategyType")
    def upgrade_strategy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        """
        return pulumi.get(self, "upgrade_strategy_type")

    @upgrade_strategy_type.setter
    def upgrade_strategy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_strategy_type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.

            Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _KubernetesClusterState:
    def __init__(__self__, *,
                 control_plane_ip_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 private_node_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KubernetesCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_ip_filters: IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the cluster.
        :param pulumi.Input[_builtins.str] name: Cluster name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] network: Network ID for the cluster to run in.
        :param pulumi.Input[_builtins.str] network_cidr: Network CIDR for the given network. Computed automatically.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_groups: Names of the node groups configured to cluster
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        :param pulumi.Input[_builtins.bool] private_node_groups: Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        :param pulumi.Input[_builtins.str] state: Operational state of the cluster.
        :param pulumi.Input[_builtins.str] storage_encryption: Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        :param pulumi.Input[_builtins.str] upgrade_strategy_type: The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        :param pulumi.Input[_builtins.str] version: Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.
               
                   Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        :param pulumi.Input[_builtins.str] zone: Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        if control_plane_ip_filters is not None:
            pulumi.set(__self__, "control_plane_ip_filters", control_plane_ip_filters)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if network_cidr is not None:
            pulumi.set(__self__, "network_cidr", network_cidr)
        if node_groups is not None:
            pulumi.set(__self__, "node_groups", node_groups)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if private_node_groups is not None:
            pulumi.set(__self__, "private_node_groups", private_node_groups)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_encryption is not None:
            pulumi.set(__self__, "storage_encryption", storage_encryption)
        if upgrade_strategy_type is not None:
            pulumi.set(__self__, "upgrade_strategy_type", upgrade_strategy_type)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="controlPlaneIpFilters")
    def control_plane_ip_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        """
        return pulumi.get(self, "control_plane_ip_filters")

    @control_plane_ip_filters.setter
    def control_plane_ip_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "control_plane_ip_filters", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster name. Needs to be unique within the account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network ID for the cluster to run in.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network CIDR for the given network. Computed automatically.
        """
        return pulumi.get(self, "network_cidr")

    @network_cidr.setter
    def network_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_cidr", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Names of the node groups configured to cluster
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "node_groups", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="privateNodeGroups")
    def private_node_groups(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        """
        return pulumi.get(self, "private_node_groups")

    @private_node_groups.setter
    def private_node_groups(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_node_groups", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operational state of the cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        """
        return pulumi.get(self, "storage_encryption")

    @storage_encryption.setter
    def storage_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_encryption", value)

    @_builtins.property
    @pulumi.getter(name="upgradeStrategyType")
    def upgrade_strategy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        """
        return pulumi.get(self, "upgrade_strategy_type")

    @upgrade_strategy_type.setter
    def upgrade_strategy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_strategy_type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.

            Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/kubernetesCluster:KubernetesCluster")
class KubernetesCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_plane_ip_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 private_node_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource represents a [Managed Kubernetes](https://upcloud.com/products/managed-kubernetes) cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create a network for the Kubernetes cluster
        example = upcloud.Network("example",
            name="example-network",
            zone="de-fra1",
            ip_network={
                "address": "172.16.1.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        # Create a Kubernetes cluster
        example_kubernetes_cluster = upcloud.KubernetesCluster("example",
            control_plane_ip_filters=["0.0.0.0/0"],
            name="exampleapp",
            network=example.id,
            zone="de-fra1")
        # Kubernetes cluster with private node groups requires a network that is routed through NAT gateway.
        example2 = upcloud.Router("example2", name="example2-router")
        example2_gateway = upcloud.Gateway("example2",
            name="example2-nat-gateway",
            zone="de-fra1",
            features=["nat"],
            router={
                "id": example2.id,
            })
        example2_network = upcloud.Network("example2",
            name="example2-network",
            zone="de-fra1",
            ip_network={
                "address": "10.10.0.0/24",
                "dhcp": True,
                "family": "IPv4",
                "dhcp_default_route": True,
            },
            router=example2.id)
        example2_kubernetes_cluster = upcloud.KubernetesCluster("example2",
            control_plane_ip_filters=["0.0.0.0/0"],
            name="example2-cluster",
            network=example2_network.id,
            zone="de-fra1",
            plan="prod-md",
            private_node_groups=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_ip_filters: IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the cluster.
        :param pulumi.Input[_builtins.str] name: Cluster name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] network: Network ID for the cluster to run in.
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        :param pulumi.Input[_builtins.bool] private_node_groups: Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        :param pulumi.Input[_builtins.str] storage_encryption: Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        :param pulumi.Input[_builtins.str] upgrade_strategy_type: The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        :param pulumi.Input[_builtins.str] version: Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.
               
                   Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        :param pulumi.Input[_builtins.str] zone: Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubernetesClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents a [Managed Kubernetes](https://upcloud.com/products/managed-kubernetes) cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create a network for the Kubernetes cluster
        example = upcloud.Network("example",
            name="example-network",
            zone="de-fra1",
            ip_network={
                "address": "172.16.1.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        # Create a Kubernetes cluster
        example_kubernetes_cluster = upcloud.KubernetesCluster("example",
            control_plane_ip_filters=["0.0.0.0/0"],
            name="exampleapp",
            network=example.id,
            zone="de-fra1")
        # Kubernetes cluster with private node groups requires a network that is routed through NAT gateway.
        example2 = upcloud.Router("example2", name="example2-router")
        example2_gateway = upcloud.Gateway("example2",
            name="example2-nat-gateway",
            zone="de-fra1",
            features=["nat"],
            router={
                "id": example2.id,
            })
        example2_network = upcloud.Network("example2",
            name="example2-network",
            zone="de-fra1",
            ip_network={
                "address": "10.10.0.0/24",
                "dhcp": True,
                "family": "IPv4",
                "dhcp_default_route": True,
            },
            router=example2.id)
        example2_kubernetes_cluster = upcloud.KubernetesCluster("example2",
            control_plane_ip_filters=["0.0.0.0/0"],
            name="example2-cluster",
            network=example2_network.id,
            zone="de-fra1",
            plan="prod-md",
            private_node_groups=True)
        ```

        :param str resource_name: The name of the resource.
        :param KubernetesClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubernetesClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_plane_ip_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 private_node_groups: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubernetesClusterArgs.__new__(KubernetesClusterArgs)

            if control_plane_ip_filters is None and not opts.urn:
                raise TypeError("Missing required property 'control_plane_ip_filters'")
            __props__.__dict__["control_plane_ip_filters"] = control_plane_ip_filters
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["plan"] = plan
            __props__.__dict__["private_node_groups"] = private_node_groups
            __props__.__dict__["storage_encryption"] = storage_encryption
            __props__.__dict__["upgrade_strategy_type"] = upgrade_strategy_type
            __props__.__dict__["version"] = version
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["network_cidr"] = None
            __props__.__dict__["node_groups"] = None
            __props__.__dict__["state"] = None
        super(KubernetesCluster, __self__).__init__(
            'upcloud:index/kubernetesCluster:KubernetesCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            control_plane_ip_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            private_node_groups: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            storage_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_strategy_type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'KubernetesCluster':
        """
        Get an existing KubernetesCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_ip_filters: IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the cluster.
        :param pulumi.Input[_builtins.str] name: Cluster name. Needs to be unique within the account.
        :param pulumi.Input[_builtins.str] network: Network ID for the cluster to run in.
        :param pulumi.Input[_builtins.str] network_cidr: Network CIDR for the given network. Computed automatically.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] node_groups: Names of the node groups configured to cluster
        :param pulumi.Input[_builtins.str] plan: The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        :param pulumi.Input[_builtins.bool] private_node_groups: Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        :param pulumi.Input[_builtins.str] state: Operational state of the cluster.
        :param pulumi.Input[_builtins.str] storage_encryption: Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        :param pulumi.Input[_builtins.str] upgrade_strategy_type: The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        :param pulumi.Input[_builtins.str] version: Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.
               
                   Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        :param pulumi.Input[_builtins.str] zone: Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubernetesClusterState.__new__(_KubernetesClusterState)

        __props__.__dict__["control_plane_ip_filters"] = control_plane_ip_filters
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["network_cidr"] = network_cidr
        __props__.__dict__["node_groups"] = node_groups
        __props__.__dict__["plan"] = plan
        __props__.__dict__["private_node_groups"] = private_node_groups
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_encryption"] = storage_encryption
        __props__.__dict__["upgrade_strategy_type"] = upgrade_strategy_type
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return KubernetesCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="controlPlaneIpFilters")
    def control_plane_ip_filters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        IP addresses or IP ranges in CIDR format which are allowed to access the cluster control plane. To allow access from any source, use `["0.0.0.0/0"]`. To deny access from all sources, use `[]`. Values set here do not restrict access to node groups or exposed Kubernetes services.
        """
        return pulumi.get(self, "control_plane_ip_filters")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User defined key-value pairs to classify the cluster.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster name. Needs to be unique within the account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        Network ID for the cluster to run in.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Network CIDR for the given network. Computed automatically.
        """
        return pulumi.get(self, "network_cidr")

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Names of the node groups configured to cluster
        """
        return pulumi.get(self, "node_groups")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[_builtins.str]:
        """
        The pricing plan used for the cluster. You can list available plans with `upctl kubernetes plans`.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="privateNodeGroups")
    def private_node_groups(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable private node groups. Private node groups requires a network that is routed through NAT gateway.
        """
        return pulumi.get(self, "private_node_groups")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Operational state of the cluster.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="storageEncryption")
    def storage_encryption(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set default storage encryption strategy for all nodes in the cluster. Valid values are `data-at-rest` and `none`.
        """
        return pulumi.get(self, "storage_encryption")

    @_builtins.property
    @pulumi.getter(name="upgradeStrategyType")
    def upgrade_strategy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The upgrade strategy to use when changing the cluster `version`. If not set, `manual` strategy will be used by default. When using `manual` strategy, you must replace the existing node-groups to update them.
        """
        return pulumi.get(self, "upgrade_strategy_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Kubernetes version ID, e.g. `1.31`. You can list available version IDs with `upctl kubernetes versions`.

            Note that when changing the cluster version, `upgrade_strategy` will be taken into account.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Zone in which the Kubernetes cluster will be hosted, e.g. `de-fra1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

