# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseOpensearchIndicesResult',
    'AwaitableGetManagedDatabaseOpensearchIndicesResult',
    'get_managed_database_opensearch_indices',
    'get_managed_database_opensearch_indices_output',
]

@pulumi.output_type
class GetManagedDatabaseOpensearchIndicesResult:
    """
    A collection of values returned by getManagedDatabaseOpensearchIndices.
    """
    def __init__(__self__, id=None, indices=None, service=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if indices and not isinstance(indices, list):
            raise TypeError("Expected argument 'indices' to be a list")
        pulumi.set(__self__, "indices", indices)
        if service and not isinstance(service, str):
            raise TypeError("Expected argument 'service' to be a str")
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def indices(self) -> Sequence['outputs.GetManagedDatabaseOpensearchIndicesIndexResult']:
        return pulumi.get(self, "indices")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        return pulumi.get(self, "service")


class AwaitableGetManagedDatabaseOpensearchIndicesResult(GetManagedDatabaseOpensearchIndicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseOpensearchIndicesResult(
            id=self.id,
            indices=self.indices,
            service=self.service)


def get_managed_database_opensearch_indices(indices: Optional[Sequence[Union['GetManagedDatabaseOpensearchIndicesIndexArgs', 'GetManagedDatabaseOpensearchIndicesIndexArgsDict']]] = None,
                                            service: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseOpensearchIndicesResult:
    """
    OpenSearch indices

    ## Example Usage

    ```python
    import pulumi
    import pulumi_upcloud as upcloud

    # Use data source to gather a list of the indices for a Managed OpenSearch Database
    # Create a Managed OpenSearch resource
    example_managed_database_opensearch = upcloud.ManagedDatabaseOpensearch("example",
        name="opensearch-example",
        title="opensearch-example",
        plan="1x2xCPU-4GB-80GB-1D",
        zone="fi-hel1",
        properties={
            "automatic_utility_network_ip_filter": False,
            "public_access": False,
        })
    # Read the available indices of the newly created service
    example = upcloud.get_managed_database_opensearch_indices_output(service=example_managed_database_opensearch.id)
    ```
    """
    __args__ = dict()
    __args__['indices'] = indices
    __args__['service'] = service
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('upcloud:index/getManagedDatabaseOpensearchIndices:getManagedDatabaseOpensearchIndices', __args__, opts=opts, typ=GetManagedDatabaseOpensearchIndicesResult).value

    return AwaitableGetManagedDatabaseOpensearchIndicesResult(
        id=pulumi.get(__ret__, 'id'),
        indices=pulumi.get(__ret__, 'indices'),
        service=pulumi.get(__ret__, 'service'))
def get_managed_database_opensearch_indices_output(indices: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedDatabaseOpensearchIndicesIndexArgs', 'GetManagedDatabaseOpensearchIndicesIndexArgsDict']]]]] = None,
                                                   service: Optional[pulumi.Input[_builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedDatabaseOpensearchIndicesResult]:
    """
    OpenSearch indices

    ## Example Usage

    ```python
    import pulumi
    import pulumi_upcloud as upcloud

    # Use data source to gather a list of the indices for a Managed OpenSearch Database
    # Create a Managed OpenSearch resource
    example_managed_database_opensearch = upcloud.ManagedDatabaseOpensearch("example",
        name="opensearch-example",
        title="opensearch-example",
        plan="1x2xCPU-4GB-80GB-1D",
        zone="fi-hel1",
        properties={
            "automatic_utility_network_ip_filter": False,
            "public_access": False,
        })
    # Read the available indices of the newly created service
    example = upcloud.get_managed_database_opensearch_indices_output(service=example_managed_database_opensearch.id)
    ```
    """
    __args__ = dict()
    __args__['indices'] = indices
    __args__['service'] = service
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('upcloud:index/getManagedDatabaseOpensearchIndices:getManagedDatabaseOpensearchIndices', __args__, opts=opts, typ=GetManagedDatabaseOpensearchIndicesResult)
    return __ret__.apply(lambda __response__: GetManagedDatabaseOpensearchIndicesResult(
        id=pulumi.get(__response__, 'id'),
        indices=pulumi.get(__response__, 'indices'),
        service=pulumi.get(__response__, 'service')))
