# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FloatingIpAddressArgs', 'FloatingIpAddress']

@pulumi.input_type
class FloatingIpAddressArgs:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 release_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FloatingIpAddress resource.
        :param pulumi.Input[_builtins.str] access: Network access for the floating IP address. Supported value: `public`.
        :param pulumi.Input[_builtins.str] family: The address family of the floating IP address.
        :param pulumi.Input[_builtins.str] mac_address: MAC address of a server interface to assign address to.
        :param pulumi.Input[_builtins.str] release_policy: The release policy of the floating IP address.
        :param pulumi.Input[_builtins.str] zone: Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if release_policy is not None:
            pulumi.set(__self__, "release_policy", release_policy)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network access for the floating IP address. Supported value: `public`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address family of the floating IP address.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address of a server interface to assign address to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="releasePolicy")
    def release_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The release policy of the floating IP address.
        """
        return pulumi.get(self, "release_policy")

    @release_policy.setter
    def release_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_policy", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _FloatingIpAddressState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 release_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FloatingIpAddress resources.
        :param pulumi.Input[_builtins.str] access: Network access for the floating IP address. Supported value: `public`.
        :param pulumi.Input[_builtins.str] family: The address family of the floating IP address.
        :param pulumi.Input[_builtins.str] ip_address: An UpCloud assigned IP Address.
        :param pulumi.Input[_builtins.str] mac_address: MAC address of a server interface to assign address to.
        :param pulumi.Input[_builtins.str] release_policy: The release policy of the floating IP address.
        :param pulumi.Input[_builtins.str] zone: Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if release_policy is not None:
            pulumi.set(__self__, "release_policy", release_policy)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network access for the floating IP address. Supported value: `public`.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address family of the floating IP address.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An UpCloud assigned IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address of a server interface to assign address to.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="releasePolicy")
    def release_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The release policy of the floating IP address.
        """
        return pulumi.get(self, "release_policy")

    @release_policy.setter
    def release_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_policy", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/floatingIpAddress:FloatingIpAddress")
class FloatingIpAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 release_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource represents a UpCloud floating IP address resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create a detached floating IP address.
        my_floating_address = upcloud.FloatingIpAddress("my_floating_address", zone="de-fra1")
        # Floating IP address assigned to a server resource.
        example = upcloud.Server("example",
            hostname="terraform.example.tld",
            zone="de-fra1",
            plan="1xCPU-1GB",
            metadata=True,
            login={
                "password_delivery": "none",
            },
            template={
                "storage": "Ubuntu Server 24.04 LTS (Noble Numbat)",
            },
            network_interfaces=[{
                "type": "public",
            }])
        my_new_floating_address = upcloud.FloatingIpAddress("my_new_floating_address", mac_address=example.network_interfaces[0].mac_address)
        ```

        ## Import

        ```sh
        $ pulumi import upcloud:index/floatingIpAddress:FloatingIpAddress my_new_floating_address 94.237.114.205
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access: Network access for the floating IP address. Supported value: `public`.
        :param pulumi.Input[_builtins.str] family: The address family of the floating IP address.
        :param pulumi.Input[_builtins.str] mac_address: MAC address of a server interface to assign address to.
        :param pulumi.Input[_builtins.str] release_policy: The release policy of the floating IP address.
        :param pulumi.Input[_builtins.str] zone: Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FloatingIpAddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents a UpCloud floating IP address resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create a detached floating IP address.
        my_floating_address = upcloud.FloatingIpAddress("my_floating_address", zone="de-fra1")
        # Floating IP address assigned to a server resource.
        example = upcloud.Server("example",
            hostname="terraform.example.tld",
            zone="de-fra1",
            plan="1xCPU-1GB",
            metadata=True,
            login={
                "password_delivery": "none",
            },
            template={
                "storage": "Ubuntu Server 24.04 LTS (Noble Numbat)",
            },
            network_interfaces=[{
                "type": "public",
            }])
        my_new_floating_address = upcloud.FloatingIpAddress("my_new_floating_address", mac_address=example.network_interfaces[0].mac_address)
        ```

        ## Import

        ```sh
        $ pulumi import upcloud:index/floatingIpAddress:FloatingIpAddress my_new_floating_address 94.237.114.205
        ```

        :param str resource_name: The name of the resource.
        :param FloatingIpAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FloatingIpAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 release_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FloatingIpAddressArgs.__new__(FloatingIpAddressArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["family"] = family
            __props__.__dict__["mac_address"] = mac_address
            __props__.__dict__["release_policy"] = release_policy
            __props__.__dict__["zone"] = zone
            __props__.__dict__["ip_address"] = None
        super(FloatingIpAddress, __self__).__init__(
            'upcloud:index/floatingIpAddress:FloatingIpAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[_builtins.str]] = None,
            family: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            mac_address: Optional[pulumi.Input[_builtins.str]] = None,
            release_policy: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'FloatingIpAddress':
        """
        Get an existing FloatingIpAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access: Network access for the floating IP address. Supported value: `public`.
        :param pulumi.Input[_builtins.str] family: The address family of the floating IP address.
        :param pulumi.Input[_builtins.str] ip_address: An UpCloud assigned IP Address.
        :param pulumi.Input[_builtins.str] mac_address: MAC address of a server interface to assign address to.
        :param pulumi.Input[_builtins.str] release_policy: The release policy of the floating IP address.
        :param pulumi.Input[_builtins.str] zone: Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FloatingIpAddressState.__new__(_FloatingIpAddressState)

        __props__.__dict__["access"] = access
        __props__.__dict__["family"] = family
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["release_policy"] = release_policy
        __props__.__dict__["zone"] = zone
        return FloatingIpAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def access(self) -> pulumi.Output[_builtins.str]:
        """
        Network access for the floating IP address. Supported value: `public`.
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def family(self) -> pulumi.Output[_builtins.str]:
        """
        The address family of the floating IP address.
        """
        return pulumi.get(self, "family")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        An UpCloud assigned IP Address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[_builtins.str]:
        """
        MAC address of a server interface to assign address to.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="releasePolicy")
    def release_policy(self) -> pulumi.Output[_builtins.str]:
        """
        The release policy of the floating IP address.
        """
        return pulumi.get(self, "release_policy")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Zone of the address, e.g. `de-fra1`. Required when assigning a detached floating IP address. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

