# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileStorageArgs', 'FileStorage']

@pulumi.input_type
class FileStorageArgs:
    def __init__(__self__, *,
                 configured_status: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 zone: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]]] = None,
                 shares: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]]] = None):
        """
        The set of arguments for constructing a FileStorage resource.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[_builtins.int] size: Size of the file storage in GB.
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the file storage.
        :param pulumi.Input[_builtins.str] name: Name of the file storage service.
        :param pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]] networks: Network attached to this file storage (currently supports at most one of these blocks).
        :param pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]] shares: List of shares exported by this file storage.
        """
        pulumi.set(__self__, "configured_status", configured_status)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "zone", zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if shares is not None:
            pulumi.set(__self__, "shares", shares)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> pulumi.Input[_builtins.str]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @configured_status.setter
    def configured_status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "configured_status", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        Size of the file storage in GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the file storage.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the file storage service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]]]:
        """
        Network attached to this file storage (currently supports at most one of these blocks).
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def shares(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]]]:
        """
        List of shares exported by this file storage.
        """
        return pulumi.get(self, "shares")

    @shares.setter
    def shares(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]]]):
        pulumi.set(self, "shares", value)


@pulumi.input_type
class _FileStorageState:
    def __init__(__self__, *,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]]] = None,
                 shares: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileStorage resources.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the file storage.
        :param pulumi.Input[_builtins.str] name: Name of the file storage service.
        :param pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]] networks: Network attached to this file storage (currently supports at most one of these blocks).
        :param pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]] shares: List of shares exported by this file storage.
        :param pulumi.Input[_builtins.int] size: Size of the file storage in GB.
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        if configured_status is not None:
            pulumi.set(__self__, "configured_status", configured_status)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if shares is not None:
            pulumi.set(__self__, "shares", shares)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @configured_status.setter
    def configured_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configured_status", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User defined key-value pairs to classify the file storage.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the file storage service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]]]:
        """
        Network attached to this file storage (currently supports at most one of these blocks).
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def shares(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]]]:
        """
        List of shares exported by this file storage.
        """
        return pulumi.get(self, "shares")

    @shares.setter
    def shares(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileStorageShareArgs']]]]):
        pulumi.set(self, "shares", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the file storage in GB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("upcloud:index/fileStorage:FileStorage")
class FileStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileStorageNetworkArgs', 'FileStorageNetworkArgsDict']]]]] = None,
                 shares: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileStorageShareArgs', 'FileStorageShareArgsDict']]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing UpCloud file storages (EXPERIMENTAL)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create network for the File Storage
        this = upcloud.Network("this",
            name="file-storage-net-test",
            zone="fi-hel2",
            ip_network={
                "address": "172.16.8.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        example = upcloud.FileStorage("example",
            name="example-file-storage-test",
            size=250,
            zone="fi-hel2",
            configured_status="stopped",
            labels={
                "environment": "staging",
                "customer": "example-customer",
            },
            shares=[{
                "name": "write-to-project",
                "path": "/project",
                "acls": [{
                    "target": "172.16.8.12",
                    "permission": "rw",
                }],
            }],
            networks=[{
                "family": "IPv4",
                "name": "example-private-net",
                "uuid": this.id,
                "ip_address": "172.16.8.11",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the file storage.
        :param pulumi.Input[_builtins.str] name: Name of the file storage service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileStorageNetworkArgs', 'FileStorageNetworkArgsDict']]]] networks: Network attached to this file storage (currently supports at most one of these blocks).
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileStorageShareArgs', 'FileStorageShareArgsDict']]]] shares: List of shares exported by this file storage.
        :param pulumi.Input[_builtins.int] size: Size of the file storage in GB.
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileStorageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing UpCloud file storages (EXPERIMENTAL)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_upcloud as upcloud

        # Create network for the File Storage
        this = upcloud.Network("this",
            name="file-storage-net-test",
            zone="fi-hel2",
            ip_network={
                "address": "172.16.8.0/24",
                "dhcp": True,
                "family": "IPv4",
            })
        example = upcloud.FileStorage("example",
            name="example-file-storage-test",
            size=250,
            zone="fi-hel2",
            configured_status="stopped",
            labels={
                "environment": "staging",
                "customer": "example-customer",
            },
            shares=[{
                "name": "write-to-project",
                "path": "/project",
                "acls": [{
                    "target": "172.16.8.12",
                    "permission": "rw",
                }],
            }],
            networks=[{
                "family": "IPv4",
                "name": "example-private-net",
                "uuid": this.id,
                "ip_address": "172.16.8.11",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param FileStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configured_status: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileStorageNetworkArgs', 'FileStorageNetworkArgsDict']]]]] = None,
                 shares: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileStorageShareArgs', 'FileStorageShareArgsDict']]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileStorageArgs.__new__(FileStorageArgs)

            if configured_status is None and not opts.urn:
                raise TypeError("Missing required property 'configured_status'")
            __props__.__dict__["configured_status"] = configured_status
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["networks"] = networks
            __props__.__dict__["shares"] = shares
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
        super(FileStorage, __self__).__init__(
            'upcloud:index/fileStorage:FileStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configured_status: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileStorageNetworkArgs', 'FileStorageNetworkArgsDict']]]]] = None,
            shares: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileStorageShareArgs', 'FileStorageShareArgsDict']]]]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileStorage':
        """
        Get an existing FileStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configured_status: The service configured status indicates the service's current intended status. Managed by the customer.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User defined key-value pairs to classify the file storage.
        :param pulumi.Input[_builtins.str] name: Name of the file storage service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileStorageNetworkArgs', 'FileStorageNetworkArgsDict']]]] networks: Network attached to this file storage (currently supports at most one of these blocks).
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileStorageShareArgs', 'FileStorageShareArgsDict']]]] shares: List of shares exported by this file storage.
        :param pulumi.Input[_builtins.int] size: Size of the file storage in GB.
        :param pulumi.Input[_builtins.str] zone: Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileStorageState.__new__(_FileStorageState)

        __props__.__dict__["configured_status"] = configured_status
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["shares"] = shares
        __props__.__dict__["size"] = size
        __props__.__dict__["zone"] = zone
        return FileStorage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configuredStatus")
    def configured_status(self) -> pulumi.Output[_builtins.str]:
        """
        The service configured status indicates the service's current intended status. Managed by the customer.
        """
        return pulumi.get(self, "configured_status")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        User defined key-value pairs to classify the file storage.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the file storage service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional[Sequence['outputs.FileStorageNetwork']]]:
        """
        Network attached to this file storage (currently supports at most one of these blocks).
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def shares(self) -> pulumi.Output[Optional[Sequence['outputs.FileStorageShare']]]:
        """
        List of shares exported by this file storage.
        """
        return pulumi.get(self, "shares")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Size of the file storage in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        Zone in which the service will be hosted, e.g. `fi-hel1`. You can list available zones with `upctl zone list`.
        """
        return pulumi.get(self, "zone")

